/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.image.ColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;
import java.util.Hashtable;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemoryImageSource
implements ImageProducer {
    private boolean animated = false;
    private boolean fullbuffers = false;
    private int[] pixeli;
    private int width;
    private int height;
    private int offset;
    private int scansize;
    private byte[] pixelb;
    private ColorModel cm;
    private Hashtable props = new Hashtable();
    private Vector consumers = new Vector();

    public MemoryImageSource(int n, int n2, ColorModel colorModel, byte[] byArray, int n3, int n4) {
        this(n, n2, colorModel, byArray, n3, n4, (Hashtable<?, ?>)null);
    }

    public MemoryImageSource(int n, int n2, ColorModel colorModel, byte[] byArray, int n3, int n4, Hashtable<?, ?> hashtable) {
        this.width = n;
        this.height = n2;
        this.cm = colorModel;
        this.offset = n3;
        this.scansize = n4;
        this.props = hashtable;
        int n5 = this.scansize > this.width ? this.scansize : this.width;
        this.pixelb = byArray;
    }

    public MemoryImageSource(int n, int n2, ColorModel colorModel, int[] nArray, int n3, int n4) {
        this(n, n2, colorModel, nArray, n3, n4, null);
    }

    public MemoryImageSource(int n, int n2, ColorModel colorModel, int[] nArray, int n3, int n4, Hashtable<?, ?> hashtable) {
        this.width = n;
        this.height = n2;
        this.cm = colorModel;
        this.offset = n3;
        this.scansize = n4;
        this.props = hashtable;
        int n5 = this.scansize > this.width ? this.scansize : this.width;
        this.pixeli = nArray;
    }

    public MemoryImageSource(int n, int n2, int[] nArray, int n3, int n4, Hashtable<?, ?> hashtable) {
        this(n, n2, ColorModel.getRGBdefault(), nArray, n3, n4, hashtable);
    }

    public MemoryImageSource(int n, int n2, int[] nArray, int n3, int n4) {
        this(n, n2, ColorModel.getRGBdefault(), nArray, n3, n4, null);
    }

    @Override
    public synchronized void addConsumer(ImageConsumer imageConsumer) {
        if (this.consumers.contains(imageConsumer)) {
            return;
        }
        this.consumers.addElement(imageConsumer);
    }

    @Override
    public synchronized boolean isConsumer(ImageConsumer imageConsumer) {
        return this.consumers.contains(imageConsumer);
    }

    @Override
    public synchronized void removeConsumer(ImageConsumer imageConsumer) {
        this.consumers.removeElement(imageConsumer);
    }

    @Override
    public void startProduction(ImageConsumer imageConsumer) {
        if (!this.consumers.contains(imageConsumer)) {
            this.consumers.addElement(imageConsumer);
        }
        Vector vector = (Vector)this.consumers.clone();
        for (int i = 0; i < vector.size(); ++i) {
            imageConsumer = (ImageConsumer)vector.elementAt(i);
            this.sendPicture(imageConsumer);
            if (this.animated) {
                imageConsumer.imageComplete(2);
                continue;
            }
            imageConsumer.imageComplete(3);
        }
    }

    @Override
    public void requestTopDownLeftRightResend(ImageConsumer imageConsumer) {
        this.startProduction(imageConsumer);
    }

    public synchronized void setAnimated(boolean bl) {
        this.animated = bl;
    }

    public synchronized void setFullBufferUpdates(boolean bl) {
        this.fullbuffers = bl;
    }

    public void newPixels() {
        if (this.animated) {
            Vector vector = (Vector)this.consumers.clone();
            for (int i = 0; i < vector.size(); ++i) {
                ImageConsumer imageConsumer = (ImageConsumer)vector.elementAt(i);
                this.sendPicture(imageConsumer);
                imageConsumer.imageComplete(16);
            }
        }
    }

    private void sendPicture(ImageConsumer imageConsumer) {
        imageConsumer.setHints(2);
        if (this.props != null) {
            imageConsumer.setProperties(this.props);
        }
        imageConsumer.setDimensions(this.width, this.height);
        imageConsumer.setColorModel(this.cm);
        if (this.pixeli != null) {
            imageConsumer.setPixels(0, 0, this.width, this.height, this.cm, this.pixeli, this.offset, this.scansize);
        } else {
            imageConsumer.setPixels(0, 0, this.width, this.height, this.cm, this.pixelb, this.offset, this.scansize);
        }
    }

    public synchronized void newPixels(int n, int n2, int n3, int n4) {
        if (this.animated) {
            if (this.fullbuffers) {
                this.newPixels();
            } else {
                Vector vector = (Vector)this.consumers.clone();
                for (int i = 0; i < vector.size(); ++i) {
                    int n5;
                    Object[] objectArray;
                    ImageConsumer imageConsumer = (ImageConsumer)vector.elementAt(i);
                    imageConsumer.setHints(2);
                    if (this.props != null) {
                        imageConsumer.setProperties(this.props);
                    }
                    if (this.pixeli != null) {
                        objectArray = new int[n3 * n4];
                        for (n5 = n2; n5 < n2 + n4; ++n5) {
                            System.arraycopy(this.pixeli, n5 * this.scansize + n + this.offset, objectArray, 0, n3 * n4);
                        }
                        imageConsumer.setPixels(n, n2, n3, n4, this.cm, (int[])objectArray, 0, n3);
                    } else {
                        objectArray = new byte[n3 * n4];
                        for (n5 = n2; n5 < n2 + n4; ++n5) {
                            System.arraycopy(this.pixelb, n5 * this.scansize + n + this.offset, objectArray, 0, n3 * n4);
                        }
                        imageConsumer.setPixels(n, n2, n3, n4, this.cm, (byte[])objectArray, 0, n3);
                    }
                    imageConsumer.imageComplete(16);
                }
            }
        }
    }

    public synchronized void newPixels(int n, int n2, int n3, int n4, boolean bl) {
        if (this.animated) {
            if (this.fullbuffers) {
                this.newPixels();
            } else {
                Vector vector = (Vector)this.consumers.clone();
                for (int i = 0; i < vector.size(); ++i) {
                    int n5;
                    Object[] objectArray;
                    ImageConsumer imageConsumer = (ImageConsumer)vector.elementAt(i);
                    imageConsumer.setHints(2);
                    if (this.props != null) {
                        imageConsumer.setProperties(this.props);
                    }
                    if (this.pixeli != null) {
                        objectArray = new int[n3 * n4];
                        for (n5 = n2; n5 < n2 + n4; ++n5) {
                            System.arraycopy(this.pixeli, n5 * this.scansize + n + this.offset, objectArray, 0, n3 * n4);
                        }
                        imageConsumer.setPixels(n, n2, n3, n4, this.cm, (int[])objectArray, 0, n3);
                    } else {
                        objectArray = new byte[n3 * n4];
                        for (n5 = n2; n5 < n2 + n4; ++n5) {
                            System.arraycopy(this.pixelb, n5 * this.scansize + n + this.offset, objectArray, 0, n3 * n4);
                        }
                        imageConsumer.setPixels(n, n2, n3, n4, this.cm, (byte[])objectArray, 0, n3);
                    }
                    if (!bl) continue;
                    imageConsumer.imageComplete(16);
                }
            }
        }
    }

    public synchronized void newPixels(byte[] byArray, ColorModel colorModel, int n, int n2) {
        this.pixeli = null;
        this.pixelb = byArray;
        this.cm = colorModel;
        this.offset = n;
        this.scansize = n2;
        if (this.animated) {
            this.newPixels();
        }
    }

    public synchronized void newPixels(int[] nArray, ColorModel colorModel, int n, int n2) {
        this.pixelb = null;
        this.pixeli = nArray;
        this.cm = colorModel;
        this.offset = n;
        this.scansize = n2;
        if (this.animated) {
            this.newPixels();
        }
    }
}

