/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorConvertOp;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.LookupTable;
import java.awt.image.Raster;
import java.awt.image.RasterOp;
import java.awt.image.WritableRaster;

public class LookupOp
implements BufferedImageOp,
RasterOp {
    private LookupTable lut;
    private RenderingHints hints;

    public LookupOp(LookupTable lookupTable, RenderingHints renderingHints) {
        this.lut = lookupTable;
        this.hints = renderingHints;
    }

    public final BufferedImage filter(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        if (bufferedImage.getColorModel() instanceof IndexColorModel) {
            throw new IllegalArgumentException("LookupOp.filter: IndexColorModel not allowed");
        }
        if (this.lut.getNumComponents() != 1 && this.lut.getNumComponents() != bufferedImage.getColorModel().getNumComponents() && this.lut.getNumComponents() != bufferedImage.getColorModel().getNumColorComponents()) {
            throw new IllegalArgumentException("LookupOp.filter: Incompatible lookup table and source image");
        }
        if (bufferedImage2 == null) {
            bufferedImage2 = this.createCompatibleDestImage(bufferedImage, null);
        } else if (bufferedImage.getHeight() != bufferedImage2.getHeight() || bufferedImage.getWidth() != bufferedImage2.getWidth()) {
            throw new IllegalArgumentException("Source and destination images are different sizes.");
        }
        BufferedImage bufferedImage3 = bufferedImage2.getColorModel().equals(bufferedImage.getColorModel()) ? bufferedImage2 : this.createCompatibleDestImage(bufferedImage, bufferedImage.getColorModel());
        WritableRaster writableRaster = bufferedImage.getRaster();
        WritableRaster writableRaster2 = bufferedImage3.getRaster();
        if (bufferedImage.getColorModel().hasAlpha() && (this.lut.getNumComponents() == 1 || this.lut.getNumComponents() == bufferedImage.getColorModel().getNumColorComponents())) {
            int[] nArray = new int[bufferedImage.getColorModel().getNumComponents()];
            int n = bufferedImage.getColorModel().getNumColorComponents();
            int[] nArray2 = new int[n];
            for (int i = bufferedImage.getMinY(); i < bufferedImage.getHeight() + bufferedImage.getMinY(); ++i) {
                for (int j = bufferedImage.getMinX(); j < bufferedImage.getWidth() + bufferedImage.getMinX(); ++j) {
                    writableRaster.getPixel(j, i, nArray);
                    System.arraycopy(nArray, 0, nArray2, 0, n);
                    writableRaster2.setPixel(j, i, this.lut.lookupPixel(nArray2, nArray));
                }
            }
        } else {
            int[] nArray = new int[bufferedImage.getColorModel().getNumComponents()];
            for (int i = bufferedImage.getMinY(); i < bufferedImage.getHeight() + bufferedImage.getMinY(); ++i) {
                for (int j = bufferedImage.getMinX(); j < bufferedImage.getWidth() + bufferedImage.getMinX(); ++j) {
                    writableRaster2.setPixel(j, i, this.lut.lookupPixel(writableRaster.getPixel(j, i, nArray), nArray));
                }
            }
        }
        if (bufferedImage3 != bufferedImage2) {
            new ColorConvertOp(this.hints).filter(bufferedImage3, bufferedImage2);
        }
        return bufferedImage2;
    }

    public final Rectangle2D getBounds2D(BufferedImage bufferedImage) {
        return bufferedImage.getRaster().getBounds();
    }

    public BufferedImage createCompatibleDestImage(BufferedImage bufferedImage, ColorModel colorModel) {
        if (colorModel != null) {
            return new BufferedImage(colorModel, bufferedImage.getRaster().createCompatibleWritableRaster(), bufferedImage.isAlphaPremultiplied(), null);
        }
        int n = bufferedImage.getType();
        if (n == 11) {
            n = 10;
        }
        return new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), n);
    }

    public final Point2D getPoint2D(Point2D point2D, Point2D point2D2) {
        if (point2D2 == null) {
            return (Point2D)point2D.clone();
        }
        point2D2.setLocation(point2D);
        return point2D2;
    }

    public final LookupTable getTable() {
        return this.lut;
    }

    public final RenderingHints getRenderingHints() {
        return this.hints;
    }

    public final WritableRaster filter(Raster raster, WritableRaster writableRaster) {
        if (writableRaster == null) {
            writableRaster = this.createCompatibleDestRaster(raster);
        } else if (raster.getNumBands() != writableRaster.getNumBands()) {
            throw new IllegalArgumentException("Source and destination rasters are incompatible.");
        }
        if (this.lut.getNumComponents() != 1 && this.lut.getNumComponents() != raster.getNumBands()) {
            throw new IllegalArgumentException("Lookup table is incompatible with this raster.");
        }
        int[] nArray = new int[raster.getNumBands()];
        for (int i = raster.getMinY(); i < raster.getHeight() + raster.getMinY(); ++i) {
            for (int j = raster.getMinX(); j < raster.getWidth() + raster.getMinX(); ++j) {
                writableRaster.setPixel(j, i, this.lut.lookupPixel(raster.getPixel(j, i, nArray), nArray));
            }
        }
        return writableRaster;
    }

    public final Rectangle2D getBounds2D(Raster raster) {
        return raster.getBounds();
    }

    public WritableRaster createCompatibleDestRaster(Raster raster) {
        return raster.createCompatibleWritableRaster();
    }
}

