/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import gnu.java.awt.Buffers;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.math.BigInteger;

public class IndexColorModel
extends ColorModel {
    private int map_size;
    private boolean opaque;
    private int trans = -1;
    private int[] rgb;
    private BigInteger validBits = BigInteger.ZERO;

    public IndexColorModel(int n, int n2, byte[] byArray, byte[] byArray2, byte[] byArray3) {
        this(n, n2, byArray, byArray2, byArray3, (byte[])null);
    }

    public IndexColorModel(int n, int n2, byte[] byArray, byte[] byArray2, byte[] byArray3, int n3) {
        super(n, IndexColorModel.nArray(8, 0 <= n3 && n3 < n2 ? 4 : 3), ColorSpace.getInstance(1000), 0 <= n3 && n3 < n2, false, 1, Buffers.smallestAppropriateTransferType(n));
        if (n < 1) {
            throw new IllegalArgumentException("bits < 1");
        }
        if (n > 16) {
            throw new IllegalArgumentException("bits > 16");
        }
        if (n2 < 1) {
            throw new IllegalArgumentException("size < 1");
        }
        this.map_size = n2;
        this.rgb = this.createColorMap(n, n2);
        for (int i = 0; i < n2; ++i) {
            this.rgb[i] = 0xFF000000 | (byArray[i] & 0xFF) << 16 | (byArray2[i] & 0xFF) << 8 | byArray3[i] & 0xFF;
        }
        this.setTransparentPixel(n3);
        this.validBits = this.validBits.setBit(n2).subtract(BigInteger.ONE);
    }

    public IndexColorModel(int n, int n2, byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4) {
        super(n, IndexColorModel.nArray(8, byArray4 == null ? 3 : 4), ColorSpace.getInstance(1000), byArray4 != null, false, 3, Buffers.smallestAppropriateTransferType(n));
        if (n < 1) {
            throw new IllegalArgumentException("bits < 1");
        }
        if (n > 16) {
            throw new IllegalArgumentException("bits > 16");
        }
        if (n2 < 1) {
            throw new IllegalArgumentException("size < 1");
        }
        this.map_size = n2;
        this.opaque = byArray4 == null;
        this.rgb = this.createColorMap(n, n2);
        if (byArray4 == null) {
            for (int i = 0; i < n2; ++i) {
                this.rgb[i] = 0xFF000000 | (byArray[i] & 0xFF) << 16 | (byArray2[i] & 0xFF) << 8 | byArray3[i] & 0xFF;
            }
            this.transparency = 1;
        } else {
            byte by = 0;
            int n3 = -1;
            for (int i = 0; i < n2; ++i) {
                by = (byte)(by | byArray4[i]);
                n3 = (byte)(n3 & byArray4[i]);
                this.rgb[i] = (byArray4[i] & 0xFF) << 24 | (byArray[i] & 0xFF) << 16 | (byArray2[i] & 0xFF) << 8 | byArray3[i] & 0xFF;
            }
            this.transparency = by == 0 || n3 == -1 ? 2 : 3;
        }
        this.validBits = this.validBits.setBit(n2).subtract(BigInteger.ONE);
    }

    public IndexColorModel(int n, int n2, byte[] byArray, int n3, boolean bl) {
        this(n, n2, byArray, n3, bl, -1);
    }

    public IndexColorModel(int n, int n2, byte[] byArray, int n3, boolean bl, int n4) {
        super(n, IndexColorModel.nArray(8, bl || 0 <= n4 && n4 < n2 ? 4 : 3), ColorSpace.getInstance(1000), bl || 0 <= n4 && n4 < n2, false, 1, Buffers.smallestAppropriateTransferType(n));
        if (n < 1) {
            throw new IllegalArgumentException("bits < 1");
        }
        if (n > 16) {
            throw new IllegalArgumentException("bits > 16");
        }
        if (n2 < 1) {
            throw new IllegalArgumentException("size < 1");
        }
        this.map_size = n2;
        this.opaque = !bl;
        this.rgb = this.createColorMap(n, n2);
        if (bl) {
            int n5 = 0;
            int n6 = 255;
            for (int i = 0; i < n2; ++i) {
                int n7 = byArray[4 * i + 3 + n3] & 0xFF;
                n5 |= n7;
                n6 &= n7;
                this.rgb[i] = n7 << 24 | (byArray[4 * i + n3] & 0xFF) << 16 | (byArray[4 * i + 1 + n3] & 0xFF) << 8 | byArray[4 * i + 2 + n3] & 0xFF;
            }
            this.transparency = n5 == 0 ? 2 : (n6 == 255 ? (n4 != -1 ? 2 : 1) : 3);
        } else {
            for (int i = 0; i < n2; ++i) {
                this.rgb[i] = 0xFF000000 | (byArray[3 * i + n3] & 0xFF) << 16 | (byArray[3 * i + 1 + n3] & 0xFF) << 8 | byArray[3 * i + 2 + n3] & 0xFF;
            }
            if (n4 != -1) {
                this.transparency = 2;
            }
        }
        this.setTransparentPixel(n4);
        this.validBits = this.validBits.setBit(n2).subtract(BigInteger.ONE);
    }

    public IndexColorModel(int n, int n2, int[] nArray, int n3, boolean bl, int n4, int n5) {
        super(n, IndexColorModel.nArray(8, 4), ColorSpace.getInstance(1000), true, false, 3, n5);
        if (n5 != 0 && n5 != 1) {
            throw new IllegalArgumentException();
        }
        if (n > 16) {
            throw new IllegalArgumentException("bits > 16");
        }
        if (n2 < 1) {
            throw new IllegalArgumentException("size < 1");
        }
        this.map_size = n2;
        this.opaque = !bl;
        this.rgb = this.createColorMap(n, n2);
        if (!bl) {
            for (int i = 0; i < n2; ++i) {
                this.rgb[i] = nArray[i + n3] | 0xFF000000;
            }
        } else {
            System.arraycopy(nArray, n3, this.rgb, 0, n2);
        }
        this.setTransparentPixel(n4);
        this.validBits = this.validBits.setBit(n2).subtract(BigInteger.ONE);
    }

    public IndexColorModel(int n, int n2, int[] nArray, int n3, int n4, BigInteger bigInteger) {
        super(n, IndexColorModel.nArray(8, 4), ColorSpace.getInstance(1000), true, false, 3, n4);
        if (n4 != 0 && n4 != 1) {
            throw new IllegalArgumentException();
        }
        if (n > 16) {
            throw new IllegalArgumentException("bits > 16");
        }
        if (n2 < 1) {
            throw new IllegalArgumentException("size < 1");
        }
        this.map_size = n2;
        this.opaque = false;
        this.trans = -1;
        this.validBits = bigInteger;
        this.rgb = this.createColorMap(n, n2);
        if (!this.hasAlpha) {
            for (int i = 0; i < n2; ++i) {
                this.rgb[i] = nArray[i + n3] | 0xFF000000;
            }
        } else {
            System.arraycopy(nArray, n3, this.rgb, 0, n2);
        }
    }

    public final int getMapSize() {
        return this.map_size;
    }

    public final int getTransparentPixel() {
        return this.trans;
    }

    public final void getReds(byte[] byArray) {
        for (int i = 0; i < this.map_size; ++i) {
            byArray[i] = (byte)((0xFF0000 & this.rgb[i]) >> 16);
        }
    }

    public final void getGreens(byte[] byArray) {
        for (int i = 0; i < this.map_size; ++i) {
            byArray[i] = (byte)((0xFF00 & this.rgb[i]) >> 8);
        }
    }

    public final void getBlues(byte[] byArray) {
        for (int i = 0; i < this.map_size; ++i) {
            byArray[i] = (byte)(0xFF & this.rgb[i]);
        }
    }

    public final void getAlphas(byte[] byArray) {
        for (int i = 0; i < this.map_size; ++i) {
            byArray[i] = i == this.trans ? (byte)0 : (byte)((0xFF000000 & this.rgb[i]) >> 24);
        }
    }

    public final int getRed(int n) {
        if (n < this.map_size) {
            return (0xFF0000 & this.rgb[n]) >> 16;
        }
        return 0;
    }

    public final int getGreen(int n) {
        if (n < this.map_size) {
            return (0xFF00 & this.rgb[n]) >> 8;
        }
        return 0;
    }

    public final int getBlue(int n) {
        if (n < this.map_size) {
            return 0xFF & this.rgb[n];
        }
        return 0;
    }

    public final int getAlpha(int n) {
        return this.rgb[n] >> 24 & 0xFF;
    }

    public final int getRGB(int n) {
        if (n >= 0 && n < this.map_size) {
            return this.rgb[n];
        }
        return 0;
    }

    public final void getRGBs(int[] nArray) {
        System.arraycopy(this.rgb, 0, nArray, 0, this.map_size);
    }

    public boolean isValid(int n) {
        if (n >= 0) {
            return this.validBits.testBit(n);
        }
        return false;
    }

    public boolean isValid() {
        BigInteger bigInteger = new BigInteger("0");
        bigInteger = bigInteger.setBit(this.map_size);
        bigInteger = bigInteger.subtract(new BigInteger("1"));
        return bigInteger.equals(this.validBits);
    }

    public BigInteger getValidPixels() {
        return this.validBits;
    }

    public BufferedImage convertToIntDiscrete(Raster raster, boolean bl) {
        int n = bl ? 2 : (this.opaque && this.trans == -1 ? 1 : 2);
        BufferedImage bufferedImage = new BufferedImage(raster.width, raster.height, n);
        for (int i = raster.minX; i < raster.width + raster.minX; ++i) {
            for (int j = raster.minY; j < raster.height + raster.minY; ++j) {
                bufferedImage.setRGB(i, j, this.rgb[raster.getSample(i, j, 0)]);
            }
        }
        return bufferedImage;
    }

    public SampleModel createCompatibleSampleModel(int n, int n2) {
        SampleModel sampleModel = this.pixel_bits == 1 || this.pixel_bits == 2 || this.pixel_bits == 4 ? new MultiPixelPackedSampleModel(this.transferType, n, n2, this.pixel_bits) : new ComponentSampleModel(this.transferType, n, n2, 1, n, new int[]{0});
        return sampleModel;
    }

    private void setTransparentPixel(int n) {
        if (n >= 0 && n < this.map_size) {
            int n2 = n;
            this.rgb[n2] = this.rgb[n2] & 0xFFFFFF;
            this.trans = n;
            if (this.transparency == 1) {
                this.transparency = 2;
                this.hasAlpha = true;
            }
        }
    }

    private int[] createColorMap(int n, int n2) {
        int n3 = Math.max(256, Math.max(1 << n, n2));
        return new int[n3];
    }
}

