/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorConvertOp;
import java.awt.image.ColorModel;
import java.awt.image.ImagingOpException;
import java.awt.image.Kernel;
import java.awt.image.Raster;
import java.awt.image.RasterOp;
import java.awt.image.WritableRaster;

public class ConvolveOp
implements BufferedImageOp,
RasterOp {
    public static final int EDGE_ZERO_FILL = 0;
    public static final int EDGE_NO_OP = 1;
    private Kernel kernel;
    private int edge;
    private RenderingHints hints;

    public ConvolveOp(Kernel kernel, int n, RenderingHints renderingHints) {
        this.kernel = kernel;
        this.edge = n;
        this.hints = renderingHints;
    }

    public ConvolveOp(Kernel kernel) {
        this.kernel = kernel;
        this.edge = 0;
        this.hints = null;
    }

    public final BufferedImage filter(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        if (bufferedImage == bufferedImage2) {
            throw new IllegalArgumentException("Source and destination images cannot be the same.");
        }
        if (bufferedImage2 == null) {
            bufferedImage2 = this.createCompatibleDestImage(bufferedImage, bufferedImage.getColorModel());
        }
        BufferedImage bufferedImage3 = bufferedImage;
        BufferedImage bufferedImage4 = bufferedImage2;
        if (bufferedImage3.getColorModel().getColorSpace().getType() != bufferedImage2.getColorModel().getColorSpace().getType()) {
            bufferedImage4 = this.createCompatibleDestImage(bufferedImage, bufferedImage.getColorModel());
        }
        this.filter(bufferedImage3.getRaster(), bufferedImage4.getRaster());
        if (bufferedImage4 != bufferedImage2) {
            new ColorConvertOp(this.hints).filter(bufferedImage4, bufferedImage2);
        }
        return bufferedImage2;
    }

    public BufferedImage createCompatibleDestImage(BufferedImage bufferedImage, ColorModel colorModel) {
        if (colorModel != null) {
            return new BufferedImage(colorModel, bufferedImage.getRaster().createCompatibleWritableRaster(), bufferedImage.isAlphaPremultiplied(), null);
        }
        return new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), bufferedImage.getType());
    }

    public final RenderingHints getRenderingHints() {
        return this.hints;
    }

    public int getEdgeCondition() {
        return this.edge;
    }

    public final Kernel getKernel() {
        return (Kernel)this.kernel.clone();
    }

    public final WritableRaster filter(Raster raster, WritableRaster writableRaster) {
        int n;
        if (raster == writableRaster) {
            throw new IllegalArgumentException("src == dest is not allowed.");
        }
        if (this.kernel.getWidth() > raster.getWidth() || this.kernel.getHeight() > raster.getHeight()) {
            throw new ImagingOpException("The kernel is too large.");
        }
        if (writableRaster == null) {
            writableRaster = this.createCompatibleDestRaster(raster);
        } else if (raster.getNumBands() != writableRaster.getNumBands()) {
            throw new ImagingOpException("src and dest have different band counts.");
        }
        int n2 = this.kernel.getWidth();
        int n3 = this.kernel.getHeight();
        int n4 = this.kernel.getXOrigin();
        int n5 = Math.max(n2 - n4 - 1, 0);
        int n6 = this.kernel.getYOrigin();
        int n7 = Math.max(n3 - n6 - 1, 0);
        int[] nArray = raster.getSampleModel().getSampleSize();
        for (n = 0; n < nArray.length; ++n) {
            nArray[n] = (int)Math.pow(2.0, nArray[n]) - 1;
        }
        n = raster.width - n4 - n5;
        int n8 = raster.height - n6 - n7;
        float[] fArray = this.kernel.getKernelData(null);
        float[] fArray2 = new float[n2 * n3];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n8; ++j) {
                for (int k = 0; k < raster.getNumBands(); ++k) {
                    float f = 0.0f;
                    raster.getSamples(i, j, n2, n3, k, fArray2);
                    for (int i2 = 0; i2 < fArray2.length; ++i2) {
                        f += fArray2[fArray2.length - i2 - 1] * fArray[i2];
                    }
                    if (f > (float)nArray[k]) {
                        f = nArray[k];
                    } else if (f < 0.0f) {
                        f = 0.0f;
                    }
                    writableRaster.setSample(i + this.kernel.getXOrigin(), j + this.kernel.getYOrigin(), k, f);
                }
            }
        }
        this.fillEdge(raster, writableRaster, 0, 0, raster.width, n6, this.edge);
        this.fillEdge(raster, writableRaster, 0, raster.height - n7, raster.width, n7, this.edge);
        this.fillEdge(raster, writableRaster, 0, n6, n4, n8, this.edge);
        this.fillEdge(raster, writableRaster, raster.width - n5, n6, n5, n8, this.edge);
        return writableRaster;
    }

    private void fillEdge(Raster raster, WritableRaster writableRaster, int n, int n2, int n3, int n4, int n5) {
        if (n3 <= 0) {
            return;
        }
        if (n4 <= 0) {
            return;
        }
        if (n5 == 0) {
            float[] fArray = new float[raster.getNumBands() * n3 * n4];
            writableRaster.setPixels(n, n2, n3, n4, fArray);
        } else {
            float[] fArray = new float[raster.getNumBands() * n3 * n4];
            raster.getPixels(n, n2, n3, n4, fArray);
            writableRaster.setPixels(n, n2, n3, n4, fArray);
        }
    }

    public WritableRaster createCompatibleDestRaster(Raster raster) {
        return raster.createCompatibleWritableRaster();
    }

    public final Rectangle2D getBounds2D(BufferedImage bufferedImage) {
        return bufferedImage.getRaster().getBounds();
    }

    public final Rectangle2D getBounds2D(Raster raster) {
        return raster.getBounds();
    }

    public final Point2D getPoint2D(Point2D point2D, Point2D point2D2) {
        if (point2D2 == null) {
            return (Point2D)point2D.clone();
        }
        point2D2.setLocation(point2D);
        return point2D2;
    }
}

