/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferDouble;
import java.awt.image.DataBufferFloat;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.SampleModel;
import java.util.Arrays;

public class ComponentSampleModel
extends SampleModel {
    protected int[] bandOffsets;
    protected int[] bankIndices;
    protected int numBands;
    protected int numBanks;
    protected int scanlineStride;
    protected int pixelStride;

    public ComponentSampleModel(int n, int n2, int n3, int n4, int n5, int[] nArray) {
        this(n, n2, n3, n4, n5, new int[nArray.length], nArray);
    }

    public ComponentSampleModel(int n, int n2, int n3, int n4, int n5, int[] nArray, int[] nArray2) {
        super(n, n2, n3, nArray2.length);
        if (n == 32) {
            throw new IllegalArgumentException("Unsupported dataType.");
        }
        if (n4 < 0 || n5 < 0 || nArray2.length < 1 || nArray2.length != nArray.length) {
            throw new IllegalArgumentException();
        }
        this.bandOffsets = (int[])nArray2.clone();
        this.bankIndices = (int[])nArray.clone();
        this.numBands = nArray2.length;
        this.numBanks = 0;
        for (int i = 0; i < nArray.length; ++i) {
            this.numBanks = Math.max(this.numBanks, nArray[i] + 1);
        }
        this.scanlineStride = n5;
        this.pixelStride = n4;
    }

    public SampleModel createCompatibleSampleModel(int n, int n2) {
        return new ComponentSampleModel(this.dataType, n, n2, this.pixelStride, this.scanlineStride, this.bankIndices, this.bandOffsets);
    }

    public SampleModel createSubsetSampleModel(int[] nArray) {
        int n = nArray.length;
        int[] nArray2 = new int[n];
        int[] nArray3 = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray2[i] = this.bankIndices[nArray[i]];
            nArray3[i] = this.bandOffsets[nArray[i]];
        }
        return new ComponentSampleModel(this.dataType, this.width, this.height, this.pixelStride, this.scanlineStride, nArray2, nArray3);
    }

    public DataBuffer createDataBuffer() {
        int n;
        int n2 = 0;
        for (n = 0; n < this.numBands; ++n) {
            n2 = Math.max(n2, this.bandOffsets[n]);
        }
        n = this.pixelStride * (this.width - 1) + this.scanlineStride * (this.height - 1) + n2 + 1;
        DataBuffer dataBuffer = null;
        switch (this.getTransferType()) {
            case 0: {
                dataBuffer = new DataBufferByte(n, this.numBanks);
                break;
            }
            case 2: {
                dataBuffer = new DataBufferShort(n, this.numBanks);
                break;
            }
            case 1: {
                dataBuffer = new DataBufferUShort(n, this.numBanks);
                break;
            }
            case 3: {
                dataBuffer = new DataBufferInt(n, this.numBanks);
                break;
            }
            case 4: {
                dataBuffer = new DataBufferFloat(n, this.numBanks);
                break;
            }
            case 5: {
                dataBuffer = new DataBufferDouble(n, this.numBanks);
            }
        }
        return dataBuffer;
    }

    public int getOffset(int n, int n2) {
        return this.getOffset(n, n2, 0);
    }

    public int getOffset(int n, int n2, int n3) {
        return this.bandOffsets[n3] + this.pixelStride * n + this.scanlineStride * n2;
    }

    public final int[] getSampleSize() {
        int n = DataBuffer.getDataTypeSize(this.getDataType());
        int[] nArray = new int[this.numBands];
        Arrays.fill(nArray, n);
        return nArray;
    }

    public final int getSampleSize(int n) {
        return DataBuffer.getDataTypeSize(this.getDataType());
    }

    public final int[] getBankIndices() {
        return (int[])this.bankIndices.clone();
    }

    public final int[] getBandOffsets() {
        return (int[])this.bandOffsets.clone();
    }

    public final int getScanlineStride() {
        return this.scanlineStride;
    }

    public final int getPixelStride() {
        return this.pixelStride;
    }

    public final int getNumDataElements() {
        return this.numBands;
    }

    public Object getDataElements(int n, int n2, Object object, DataBuffer dataBuffer) {
        int n3 = this.getTransferType();
        int n4 = this.getNumDataElements();
        int n5 = n2 * this.scanlineStride + n * this.pixelStride;
        switch (n3) {
            case 0: {
                byte[] byArray = object == null ? new byte[n4] : (byte[])object;
                for (int i = 0; i < n4; ++i) {
                    byArray[i] = (byte)dataBuffer.getElem(this.bankIndices[i], n5 + this.bandOffsets[i]);
                }
                object = byArray;
                break;
            }
            case 1: 
            case 2: {
                short[] sArray = object == null ? new short[n4] : (short[])object;
                for (int i = 0; i < n4; ++i) {
                    sArray[i] = (short)dataBuffer.getElem(this.bankIndices[i], n5 + this.bandOffsets[i]);
                }
                object = sArray;
                break;
            }
            case 3: {
                int[] nArray = object == null ? new int[n4] : (int[])object;
                for (int i = 0; i < n4; ++i) {
                    nArray[i] = dataBuffer.getElem(this.bankIndices[i], n5 + this.bandOffsets[i]);
                }
                object = nArray;
                break;
            }
            case 4: {
                float[] fArray = object == null ? new float[n4] : (float[])object;
                for (int i = 0; i < n4; ++i) {
                    fArray[i] = dataBuffer.getElemFloat(this.bankIndices[i], n5 + this.bandOffsets[i]);
                }
                object = fArray;
                break;
            }
            case 5: {
                double[] dArray = object == null ? new double[n4] : (double[])object;
                for (int i = 0; i < n4; ++i) {
                    dArray[i] = dataBuffer.getElemDouble(this.bankIndices[i], n5 + this.bandOffsets[i]);
                }
                object = dArray;
            }
        }
        return object;
    }

    public int[] getPixel(int n, int n2, int[] nArray, DataBuffer dataBuffer) {
        if (n < 0 || n >= this.width || n2 < 0 || n2 >= this.height) {
            throw new ArrayIndexOutOfBoundsException("Pixel (" + n + ", " + n2 + ") is out of bounds.");
        }
        int n3 = this.pixelStride * n + this.scanlineStride * n2;
        if (nArray == null) {
            nArray = new int[this.numBands];
        }
        for (int i = 0; i < this.numBands; ++i) {
            nArray[i] = dataBuffer.getElem(this.bankIndices[i], n3 + this.bandOffsets[i]);
        }
        return nArray;
    }

    public int[] getPixels(int n, int n2, int n3, int n4, int[] nArray, DataBuffer dataBuffer) {
        int n5 = this.pixelStride * n + this.scanlineStride * n2;
        if (nArray == null) {
            nArray = new int[this.numBands * n3 * n4];
        }
        int n6 = 0;
        for (n2 = 0; n2 < n4; ++n2) {
            int n7 = n5;
            for (n = 0; n < n3; ++n) {
                for (int i = 0; i < this.numBands; ++i) {
                    nArray[n6++] = dataBuffer.getElem(this.bankIndices[i], n7 + this.bandOffsets[i]);
                }
                n7 += this.pixelStride;
            }
            n5 += this.scanlineStride;
        }
        return nArray;
    }

    public int getSample(int n, int n2, int n3, DataBuffer dataBuffer) {
        if (n < 0 || n >= this.width || n2 < 0 || n2 >= this.height) {
            throw new ArrayIndexOutOfBoundsException("Sample (" + n + ", " + n2 + ") is out of bounds.");
        }
        return dataBuffer.getElem(this.bankIndices[n3], this.getOffset(n, n2, n3));
    }

    public void setDataElements(int n, int n2, Object object, DataBuffer dataBuffer) {
        int n3 = this.getTransferType();
        int n4 = this.getNumDataElements();
        int n5 = n2 * this.scanlineStride + n * this.pixelStride;
        switch (n3) {
            case 0: {
                byte[] byArray = (byte[])object;
                for (int i = 0; i < n4; ++i) {
                    dataBuffer.setElem(this.bankIndices[i], n5 + this.bandOffsets[i], byArray[i] & 0xFF);
                }
                break;
            }
            case 1: 
            case 2: {
                short[] sArray = (short[])object;
                for (int i = 0; i < n4; ++i) {
                    dataBuffer.setElem(this.bankIndices[i], n5 + this.bandOffsets[i], sArray[i] & 0xFFFF);
                }
                break;
            }
            case 3: {
                int[] nArray = (int[])object;
                for (int i = 0; i < n4; ++i) {
                    dataBuffer.setElem(this.bankIndices[i], n5 + this.bandOffsets[i], nArray[i]);
                }
                break;
            }
            case 4: {
                float[] fArray = (float[])object;
                for (int i = 0; i < n4; ++i) {
                    dataBuffer.setElemFloat(this.bankIndices[i], n5 + this.bandOffsets[i], fArray[i]);
                }
                break;
            }
            case 5: {
                double[] dArray = (double[])object;
                for (int i = 0; i < n4; ++i) {
                    dataBuffer.setElemDouble(this.bankIndices[i], n5 + this.bandOffsets[i], dArray[i]);
                }
                break;
            }
        }
    }

    public void setPixel(int n, int n2, int[] nArray, DataBuffer dataBuffer) {
        int n3 = this.pixelStride * n + this.scanlineStride * n2;
        for (int i = 0; i < this.numBands; ++i) {
            dataBuffer.setElem(this.bankIndices[i], n3 + this.bandOffsets[i], nArray[i]);
        }
    }

    public void setSample(int n, int n2, int n3, int n4, DataBuffer dataBuffer) {
        dataBuffer.setElem(this.bankIndices[n3], this.getOffset(n, n2, n3), n4);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof ComponentSampleModel)) {
            return false;
        }
        ComponentSampleModel componentSampleModel = (ComponentSampleModel)object;
        if (this.dataType != componentSampleModel.dataType) {
            return false;
        }
        if (this.width != componentSampleModel.width) {
            return false;
        }
        if (this.height != componentSampleModel.height) {
            return false;
        }
        if (this.pixelStride != componentSampleModel.pixelStride) {
            return false;
        }
        if (this.scanlineStride != componentSampleModel.scanlineStride) {
            return false;
        }
        if (!Arrays.equals(this.bandOffsets, componentSampleModel.bandOffsets)) {
            return false;
        }
        return Arrays.equals(this.bankIndices, componentSampleModel.bankIndices);
    }

    public int hashCode() {
        int n;
        int n2 = 17;
        n2 = 37 * n2 + this.dataType;
        n2 = 37 * n2 + this.width;
        n2 = 37 * n2 + this.height;
        n2 = 37 * n2 + this.pixelStride;
        n2 = 37 * n2 + this.scanlineStride;
        for (n = 0; n < this.bandOffsets.length; ++n) {
            n2 = 37 * n2 + this.bandOffsets[n];
        }
        for (n = 0; n < this.bankIndices.length; ++n) {
            n2 = 37 * n2 + this.bankIndices[n];
        }
        return n2;
    }
}

