/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.Raster;
import java.awt.image.RasterOp;
import java.awt.image.WritableRaster;
import java.util.Arrays;

public class BandCombineOp
implements RasterOp {
    private RenderingHints hints;
    private float[][] matrix;

    public BandCombineOp(float[][] fArray, RenderingHints renderingHints) {
        this.matrix = new float[fArray.length][];
        int n = fArray[0].length;
        for (int i = 0; i < fArray.length; ++i) {
            this.matrix[i] = new float[n + 1];
            for (int j = 0; j < n; ++j) {
                this.matrix[i][j] = fArray[i][j];
            }
            this.matrix[i][n] = 0.0f;
        }
        this.hints = renderingHints;
    }

    public WritableRaster filter(Raster raster, WritableRaster writableRaster) {
        if (writableRaster == null) {
            writableRaster = this.createCompatibleDestRaster(raster);
        } else if (writableRaster.getNumBands() != raster.getNumBands() || writableRaster.getTransferType() != raster.getTransferType()) {
            throw new IllegalArgumentException("Destination raster is incompatible with source raster");
        }
        int[] nArray = new int[this.matrix[0].length - 1];
        int[] nArray2 = new int[this.matrix[0].length - 1];
        int[] nArray3 = new int[this.matrix.length];
        for (int i = raster.getMinY(); i < raster.getHeight() + raster.getMinY(); ++i) {
            for (int j = raster.getMinX(); j < raster.getWidth() + raster.getMinX(); ++j) {
                nArray[nArray.length - 1] = 1;
                raster.getPixel(j, i, nArray);
                if (!Arrays.equals(nArray, nArray2)) {
                    System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
                    for (int k = 0; k < this.matrix.length; ++k) {
                        nArray3[k] = 0;
                        for (int i2 = 0; i2 < this.matrix[0].length - 1; ++i2) {
                            int n = k;
                            nArray3[n] = nArray3[n] + nArray[i2] * (int)this.matrix[k][i2];
                        }
                    }
                }
                writableRaster.setPixel(j, i, nArray3);
            }
        }
        return writableRaster;
    }

    public final Rectangle2D getBounds2D(Raster raster) {
        return raster.getBounds();
    }

    public WritableRaster createCompatibleDestRaster(Raster raster) {
        if (raster.getNumBands() != this.matrix.length) {
            throw new IllegalArgumentException("Number of rows in matrix specifies an incompatible number of bands");
        }
        if (raster.getNumBands() != this.matrix[0].length - 1 && raster.getNumBands() != this.matrix[0].length - 2) {
            throw new IllegalArgumentException("Incompatible number of bands: the number of bands in the raster must equal the number of columns in the matrix, optionally minus one");
        }
        return raster.createCompatibleWritableRaster();
    }

    public final Point2D getPoint2D(Point2D point2D, Point2D point2D2) {
        if (point2D2 == null) {
            return (Point2D)point2D.clone();
        }
        point2D2.setLocation(point2D);
        return point2D2;
    }

    public final RenderingHints getRenderingHints() {
        return this.hints;
    }

    public final float[][] getMatrix() {
        return this.matrix;
    }
}

