/*
 * Decompiled with CFR 0.152.
 */
package java.awt.im;

import gnu.java.util.EmptyEnumeration;
import java.awt.AWTEvent;
import java.awt.AWTException;
import java.awt.Component;
import java.awt.im.spi.InputMethod;
import java.awt.im.spi.InputMethodDescriptor;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;

public class InputContext {
    private static final ArrayList<InputMethodDescriptor> descriptors;
    private InputMethod im;
    private final HashMap<Locale, InputMethod> recent = new HashMap();
    private Character.Subset[] subsets;

    protected InputContext() {
    }

    public static InputContext getInstance() {
        InputContext inputContext = new InputContext();
        inputContext.selectInputMethod(Locale.getDefault());
        return inputContext;
    }

    public boolean selectInputMethod(Locale locale) {
        if (this.im != null && this.im.setLocale(locale)) {
            this.recent.put(locale, this.im);
            return true;
        }
        InputMethod inputMethod = this.recent.get(locale);
        if (inputMethod != null) {
            int n = descriptors.size();
            for (int i = 0; i < n; ++i) {
                Locale[] localeArray;
                InputMethodDescriptor inputMethodDescriptor = descriptors.get(i);
                try {
                    localeArray = inputMethodDescriptor.getAvailableLocales();
                }
                catch (AWTException aWTException) {
                    continue;
                }
                int n2 = localeArray.length;
                while (--n2 >= 0) {
                    if (!locale.equals(localeArray[n2])) continue;
                    try {
                        inputMethod = inputMethodDescriptor.createInputMethod();
                        this.recent.put(locale, inputMethod);
                    }
                    catch (Exception exception) {}
                }
            }
        }
        if (inputMethod == null) {
            return false;
        }
        if (this.im != null) {
            try {
                inputMethod.setCompositionEnabled(this.im.isCompositionEnabled());
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
            this.im.endComposition();
            this.im.deactivate(false);
            this.im.hideWindows();
        }
        this.im = inputMethod;
        this.im.setLocale(locale);
        this.im.setCharacterSubsets(this.subsets);
        return true;
    }

    public Locale getLocale() {
        return this.im == null ? null : this.im.getLocale();
    }

    public void setCharacterSubsets(Character.Subset[] subsetArray) {
        this.subsets = subsetArray;
        if (this.im != null) {
            this.im.setCharacterSubsets(subsetArray);
        }
    }

    public void setCompositionEnabled(boolean bl) {
        if (this.im == null) {
            throw new UnsupportedOperationException();
        }
        this.im.setCompositionEnabled(bl);
    }

    public boolean isCompositionEnabled() {
        if (this.im == null) {
            throw new UnsupportedOperationException();
        }
        return this.im.isCompositionEnabled();
    }

    public void reconvert() {
        if (this.im == null) {
            throw new UnsupportedOperationException();
        }
        this.im.reconvert();
    }

    public void dispatchEvent(AWTEvent aWTEvent) {
        if (this.im != null) {
            this.im.dispatchEvent(aWTEvent);
        }
    }

    public void removeNotify(Component component) {
        if (this.im != null) {
            this.im.deactivate(false);
            this.im.removeNotify();
        }
    }

    public void endComposition() {
        if (this.im != null) {
            this.im.endComposition();
        }
    }

    public void dispose() {
        if (this.im != null) {
            this.im.deactivate(false);
            this.im.dispose();
        }
    }

    public Object getInputMethodControlObject() {
        return this.im == null ? null : this.im.getControlObject();
    }

    static {
        Enumeration<URL> enumeration;
        descriptors = new ArrayList();
        try {
            enumeration = ClassLoader.getSystemResources("META_INF/services/java.awt.im.spi.InputMethodDescriptor");
        }
        catch (IOException iOException) {
            enumeration = EmptyEnumeration.getInstance();
        }
        while (enumeration.hasMoreElements()) {
            String string;
            BufferedReader bufferedReader;
            URL uRL = enumeration.nextElement();
            try {
                bufferedReader = new BufferedReader(new InputStreamReader(uRL.openConnection().getInputStream(), "UTF-8"));
                string = bufferedReader.readLine().trim();
            }
            catch (IOException iOException) {
                continue;
            }
            while (string != null) {
                try {
                    if (string.charAt(0) != '#') {
                        Class<?> clazz = Class.forName(string);
                        descriptors.add((InputMethodDescriptor)clazz.newInstance());
                    }
                    string = bufferedReader.readLine().trim();
                }
                catch (IOException iOException) {
                }
                catch (Exception exception) {}
            }
        }
    }
}

