/*
 * Decompiled with CFR 0.152.
 */
package java.awt.geom;

import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.FlatteningPathIterator;
import java.awt.geom.IllegalPathStateException;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.QuadCurve2D;
import java.awt.geom.Rectangle2D;

public final class GeneralPath
implements Shape,
Cloneable {
    public static final int WIND_EVEN_ODD = 0;
    public static final int WIND_NON_ZERO = 1;
    private static final int INIT_SIZE = 10;
    private static final double BIG_VALUE = 1.7976931348623158E307;
    int rule;
    byte[] types;
    float[] xpoints;
    float[] ypoints;
    private int subpath = -1;
    int index;

    public GeneralPath() {
        this(1, 10);
    }

    public GeneralPath(int n) {
        this(n, 10);
    }

    public GeneralPath(int n, int n2) {
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException();
        }
        this.rule = n;
        if (n2 < 10) {
            n2 = 10;
        }
        this.types = new byte[n2];
        this.xpoints = new float[n2];
        this.ypoints = new float[n2];
    }

    public GeneralPath(Shape shape) {
        this.types = new byte[10];
        this.xpoints = new float[10];
        this.ypoints = new float[10];
        PathIterator pathIterator = shape.getPathIterator(null);
        this.setWindingRule(pathIterator.getWindingRule());
        this.append(pathIterator, false);
    }

    public void moveTo(float f, float f2) {
        this.subpath = this.index;
        this.ensureSize(this.index + 1);
        this.types[this.index] = 0;
        this.xpoints[this.index] = f;
        this.ypoints[this.index++] = f2;
    }

    public void lineTo(float f, float f2) {
        this.ensureSize(this.index + 1);
        this.types[this.index] = 1;
        this.xpoints[this.index] = f;
        this.ypoints[this.index++] = f2;
    }

    public void quadTo(float f, float f2, float f3, float f4) {
        this.ensureSize(this.index + 2);
        this.types[this.index] = 2;
        this.xpoints[this.index] = f;
        this.ypoints[this.index++] = f2;
        this.xpoints[this.index] = f3;
        this.ypoints[this.index++] = f4;
    }

    public void curveTo(float f, float f2, float f3, float f4, float f5, float f6) {
        this.ensureSize(this.index + 3);
        this.types[this.index] = 3;
        this.xpoints[this.index] = f;
        this.ypoints[this.index++] = f2;
        this.xpoints[this.index] = f3;
        this.ypoints[this.index++] = f4;
        this.xpoints[this.index] = f5;
        this.ypoints[this.index++] = f6;
    }

    public void closePath() {
        if (this.index >= 1 && this.types[this.index - 1] == 4) {
            return;
        }
        this.ensureSize(this.index + 1);
        this.types[this.index] = 4;
        this.xpoints[this.index] = this.xpoints[this.subpath];
        this.ypoints[this.index++] = this.ypoints[this.subpath];
    }

    public void append(Shape shape, boolean bl) {
        this.append(shape.getPathIterator(null), bl);
    }

    public void append(PathIterator pathIterator, boolean bl) {
        float[] fArray = new float[6];
        while (!pathIterator.isDone()) {
            switch (pathIterator.currentSegment(fArray)) {
                case 0: {
                    if (!bl || this.index == 0) {
                        this.moveTo(fArray[0], fArray[1]);
                        break;
                    }
                    if (this.index >= 1 && this.types[this.index - 1] == 4 && fArray[0] == this.xpoints[this.index - 1] && fArray[1] == this.ypoints[this.index - 1]) break;
                }
                case 1: {
                    this.lineTo(fArray[0], fArray[1]);
                    break;
                }
                case 2: {
                    this.quadTo(fArray[0], fArray[1], fArray[2], fArray[3]);
                    break;
                }
                case 3: {
                    this.curveTo(fArray[0], fArray[1], fArray[2], fArray[3], fArray[4], fArray[5]);
                    break;
                }
                case 4: {
                    this.closePath();
                }
            }
            bl = false;
            pathIterator.next();
        }
    }

    public int getWindingRule() {
        return this.rule;
    }

    public void setWindingRule(int n) {
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException();
        }
        this.rule = n;
    }

    public Point2D getCurrentPoint() {
        if (this.subpath < 0) {
            return null;
        }
        return new Point2D.Float(this.xpoints[this.index - 1], this.ypoints[this.index - 1]);
    }

    public void reset() {
        this.subpath = -1;
        this.index = 0;
    }

    public void transform(AffineTransform affineTransform) {
        double[] dArray = new double[6];
        affineTransform.getMatrix(dArray);
        for (int i = 0; i < this.index; ++i) {
            double d = dArray[0] * (double)this.xpoints[i] + dArray[2] * (double)this.ypoints[i] + dArray[4];
            double d2 = dArray[1] * (double)this.xpoints[i] + dArray[3] * (double)this.ypoints[i] + dArray[5];
            this.xpoints[i] = (float)d;
            this.ypoints[i] = (float)d2;
        }
    }

    public Shape createTransformedShape(AffineTransform affineTransform) {
        GeneralPath generalPath = new GeneralPath(this);
        generalPath.transform(affineTransform);
        return generalPath;
    }

    public Rectangle getBounds() {
        return this.getBounds2D().getBounds();
    }

    public Rectangle2D getBounds2D() {
        float f;
        float f2;
        float f3;
        float f4;
        if (this.index > 0) {
            f3 = f4 = this.xpoints[0];
            f = f2 = this.ypoints[0];
        } else {
            f2 = 0.0f;
            f = 0.0f;
            f4 = 0.0f;
            f3 = 0.0f;
        }
        for (int i = 0; i < this.index; ++i) {
            f3 = Math.min(this.xpoints[i], f3);
            f = Math.min(this.ypoints[i], f);
            f4 = Math.max(this.xpoints[i], f4);
            f2 = Math.max(this.ypoints[i], f2);
        }
        return new Rectangle2D.Float(f3, f, f4 - f3, f2 - f);
    }

    public boolean contains(double d, double d2) {
        return this.getWindingNumber(d, d2) != 0;
    }

    public boolean contains(Point2D point2D) {
        return this.contains(point2D.getX(), point2D.getY());
    }

    public boolean contains(double d, double d2, double d3, double d4) {
        if (!this.getBounds2D().intersects(d, d2, d3, d4)) {
            return false;
        }
        if (this.getAxisIntersections(d, d2, false, d3) != 0 || this.getAxisIntersections(d, d2 + d4, false, d3) != 0 || this.getAxisIntersections(d + d3, d2, true, d4) != 0 || this.getAxisIntersections(d, d2, true, d4) != 0) {
            return false;
        }
        return this.getWindingNumber(d, d2) != 0;
    }

    public boolean contains(Rectangle2D rectangle2D) {
        return this.contains(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
    }

    public boolean intersects(double d, double d2, double d3, double d4) {
        if (this.getAxisIntersections(d, d2, false, d3) != 0 || this.getAxisIntersections(d, d2 + d4, false, d3) != 0 || this.getAxisIntersections(d + d3, d2, true, d4) != 0 || this.getAxisIntersections(d, d2, true, d4) != 0) {
            return true;
        }
        return this.getWindingNumber(d, d2) != 0;
    }

    public boolean intersects(Rectangle2D rectangle2D) {
        return this.intersects(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
    }

    public PathIterator getPathIterator(AffineTransform affineTransform) {
        return new GeneralPathIterator(this, affineTransform);
    }

    public PathIterator getPathIterator(AffineTransform affineTransform, double d) {
        return new FlatteningPathIterator(this.getPathIterator(affineTransform), d);
    }

    public Object clone() {
        return new GeneralPath(this);
    }

    private void ensureSize(int n) {
        if (this.subpath < 0) {
            throw new IllegalPathStateException("need initial moveto");
        }
        if (n <= this.xpoints.length) {
            return;
        }
        byte[] byArray = new byte[this.types.length << 1];
        System.arraycopy(this.types, 0, byArray, 0, this.index);
        this.types = byArray;
        float[] fArray = new float[this.xpoints.length << 1];
        System.arraycopy(this.xpoints, 0, fArray, 0, this.index);
        this.xpoints = fArray;
        fArray = new float[this.ypoints.length << 1];
        System.arraycopy(this.ypoints, 0, fArray, 0, this.index);
        this.ypoints = fArray;
    }

    private int getAxisIntersections(double d, double d2, boolean bl, double d3) {
        return this.evaluateCrossings(d, d2, false, bl, d3);
    }

    private int getWindingNumber(double d, double d2) {
        return this.evaluateCrossings(d, d2, true, true, 1.7976931348623158E307);
    }

    private int evaluateCrossings(double d, double d2, boolean bl, boolean bl2, double d3) {
        float[] fArray;
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        int n = bl ? -1 : 1;
        double[] dArray = new double[4];
        double d4 = 0.0;
        int n2 = 0;
        int n3 = 0;
        boolean bl3 = false;
        if (this.index == 0) {
            return 0;
        }
        if (bl2) {
            fArray = this.ypoints;
            this.ypoints = this.xpoints;
            this.xpoints = fArray;
            double d5 = d2;
            d2 = d;
            d = d5;
        }
        if ((d4 = (double)this.ypoints[0] * 1.0E-7) == 0.0) {
            d4 = 1.0E-7;
        }
        n2 = 0;
        while (n2 < this.index) {
            switch (this.types[n2]) {
                case 0: {
                    double d6;
                    double d7;
                    double d8;
                    double d9;
                    if (bl3) {
                        d9 = f;
                        d8 = f2;
                        d7 = f3;
                        d6 = f4;
                        if (d8 == 0.0) {
                            d8 -= d4;
                        }
                        if (d6 == 0.0) {
                            d6 -= d4;
                        }
                        if (Line2D.linesIntersect(d9, d8, d7, d6, d4, 0.0, d3, 0.0)) {
                            n3 += d6 < d8 ? 1 : n;
                        }
                        f = f3;
                        f2 = f4;
                    }
                    f = f3 = this.xpoints[n2] - (float)d;
                    f2 = f4 = this.ypoints[n2++] - (float)d2;
                    bl3 = true;
                    break;
                }
                case 4: {
                    double d9 = f;
                    double d8 = f2;
                    double d7 = f3;
                    double d6 = f4;
                    if (d8 == 0.0) {
                        d8 -= d4;
                    }
                    if (d6 == 0.0) {
                        d6 -= d4;
                    }
                    if (Line2D.linesIntersect(d9, d8, d7, d6, d4, 0.0, d3, 0.0)) {
                        n3 += d6 < d8 ? 1 : n;
                    }
                    f = f3;
                    f2 = f4;
                    ++n2;
                    bl3 = false;
                    break;
                }
                case 1: {
                    double d9 = f;
                    double d8 = f2;
                    double d7 = this.xpoints[n2] - (float)d;
                    double d6 = this.ypoints[n2++] - (float)d2;
                    if (d8 == 0.0) {
                        d8 -= d4;
                    }
                    if (d6 == 0.0) {
                        d6 -= d4;
                    }
                    if (Line2D.linesIntersect(d9, d8, d7, d6, d4, 0.0, d3, 0.0)) {
                        n3 += d6 < d8 ? 1 : n;
                    }
                    f = this.xpoints[n2 - 1] - (float)d;
                    f2 = this.ypoints[n2 - 1] - (float)d2;
                    break;
                }
                case 2: {
                    double d10;
                    int n4;
                    double d9 = f;
                    double d8 = f2;
                    double d7 = (double)this.xpoints[n2] - d;
                    double d6 = (double)this.ypoints[n2++] - d2;
                    double d11 = (double)this.xpoints[n2] - d;
                    double d12 = (double)this.ypoints[n2++] - d2;
                    if ((d9 > 0.0 || d7 > 0.0 || d11 > 0.0) && (d8 * d6 <= 0.0 || d6 * d12 <= 0.0)) {
                        if (d8 == 0.0) {
                            d8 -= d4;
                        }
                        if (d12 == 0.0) {
                            d12 -= d4;
                        }
                        dArray[0] = d8;
                        dArray[1] = 2.0 * (d6 - d8);
                        dArray[2] = d12 - 2.0 * d6 + d8;
                        n4 = QuadCurve2D.solveQuadratic(dArray);
                        if (n4 == 2) {
                            for (int i = 0; i < n4; ++i) {
                                float f5 = (float)dArray[i];
                                if (!(f5 > 0.0f) || !(f5 < 1.0f) || !((d10 = (double)(f5 * f5) * (d11 - 2.0 * d7 + d9) + (double)(2.0f * f5) * (d7 - d9) + d9) >= 0.0) || !(d10 <= d3)) continue;
                                n3 += (double)(2.0f * f5) * (d12 - 2.0 * d6 + d8) + 2.0 * (d6 - d8) < 0.0 ? 1 : n;
                            }
                        }
                    }
                    f = this.xpoints[n2 - 1] - (float)d;
                    f2 = this.ypoints[n2 - 1] - (float)d2;
                    break;
                }
                case 3: {
                    double d10;
                    int n4;
                    double d9 = f;
                    double d8 = f2;
                    double d7 = (double)this.xpoints[n2] - d;
                    double d6 = (double)this.ypoints[n2++] - d2;
                    double d11 = (double)this.xpoints[n2] - d;
                    double d12 = (double)this.ypoints[n2++] - d2;
                    double d13 = (double)this.xpoints[n2] - d;
                    double d14 = (double)this.ypoints[n2++] - d2;
                    if ((d9 > 0.0 || d7 > 0.0 || d11 > 0.0 || d13 > 0.0) && (d8 * d6 <= 0.0 || d6 * d12 <= 0.0 || d12 * d14 <= 0.0)) {
                        if (d8 == 0.0) {
                            d8 -= d4;
                        }
                        if (d14 == 0.0) {
                            d14 -= d4;
                        }
                        dArray[0] = d8;
                        dArray[1] = 3.0 * (d6 - d8);
                        dArray[2] = 3.0 * (d12 + d8 - 2.0 * d6);
                        dArray[3] = d14 - 3.0 * d12 + 3.0 * d6 - d8;
                        n4 = CubicCurve2D.solveCubic(dArray);
                        if (n4 != 0) {
                            for (int i = 0; i < n4; ++i) {
                                float f6 = (float)dArray[i];
                                if (!((double)f6 > 0.0) || !((double)f6 < 1.0) || !((d10 = (double)(-(f6 * f6 * f6)) * (d9 - 3.0 * d7 + 3.0 * d11 - d13) + (double)(3.0f * f6 * f6) * (d9 - 2.0 * d7 + d11) + (double)(3.0f * f6) * (d7 - d9) + d9) >= 0.0) || !(d10 <= d3)) continue;
                                n3 += (double)(3.0f * f6 * f6) * (d14 + 3.0 * d6 - 3.0 * d12 - d8) + (double)(6.0f * f6) * (d8 - 2.0 * d6 + d12) + 3.0 * (d6 - d8) < 0.0 ? 1 : n;
                            }
                        }
                    }
                    f = this.xpoints[n2 - 1] - (float)d;
                    f2 = this.ypoints[n2 - 1] - (float)d2;
                }
            }
        }
        if (bl2) {
            fArray = this.ypoints;
            this.ypoints = this.xpoints;
            this.xpoints = fArray;
        }
        return n3;
    }

    private static class GeneralPathIterator
    implements PathIterator {
        private static final int[] NUM_COORDS = new int[]{1, 1, 2, 3, 0};
        final GeneralPath path;
        private final AffineTransform transform;
        private int pos;

        GeneralPathIterator(GeneralPath generalPath, AffineTransform affineTransform) {
            this.path = generalPath;
            this.transform = affineTransform;
        }

        public int getWindingRule() {
            return this.path.rule;
        }

        public boolean isDone() {
            return this.pos >= this.path.index;
        }

        public void next() {
            byte by = this.path.types[this.pos];
            this.pos = by == 4 ? ++this.pos : (this.pos += NUM_COORDS[by]);
        }

        public int currentSegment(float[] fArray) {
            byte by = this.path.types[this.pos];
            int n = NUM_COORDS[by];
            if (n > 0) {
                for (int i = 0; i < n; ++i) {
                    fArray[i << 1] = this.path.xpoints[this.pos + i];
                    fArray[(i << 1) + 1] = this.path.ypoints[this.pos + i];
                }
                if (this.transform != null) {
                    this.transform.transform(fArray, 0, fArray, 0, n);
                }
            }
            return by;
        }

        public int currentSegment(double[] dArray) {
            byte by = this.path.types[this.pos];
            int n = NUM_COORDS[by];
            if (n > 0) {
                for (int i = 0; i < n; ++i) {
                    dArray[i << 1] = this.path.xpoints[this.pos + i];
                    dArray[(i << 1) + 1] = this.path.ypoints[this.pos + i];
                }
                if (this.transform != null) {
                    this.transform.transform(dArray, 0, dArray, 0, n);
                }
            }
            return by;
        }
    }
}

