/*
 * Decompiled with CFR 0.152.
 */
package java.awt.geom;

import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.FlatteningPathIterator;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.QuadCurve2D;
import java.awt.geom.Rectangle2D;
import java.util.NoSuchElementException;

public abstract class CubicCurve2D
implements Shape,
Cloneable {
    private static final double BIG_VALUE = 1.7976931348623158E307;
    private static final double EPSILON = 1.0E-10;

    protected CubicCurve2D() {
    }

    public abstract double getX1();

    public abstract double getY1();

    public abstract Point2D getP1();

    public abstract double getCtrlX1();

    public abstract double getCtrlY1();

    public abstract Point2D getCtrlP1();

    public abstract double getCtrlX2();

    public abstract double getCtrlY2();

    public abstract Point2D getCtrlP2();

    public abstract double getX2();

    public abstract double getY2();

    public abstract Point2D getP2();

    public abstract void setCurve(double var1, double var3, double var5, double var7, double var9, double var11, double var13, double var15);

    public void setCurve(double[] dArray, int n) {
        this.setCurve(dArray[n++], dArray[n++], dArray[n++], dArray[n++], dArray[n++], dArray[n++], dArray[n++], dArray[n++]);
    }

    public void setCurve(Point2D point2D, Point2D point2D2, Point2D point2D3, Point2D point2D4) {
        this.setCurve(point2D.getX(), point2D.getY(), point2D2.getX(), point2D2.getY(), point2D3.getX(), point2D3.getY(), point2D4.getX(), point2D4.getY());
    }

    public void setCurve(Point2D[] point2DArray, int n) {
        this.setCurve(point2DArray[n].getX(), point2DArray[n++].getY(), point2DArray[n].getX(), point2DArray[n++].getY(), point2DArray[n].getX(), point2DArray[n++].getY(), point2DArray[n].getX(), point2DArray[n++].getY());
    }

    public void setCurve(CubicCurve2D cubicCurve2D) {
        this.setCurve(cubicCurve2D.getX1(), cubicCurve2D.getY1(), cubicCurve2D.getCtrlX1(), cubicCurve2D.getCtrlY1(), cubicCurve2D.getCtrlX2(), cubicCurve2D.getCtrlY2(), cubicCurve2D.getX2(), cubicCurve2D.getY2());
    }

    public static double getFlatnessSq(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
        return Math.max(Line2D.ptSegDistSq(d, d2, d7, d8, d3, d4), Line2D.ptSegDistSq(d, d2, d7, d8, d5, d6));
    }

    public static double getFlatness(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
        return Math.sqrt(CubicCurve2D.getFlatnessSq(d, d2, d3, d4, d5, d6, d7, d8));
    }

    public static double getFlatnessSq(double[] dArray, int n) {
        return CubicCurve2D.getFlatnessSq(dArray[n++], dArray[n++], dArray[n++], dArray[n++], dArray[n++], dArray[n++], dArray[n++], dArray[n++]);
    }

    public static double getFlatness(double[] dArray, int n) {
        return Math.sqrt(CubicCurve2D.getFlatnessSq(dArray[n++], dArray[n++], dArray[n++], dArray[n++], dArray[n++], dArray[n++], dArray[n++], dArray[n++]));
    }

    public double getFlatnessSq() {
        return CubicCurve2D.getFlatnessSq(this.getX1(), this.getY1(), this.getCtrlX1(), this.getCtrlY1(), this.getCtrlX2(), this.getCtrlY2(), this.getX2(), this.getY2());
    }

    public double getFlatness() {
        return Math.sqrt(CubicCurve2D.getFlatnessSq(this.getX1(), this.getY1(), this.getCtrlX1(), this.getCtrlY1(), this.getCtrlX2(), this.getCtrlY2(), this.getX2(), this.getY2()));
    }

    public void subdivide(CubicCurve2D cubicCurve2D, CubicCurve2D cubicCurve2D2) {
        double[] dArray = new double[]{this.getX1(), this.getY1(), this.getCtrlX1(), this.getCtrlY1(), this.getCtrlX2(), this.getCtrlY2(), this.getX2(), this.getY2(), 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
        CubicCurve2D.subdivide(dArray, 0, dArray, 0, dArray, 6);
        if (cubicCurve2D != null) {
            cubicCurve2D.setCurve(dArray, 0);
        }
        if (cubicCurve2D2 != null) {
            cubicCurve2D2.setCurve(dArray, 6);
        }
    }

    public static void subdivide(CubicCurve2D cubicCurve2D, CubicCurve2D cubicCurve2D2, CubicCurve2D cubicCurve2D3) {
        cubicCurve2D.subdivide(cubicCurve2D2, cubicCurve2D3);
    }

    public static void subdivide(double[] dArray, int n, double[] dArray2, int n2, double[] dArray3, int n3) {
        double d = dArray[n];
        double d2 = dArray[n + 1];
        double d3 = dArray[n + 2];
        double d4 = dArray[n + 3];
        double d5 = dArray[n + 4];
        double d6 = dArray[n + 5];
        double d7 = dArray[n + 6];
        double d8 = dArray[n + 7];
        double d9 = (d + d3) / 2.0;
        double d10 = (d2 + d4) / 2.0;
        double d11 = (d7 + d5) / 2.0;
        double d12 = (d8 + d6) / 2.0;
        double d13 = (d3 + d5) / 2.0;
        double d14 = (d4 + d6) / 2.0;
        double d15 = (d9 + d13) / 2.0;
        double d16 = (d10 + d14) / 2.0;
        double d17 = (d13 + d11) / 2.0;
        double d18 = (d14 + d12) / 2.0;
        d13 = (d15 + d17) / 2.0;
        d14 = (d16 + d18) / 2.0;
        if (dArray2 != null) {
            dArray2[n2] = d;
            dArray2[n2 + 1] = d2;
            dArray2[n2 + 2] = d9;
            dArray2[n2 + 3] = d10;
            dArray2[n2 + 4] = d15;
            dArray2[n2 + 5] = d16;
            dArray2[n2 + 6] = d13;
            dArray2[n2 + 7] = d14;
        }
        if (dArray3 != null) {
            dArray3[n3] = d13;
            dArray3[n3 + 1] = d14;
            dArray3[n3 + 2] = d17;
            dArray3[n3 + 3] = d18;
            dArray3[n3 + 4] = d11;
            dArray3[n3 + 5] = d12;
            dArray3[n3 + 6] = d7;
            dArray3[n3 + 7] = d8;
        }
    }

    public static int solveCubic(double[] dArray) {
        return CubicCurve2D.solveCubic(dArray, dArray);
    }

    public static int solveCubic(double[] dArray, double[] dArray2) {
        double d = dArray[3];
        if (d == 0.0) {
            return QuadCurve2D.solveQuadratic(dArray, dArray2);
        }
        double d2 = dArray[0] / d;
        double d3 = dArray[1] / d;
        double d4 = dArray[2] / d;
        double d5 = d4 * d4 - 3.0 * d3;
        double d6 = 2.0 * d4 * d4 * d4 - 9.0 * d4 * d3 + 27.0 * d2;
        double d7 = d5 / 9.0;
        double d8 = d6 / 54.0;
        double d9 = d7 * d7 * d7;
        double d10 = d8 * d8;
        double d11 = 729.0 * d6 * d6;
        double d12 = 2916.0 * d5 * d5 * d5;
        if (d8 == 0.0 && d7 == 0.0) {
            dArray2[0] = -d4 / 3.0;
            return 1;
        }
        if (d11 == d12) {
            double d13 = Math.sqrt(d7);
            if (d8 > 0.0) {
                dArray2[0] = -2.0 * d13 - d4 / 3.0;
                dArray2[1] = d13 - d4 / 3.0;
            } else {
                dArray2[0] = -d13 - d4 / 3.0;
                dArray2[1] = 2.0 * d13 - d4 / 3.0;
            }
            return 2;
        }
        if (d11 < d12) {
            double d14 = Math.sqrt(d7);
            double d15 = d14 * d14 * d14;
            double d16 = Math.acos(d8 / d15);
            double d17 = -2.0 * d14;
            dArray2[0] = d17 * Math.cos(d16 / 3.0) - d4 / 3.0;
            dArray2[1] = d17 * Math.cos((d16 + Math.PI * 2) / 3.0) - d4 / 3.0;
            dArray2[2] = d17 * Math.cos((d16 - Math.PI * 2) / 3.0) - d4 / 3.0;
            return 3;
        }
        double d18 = d8 >= 0.0 ? 1 : -1;
        double d19 = -d18 * Math.pow(Math.abs(d8) + Math.sqrt(d10 - d9), 0.3333333333333333);
        double d20 = d7 / d19;
        dArray2[0] = d19 + d20 - d4 / 3.0;
        return 1;
    }

    public boolean contains(double d, double d2) {
        if (!this.getBounds2D().contains(d, d2)) {
            return false;
        }
        return (this.getAxisIntersections(d, d2, true, 1.7976931348623158E307) & 1) != 0;
    }

    public boolean contains(Point2D point2D) {
        return this.contains(point2D.getX(), point2D.getY());
    }

    public boolean intersects(double d, double d2, double d3, double d4) {
        if (!this.getBounds2D().contains(d, d2, d3, d4)) {
            return false;
        }
        if (this.getAxisIntersections(d, d2, true, d3) != 0 || this.getAxisIntersections(d, d2 + d4, true, d3) != 0 || this.getAxisIntersections(d + d3, d2, false, d4) != 0 || this.getAxisIntersections(d, d2, false, d4) != 0) {
            return true;
        }
        return (this.getAxisIntersections(d, d2, true, 1.7976931348623158E307) & 1) != 0;
    }

    public boolean intersects(Rectangle2D rectangle2D) {
        return this.intersects(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
    }

    public boolean contains(double d, double d2, double d3, double d4) {
        if (!this.getBounds2D().intersects(d, d2, d3, d4)) {
            return false;
        }
        if (this.getAxisIntersections(d, d2, true, d3) != 0 || this.getAxisIntersections(d, d2 + d4, true, d3) != 0 || this.getAxisIntersections(d + d3, d2, false, d4) != 0 || this.getAxisIntersections(d, d2, false, d4) != 0) {
            return false;
        }
        return (this.getAxisIntersections(d, d2, true, 1.7976931348623158E307) & 1) != 0;
    }

    public boolean contains(Rectangle2D rectangle2D) {
        return this.contains(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
    }

    public Rectangle getBounds() {
        return this.getBounds2D().getBounds();
    }

    public PathIterator getPathIterator(final AffineTransform affineTransform) {
        return new PathIterator(){
            private int current = 0;

            public int getWindingRule() {
                return 1;
            }

            public boolean isDone() {
                return this.current >= 2;
            }

            public void next() {
                ++this.current;
            }

            public int currentSegment(float[] fArray) {
                int n;
                switch (this.current) {
                    case 0: {
                        fArray[0] = (float)CubicCurve2D.this.getX1();
                        fArray[1] = (float)CubicCurve2D.this.getY1();
                        n = 0;
                        break;
                    }
                    case 1: {
                        fArray[0] = (float)CubicCurve2D.this.getCtrlX1();
                        fArray[1] = (float)CubicCurve2D.this.getCtrlY1();
                        fArray[2] = (float)CubicCurve2D.this.getCtrlX2();
                        fArray[3] = (float)CubicCurve2D.this.getCtrlY2();
                        fArray[4] = (float)CubicCurve2D.this.getX2();
                        fArray[5] = (float)CubicCurve2D.this.getY2();
                        n = 3;
                        break;
                    }
                    default: {
                        throw new NoSuchElementException("cubic iterator out of bounds");
                    }
                }
                if (affineTransform != null) {
                    affineTransform.transform(fArray, 0, fArray, 0, 3);
                }
                return n;
            }

            public int currentSegment(double[] dArray) {
                int n;
                switch (this.current) {
                    case 0: {
                        dArray[0] = CubicCurve2D.this.getX1();
                        dArray[1] = CubicCurve2D.this.getY1();
                        n = 0;
                        break;
                    }
                    case 1: {
                        dArray[0] = CubicCurve2D.this.getCtrlX1();
                        dArray[1] = CubicCurve2D.this.getCtrlY1();
                        dArray[2] = CubicCurve2D.this.getCtrlX2();
                        dArray[3] = CubicCurve2D.this.getCtrlY2();
                        dArray[4] = CubicCurve2D.this.getX2();
                        dArray[5] = CubicCurve2D.this.getY2();
                        n = 3;
                        break;
                    }
                    default: {
                        throw new NoSuchElementException("cubic iterator out of bounds");
                    }
                }
                if (affineTransform != null) {
                    affineTransform.transform(dArray, 0, dArray, 0, 3);
                }
                return n;
            }
        };
    }

    public PathIterator getPathIterator(AffineTransform affineTransform, double d) {
        return new FlatteningPathIterator(this.getPathIterator(affineTransform), d);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw (Error)new InternalError().initCause(cloneNotSupportedException);
        }
    }

    private int getAxisIntersections(double d, double d2, boolean bl, double d3) {
        double d4;
        double d5;
        double d6;
        double d7;
        double d8;
        double d9;
        int n = 0;
        double[] dArray = new double[4];
        double d10 = 0.0;
        double d11 = 0.0;
        if (bl) {
            d11 = this.getY1() - d2;
            d9 = this.getCtrlY1() - d2;
            d8 = this.getCtrlY2() - d2;
            d10 = this.getY2() - d2;
            d7 = this.getX1() - d;
            d6 = this.getCtrlX1() - d;
            d5 = this.getCtrlX2() - d;
            d4 = this.getX2() - d;
        } else {
            d11 = this.getX1() - d;
            d9 = this.getCtrlX1() - d;
            d8 = this.getCtrlX2() - d;
            d10 = this.getX2() - d;
            d7 = this.getY1() - d2;
            d6 = this.getCtrlY1() - d2;
            d5 = this.getCtrlY2() - d2;
            d4 = this.getY2() - d2;
        }
        if (d11 == 0.0 || d10 == 0.0) {
            double d12 = this.getFlatness() * 1.0E-10;
            if (d11 == 0.0) {
                d11 -= d12;
            }
            if (d10 == 0.0) {
                d10 -= d12;
            }
        }
        if (bl) {
            if (Line2D.linesIntersect(d7, d11, d4, d10, 1.0E-10, 0.0, d3, 0.0)) {
                ++n;
            }
        } else if (Line2D.linesIntersect(d11, d7, d10, d4, 0.0, 1.0E-10, 0.0, d3)) {
            ++n;
        }
        dArray[0] = d11;
        dArray[1] = 3.0 * (d9 - d11);
        dArray[2] = 3.0 * (d8 + d11 - 2.0 * d9);
        dArray[3] = d10 - 3.0 * d8 + 3.0 * d9 - d11;
        int n2 = CubicCurve2D.solveCubic(dArray);
        if (n2 != 0) {
            for (int i = 0; i < n2; ++i) {
                double d13;
                double d14 = dArray[i];
                if (!(d14 >= 0.0) || !(d14 <= 1.0) || !((d13 = -(d14 * d14 * d14) * (d7 - 3.0 * d6 + 3.0 * d5 - d4) + 3.0 * d14 * d14 * (d7 - 2.0 * d6 + d5) + 3.0 * d14 * (d6 - d7) + d7) > 0.0) || !(d13 <= d3)) continue;
                ++n;
            }
        }
        return n;
    }

    public static class Float
    extends CubicCurve2D {
        public float x1;
        public float y1;
        public float ctrlx1;
        public float ctrly1;
        public float ctrlx2;
        public float ctrly2;
        public float x2;
        public float y2;

        public Float() {
        }

        public Float(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
            this.x1 = f;
            this.y1 = f2;
            this.ctrlx1 = f3;
            this.ctrly1 = f4;
            this.ctrlx2 = f5;
            this.ctrly2 = f6;
            this.x2 = f7;
            this.y2 = f8;
        }

        public double getX1() {
            return this.x1;
        }

        public double getY1() {
            return this.y1;
        }

        public Point2D getP1() {
            return new Point2D.Float(this.x1, this.y1);
        }

        public double getCtrlX1() {
            return this.ctrlx1;
        }

        public double getCtrlY1() {
            return this.ctrly1;
        }

        public Point2D getCtrlP1() {
            return new Point2D.Float(this.ctrlx1, this.ctrly1);
        }

        public double getCtrlX2() {
            return this.ctrlx2;
        }

        public double getCtrlY2() {
            return this.ctrly2;
        }

        public Point2D getCtrlP2() {
            return new Point2D.Float(this.ctrlx2, this.ctrly2);
        }

        public double getX2() {
            return this.x2;
        }

        public double getY2() {
            return this.y2;
        }

        public Point2D getP2() {
            return new Point2D.Float(this.x2, this.y2);
        }

        public void setCurve(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
            this.x1 = (float)d;
            this.y1 = (float)d2;
            this.ctrlx1 = (float)d3;
            this.ctrly1 = (float)d4;
            this.ctrlx2 = (float)d5;
            this.ctrly2 = (float)d6;
            this.x2 = (float)d7;
            this.y2 = (float)d8;
        }

        public void setCurve(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
            this.x1 = f;
            this.y1 = f2;
            this.ctrlx1 = f3;
            this.ctrly1 = f4;
            this.ctrlx2 = f5;
            this.ctrly2 = f6;
            this.x2 = f7;
            this.y2 = f8;
        }

        public Rectangle2D getBounds2D() {
            float f = Math.min(Math.min(this.x1, this.ctrlx1), Math.min(this.ctrlx2, this.x2));
            float f2 = Math.min(Math.min(this.y1, this.ctrly1), Math.min(this.ctrly2, this.y2));
            float f3 = Math.max(Math.max(this.x1, this.ctrlx1), Math.max(this.ctrlx2, this.x2));
            float f4 = Math.max(Math.max(this.y1, this.ctrly1), Math.max(this.ctrly2, this.y2));
            return new Rectangle2D.Float(f, f2, f3 - f, f4 - f2);
        }
    }

    public static class Double
    extends CubicCurve2D {
        public double x1;
        public double y1;
        public double ctrlx1;
        public double ctrly1;
        public double ctrlx2;
        public double ctrly2;
        public double x2;
        public double y2;

        public Double() {
        }

        public Double(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
            this.x1 = d;
            this.y1 = d2;
            this.ctrlx1 = d3;
            this.ctrly1 = d4;
            this.ctrlx2 = d5;
            this.ctrly2 = d6;
            this.x2 = d7;
            this.y2 = d8;
        }

        public double getX1() {
            return this.x1;
        }

        public double getY1() {
            return this.y1;
        }

        public Point2D getP1() {
            return new Point2D.Double(this.x1, this.y1);
        }

        public double getCtrlX1() {
            return this.ctrlx1;
        }

        public double getCtrlY1() {
            return this.ctrly1;
        }

        public Point2D getCtrlP1() {
            return new Point2D.Double(this.ctrlx1, this.ctrly1);
        }

        public double getCtrlX2() {
            return this.ctrlx2;
        }

        public double getCtrlY2() {
            return this.ctrly2;
        }

        public Point2D getCtrlP2() {
            return new Point2D.Double(this.ctrlx2, this.ctrly2);
        }

        public double getX2() {
            return this.x2;
        }

        public double getY2() {
            return this.y2;
        }

        public Point2D getP2() {
            return new Point2D.Double(this.x2, this.y2);
        }

        public void setCurve(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
            this.x1 = d;
            this.y1 = d2;
            this.ctrlx1 = d3;
            this.ctrly1 = d4;
            this.ctrlx2 = d5;
            this.ctrly2 = d6;
            this.x2 = d7;
            this.y2 = d8;
        }

        public Rectangle2D getBounds2D() {
            double d = Math.min(Math.min(this.x1, this.ctrlx1), Math.min(this.ctrlx2, this.x2));
            double d2 = Math.min(Math.min(this.y1, this.ctrly1), Math.min(this.ctrly2, this.y2));
            double d3 = Math.max(Math.max(this.x1, this.ctrlx1), Math.max(this.ctrlx2, this.x2));
            double d4 = Math.max(Math.max(this.y1, this.ctrly1), Math.max(this.ctrly2, this.y2));
            return new Rectangle2D.Double(d, d2, d3 - d, d4 - d2);
        }
    }
}

