/*
 * Decompiled with CFR 0.152.
 */
package java.awt.geom;

import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.FlatteningPathIterator;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.QuadCurve2D;
import java.awt.geom.Rectangle2D;
import java.util.Vector;

public class Area
implements Shape,
Cloneable {
    private static final double EPSILON = 1.0E-11;
    private static final double RS_EPSILON = 1.0E-13;
    private static final double PE_EPSILON = 1.0E-11;
    Vector solids = new Vector();
    Vector holes = new Vector();
    private Vector cc_intersections;
    private int windingRule;

    public Area() {
    }

    public Area(Shape shape) {
        this();
        Segment segment;
        int n;
        Vector vector = this.makeSegment(shape);
        if (vector == null) {
            return;
        }
        for (int i = 0; i < vector.size(); ++i) {
            if (((Segment)vector.elementAt(i)).getSignedArea() != 0.0) continue;
            vector.remove(i--);
        }
        Vector vector2 = new Vector();
        for (n = 0; n < vector.size(); ++n) {
            Segment segment2 = (Segment)vector.elementAt(n);
            this.createNodesSelf(segment2);
        }
        if (vector.size() > 1) {
            for (n = 0; n < vector.size() - 1; ++n) {
                for (int i = n + 1; i < vector.size(); ++i) {
                    segment = (Segment)vector.elementAt(n);
                    Segment segment3 = (Segment)vector.elementAt(i);
                    this.createNodes(segment, segment3);
                }
            }
        }
        Vector<Segment> vector3 = new Vector<Segment>();
        for (int i = 0; i < vector.size(); ++i) {
            Segment segment4;
            segment = segment4 = (Segment)vector.elementAt(i);
            do {
                vector3.add(segment4);
            } while ((segment4 = segment4.next) != segment);
        }
        vector2 = this.weilerAtherton(vector3);
        this.deleteRedundantPaths(vector2);
    }

    public void add(Area area) {
        Segment segment;
        int n;
        Segment segment2;
        if (this.equals(area)) {
            return;
        }
        if (area.isEmpty()) {
            return;
        }
        Area area2 = (Area)area.clone();
        Vector vector = new Vector();
        Vector vector2 = new Vector();
        vector.addAll(this.solids);
        vector.addAll(this.holes);
        vector2.addAll(area2.solids);
        vector2.addAll(area2.holes);
        int n2 = 0;
        for (int i = 0; i < vector.size(); ++i) {
            segment2 = (Segment)vector.elementAt(i);
            for (int j = 0; j < vector2.size(); ++j) {
                Segment segment3 = (Segment)vector2.elementAt(j);
                n2 += this.createNodes(segment2, segment3);
            }
        }
        Vector vector3 = new Vector();
        Vector<Segment> vector4 = new Vector<Segment>();
        for (n = 0; n < vector.size(); ++n) {
            segment = segment2 = (Segment)vector.elementAt(n);
            do {
                if (!segment2.isSegmentOutside(area)) continue;
                vector4.add(segment2);
            } while ((segment2 = segment2.next) != segment);
        }
        for (n = 0; n < vector2.size(); ++n) {
            segment = segment2 = (Segment)vector2.elementAt(n);
            do {
                if (!segment2.isSegmentOutside(this)) continue;
                vector4.add(segment2);
            } while ((segment2 = segment2.next) != segment);
        }
        vector3 = this.weilerAtherton(vector4);
        this.deleteRedundantPaths(vector3);
    }

    public void subtract(Area area) {
        boolean bl;
        Segment segment;
        Segment segment2;
        int n;
        Cloneable cloneable;
        if (this.isEmpty() || area.isEmpty()) {
            return;
        }
        if (this.equals(area)) {
            this.reset();
            return;
        }
        Vector vector = new Vector();
        Area area2 = (Area)area.clone();
        vector.addAll(this.solids);
        vector.addAll(this.holes);
        this.setDirection(area2.holes, true);
        this.setDirection(area2.solids, false);
        Vector vector2 = new Vector();
        vector2.addAll(area2.solids);
        vector2.addAll(area2.holes);
        int n2 = 0;
        for (int i = 0; i < vector.size(); ++i) {
            cloneable = (Segment)vector.elementAt(i);
            for (n = 0; n < vector2.size(); ++n) {
                segment2 = (Segment)vector2.elementAt(n);
                n2 += this.createNodes((Segment)cloneable, segment2);
            }
        }
        Vector vector3 = new Vector();
        cloneable = new Vector();
        for (n = 0; n < vector.size(); ++n) {
            segment = segment2 = (Segment)vector.elementAt(n);
            if (segment2.isSegmentOutside(area) && segment2.node == null) {
                ((Vector)cloneable).add(segment2);
            }
            bl = false;
            do {
                if (segment2.node == null && !bl) continue;
                boolean bl2 = bl = segment2.node != null;
                if (!segment2.isSegmentOutside(area)) continue;
                ((Vector)cloneable).add(segment2);
            } while ((segment2 = segment2.next) != segment);
        }
        for (n = 0; n < vector2.size(); ++n) {
            segment = segment2 = (Segment)vector2.elementAt(n);
            if (!segment2.isSegmentOutside(this) && segment2.node == null) {
                ((Vector)cloneable).add(segment2);
            }
            segment2 = segment2.next;
            bl = false;
            do {
                if (segment2.node == null && !bl) continue;
                boolean bl3 = bl = segment2.node != null;
                if (segment2.isSegmentOutside(this)) continue;
                ((Vector)cloneable).add(segment2);
            } while ((segment2 = segment2.next) != segment);
        }
        vector3 = this.weilerAtherton((Vector)cloneable);
        this.deleteRedundantPaths(vector3);
    }

    public void intersect(Area area) {
        boolean bl;
        Segment segment;
        Segment segment2;
        int n;
        Cloneable cloneable;
        if (this.isEmpty() || area.isEmpty()) {
            this.reset();
            return;
        }
        if (this.equals(area)) {
            return;
        }
        Vector vector = new Vector();
        Area area2 = (Area)area.clone();
        vector.addAll(this.solids);
        vector.addAll(this.holes);
        Vector vector2 = new Vector();
        vector2.addAll(area2.solids);
        vector2.addAll(area2.holes);
        int n2 = 0;
        for (int i = 0; i < vector.size(); ++i) {
            cloneable = (Segment)vector.elementAt(i);
            for (n = 0; n < vector2.size(); ++n) {
                segment2 = (Segment)vector2.elementAt(n);
                n2 += this.createNodes((Segment)cloneable, segment2);
            }
        }
        Vector vector3 = new Vector();
        cloneable = new Vector();
        for (n = 0; n < vector.size(); ++n) {
            segment = segment2 = (Segment)vector.elementAt(n);
            if (!segment2.isSegmentOutside(area) && segment2.node == null) {
                ((Vector)cloneable).add(segment2);
            }
            bl = false;
            do {
                if (segment2.node == null && !bl) continue;
                boolean bl2 = bl = segment2.node != null;
                if (segment2.isSegmentOutside(area)) continue;
                ((Vector)cloneable).add(segment2);
            } while ((segment2 = segment2.next) != segment);
        }
        for (n = 0; n < vector2.size(); ++n) {
            segment = segment2 = (Segment)vector2.elementAt(n);
            if (!segment2.isSegmentOutside(this) && segment2.node == null) {
                ((Vector)cloneable).add(segment2);
            }
            segment2 = segment2.next;
            bl = false;
            do {
                if (segment2.node == null && !bl) continue;
                boolean bl3 = bl = segment2.node != null;
                if (segment2.isSegmentOutside(this)) continue;
                ((Vector)cloneable).add(segment2);
            } while ((segment2 = segment2.next) != segment);
        }
        vector3 = this.weilerAtherton((Vector)cloneable);
        this.deleteRedundantPaths(vector3);
    }

    public void exclusiveOr(Area area) {
        Segment segment;
        int n;
        Segment segment2;
        if (area.isEmpty()) {
            return;
        }
        if (this.isEmpty()) {
            Area area2 = (Area)area.clone();
            this.solids = area2.solids;
            this.holes = area2.holes;
            return;
        }
        if (this.equals(area)) {
            this.reset();
            return;
        }
        Vector vector = new Vector();
        Area area3 = (Area)area.clone();
        Vector vector2 = new Vector();
        vector.addAll(this.solids);
        vector.addAll(this.holes);
        this.setDirection(area3.holes, true);
        this.setDirection(area3.solids, false);
        vector2.addAll(area3.solids);
        vector2.addAll(area3.holes);
        int n2 = 0;
        for (int i = 0; i < vector.size(); ++i) {
            segment2 = (Segment)vector.elementAt(i);
            for (int j = 0; j < vector2.size(); ++j) {
                Segment segment3 = (Segment)vector2.elementAt(j);
                n2 += this.createNodes(segment2, segment3);
            }
        }
        Vector vector3 = new Vector();
        Vector<Segment> vector4 = new Vector<Segment>();
        for (n = 0; n < vector.size(); ++n) {
            segment = segment2 = (Segment)vector.elementAt(n);
            do {
                vector4.add(segment2);
            } while ((segment2 = segment2.next) != segment);
        }
        for (n = 0; n < vector2.size(); ++n) {
            segment = segment2 = (Segment)vector2.elementAt(n);
            do {
                vector4.add(segment2);
            } while ((segment2 = segment2.next) != segment);
        }
        vector3 = this.weilerAtherton(vector4);
        this.deleteRedundantPaths(vector3);
    }

    public void reset() {
        this.solids = new Vector();
        this.holes = new Vector();
    }

    public boolean isEmpty() {
        int n;
        if (this.solids.size() == 0) {
            return true;
        }
        double d = 0.0;
        for (n = 0; n < this.solids.size(); ++n) {
            d += Math.abs(((Segment)this.solids.elementAt(n)).getSignedArea());
        }
        for (n = 0; n < this.holes.size(); ++n) {
            d -= Math.abs(((Segment)this.holes.elementAt(n)).getSignedArea());
        }
        return d <= 1.0E-11;
    }

    public boolean isPolygonal() {
        int n;
        for (n = 0; n < this.holes.size(); ++n) {
            if (((Segment)this.holes.elementAt(n)).isPolygonal()) continue;
            return false;
        }
        for (n = 0; n < this.solids.size(); ++n) {
            if (((Segment)this.solids.elementAt(n)).isPolygonal()) continue;
            return false;
        }
        return true;
    }

    public boolean isRectangular() {
        if (this.isEmpty()) {
            return true;
        }
        if (this.holes.size() != 0 || this.solids.size() != 1) {
            return false;
        }
        Segment segment = (Segment)this.solids.elementAt(0);
        if (!segment.isPolygonal()) {
            return false;
        }
        int n = 0;
        Segment segment2 = segment;
        do {
            Segment segment3 = segment2.next;
            double d = (segment2.P2.getX() - segment2.P1.getX()) * (segment3.P2.getX() - segment3.P1.getX()) / (segment2.P1.distance(segment2.P2) * segment3.P1.distance(segment3.P2));
            double d2 = (segment2.P2.getY() - segment2.P1.getY()) * (segment3.P2.getY() - segment3.P1.getY()) / (segment2.P1.distance(segment2.P2) * segment3.P1.distance(segment3.P2));
            double d3 = d + d2;
            if (d != 0.0 && d2 != 0.0) {
                return false;
            }
            if (Math.abs(d3) == 0.0) {
                ++n;
                continue;
            }
            if (!(Math.abs(1.0 - d3) > 0.0)) continue;
            return false;
        } while ((segment2 = segment2.next) != segment);
        return n == 4;
    }

    public boolean isSingular() {
        return this.holes.size() == 0 && this.solids.size() <= 1;
    }

    public Rectangle2D getBounds2D() {
        double d;
        double d2;
        if (this.solids.size() == 0) {
            return new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
        }
        double d3 = d2 = ((Segment)this.solids.elementAt((int)0)).P1.getX();
        double d4 = d = ((Segment)this.solids.elementAt((int)0)).P1.getY();
        for (int i = 0; i < this.solids.size(); ++i) {
            Rectangle2D rectangle2D = ((Segment)this.solids.elementAt(i)).getPathBounds();
            d3 = Math.min(rectangle2D.getMinX(), d3);
            d4 = Math.min(rectangle2D.getMinY(), d4);
            d2 = Math.max(rectangle2D.getMaxX(), d2);
            d = Math.max(rectangle2D.getMaxY(), d);
        }
        return new Rectangle2D.Double(d3, d4, d2 - d3, d - d4);
    }

    public Rectangle getBounds() {
        return this.getBounds2D().getBounds();
    }

    public Object clone() {
        try {
            int n;
            Area area = new Area();
            for (n = 0; n < this.solids.size(); ++n) {
                area.solids.add(((Segment)this.solids.elementAt(n)).cloneSegmentList());
            }
            for (n = 0; n < this.holes.size(); ++n) {
                area.holes.add(((Segment)this.holes.elementAt(n)).cloneSegmentList());
            }
            return area;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw (Error)new InternalError().initCause(cloneNotSupportedException);
        }
    }

    public boolean equals(Area area) {
        int n;
        int n2;
        if (area == null) {
            return false;
        }
        if (!this.getBounds2D().equals(area.getBounds2D())) {
            return false;
        }
        if (this.solids.size() != area.solids.size() || this.holes.size() != area.holes.size()) {
            return false;
        }
        Vector vector = new Vector();
        vector.addAll(this.solids);
        vector.addAll(this.holes);
        Vector vector2 = new Vector();
        vector2.addAll(area.solids);
        vector2.addAll(area.holes);
        int n3 = vector.size();
        boolean[][] blArray = new boolean[2][n3];
        for (n2 = 0; n2 < n3; ++n2) {
            for (n = 0; n < n3; ++n) {
                Segment segment = (Segment)vector.elementAt(n2);
                Segment segment2 = (Segment)vector2.elementAt(n);
                if (blArray[0][n2] || blArray[1][n] || !segment.pathEquals(segment2)) continue;
                blArray[1][n] = true;
                blArray[0][n2] = true;
            }
        }
        n2 = 1;
        for (n = 0; n < n3; ++n) {
            n2 = n2 != 0 && blArray[0][n] && blArray[1][n] ? 1 : 0;
        }
        return n2 != 0;
    }

    public void transform(AffineTransform affineTransform) {
        int n;
        for (n = 0; n < this.solids.size(); ++n) {
            ((Segment)this.solids.elementAt(n)).transformSegmentList(affineTransform);
        }
        for (n = 0; n < this.holes.size(); ++n) {
            ((Segment)this.holes.elementAt(n)).transformSegmentList(affineTransform);
        }
        if ((affineTransform.getType() & 0x40) != 0) {
            this.setDirection(this.holes, false);
            this.setDirection(this.solids, true);
        }
    }

    public Area createTransformedArea(AffineTransform affineTransform) {
        Area area = (Area)this.clone();
        area.transform(affineTransform);
        return area;
    }

    public boolean contains(double d, double d2) {
        int n;
        int n2 = 0;
        for (n = 0; n < this.solids.size(); ++n) {
            if (!((Segment)this.solids.elementAt(n)).contains(d, d2)) continue;
            ++n2;
        }
        for (n = 0; n < this.holes.size(); ++n) {
            if (!((Segment)this.holes.elementAt(n)).contains(d, d2)) continue;
            --n2;
        }
        return n2 != 0;
    }

    public boolean contains(Point2D point2D) {
        return this.contains(point2D.getX(), point2D.getY());
    }

    public boolean contains(double d, double d2, double d3, double d4) {
        int n;
        LineSegment[] lineSegmentArray = new LineSegment[]{new LineSegment(d, d2, d + d3, d2), new LineSegment(d, d2 + d4, d + d3, d2 + d4), new LineSegment(d, d2, d, d2 + d4), new LineSegment(d + d3, d2, d + d3, d2 + d4)};
        for (int i = 0; i < 4; ++i) {
            Segment segment;
            Segment segment2;
            for (n = 0; n < this.solids.size(); ++n) {
                segment = segment2 = (Segment)this.solids.elementAt(n);
                do {
                    if (!lineSegmentArray[i].hasIntersections(segment2)) continue;
                    return false;
                } while ((segment2 = segment2.next) != segment);
            }
            for (n = 0; n < this.holes.size(); ++n) {
                segment = segment2 = (Segment)this.holes.elementAt(n);
                do {
                    if (!lineSegmentArray[i].hasIntersections(segment2)) continue;
                    return false;
                } while ((segment2 = segment2.next) != segment);
            }
        }
        if (!this.contains(d, d2)) {
            return false;
        }
        Rectangle2D.Double double_ = new Rectangle2D.Double(d, d2, d3, d4);
        for (n = 0; n < this.holes.size(); ++n) {
            if (((Segment)this.holes.elementAt(n)).isSegmentOutside(double_)) continue;
            return false;
        }
        return true;
    }

    public boolean contains(Rectangle2D rectangle2D) {
        return this.contains(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
    }

    public boolean intersects(double d, double d2, double d3, double d4) {
        if (this.solids.size() == 0) {
            return false;
        }
        LineSegment[] lineSegmentArray = new LineSegment[]{new LineSegment(d, d2, d + d3, d2), new LineSegment(d, d2 + d4, d + d3, d2 + d4), new LineSegment(d, d2, d, d2 + d4), new LineSegment(d + d3, d2, d + d3, d2 + d4)};
        for (int i = 0; i < 4; ++i) {
            Segment segment;
            Segment segment2;
            int n;
            for (n = 0; n < this.solids.size(); ++n) {
                segment = segment2 = (Segment)this.solids.elementAt(n);
                do {
                    if (!lineSegmentArray[i].hasIntersections(segment2)) continue;
                    return true;
                } while ((segment2 = segment2.next) != segment);
            }
            for (n = 0; n < this.holes.size(); ++n) {
                segment = segment2 = (Segment)this.holes.elementAt(n);
                do {
                    if (!lineSegmentArray[i].hasIntersections(segment2)) continue;
                    return true;
                } while ((segment2 = segment2.next) != segment);
            }
        }
        if (this.contains(d + d3 * 0.5, d2 + d4 * 0.5)) {
            return true;
        }
        Point2D point2D = ((Segment)this.solids.elementAt(0)).getMidPoint();
        return new Rectangle2D.Double(d, d2, d3, d4).contains(point2D);
    }

    public boolean intersects(Rectangle2D rectangle2D) {
        return this.intersects(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
    }

    public PathIterator getPathIterator(AffineTransform affineTransform) {
        return new AreaIterator(affineTransform);
    }

    public PathIterator getPathIterator(AffineTransform affineTransform, double d) {
        return new FlatteningPathIterator(this.getPathIterator(affineTransform), d);
    }

    private Vector weilerAtherton(Vector vector) {
        Vector<Segment> vector2 = new Vector<Segment>();
        while (vector.size() > 0) {
            Segment segment;
            Segment segment2 = segment = (Segment)vector.elementAt(0);
            do {
                vector.remove(segment2);
                if (segment2.node == null) continue;
                segment2.next = segment2.node;
                segment2.node = null;
            } while ((segment2 = segment2.next) != segment);
            vector2.add(segment);
        }
        return vector2;
    }

    private int getRecursionDepth(CubicSegment cubicSegment) {
        double d = cubicSegment.P1.getX();
        double d2 = cubicSegment.P1.getY();
        double d3 = cubicSegment.cp1.getX();
        double d4 = cubicSegment.cp1.getY();
        double d5 = cubicSegment.cp2.getX();
        double d6 = cubicSegment.cp2.getY();
        double d7 = cubicSegment.P2.getX();
        double d8 = cubicSegment.P2.getY();
        double d9 = Math.max(Math.max(Math.abs(d - 2.0 * d3 + d5), Math.abs(d3 - 2.0 * d5 + d7)), Math.max(Math.abs(d2 - 2.0 * d4 + d6), Math.abs(d4 - 2.0 * d6 + d8)));
        double d10 = Math.sqrt(2.0) * 6.0 * d9 / 8.0E-13;
        int n = (int)Math.ceil(Math.log(d10) / Math.log(4.0));
        return n;
    }

    private void recursiveSubdivide(CubicCurve2D cubicCurve2D, CubicCurve2D cubicCurve2D2, int n, int n2, double d, double d2, double d3, double d4) {
        boolean bl;
        boolean bl2 = n <= 0;
        boolean bl3 = bl = n2 <= 0;
        if (bl2 && bl) {
            double d5 = cubicCurve2D.getP2().getX() - cubicCurve2D.getP1().getX();
            double d6 = cubicCurve2D.getP2().getY() - cubicCurve2D.getP1().getY();
            double d7 = cubicCurve2D2.getP2().getX() - cubicCurve2D2.getP1().getX();
            double d8 = cubicCurve2D2.getP2().getY() - cubicCurve2D2.getP1().getY();
            double d9 = cubicCurve2D2.getP1().getX() - cubicCurve2D.getP1().getX();
            double d10 = cubicCurve2D2.getP1().getY() - cubicCurve2D.getP1().getY();
            double d11 = d7 * d6 - d8 * d5;
            if (d11 + 1.0 == 1.0) {
                return;
            }
            double d12 = 1.0 / d11;
            double d13 = (d7 * d10 - d8 * d9) * d12;
            double d14 = (d5 * d10 - d6 * d9) * d12;
            if (d13 < 0.0 || d13 > 1.0 || d14 < 0.0 || d14 > 1.0) {
                return;
            }
            double[] dArray = new double[]{d + d13 * d3, d2 + d14 * d3};
            this.cc_intersections.add(dArray);
            return;
        }
        CubicCurve2D.Double double_ = new CubicCurve2D.Double();
        CubicCurve2D.Double double_2 = new CubicCurve2D.Double();
        CubicCurve2D.Double double_3 = new CubicCurve2D.Double();
        CubicCurve2D.Double double_4 = new CubicCurve2D.Double();
        if (!bl2 && !bl) {
            --n;
            --n2;
            d3 *= 0.5;
            d4 *= 0.5;
            cubicCurve2D.subdivide(double_, double_2);
            cubicCurve2D2.subdivide(double_3, double_4);
            if (double_.getBounds2D().intersects(double_3.getBounds2D())) {
                this.recursiveSubdivide(double_, double_3, n, n2, d, d2, d3, d4);
            }
            if (double_.getBounds2D().intersects(double_4.getBounds2D())) {
                this.recursiveSubdivide(double_, double_4, n, n2, d, d2 + d4, d3, d4);
            }
            if (double_2.getBounds2D().intersects(double_3.getBounds2D())) {
                this.recursiveSubdivide(double_2, double_3, n, n2, d + d3, d2, d3, d4);
            }
            if (double_2.getBounds2D().intersects(double_4.getBounds2D())) {
                this.recursiveSubdivide(double_2, double_4, n, n2, d + d3, d2 + d4, d3, d4);
            }
            return;
        }
        if (!bl2) {
            --n;
            cubicCurve2D.subdivide(double_, double_2);
            d3 *= 0.5;
            if (double_.getBounds2D().intersects(cubicCurve2D2.getBounds2D())) {
                this.recursiveSubdivide(double_, cubicCurve2D2, n, n2, d, d2, d3, d4);
            }
            if (double_2.getBounds2D().intersects(cubicCurve2D2.getBounds2D())) {
                this.recursiveSubdivide(double_2, cubicCurve2D2, n, n2, d + d3, d2, d3, d4);
            }
            return;
        }
        --n2;
        cubicCurve2D2.subdivide(double_3, double_4);
        d4 *= 0.5;
        if (cubicCurve2D.getBounds2D().intersects(double_3.getBounds2D())) {
            this.recursiveSubdivide(cubicCurve2D, double_3, n, n2, d, d2, d3, d4);
        }
        if (cubicCurve2D.getBounds2D().intersects(double_4.getBounds2D())) {
            this.recursiveSubdivide(cubicCurve2D, double_4, n, n2, d, d2 + d4, d3, d4);
        }
    }

    Intersection[] cubicCubicIntersect(CubicSegment cubicSegment, CubicSegment cubicSegment2) {
        Rectangle2D rectangle2D;
        Rectangle2D rectangle2D2 = cubicSegment.getBounds();
        if (!rectangle2D2.intersects(rectangle2D = cubicSegment2.getBounds())) {
            return null;
        }
        this.cc_intersections = new Vector();
        this.recursiveSubdivide(cubicSegment.getCubicCurve2D(), cubicSegment2.getCubicCurve2D(), this.getRecursionDepth(cubicSegment), this.getRecursionDepth(cubicSegment2), 0.0, 0.0, 1.0, 1.0);
        if (this.cc_intersections.size() == 0) {
            return null;
        }
        Intersection[] intersectionArray = new Intersection[this.cc_intersections.size()];
        for (int i = 0; i < this.cc_intersections.size(); ++i) {
            double[] dArray = (double[])this.cc_intersections.elementAt(i);
            intersectionArray[i] = new Intersection(cubicSegment.evaluatePoint(dArray[0]), dArray[0], dArray[1]);
        }
        this.cc_intersections = null;
        return intersectionArray;
    }

    Intersection[] lineQuadIntersect(LineSegment lineSegment, QuadSegment quadSegment) {
        double d;
        double[] dArray = new double[3];
        double[] dArray2 = new double[3];
        double[] dArray3 = new double[3];
        double d2 = quadSegment.P1.getX();
        double d3 = quadSegment.P1.getY();
        double d4 = quadSegment.cp.getX();
        double d5 = quadSegment.cp.getY();
        double d6 = quadSegment.P2.getX();
        double d7 = quadSegment.P2.getY();
        double d8 = lineSegment.P1.getX();
        double d9 = lineSegment.P1.getY();
        double d10 = lineSegment.P2.getX();
        double d11 = lineSegment.P2.getY();
        double d12 = d10 - d8;
        double d13 = d11 - d9;
        dArray[0] = d3;
        dArray[1] = 2.0 * (d5 - d3);
        dArray[2] = d7 - 2.0 * d5 + d3;
        dArray2[0] = d2;
        dArray2[1] = 2.0 * (d4 - d2);
        dArray2[2] = d6 - 2.0 * d4 + d2;
        if (d13 == 0.0 && d12 == 0.0) {
            return null;
        }
        if (d12 == 0.0 || d13 / d12 > 1.0) {
            d = d12 / d13;
            dArray2[0] = dArray2[0] - d8;
            dArray[0] = dArray[0] - d9;
            dArray[0] = dArray[0] * d;
            dArray[1] = dArray[1] * d;
            dArray[2] = dArray[2] * d;
        } else {
            d = d13 / d12;
            dArray2[0] = dArray2[0] - d8;
            dArray[0] = dArray[0] - d9;
            dArray2[0] = dArray2[0] * d;
            dArray2[1] = dArray2[1] * d;
            dArray2[2] = dArray2[2] * d;
        }
        for (int i = 0; i < 3; ++i) {
            dArray3[i] = dArray[i] - dArray2[i];
        }
        int n = QuadCurve2D.solveQuadratic(dArray3);
        if (n > 0) {
            Intersection[] intersectionArray = new Intersection[n];
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                double d14 = dArray3[i];
                if (d14 >= 0.0 && d14 <= 1.0) {
                    Point2D point2D = quadSegment.evaluatePoint(d14);
                    if (d12 == 0.0) {
                        point2D.setLocation(d8, point2D.getY());
                    }
                    if (d13 == 0.0) {
                        point2D.setLocation(point2D.getX(), d9);
                    }
                    if (!(point2D.getX() <= Math.max(d8, d10)) || !(point2D.getX() >= Math.min(d8, d10)) || !(point2D.getY() <= Math.max(d9, d11)) || !(point2D.getY() >= Math.min(d9, d11))) continue;
                    double d15 = point2D.distance(lineSegment.P1) / lineSegment.P2.distance(lineSegment.P1);
                    intersectionArray[i] = new Intersection(point2D, d15, d14);
                    ++n2;
                    continue;
                }
                intersectionArray[i] = null;
            }
            if (n2 == 0) {
                return null;
            }
            Intersection[] intersectionArray2 = new Intersection[n2];
            for (int i = 0; i < n; ++i) {
                if (intersectionArray[i] == null) continue;
                intersectionArray2[--n2] = intersectionArray[i];
            }
            return intersectionArray2;
        }
        return null;
    }

    Intersection[] lineCubicIntersect(LineSegment lineSegment, CubicSegment cubicSegment) {
        double d;
        double[] dArray = new double[4];
        double[] dArray2 = new double[4];
        double[] dArray3 = new double[4];
        double d2 = cubicSegment.P1.getX();
        double d3 = cubicSegment.P1.getY();
        double d4 = cubicSegment.cp1.getX();
        double d5 = cubicSegment.cp1.getY();
        double d6 = cubicSegment.cp2.getX();
        double d7 = cubicSegment.cp2.getY();
        double d8 = cubicSegment.P2.getX();
        double d9 = cubicSegment.P2.getY();
        double d10 = lineSegment.P1.getX();
        double d11 = lineSegment.P1.getY();
        double d12 = lineSegment.P2.getX();
        double d13 = lineSegment.P2.getY();
        double d14 = d12 - d10;
        double d15 = d13 - d11;
        dArray[0] = d3;
        dArray[1] = 3.0 * (d5 - d3);
        dArray[2] = 3.0 * (d7 + d3 - 2.0 * d5);
        dArray[3] = d9 - 3.0 * d7 + 3.0 * d5 - d3;
        dArray2[0] = d2;
        dArray2[1] = 3.0 * (d4 - d2);
        dArray2[2] = 3.0 * (d6 + d2 - 2.0 * d4);
        dArray2[3] = d8 - 3.0 * d6 + 3.0 * d4 - d2;
        if (d15 == 0.0 && d14 == 0.0) {
            return null;
        }
        if (d14 == 0.0 || d15 / d14 > 1.0) {
            d = d14 / d15;
            dArray2[0] = dArray2[0] - d10;
            dArray[0] = dArray[0] - d11;
            dArray[0] = dArray[0] * d;
            dArray[1] = dArray[1] * d;
            dArray[2] = dArray[2] * d;
            dArray[3] = dArray[3] * d;
        } else {
            d = d15 / d14;
            dArray2[0] = dArray2[0] - d10;
            dArray[0] = dArray[0] - d11;
            dArray2[0] = dArray2[0] * d;
            dArray2[1] = dArray2[1] * d;
            dArray2[2] = dArray2[2] * d;
            dArray2[3] = dArray2[3] * d;
        }
        for (int i = 0; i < 4; ++i) {
            dArray3[i] = dArray[i] - dArray2[i];
        }
        int n = CubicCurve2D.solveCubic(dArray3);
        if (n > 0) {
            Intersection[] intersectionArray = new Intersection[n];
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                double d16 = dArray3[i];
                if (d16 >= 0.0 && d16 <= 1.0) {
                    Point2D point2D = cubicSegment.evaluatePoint(d16);
                    if (d14 == 0.0) {
                        point2D.setLocation(d10, point2D.getY());
                    }
                    if (d15 == 0.0) {
                        point2D.setLocation(point2D.getX(), d11);
                    }
                    if (!(point2D.getX() <= Math.max(d10, d12)) || !(point2D.getX() >= Math.min(d10, d12)) || !(point2D.getY() <= Math.max(d11, d13)) || !(point2D.getY() >= Math.min(d11, d13))) continue;
                    double d17 = point2D.distance(lineSegment.P1) / lineSegment.P2.distance(lineSegment.P1);
                    intersectionArray[i] = new Intersection(point2D, d17, d16);
                    ++n2;
                    continue;
                }
                intersectionArray[i] = null;
            }
            if (n2 == 0) {
                return null;
            }
            Intersection[] intersectionArray2 = new Intersection[n2];
            for (int i = 0; i < n; ++i) {
                if (intersectionArray[i] == null) continue;
                intersectionArray2[--n2] = intersectionArray[i];
            }
            return intersectionArray2;
        }
        return null;
    }

    Intersection linesIntersect(LineSegment lineSegment, LineSegment lineSegment2) {
        Point2D point2D = lineSegment.P1;
        Point2D point2D2 = lineSegment.P2;
        Point2D point2D3 = lineSegment2.P1;
        Point2D point2D4 = lineSegment2.P2;
        if (!Line2D.linesIntersect(point2D.getX(), point2D.getY(), point2D2.getX(), point2D2.getY(), point2D3.getX(), point2D3.getY(), point2D4.getX(), point2D4.getY())) {
            return null;
        }
        double d = point2D.getX();
        double d2 = point2D.getY();
        double d3 = point2D2.getX() - d;
        double d4 = point2D2.getY() - d2;
        double d5 = point2D3.getX();
        double d6 = point2D3.getY();
        double d7 = point2D4.getX() - d5;
        double d8 = point2D4.getY() - d6;
        double d9 = d7 * d4 - d8 * d3;
        double d10 = d7 * (d6 - d2) + d8 * (d - d5);
        if (Math.abs(d9) < 1.0E-11) {
            return null;
        }
        if ((d10 /= d9) == 0.0) {
            return null;
        }
        if (d10 == 1.0) {
            return null;
        }
        Point2D.Double double_ = new Point2D.Double(d + d10 * d3, d2 + d10 * d4);
        return new Intersection(double_, double_.distance(point2D) / point2D.distance(point2D2), double_.distance(point2D3) / point2D3.distance(point2D4));
    }

    boolean pointEquals(Point2D point2D, Point2D point2D2) {
        return point2D.equals(point2D2) || point2D.distance(point2D2) < 1.0E-11;
    }

    private Vector makeSegment(Shape shape) {
        Vector<Segment> vector = new Vector<Segment>();
        PathIterator pathIterator = shape.getPathIterator(null);
        double[] dArray = new double[6];
        Segment segment = null;
        Segment segment2 = null;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        this.windingRule = pathIterator.getWindingRule();
        while (!pathIterator.isDone()) {
            switch (pathIterator.currentSegment(dArray)) {
                case 0: {
                    if (segment != null) {
                        segment2 = segment2.next = new LineSegment(d4, d3, d2, d);
                        segment2.next = segment;
                    }
                    segment = null;
                    d2 = d4 = dArray[0];
                    d = d3 = dArray[1];
                    break;
                }
                case 4: {
                    if (segment != null && (d2 != d4 || d != d3)) {
                        segment2 = segment2.next = new LineSegment(d4, d3, d2, d);
                        segment2.next = segment;
                        d4 = d2;
                        d3 = d;
                        segment = null;
                        break;
                    }
                    if (segment == null) break;
                    segment2.next = segment;
                    segment = null;
                    break;
                }
                case 1: {
                    if (d4 == dArray[0] && d3 == dArray[1]) break;
                    Segment segment3 = new LineSegment(d4, d3, dArray[0], dArray[1]);
                    if (segment == null) {
                        segment2 = segment3;
                        segment = segment2;
                        vector.add(segment);
                    } else {
                        segment2 = segment2.next = segment3;
                    }
                    d4 = dArray[0];
                    d3 = dArray[1];
                    break;
                }
                case 2: {
                    Segment segment3 = new QuadSegment(d4, d3, dArray[0], dArray[1], dArray[2], dArray[3]);
                    if (segment == null) {
                        segment2 = segment3;
                        segment = segment2;
                        vector.add(segment);
                    } else {
                        segment2 = segment2.next = segment3;
                    }
                    d4 = dArray[2];
                    d3 = dArray[3];
                    break;
                }
                case 3: {
                    Segment segment3 = new CubicSegment(d4, d3, dArray[0], dArray[1], dArray[2], dArray[3], dArray[4], dArray[5]);
                    if (segment == null) {
                        segment2 = segment3;
                        segment = segment2;
                        vector.add(segment);
                    } else {
                        segment2 = segment2.next = segment3;
                    }
                    double[] dArray2 = ((CubicSegment)segment3).getLoop();
                    if (dArray2 != null) {
                        segment3.subdivideInsert(dArray2[0]);
                        segment3.next.subdivideInsert((dArray2[1] - dArray2[0]) / (1.0 - dArray2[0]));
                        CubicSegment cubicSegment = (CubicSegment)segment3.next;
                        segment3.next = cubicSegment.next;
                        cubicSegment.next = cubicSegment;
                        segment3.next.P1 = cubicSegment.P2 = cubicSegment.P1;
                        segment3.P2 = cubicSegment.P2;
                        vector.add(cubicSegment);
                        segment2 = segment3.next;
                    }
                    d4 = dArray[4];
                    d3 = dArray[5];
                }
            }
            pathIterator.next();
        }
        if (segment != null) {
            if (d2 != d4 || d != d3) {
                segment2 = segment2.next = new LineSegment(d4, d3, d2, d);
                segment2.next = segment;
            } else {
                segment2.next = segment;
            }
        }
        if (vector.size() == 0) {
            return null;
        }
        return vector;
    }

    private int createNodes(Segment segment, Segment segment2) {
        int n = 0;
        Segment segment3 = segment;
        Segment segment4 = segment2;
        do {
            n += segment3.splitIntersections(segment4);
        } while ((segment4 = segment4.next) != segment2 || (segment3 = segment3.next) != segment);
        return n;
    }

    private int createNodesSelf(Segment segment) {
        int n = 0;
        Segment segment2 = segment;
        if (segment.next == segment) {
            return 0;
        }
        do {
            Segment segment3 = segment2.next;
            do {
                if (segment3 == segment2) continue;
                n += segment2.splitIntersections(segment3);
            } while ((segment3 = segment3.next) != segment);
        } while ((segment2 = segment2.next) != segment);
        return n;
    }

    private void deleteRedundantPaths(Vector vector) {
        int n;
        int n2;
        int n3 = vector.size();
        int[][] nArray = new int[n3][n3];
        int[][] nArray2 = new int[n3][2];
        Rectangle2D[] rectangle2DArray = new Rectangle2D[n3];
        int n4 = this.windingRule == 1 ? -1 : 1;
        for (n2 = 0; n2 < n3; ++n2) {
            rectangle2DArray[n2] = ((Segment)vector.elementAt(n2)).getPathBounds();
        }
        for (n2 = 0; n2 < n3; ++n2) {
            Segment segment = (Segment)vector.elementAt(n2);
            segment.nullNodes();
            n = segment.hasClockwiseOrientation() ? 1 : n4;
            for (int i = 0; i < n3; ++i) {
                if (n2 != i) {
                    Segment segment2 = (Segment)vector.elementAt(i);
                    if (rectangle2DArray[n2].intersects(rectangle2DArray[i])) {
                        Segment segment3 = segment2.next;
                        while (segment3.P1.getY() == segment3.P2.getY() && segment3 != segment2) {
                            segment3 = segment3.next;
                        }
                        Point2D point2D = segment3.getMidPoint();
                        if (!segment.contains(point2D.getX(), point2D.getY())) continue;
                        nArray[n2][i] = n;
                        continue;
                    }
                    nArray[n2][i] = 0;
                    continue;
                }
                nArray[n2][i] = n;
            }
        }
        for (n2 = 0; n2 < n3; ++n2) {
            nArray2[n2][0] = 0;
            for (int i = 0; i < n3; ++i) {
                int[] nArray3 = nArray2[n2];
                nArray3[0] = nArray3[0] + nArray[i][n2];
            }
            nArray2[n2][1] = nArray[n2][n2];
        }
        Vector vector2 = new Vector();
        Vector vector3 = new Vector();
        if (this.windingRule == 1) {
            for (n = 0; n < n3; ++n) {
                if (nArray2[n][0] == 0) {
                    vector3.add(vector.elementAt(n));
                    continue;
                }
                if (nArray2[n][0] - nArray2[n][1] != 0 || Math.abs(nArray2[n][0]) != 1) continue;
                vector2.add(vector.elementAt(n));
            }
        } else {
            this.windingRule = 1;
            for (n = 0; n < n3; ++n) {
                if ((nArray2[n][0] & 1) == 0) {
                    vector3.add(vector.elementAt(n));
                    continue;
                }
                if ((nArray2[n][0] & 1) != 1) continue;
                vector2.add(vector.elementAt(n));
            }
        }
        this.setDirection(vector3, false);
        this.setDirection(vector2, true);
        this.holes = vector3;
        this.solids = vector2;
    }

    private void setDirection(Vector vector, boolean bl) {
        for (int i = 0; i < vector.size(); ++i) {
            Segment segment = (Segment)vector.elementAt(i);
            if (bl == segment.hasClockwiseOrientation()) continue;
            segment.reverseAll();
        }
    }

    private class CubicSegment
    extends Segment {
        Point2D cp1;
        Point2D cp2;

        public CubicSegment(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
            this.P1 = new Point2D.Double(d, d2);
            this.P2 = new Point2D.Double(d7, d8);
            this.cp1 = new Point2D.Double(d3, d4);
            this.cp2 = new Point2D.Double(d5, d6);
        }

        public Object clone() {
            return new CubicSegment(this.P1.getX(), this.P1.getY(), this.cp1.getX(), this.cp1.getY(), this.cp2.getX(), this.cp2.getY(), this.P2.getX(), this.P2.getY());
        }

        double curveArea() {
            double d = this.P1.getX();
            double d2 = this.P1.getY();
            double d3 = this.cp1.getX();
            double d4 = this.cp1.getY();
            double d5 = this.cp2.getX();
            double d6 = this.cp2.getY();
            double d7 = this.P2.getX();
            double d8 = this.P2.getY();
            double d9 = d8 - 3.0 * d6 + 3.0 * d4 - d2;
            double d10 = 3.0 * (d6 + d2 - 2.0 * d4);
            double d11 = 3.0 * (d4 - d2);
            double d12 = d7 - 3.0 * d5 + 3.0 * d3 - d;
            double d13 = 3.0 * (d5 + d - 2.0 * d3);
            double d14 = 3.0 * (d3 - d);
            double d15 = (d13 * d9 - d12 * d10) / 5.0 + (d14 * d9 - d12 * d11) / 2.0 + (d14 * d10 - d13 * d11) / 3.0;
            return d15;
        }

        boolean equals(Segment segment) {
            if (!(segment instanceof CubicSegment)) {
                return false;
            }
            return this.P1.equals(segment.P1) && this.cp1.equals(((CubicSegment)segment).cp1) && this.cp2.equals(((CubicSegment)segment).cp2) && this.P2.equals(segment.P2);
        }

        Point2D evaluatePoint(double d) {
            double d2 = this.P1.getX();
            double d3 = this.P1.getY();
            double d4 = this.cp1.getX();
            double d5 = this.cp1.getY();
            double d6 = this.cp2.getX();
            double d7 = this.cp2.getY();
            double d8 = this.P2.getX();
            double d9 = this.P2.getY();
            return new Point2D.Double(-(d * d * d) * (d2 - 3.0 * d4 + 3.0 * d6 - d8) + 3.0 * d * d * (d2 - 2.0 * d4 + d6) + 3.0 * d * (d4 - d2) + d2, -(d * d * d) * (d3 - 3.0 * d5 + 3.0 * d7 - d9) + 3.0 * d * d * (d3 - 2.0 * d5 + d7) + 3.0 * d * (d5 - d3) + d3);
        }

        Rectangle2D getBounds() {
            double d;
            double d2;
            int n;
            double d3 = this.P1.getX();
            double d4 = this.P1.getY();
            double d5 = this.cp1.getX();
            double d6 = this.cp1.getY();
            double d7 = this.cp2.getX();
            double d8 = this.cp2.getY();
            double d9 = this.P2.getX();
            double d10 = this.P2.getY();
            double[] dArray = new double[3];
            double d11 = Math.max(d3, d9);
            double d12 = Math.max(d4, d10);
            double d13 = Math.min(d3, d9);
            double d14 = Math.min(d4, d10);
            dArray[0] = 3.0 * (d6 - d4);
            dArray[1] = 6.0 * (d8 + d4 - 2.0 * d6);
            dArray[2] = 3.0 * (d10 - 3.0 * d8 + 3.0 * d6 - d4);
            int n2 = QuadCurve2D.solveQuadratic(dArray);
            for (n = 0; n < n2; ++n) {
                d2 = dArray[n];
                if (!(d2 > 0.0) || !(d2 < 1.0)) continue;
                d = this.evaluatePoint(d2).getY();
                d12 = Math.max(d, d12);
                d14 = Math.min(d, d14);
            }
            dArray[0] = 3.0 * (d5 - d3);
            dArray[1] = 6.0 * (d7 + d3 - 2.0 * d5);
            dArray[2] = 3.0 * (d9 - 3.0 * d7 + 3.0 * d5 - d3);
            n2 = QuadCurve2D.solveQuadratic(dArray);
            for (n = 0; n < n2; ++n) {
                d2 = dArray[n];
                if (!(d2 > 0.0) || !(d2 < 1.0)) continue;
                d = this.evaluatePoint(d2).getX();
                d11 = Math.max(d, d11);
                d13 = Math.min(d, d13);
            }
            return new Rectangle2D.Double(d13, d14, d11 - d13, d12 - d14);
        }

        CubicCurve2D getCubicCurve2D() {
            return new CubicCurve2D.Double(this.P1.getX(), this.P1.getY(), this.cp1.getX(), this.cp1.getY(), this.cp2.getX(), this.cp2.getY(), this.P2.getX(), this.P2.getY());
        }

        double[] getLoop() {
            double d;
            double d2;
            double d3;
            double d4 = this.P1.getX();
            double d5 = this.P1.getY();
            double d6 = this.cp1.getX();
            double d7 = this.cp1.getY();
            double d8 = this.cp2.getX();
            double d9 = this.cp2.getY();
            double d10 = this.P2.getX();
            double d11 = this.P2.getY();
            double[] dArray = new double[4];
            double[] dArray2 = new double[2];
            double d12 = d10 - 3.0 * d8 + 3.0 * d6 - d4;
            double d13 = d11 - 3.0 * d9 + 3.0 * d7 - d5;
            if (d12 == 0.0 && d13 == 0.0) {
                return null;
            }
            if (d12 != 0.0 && d13 != 0.0) {
                d3 = 3.0 * (d8 + d4 - 2.0 * d6) / d12;
                d2 = 3.0 * (d6 - d4) / d12;
                double d14 = 3.0 * (d9 + d5 - 2.0 * d7) / d13;
                double d15 = 3.0 * (d7 - d5) / d13;
                if (d3 == d14 || d15 == d2) {
                    return null;
                }
                d = (d15 - d2) / (d3 - d14);
            } else if (d12 == 0.0) {
                d = -(3.0 * (d6 - d4)) / (3.0 * (d8 + d4 - 2.0 * d6));
                d3 = 3.0 * (d9 + d5 - 2.0 * d7) / d13;
                d2 = 3.0 * (d7 - d5) / d13;
            } else {
                d = -(3.0 * (d7 - d5)) / (3.0 * (d9 + d5 - 2.0 * d7));
                d3 = 3.0 * (d8 + d4 - 2.0 * d6) / d12;
                d2 = 3.0 * (d6 - d4) / d12;
            }
            dArray[0] = -d * d * d - d3 * d * d - d2 * d;
            dArray[1] = 3.0 * d * d + 2.0 * d * d3 + 2.0 * d2;
            dArray[2] = -3.0 * d;
            dArray[3] = 2.0;
            int n = CubicCurve2D.solveCubic(dArray);
            if (n != 3) {
                return null;
            }
            for (int i = 0; i < 2; ++i) {
                for (int j = i + 1; j < 3; ++j) {
                    if (!(dArray[j] < dArray[i])) continue;
                    double d16 = dArray[i];
                    dArray[i] = dArray[j];
                    dArray[j] = d16;
                }
            }
            if (Math.abs(dArray[0] + dArray[2] - d) < 1.0E-13 && dArray[0] >= 0.0 && dArray[0] <= 1.0 && dArray[2] >= 0.0 && dArray[2] <= 1.0 && this.evaluatePoint(dArray[0]).distance(this.evaluatePoint(dArray[2])) < 9.999999999999999E-11) {
                dArray2[0] = dArray[0];
                dArray2[1] = dArray[2];
                return dArray2;
            }
            return null;
        }

        Point2D getMidPoint() {
            return this.evaluatePoint(0.5);
        }

        int getType() {
            return 3;
        }

        int pathIteratorFormat(double[] dArray) {
            dArray[0] = this.cp1.getX();
            dArray[1] = this.cp1.getY();
            dArray[2] = this.cp2.getX();
            dArray[3] = this.cp2.getY();
            dArray[4] = this.P2.getX();
            dArray[5] = this.P2.getY();
            return 3;
        }

        int rayCrossing(double d, double d2) {
            double d3 = this.P1.getX() - d;
            double d4 = this.P1.getY() - d2;
            double d5 = this.cp1.getX() - d;
            double d6 = this.cp1.getY() - d2;
            double d7 = this.cp2.getX() - d;
            double d8 = this.cp2.getY() - d2;
            double d9 = this.P2.getX() - d;
            double d10 = this.P2.getY() - d2;
            double[] dArray = new double[4];
            int n = 0;
            if ((d3 > 0.0 || d5 > 0.0 || d7 > 0.0 || d9 > 0.0) && (d4 * d6 <= 0.0 || d6 * d8 <= 0.0 || d8 * d10 <= 0.0)) {
                if (d4 == 0.0) {
                    d4 -= 1.0E-11;
                }
                if (d10 == 0.0) {
                    d10 -= 1.0E-11;
                }
                dArray[0] = d4;
                dArray[1] = 3.0 * (d6 - d4);
                dArray[2] = 3.0 * (d8 + d4 - 2.0 * d6);
                dArray[3] = d10 - 3.0 * d8 + 3.0 * d6 - d4;
                int n2 = CubicCurve2D.solveCubic(dArray);
                if (n2 > 0) {
                    for (int i = 0; i < n2; ++i) {
                        double d11;
                        if (!(dArray[i] > 0.0) || !(dArray[i] < 1.0) || !(-((d11 = dArray[i]) * d11 * d11) * (d3 - 3.0 * d5 + 3.0 * d7 - d9) + 3.0 * d11 * d11 * (d3 - 2.0 * d5 + d7) + 3.0 * d11 * (d5 - d3) + d3 > 0.0)) continue;
                        ++n;
                    }
                }
            }
            return n;
        }

        void reverseCoords() {
            Point2D point2D = this.P1;
            this.P1 = this.P2;
            this.P2 = point2D;
            point2D = this.cp1;
            this.cp1 = this.cp2;
            this.cp2 = point2D;
        }

        int splitIntersections(Segment segment) {
            if (segment instanceof LineSegment) {
                return segment.splitIntersections(this);
            }
            Intersection[] intersectionArray = null;
            if (segment instanceof QuadSegment) {
                intersectionArray = Area.this.cubicCubicIntersect(this, ((QuadSegment)segment).getCubicSegment());
            }
            if (segment instanceof CubicSegment) {
                intersectionArray = Area.this.cubicCubicIntersect(this, (CubicSegment)segment);
            }
            if (intersectionArray == null) {
                return 0;
            }
            if (intersectionArray.length == 1) {
                return this.createNode(segment, intersectionArray[0]);
            }
            return this.createNodes(segment, intersectionArray);
        }

        void subdivideInsert(double d) {
            CubicSegment cubicSegment = (CubicSegment)this.clone();
            double d2 = (cubicSegment.cp1.getX() - cubicSegment.P1.getX()) * d + cubicSegment.P1.getX();
            double d3 = (cubicSegment.cp1.getY() - cubicSegment.P1.getY()) * d + cubicSegment.P1.getY();
            double d4 = (cubicSegment.cp2.getX() - cubicSegment.cp1.getX()) * d + cubicSegment.cp1.getX();
            double d5 = (cubicSegment.cp2.getY() - cubicSegment.cp1.getY()) * d + cubicSegment.cp1.getY();
            cubicSegment.cp2.setLocation((cubicSegment.P2.getX() - cubicSegment.cp2.getX()) * d + cubicSegment.cp2.getX(), (cubicSegment.P2.getY() - cubicSegment.cp2.getY()) * d + cubicSegment.cp2.getY());
            cubicSegment.cp1.setLocation((cubicSegment.cp2.getX() - d4) * d + d4, (cubicSegment.cp2.getY() - d5) * d + d5);
            double d6 = (d4 - d2) * d + d2;
            double d7 = (d5 - d3) * d + d3;
            double d8 = (cubicSegment.cp1.getX() - d6) * d + d6;
            double d9 = (cubicSegment.cp1.getY() - d7) * d + d7;
            cubicSegment.P1.setLocation(d8, d9);
            this.insert(cubicSegment);
            this.cp1.setLocation(d2, d3);
            this.cp2.setLocation(d6, d7);
            this.P2 = cubicSegment.P1;
            this.next.node = this.node;
            this.node = null;
        }

        void transform(AffineTransform affineTransform) {
            this.P1 = affineTransform.transform(this.P1, null);
            this.P2 = affineTransform.transform(this.P2, null);
            this.cp1 = affineTransform.transform(this.cp1, null);
            this.cp2 = affineTransform.transform(this.cp2, null);
        }
    }

    private class QuadSegment
    extends Segment {
        Point2D cp;

        QuadSegment(double d, double d2, double d3, double d4, double d5, double d6) {
            this.P1 = new Point2D.Double(d, d2);
            this.P2 = new Point2D.Double(d5, d6);
            this.cp = new Point2D.Double(d3, d4);
        }

        public Object clone() {
            return new QuadSegment(this.P1.getX(), this.P1.getY(), this.cp.getX(), this.cp.getY(), this.P2.getX(), this.P2.getY());
        }

        double curveArea() {
            double d = this.P1.getX();
            double d2 = this.P1.getY();
            double d3 = this.cp.getX();
            double d4 = this.cp.getY();
            double d5 = this.P2.getX();
            double d6 = this.P2.getY();
            double d7 = d6 - 2.0 * d4 + d2;
            double d8 = 2.0 * (d4 - d2);
            double d9 = d5 - 2.0 * d3 + d;
            double d10 = 2.0 * (d3 - d);
            double d11 = (d10 * d7 - d9 * d8) / 3.0;
            return d11;
        }

        boolean equals(Segment segment) {
            if (!(segment instanceof QuadSegment)) {
                return false;
            }
            return this.P1.equals(segment.P1) && this.cp.equals(((QuadSegment)segment).cp) && this.P2.equals(segment.P2);
        }

        Point2D evaluatePoint(double d) {
            double d2 = this.P1.getX();
            double d3 = this.P1.getY();
            double d4 = this.cp.getX();
            double d5 = this.cp.getY();
            double d6 = this.P2.getX();
            double d7 = this.P2.getY();
            return new Point2D.Double(d * d * (d6 - 2.0 * d4 + d2) + 2.0 * d * (d4 - d2) + d2, d * d * (d7 - 2.0 * d5 + d3) + 2.0 * d * (d5 - d3) + d3);
        }

        Rectangle2D getBounds() {
            double d;
            double d2;
            double d3 = this.P1.getX();
            double d4 = this.P1.getY();
            double d5 = this.cp.getX();
            double d6 = this.cp.getY();
            double d7 = this.P2.getX();
            double d8 = this.P2.getY();
            double d9 = Math.max(d3, d7);
            double d10 = Math.max(d4, d8);
            double d11 = Math.min(d3, d7);
            double d12 = Math.min(d4, d8);
            double d13 = 2.0 * (d6 - d4);
            double d14 = 2.0 * (d8 - 2.0 * d6 + d4);
            if (d14 != 0.0 && (d2 = -d13 / d14) > 0.0 && d2 < 1.0) {
                d = this.evaluatePoint(d2).getY();
                d10 = Math.max(d, d10);
                d12 = Math.min(d, d12);
            }
            d13 = 2.0 * (d5 - d3);
            d14 = 2.0 * (d7 - 2.0 * d5 + d3);
            if (d14 != 0.0 && (d2 = -d13 / d14) > 0.0 && d2 < 1.0) {
                d = this.evaluatePoint(d2).getY();
                d9 = Math.max(d, d9);
                d11 = Math.min(d, d11);
            }
            return new Rectangle2D.Double(d11, d12, d9 - d11, d10 - d12);
        }

        CubicSegment getCubicSegment() {
            double d = this.P1.getX() + 2.0 * (this.cp.getX() - this.P1.getX()) / 3.0;
            double d2 = this.P1.getY() + 2.0 * (this.cp.getY() - this.P1.getY()) / 3.0;
            double d3 = this.cp.getX() + (this.P2.getX() - this.cp.getX()) / 3.0;
            double d4 = this.cp.getY() + (this.P2.getY() - this.cp.getY()) / 3.0;
            return new CubicSegment(this.P1.getX(), this.P1.getY(), d, d2, d3, d4, this.P2.getX(), this.P2.getY());
        }

        Point2D getMidPoint() {
            return this.evaluatePoint(0.5);
        }

        int getType() {
            return 2;
        }

        int pathIteratorFormat(double[] dArray) {
            dArray[0] = this.cp.getX();
            dArray[1] = this.cp.getY();
            dArray[2] = this.P2.getX();
            dArray[3] = this.P2.getY();
            return 2;
        }

        int rayCrossing(double d, double d2) {
            double d3 = this.P1.getX() - d;
            double d4 = this.P1.getY() - d2;
            double d5 = this.cp.getX() - d;
            double d6 = this.cp.getY() - d2;
            double d7 = this.P2.getX() - d;
            double d8 = this.P2.getY() - d2;
            double[] dArray = new double[3];
            int n = 0;
            if ((d3 > 0.0 || d5 > 0.0 || d7 > 0.0) && (d4 * d6 <= 0.0 || d6 * d8 <= 0.0)) {
                if (d4 == 0.0) {
                    d4 -= 1.0E-11;
                }
                if (d8 == 0.0) {
                    d8 -= 1.0E-11;
                }
                dArray[0] = d4;
                dArray[1] = 2.0 * (d6 - d4);
                dArray[2] = d8 - 2.0 * d6 + d4;
                int n2 = QuadCurve2D.solveQuadratic(dArray);
                for (int i = 0; i < n2; ++i) {
                    double d9;
                    if (!(dArray[i] > 0.0) || !(dArray[i] < 1.0) || !((d9 = dArray[i]) * d9 * (d7 - 2.0 * d5 + d3) + 2.0 * d9 * (d5 - d3) + d3 > 0.0)) continue;
                    ++n;
                }
            }
            return n;
        }

        void reverseCoords() {
            Point2D point2D = this.P1;
            this.P1 = this.P2;
            this.P2 = point2D;
        }

        int splitIntersections(Segment segment) {
            if (segment instanceof LineSegment) {
                return segment.splitIntersections(this);
            }
            if (segment instanceof CubicSegment) {
                return segment.splitIntersections(this);
            }
            if (segment instanceof QuadSegment) {
                Intersection[] intersectionArray = Area.this.cubicCubicIntersect(this.getCubicSegment(), ((QuadSegment)segment).getCubicSegment());
                if (intersectionArray == null) {
                    return 0;
                }
                if (intersectionArray.length == 1) {
                    return this.createNode(segment, intersectionArray[0]);
                }
                return this.createNodes(segment, intersectionArray);
            }
            return 0;
        }

        void subdivideInsert(double d) {
            double d2 = this.P1.getX();
            double d3 = this.P1.getY();
            double d4 = this.cp.getX();
            double d5 = this.cp.getY();
            double d6 = this.P2.getX();
            double d7 = this.P2.getY();
            double d8 = d2 + d * (d4 - d2);
            double d9 = d3 + d * (d5 - d3);
            double d10 = d4 + d * (d6 - d4);
            double d11 = d5 + d * (d7 - d5);
            double d12 = d8 + d * (d10 - d8);
            double d13 = d9 + d * (d11 - d9);
            this.insert(new QuadSegment(d12, d13, d10, d11, d6, d7));
            this.P2 = this.next.P1;
            this.cp.setLocation(d8, d9);
            this.next.node = this.node;
            this.node = null;
        }

        void transform(AffineTransform affineTransform) {
            this.P1 = affineTransform.transform(this.P1, null);
            this.P2 = affineTransform.transform(this.P2, null);
            this.cp = affineTransform.transform(this.cp, null);
        }
    }

    private class LineSegment
    extends Segment {
        public LineSegment(double d, double d2, double d3, double d4) {
            this.P1 = new Point2D.Double(d, d2);
            this.P2 = new Point2D.Double(d3, d4);
        }

        public LineSegment(Point2D point2D, Point2D point2D2) {
            this.P1 = (Point2D)point2D.clone();
            this.P2 = (Point2D)point2D2.clone();
        }

        public Object clone() {
            return new LineSegment(this.P1, this.P2);
        }

        void transform(AffineTransform affineTransform) {
            this.P1 = affineTransform.transform(this.P1, null);
            this.P2 = affineTransform.transform(this.P2, null);
        }

        void reverseCoords() {
            Point2D point2D = this.P1;
            this.P1 = this.P2;
            this.P2 = point2D;
        }

        Point2D getMidPoint() {
            return new Point2D.Double(0.5 * (this.P1.getX() + this.P2.getX()), 0.5 * (this.P1.getY() + this.P2.getY()));
        }

        double curveArea() {
            return 0.0;
        }

        int getType() {
            return 1;
        }

        void subdivideInsert(double d) {
            Point2D.Double double_ = new Point2D.Double((this.P2.getX() - this.P1.getX()) * d + this.P1.getX(), (this.P2.getY() - this.P1.getY()) * d + this.P1.getY());
            this.insert(new LineSegment(double_, this.P2));
            this.P2 = double_;
            this.next.node = this.node;
            this.node = null;
        }

        boolean isCoLinear(LineSegment lineSegment) {
            double d;
            double d2;
            double d3 = this.P1.getX();
            double d4 = this.P1.getY();
            double d5 = this.P2.getX();
            double d6 = this.P2.getY();
            double d7 = lineSegment.P1.getX();
            double d8 = lineSegment.P1.getY();
            if ((d4 - d8) * ((d2 = lineSegment.P2.getX()) - d7) - (d3 - d7) * ((d = lineSegment.P2.getY()) - d8) != 0.0) {
                return false;
            }
            return (d5 - d3) * (d - d8) - (d6 - d4) * (d2 - d7) == 0.0;
        }

        Segment lastCoLinear() {
            Segment segment = this;
            Segment segment2 = this.next;
            while (segment2 instanceof LineSegment) {
                if (this.isCoLinear((LineSegment)segment2)) {
                    segment = segment2;
                    segment2 = segment2.next;
                    continue;
                }
                return segment;
            }
            return segment;
        }

        boolean equals(Segment segment) {
            if (!(segment instanceof LineSegment)) {
                return false;
            }
            Point2D point2D = this.P1;
            Point2D point2D2 = segment.P1;
            if (!point2D.equals(point2D2)) {
                return false;
            }
            Point2D point2D3 = this.lastCoLinear().P2;
            Point2D point2D4 = ((LineSegment)segment).lastCoLinear().P2;
            return point2D3.equals(point2D4);
        }

        int pathIteratorFormat(double[] dArray) {
            dArray[0] = this.P2.getX();
            dArray[1] = this.P2.getY();
            return 1;
        }

        boolean hasIntersections(Segment segment) {
            if (segment instanceof LineSegment) {
                return Area.this.linesIntersect(this, (LineSegment)segment) != null;
            }
            if (segment instanceof QuadSegment) {
                return Area.this.lineQuadIntersect(this, (QuadSegment)segment) != null;
            }
            if (segment instanceof CubicSegment) {
                return Area.this.lineCubicIntersect(this, (CubicSegment)segment) != null;
            }
            return false;
        }

        int splitIntersections(Segment segment) {
            if (segment instanceof LineSegment) {
                Intersection intersection = Area.this.linesIntersect(this, (LineSegment)segment);
                if (intersection == null) {
                    return 0;
                }
                return this.createNode(segment, intersection);
            }
            Intersection[] intersectionArray = null;
            if (segment instanceof QuadSegment) {
                intersectionArray = Area.this.lineQuadIntersect(this, (QuadSegment)segment);
            }
            if (segment instanceof CubicSegment) {
                intersectionArray = Area.this.lineCubicIntersect(this, (CubicSegment)segment);
            }
            if (intersectionArray == null) {
                return 0;
            }
            if (intersectionArray.length == 1) {
                return this.createNode(segment, intersectionArray[0]);
            }
            return this.createNodes(segment, intersectionArray);
        }

        Rectangle2D getBounds() {
            return new Rectangle2D.Double(Math.min(this.P1.getX(), this.P2.getX()), Math.min(this.P1.getY(), this.P2.getY()), Math.abs(this.P1.getX() - this.P2.getX()), Math.abs(this.P1.getY() - this.P2.getY()));
        }

        int rayCrossing(double d, double d2) {
            double d3 = this.P1.getX() - d;
            double d4 = this.P1.getY() - d2;
            double d5 = this.P2.getX() - d;
            double d6 = this.P2.getY() - d2;
            if (d4 * d6 > 0.0) {
                return 0;
            }
            if (d3 < 0.0 && d5 < 0.0) {
                return 0;
            }
            if (d4 == 0.0) {
                d4 -= 1.0E-11;
            }
            if (d6 == 0.0) {
                d6 -= 1.0E-11;
            }
            if (Line2D.linesIntersect(d3, d4, d5, d6, 1.0E-11, 0.0, Double.MAX_VALUE, 0.0)) {
                return 1;
            }
            return 0;
        }
    }

    private abstract class Segment
    implements Cloneable {
        Point2D P1 = null;
        Point2D P2 = null;
        Segment next = null;
        Segment node = null;

        Segment() {
        }

        abstract void reverseCoords();

        abstract Point2D getMidPoint();

        abstract Rectangle2D getBounds();

        abstract void transform(AffineTransform var1);

        abstract int getType();

        abstract int splitIntersections(Segment var1);

        abstract int pathIteratorFormat(double[] var1);

        abstract int rayCrossing(double var1, double var3);

        abstract void subdivideInsert(double var1);

        abstract double curveArea();

        abstract boolean equals(Segment var1);

        boolean contains(double d, double d2) {
            Segment segment = this;
            int n = 0;
            do {
                int n2 = segment.rayCrossing(d, d2);
                n += n2;
            } while ((segment = segment.next) != this);
            return (n & 1) == 1;
        }

        void nullNodes() {
            Segment segment = this;
            do {
                segment.node = null;
            } while ((segment = segment.next) != this);
        }

        void transformSegmentList(AffineTransform affineTransform) {
            Segment segment = this;
            do {
                segment.transform(affineTransform);
            } while ((segment = segment.next) != this);
        }

        boolean hasClockwiseOrientation() {
            return this.getSignedArea() > 0.0;
        }

        public Rectangle2D getPathBounds() {
            double d;
            double d2;
            double d3 = d2 = this.P1.getX();
            double d4 = d = this.P1.getY();
            Segment segment = this;
            do {
                Rectangle2D rectangle2D = segment.getBounds();
                d3 = Math.min(rectangle2D.getMinX(), d3);
                d4 = Math.min(rectangle2D.getMinY(), d4);
                d2 = Math.max(rectangle2D.getMaxX(), d2);
                d = Math.max(rectangle2D.getMaxY(), d);
            } while ((segment = segment.next) != this);
            return new Rectangle2D.Double(d3, d4, d2 - d3, d - d4);
        }

        double getSignedArea() {
            double d = 0.0;
            Segment segment = this;
            do {
                d += segment.curveArea();
                d += segment.P1.getX() * segment.next.P1.getY() - segment.P1.getY() * segment.next.P1.getX();
            } while ((segment = segment.next) != this);
            return d;
        }

        void reverseAll() {
            this.reverseCoords();
            Segment segment = this.next;
            Segment segment2 = this;
            while (segment != this) {
                segment.reverseCoords();
                Segment segment3 = segment.next;
                segment.next = segment2;
                segment2 = segment;
                segment = segment3;
            }
            this.next = segment2;
        }

        void insert(Segment segment) {
            Segment segment2 = this.next;
            this.next = segment;
            segment.next = segment2;
        }

        boolean isPolygonal() {
            Segment segment = this;
            do {
                if (segment instanceof LineSegment) continue;
                return false;
            } while ((segment = segment.next) != this);
            return true;
        }

        Segment cloneSegmentList() throws CloneNotSupportedException {
            Segment segment;
            Vector<Segment> vector = new Vector<Segment>();
            Segment segment2 = this.next;
            while (segment2 != this) {
                vector.add(segment2);
                segment2 = segment2.next;
            }
            segment2 = segment = (Segment)this.clone();
            for (int i = 0; i < vector.size(); ++i) {
                segment = segment.next = (Segment)((Segment)vector.elementAt(i)).clone();
            }
            segment.next = segment2;
            return segment2;
        }

        int createNode(Segment segment, Intersection intersection) {
            Point2D point2D = intersection.p;
            if ((Area.this.pointEquals(this.P1, point2D) || Area.this.pointEquals(this.P2, point2D)) && (Area.this.pointEquals(segment.P1, point2D) || Area.this.pointEquals(segment.P2, point2D))) {
                return 0;
            }
            this.subdivideInsert(intersection.ta);
            segment.subdivideInsert(intersection.tb);
            this.P2 = this.next.P1 = intersection.p;
            segment.next.P1 = this.next.P1;
            segment.P2 = this.next.P1;
            this.node = segment.next;
            segment.node = this.next;
            return 1;
        }

        protected int createNodes(Segment segment, Intersection[] intersectionArray) {
            int n;
            int n2;
            Intersection[] intersectionArray2;
            int n3;
            Vector<Intersection> vector = new Vector<Intersection>();
            for (n3 = 0; n3 < intersectionArray.length; ++n3) {
                intersectionArray2 = intersectionArray[n3].p;
                if ((Area.this.pointEquals(this.P1, (Point2D)intersectionArray2) || Area.this.pointEquals(this.P2, (Point2D)intersectionArray2)) && (Area.this.pointEquals(segment.P1, (Point2D)intersectionArray2) || Area.this.pointEquals(segment.P2, (Point2D)intersectionArray2))) continue;
                vector.add(intersectionArray[n3]);
            }
            n3 = vector.size();
            intersectionArray2 = new Intersection[n3];
            Intersection[] intersectionArray3 = new Intersection[n3];
            for (n2 = 0; n2 < n3; ++n2) {
                intersectionArray2[n2] = intersectionArray3[n2] = (Intersection)vector.elementAt(n2);
            }
            for (n2 = 0; n2 < n3 - 1; ++n2) {
                for (n = n2 + 1; n < n3; ++n) {
                    Intersection intersection;
                    if (intersectionArray2[n2].ta > intersectionArray2[n].ta) {
                        intersection = intersectionArray2[n2];
                        intersectionArray2[n2] = intersectionArray2[n];
                        intersectionArray2[n] = intersection;
                    }
                    if (!(intersectionArray3[n2].tb > intersectionArray3[n].tb)) continue;
                    intersection = intersectionArray3[n2];
                    intersectionArray3[n2] = intersectionArray3[n];
                    intersectionArray3[n] = intersection;
                }
            }
            Segment segment2 = this;
            for (n = 0; n < n3; ++n) {
                segment2.subdivideInsert(intersectionArray2[n].ta);
                for (int i = n + 1; i < n3; ++i) {
                    intersectionArray2[i].ta = (intersectionArray2[i].ta - intersectionArray2[n].ta) / (1.0 - intersectionArray2[n].ta);
                }
                intersectionArray2[n].seg = segment2;
                segment2 = segment2.next;
            }
            segment2 = segment;
            for (n = 0; n < n3; ++n) {
                segment2.subdivideInsert(intersectionArray3[n].tb);
                for (int i = n + 1; i < n3; ++i) {
                    intersectionArray3[i].tb = (intersectionArray3[i].tb - intersectionArray3[n].tb) / (1.0 - intersectionArray3[n].tb);
                }
                intersectionArray3[n].seg.node = segment2.next;
                segment2.node = intersectionArray3[n].seg.next;
                segment2.P2 = segment2.next.P1 = intersectionArray3[n].p;
                intersectionArray3[n].seg.next.P1 = segment2.next.P1;
                intersectionArray3[n].seg.P2 = segment2.next.P1;
                segment2 = segment2.next;
            }
            return n3;
        }

        boolean pathEquals(Segment segment) {
            if (!this.getPathBounds().equals(segment.getPathBounds())) {
                return false;
            }
            Segment segment2 = this.getTopLeft();
            Segment segment3 = segment.getTopLeft();
            Segment segment4 = segment2;
            Segment segment5 = segment3;
            do {
                if (!segment4.equals(segment5)) {
                    return false;
                }
                if (segment4 instanceof LineSegment) {
                    segment4 = ((LineSegment)segment4).lastCoLinear();
                }
                if (segment5 instanceof LineSegment) {
                    segment5 = ((LineSegment)segment5).lastCoLinear();
                }
                segment4 = segment4.next;
                segment5 = segment5.next;
            } while (segment4 != segment2 && segment5 != segment3);
            return true;
        }

        Segment getTopLeft() {
            Segment segment = this;
            Segment segment2 = this;
            do {
                if (segment.P1.getY() < segment2.P1.getY()) {
                    segment2 = segment;
                    continue;
                }
                if (segment.P1.getY() != segment2.P1.getY() || !(segment.P1.getX() < segment2.P1.getX())) continue;
                segment2 = segment;
            } while ((segment = segment.next) != this);
            return segment2;
        }

        boolean isSegmentOutside(Shape shape) {
            return !shape.contains(this.getMidPoint());
        }
    }

    private class Intersection {
        Point2D p;
        double ta;
        double tb;
        Segment seg;

        public Intersection(Point2D point2D, double d, double d2) {
            this.p = point2D;
            this.ta = d;
            this.tb = d2;
        }
    }

    private class AreaIterator
    implements PathIterator {
        private Vector segments;
        private int index;
        private AffineTransform at;

        public AreaIterator(AffineTransform affineTransform) {
            this.at = affineTransform;
            this.index = 0;
            this.segments = new Vector();
            Vector vector = new Vector();
            vector.addAll(Area.this.solids);
            vector.addAll(Area.this.holes);
            for (int i = 0; i < vector.size(); ++i) {
                Segment segment;
                Segment segment2 = segment = (Segment)vector.elementAt(i);
                IteratorSegment iteratorSegment = new IteratorSegment();
                iteratorSegment.type = 0;
                iteratorSegment.coords[0] = segment2.P1.getX();
                iteratorSegment.coords[1] = segment2.P1.getY();
                this.segments.add(iteratorSegment);
                do {
                    iteratorSegment = new IteratorSegment();
                    iteratorSegment.type = segment.pathIteratorFormat(iteratorSegment.coords);
                    this.segments.add(iteratorSegment);
                } while ((segment = segment.next) != segment2);
                iteratorSegment = new IteratorSegment();
                iteratorSegment.type = 4;
                this.segments.add(iteratorSegment);
            }
        }

        public int currentSegment(double[] dArray) {
            IteratorSegment iteratorSegment = (IteratorSegment)this.segments.elementAt(this.index);
            if (this.at != null) {
                this.at.transform(iteratorSegment.coords, 0, dArray, 0, 3);
            } else {
                for (int i = 0; i < 6; ++i) {
                    dArray[i] = iteratorSegment.coords[i];
                }
            }
            return iteratorSegment.type;
        }

        public int currentSegment(float[] fArray) {
            IteratorSegment iteratorSegment = (IteratorSegment)this.segments.elementAt(this.index);
            double[] dArray = new double[6];
            if (this.at != null) {
                this.at.transform(iteratorSegment.coords, 0, dArray, 0, 3);
                for (int i = 0; i < 6; ++i) {
                    fArray[i] = (float)dArray[i];
                }
            } else {
                for (int i = 0; i < 6; ++i) {
                    fArray[i] = (float)iteratorSegment.coords[i];
                }
            }
            return iteratorSegment.type;
        }

        public int getWindingRule() {
            return 0;
        }

        public boolean isDone() {
            return this.index >= this.segments.size();
        }

        public void next() {
            ++this.index;
        }

        class IteratorSegment {
            int type;
            double[] coords = new double[6];

            IteratorSegment() {
            }
        }
    }
}

