/*
 * Decompiled with CFR 0.152.
 */
package java.awt.event;

import gnu.java.awt.EventModifier;
import gnu.java.lang.CPStringBuilder;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.InputEvent;
import java.io.IOException;
import java.io.ObjectInputStream;

public class MouseEvent
extends InputEvent {
    private static final long serialVersionUID = -991214153494842848L;
    public static final int MOUSE_FIRST = 500;
    public static final int MOUSE_LAST = 507;
    public static final int MOUSE_CLICKED = 500;
    public static final int MOUSE_PRESSED = 501;
    public static final int MOUSE_RELEASED = 502;
    public static final int MOUSE_MOVED = 503;
    public static final int MOUSE_ENTERED = 504;
    public static final int MOUSE_EXITED = 505;
    public static final int NOBUTTON = 0;
    public static final int BUTTON1 = 1;
    public static final int BUTTON2 = 2;
    public static final int BUTTON3 = 3;
    public static final int MOUSE_DRAGGED = 506;
    public static final int MOUSE_WHEEL = 507;
    private int x;
    private int y;
    private int absX;
    private int absY;
    private final int clickCount;
    private int button;
    private final boolean popupTrigger;

    public MouseEvent(Component component, int n, long l, int n2, int n3, int n4, int n5, boolean bl, int n6) {
        this(component, n, l, n2, n3, n4, 0, 0, n5, bl, n6);
    }

    public MouseEvent(Component component, int n, long l, int n2, int n3, int n4, int n5, boolean bl) {
        this(component, n, l, n2, n3, n4, n5, bl, 0);
    }

    public MouseEvent(Component component, int n, long l, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl, int n8) {
        super(component, n, l, n2);
        this.x = n3;
        this.y = n4;
        this.clickCount = n7;
        this.popupTrigger = bl;
        this.button = n8;
        if (n8 < 0 || n8 > 3) {
            throw new IllegalArgumentException();
        }
        if ((n2 & 0x3F) != 0) {
            if ((n2 & 0x10) != 0) {
                this.button = 1;
            } else if ((n2 & 8) != 0) {
                this.button = 2;
            } else if ((n2 & 4) != 0) {
                this.button = 3;
            }
        }
        if (n == 502) {
            this.modifiersEx &= 0xFFFFE3FF;
        }
        this.absX = n5;
        this.absY = n6;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public Point getLocationOnScreen() {
        return new Point(this.absX, this.absY);
    }

    public int getXOnScreen() {
        return this.absX;
    }

    public int getYOnScreen() {
        return this.absY;
    }

    public Point getPoint() {
        return new Point(this.x, this.y);
    }

    public void translatePoint(int n, int n2) {
        this.x += n;
        this.y += n2;
    }

    public int getClickCount() {
        return this.clickCount;
    }

    public int getButton() {
        return this.button;
    }

    public boolean isPopupTrigger() {
        return this.popupTrigger;
    }

    public static String getMouseModifiersText(int n) {
        if (((n &= 0x3F) & 8) != 0) {
            n |= 0x800;
        }
        if ((n & 4) != 0) {
            n |= 0x1000;
        }
        return MouseEvent.getModifiersExText(EventModifier.extend(n));
    }

    public String paramString() {
        CPStringBuilder cPStringBuilder = new CPStringBuilder();
        switch (this.id) {
            case 500: {
                cPStringBuilder.append("MOUSE_CLICKED,(");
                break;
            }
            case 501: {
                cPStringBuilder.append("MOUSE_PRESSED,(");
                break;
            }
            case 502: {
                cPStringBuilder.append("MOUSE_RELEASED,(");
                break;
            }
            case 503: {
                cPStringBuilder.append("MOUSE_MOVED,(");
                break;
            }
            case 504: {
                cPStringBuilder.append("MOUSE_ENTERED,(");
                break;
            }
            case 505: {
                cPStringBuilder.append("MOUSE_EXITED,(");
                break;
            }
            case 506: {
                cPStringBuilder.append("MOUSE_DRAGGED,(");
                break;
            }
            case 507: {
                cPStringBuilder.append("MOUSE_WHEEL,(");
                break;
            }
            default: {
                cPStringBuilder.append("unknown type,(");
            }
        }
        cPStringBuilder.append(this.x).append(',').append(this.y).append("),button=").append(this.button);
        if (this.modifiersEx != 0) {
            cPStringBuilder.append(",extModifiers=").append(MouseEvent.getModifiersExText(this.modifiersEx));
        }
        cPStringBuilder.append(",clickCount=").append(this.clickCount);
        cPStringBuilder.append(",consumed=").append(this.consumed);
        return cPStringBuilder.toString();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if ((this.modifiers & 0x3F) != 0) {
            if ((this.modifiers & 0x10) != 0) {
                this.button = 1;
            } else if ((this.modifiers & 8) != 0) {
                this.button = 2;
            } else if ((this.modifiers & 4) != 0) {
                this.button = 3;
            }
            this.modifiersEx = EventModifier.extend(this.modifiers) & 0x3FC0;
        }
    }
}

