/*
 * Decompiled with CFR 0.152.
 */
package java.awt.event;

import java.awt.AWTEvent;
import java.awt.ActiveEvent;
import java.awt.EventQueue;

public class InvocationEvent
extends AWTEvent
implements ActiveEvent {
    private static final long serialVersionUID = 436056344909459450L;
    public static final int INVOCATION_FIRST = 1200;
    public static final int INVOCATION_DEFAULT = 1200;
    public static final int INVOCATION_LAST = 1200;
    protected Runnable runnable;
    protected Object notifier;
    protected boolean catchExceptions;
    private Exception exception;
    private Throwable throwable;
    private final long when = EventQueue.getMostRecentEventTime();

    public InvocationEvent(Object object, Runnable runnable) {
        this(object, 1200, runnable, null, false);
    }

    public InvocationEvent(Object object, Runnable runnable, Object object2, boolean bl) {
        this(object, 1200, runnable, object2, bl);
    }

    protected InvocationEvent(Object object, int n, Runnable runnable, Object object2, boolean bl) {
        super(object, n);
        this.runnable = runnable;
        this.notifier = object2;
        this.catchExceptions = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatch() {
        if (this.catchExceptions) {
            try {
                this.runnable.run();
            }
            catch (Throwable throwable) {
                this.throwable = throwable;
                if (throwable instanceof Exception) {
                    this.exception = (Exception)throwable;
                }
            }
        } else {
            this.runnable.run();
        }
        Object object = this.notifier;
        if (object != null) {
            Object object2 = object;
            synchronized (object2) {
                object.notifyAll();
            }
        }
    }

    public Exception getException() {
        return this.exception;
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public long getWhen() {
        return this.when;
    }

    public String paramString() {
        return (this.id == 1200 ? "INVOCATION_DEFAULT,runnable=" : "unknown type,runnable=") + this.runnable + ",notifier=" + this.notifier + ",catchExceptions=" + this.catchExceptions + ",when=" + this.when;
    }
}

