/*
 * Decompiled with CFR 0.152.
 */
package java.awt.event;

import gnu.java.lang.CPStringBuilder;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.font.TextHitInfo;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.text.AttributedCharacterIterator;

public class InputMethodEvent
extends AWTEvent {
    private static final long serialVersionUID = 4727190874778922661L;
    public static final int INPUT_METHOD_FIRST = 1100;
    public static final int INPUT_METHOD_TEXT_CHANGED = 1100;
    public static final int CARET_POSITION_CHANGED = 1101;
    public static final int INPUT_METHOD_LAST = 1101;
    private long when;
    private final transient AttributedCharacterIterator text;
    private final transient int committedCharacterCount;
    private final transient TextHitInfo caret;
    private final transient TextHitInfo visiblePosition;

    public InputMethodEvent(Component component, int n, long l, AttributedCharacterIterator attributedCharacterIterator, int n2, TextHitInfo textHitInfo, TextHitInfo textHitInfo2) {
        super(component, n);
        this.when = l;
        this.text = attributedCharacterIterator;
        this.committedCharacterCount = n2;
        this.caret = textHitInfo;
        this.visiblePosition = textHitInfo2;
        if (n < 1100 || n > 1101 || n == 1101 && attributedCharacterIterator != null || n2 < 0 || n2 > (attributedCharacterIterator == null ? 0 : attributedCharacterIterator.getEndIndex() - attributedCharacterIterator.getBeginIndex())) {
            throw new IllegalArgumentException();
        }
    }

    public InputMethodEvent(Component component, int n, AttributedCharacterIterator attributedCharacterIterator, int n2, TextHitInfo textHitInfo, TextHitInfo textHitInfo2) {
        this(component, n, EventQueue.getMostRecentEventTime(), attributedCharacterIterator, n2, textHitInfo, textHitInfo2);
    }

    public InputMethodEvent(Component component, int n, TextHitInfo textHitInfo, TextHitInfo textHitInfo2) {
        this(component, n, EventQueue.getMostRecentEventTime(), null, 0, textHitInfo, textHitInfo2);
    }

    public AttributedCharacterIterator getText() {
        return this.text;
    }

    public int getCommittedCharacterCount() {
        return this.committedCharacterCount;
    }

    public TextHitInfo getCaret() {
        return this.caret;
    }

    public TextHitInfo getVisiblePosition() {
        return this.visiblePosition;
    }

    public void consume() {
        this.consumed = true;
    }

    public boolean isConsumed() {
        return this.consumed;
    }

    public long getWhen() {
        return this.when;
    }

    public String paramString() {
        CPStringBuilder cPStringBuilder = new CPStringBuilder(80 + (this.text == null ? 0 : this.text.getEndIndex() - this.text.getBeginIndex()));
        cPStringBuilder.append(this.id == 1100 ? "INPUT_METHOD_TEXT_CHANGED, " : "CARET_POSITION_CHANGED, ");
        if (this.text == null) {
            cPStringBuilder.append("no text, 0 characters committed, caret: ");
        } else {
            cPStringBuilder.append('\"');
            int n = this.text.getBeginIndex();
            int n2 = this.committedCharacterCount;
            while (--n2 >= 0) {
                cPStringBuilder.append(this.text.setIndex(n++));
            }
            cPStringBuilder.append("\" + \"");
            n2 = this.text.getEndIndex() - n;
            while (--n2 >= 0) {
                cPStringBuilder.append(this.text.setIndex(n++));
            }
            cPStringBuilder.append("\", ").append(this.committedCharacterCount).append(" characters committed, caret: ");
        }
        cPStringBuilder.append(this.caret == null ? "no caret" : this.caret).append(", ").append(this.visiblePosition == null ? "no visible position" : this.visiblePosition);
        return cPStringBuilder.toString();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.when == 0L) {
            this.when = EventQueue.getMostRecentEventTime();
        }
    }
}

