/*
 * Decompiled with CFR 0.152.
 */
package java.awt.dnd;

import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.FlavorMap;
import java.awt.datatransfer.SystemFlavorMap;
import java.awt.dnd.Autoscroll;
import java.awt.dnd.DropTargetContext;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.dnd.peer.DropTargetPeer;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.peer.ComponentPeer;
import java.awt.peer.LightweightPeer;
import java.io.Serializable;
import java.util.EventListener;
import java.util.TooManyListenersException;
import javax.swing.Timer;

public class DropTarget
implements DropTargetListener,
EventListener,
Serializable {
    private static final long serialVersionUID = -6283860791671019047L;
    private Component component;
    private FlavorMap flavorMap;
    private int actions;
    private DropTargetPeer peer;
    private DropTargetContext dropTargetContext;
    private DropTargetListener dropTargetListener;
    private DropTargetAutoScroller autoscroller;
    private boolean active = true;

    public DropTarget() {
        this(null, 3, null, true, null);
    }

    public DropTarget(Component component, DropTargetListener dropTargetListener) {
        this(component, 3, dropTargetListener, true, null);
    }

    public DropTarget(Component component, int n, DropTargetListener dropTargetListener) {
        this(component, n, dropTargetListener, true, null);
    }

    public DropTarget(Component component, int n, DropTargetListener dropTargetListener, boolean bl) {
        this(component, n, dropTargetListener, bl, null);
    }

    public DropTarget(Component component, int n, DropTargetListener dropTargetListener, boolean bl, FlavorMap flavorMap) {
        if (GraphicsEnvironment.isHeadless()) {
            throw new HeadlessException();
        }
        this.setComponent(component);
        this.setDefaultActions(n);
        this.dropTargetListener = dropTargetListener;
        this.flavorMap = flavorMap == null ? SystemFlavorMap.getDefaultFlavorMap() : flavorMap;
        this.setActive(bl);
        if (component != null) {
            component.setDropTarget(this);
        }
    }

    public void setComponent(Component component) {
        if (this.component != null) {
            this.clearAutoscroll();
        }
        this.component = component;
    }

    public Component getComponent() {
        return this.component;
    }

    public void setDefaultActions(int n) {
        this.actions = n;
    }

    public int getDefaultActions() {
        return this.actions;
    }

    public void setActive(boolean bl) {
        this.active = bl;
        if (!bl) {
            this.clearAutoscroll();
        }
    }

    public boolean isActive() {
        return this.active;
    }

    public void addDropTargetListener(DropTargetListener dropTargetListener) throws TooManyListenersException {
        if (dropTargetListener == null) {
            return;
        }
        if (dropTargetListener.equals(this)) {
            throw new IllegalArgumentException();
        }
        if (this.dropTargetListener != null) {
            throw new TooManyListenersException();
        }
        this.dropTargetListener = dropTargetListener;
    }

    public void removeDropTargetListener(DropTargetListener dropTargetListener) {
        if (this.dropTargetListener != null) {
            this.dropTargetListener = null;
        }
    }

    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        if (this.active) {
            if (this.dropTargetListener != null) {
                this.dropTargetListener.dragEnter(dropTargetDragEvent);
            }
            this.initializeAutoscrolling(dropTargetDragEvent.getLocation());
        }
    }

    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        if (this.active) {
            if (this.dropTargetListener != null) {
                this.dropTargetListener.dragOver(dropTargetDragEvent);
            }
            this.updateAutoscroll(dropTargetDragEvent.getLocation());
        }
    }

    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
        if (this.active) {
            if (this.dropTargetListener != null) {
                this.dropTargetListener.dropActionChanged(dropTargetDragEvent);
            }
            this.updateAutoscroll(dropTargetDragEvent.getLocation());
        }
    }

    public void dragExit(DropTargetEvent dropTargetEvent) {
        if (this.active) {
            if (this.dropTargetListener != null) {
                this.dropTargetListener.dragExit(dropTargetEvent);
            }
            this.clearAutoscroll();
        }
    }

    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        this.clearAutoscroll();
        if (this.dropTargetListener != null) {
            this.dropTargetListener.drop(dropTargetDropEvent);
        }
    }

    public FlavorMap getFlavorMap() {
        return this.flavorMap;
    }

    public void setFlavorMap(FlavorMap flavorMap) {
        this.flavorMap = flavorMap;
    }

    public void addNotify(ComponentPeer componentPeer) {
        for (Component component = this.component; component != null && componentPeer instanceof LightweightPeer; component = component.getParent()) {
            componentPeer = component.getPeer();
        }
        if (componentPeer instanceof DropTargetPeer) {
            this.peer = (DropTargetPeer)((Object)componentPeer);
            this.peer.addDropTarget(this);
        } else {
            this.peer = null;
        }
    }

    public void removeNotify(ComponentPeer componentPeer) {
        this.peer.removeDropTarget(this);
        this.peer = null;
        componentPeer = null;
    }

    public DropTargetContext getDropTargetContext() {
        if (this.dropTargetContext == null) {
            this.dropTargetContext = this.createDropTargetContext();
        }
        return this.dropTargetContext;
    }

    protected DropTargetContext createDropTargetContext() {
        if (this.dropTargetContext == null) {
            this.dropTargetContext = new DropTargetContext(this);
        }
        return this.dropTargetContext;
    }

    protected DropTargetAutoScroller createDropTargetAutoScroller(Component component, Point point) {
        return new DropTargetAutoScroller(component, point);
    }

    protected void initializeAutoscrolling(Point point) {
        if (this.component instanceof Autoscroll) {
            this.autoscroller = this.createDropTargetAutoScroller(this.component, point);
        }
    }

    protected void updateAutoscroll(Point point) {
        if (this.autoscroller != null) {
            this.autoscroller.updateLocation(point);
        }
    }

    protected void clearAutoscroll() {
        if (this.autoscroller != null) {
            this.autoscroller.stop();
            this.autoscroller = null;
        }
    }

    protected static class DropTargetAutoScroller
    implements ActionListener {
        private static final int HYSTERESIS = 10;
        private static final int DELAY = 100;
        private Component component;
        private Point point;
        private Timer timer;
        private Rectangle outer;
        private Rectangle inner;

        protected DropTargetAutoScroller(Component component, Point point) {
            this.component = component;
            this.point = point;
            this.timer = new Timer(100, this);
            this.timer.setCoalesce(true);
            this.timer.start();
        }

        protected void updateLocation(Point point) {
            Point point2 = this.point;
            this.point = point;
            if (Math.abs(this.point.x - point2.x) > 10 || Math.abs(this.point.y - point2.y) > 10) {
                if (this.timer.isRunning()) {
                    this.timer.stop();
                }
            } else if (!this.timer.isRunning()) {
                this.timer.start();
            }
        }

        protected void stop() {
            this.timer.start();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Autoscroll autoscroll = (Autoscroll)((Object)this.component);
            Insets insets = autoscroll.getAutoscrollInsets();
            int n = this.component.getWidth();
            int n2 = this.component.getHeight();
            if (n != this.outer.width || n2 != this.outer.height) {
                this.outer.setBounds(0, 0, n, n2);
            }
            if (this.inner.x != insets.left || this.inner.y != insets.top) {
                this.inner.setLocation(insets.left, insets.top);
            }
            int n3 = n - insets.left - insets.right;
            int n4 = n2 - insets.top - insets.bottom;
            if (n3 != this.inner.width || n4 != this.inner.height) {
                this.inner.setSize(n3, n4);
            }
            if (this.outer.contains(this.point) && !this.inner.contains(this.point)) {
                autoscroll.autoscroll(this.point);
            }
        }
    }
}

