/*
 * Decompiled with CFR 0.152.
 */
package java.awt.dnd;

import gnu.classpath.NotImplementedException;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.FlavorMap;
import java.awt.datatransfer.SystemFlavorMap;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DnDEventMulticaster;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSourceContext;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DragSourceMotionListener;
import java.awt.dnd.InvalidDnDOperationException;
import java.awt.dnd.MouseDragGestureRecognizer;
import java.awt.dnd.peer.DragSourceContextPeer;
import java.io.Serializable;
import java.util.EventListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DragSource
implements Serializable {
    private static final long serialVersionUID = 6236096958971414066L;
    public static final Cursor DefaultCopyDrop = null;
    public static final Cursor DefaultMoveDrop = null;
    public static final Cursor DefaultLinkDrop = null;
    public static final Cursor DefaultCopyNoDrop = null;
    public static final Cursor DefaultMoveNoDrop = null;
    public static final Cursor DefaultLinkNoDrop = null;
    private transient FlavorMap flavorMap = SystemFlavorMap.getDefaultFlavorMap();
    private transient DragSourceListener dragSourceListener;
    private transient DragSourceMotionListener dragSourceMotionListener;
    private static DragSource ds;
    private DragSourceContextPeer peer;
    private DragSourceContext context;

    public DragSource() {
        if (GraphicsEnvironment.isHeadless()) {
            ds = null;
            throw new HeadlessException();
        }
    }

    public static DragSource getDefaultDragSource() {
        if (GraphicsEnvironment.isHeadless()) {
            ds = null;
            throw new HeadlessException();
        }
        if (ds == null) {
            ds = new DragSource();
        }
        return ds;
    }

    public static boolean isDragImageSupported() {
        return false;
    }

    public void startDrag(DragGestureEvent dragGestureEvent, Cursor cursor, Image image, Point point, Transferable transferable, DragSourceListener dragSourceListener, FlavorMap flavorMap) {
        try {
            this.flavorMap = flavorMap;
            if (this.peer == null) {
                this.peer = Toolkit.getDefaultToolkit().createDragSourceContextPeer(dragGestureEvent);
            }
            if (this.context == null) {
                this.context = this.createDragSourceContext(this.peer, dragGestureEvent, cursor, image, point, transferable, dragSourceListener);
            }
            if (this.peer == null) {
                throw new InvalidDnDOperationException();
            }
            this.peer.startDrag(this.context, cursor, image, point);
        }
        catch (Exception exception) {
            throw new InvalidDnDOperationException("Drag and Drop system is unable to initiate a drag operation.");
        }
    }

    public void startDrag(DragGestureEvent dragGestureEvent, Cursor cursor, Transferable transferable, DragSourceListener dragSourceListener, FlavorMap flavorMap) {
        this.startDrag(dragGestureEvent, cursor, null, null, transferable, dragSourceListener, flavorMap);
    }

    public void startDrag(DragGestureEvent dragGestureEvent, Cursor cursor, Image image, Point point, Transferable transferable, DragSourceListener dragSourceListener) {
        this.startDrag(dragGestureEvent, cursor, image, point, transferable, dragSourceListener, null);
    }

    public void startDrag(DragGestureEvent dragGestureEvent, Cursor cursor, Transferable transferable, DragSourceListener dragSourceListener) {
        this.startDrag(dragGestureEvent, cursor, null, null, transferable, dragSourceListener, null);
    }

    protected DragSourceContext createDragSourceContext(DragSourceContextPeer dragSourceContextPeer, DragGestureEvent dragGestureEvent, Cursor cursor, Image image, Point point, Transferable transferable, DragSourceListener dragSourceListener) {
        return new DragSourceContext(dragSourceContextPeer, dragGestureEvent, cursor, image, point, transferable, dragSourceListener);
    }

    public FlavorMap getFlavorMap() {
        return this.flavorMap;
    }

    public <T extends DragGestureRecognizer> T createDragGestureRecognizer(Class<T> clazz, Component component, int n, DragGestureListener dragGestureListener) {
        return Toolkit.getDefaultToolkit().createDragGestureRecognizer(clazz, this, component, n, dragGestureListener);
    }

    public DragGestureRecognizer createDefaultDragGestureRecognizer(Component component, int n, DragGestureListener dragGestureListener) {
        return this.createDragGestureRecognizer(MouseDragGestureRecognizer.class, component, n, dragGestureListener);
    }

    public void addDragSourceListener(DragSourceListener dragSourceListener) {
        DnDEventMulticaster.add(this.dragSourceListener, dragSourceListener);
    }

    public void removeDragSourceListener(DragSourceListener dragSourceListener) {
        DnDEventMulticaster.remove(this.dragSourceListener, dragSourceListener);
    }

    public DragSourceListener[] getDragSourceListeners() {
        return (DragSourceListener[])this.getListeners(DragSourceListener.class);
    }

    public void addDragSourceMotionListener(DragSourceMotionListener dragSourceMotionListener) {
        DnDEventMulticaster.add(this.dragSourceMotionListener, dragSourceMotionListener);
    }

    public void removeDragSourceMotionListener(DragSourceMotionListener dragSourceMotionListener) {
        DnDEventMulticaster.remove(this.dragSourceMotionListener, dragSourceMotionListener);
    }

    public DragSourceMotionListener[] getDragSourceMotionListeners() {
        return (DragSourceMotionListener[])this.getListeners(DragSourceMotionListener.class);
    }

    public <T extends EventListener> T[] getListeners(Class<T> clazz) {
        if (clazz == DragSourceListener.class) {
            return DnDEventMulticaster.getListeners((EventListener)this.dragSourceListener, clazz);
        }
        if (clazz == DragSourceMotionListener.class) {
            return DnDEventMulticaster.getListeners((EventListener)this.dragSourceMotionListener, clazz);
        }
        return new EventListener[0];
    }

    public static int getDragThreshold() throws NotImplementedException {
        return 8;
    }
}

