/*
 * Decompiled with CFR 0.152.
 */
package java.awt.datatransfer;

import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.FlavorMap;
import java.awt.datatransfer.FlavorTable;
import java.awt.datatransfer.MimeType;
import java.awt.datatransfer.MimeTypeParseException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.WeakHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SystemFlavorMap
implements FlavorMap,
FlavorTable {
    private static final Map systemFlavorMaps = new WeakHashMap();
    private static final String GNU_JAVA_MIME_PREFIX = "gnu.java:";
    private HashMap<String, List<DataFlavor>> nativeToFlavorMap = new HashMap();
    private HashMap<DataFlavor, List<String>> flavorToNativeMap = new HashMap();

    private SystemFlavorMap() {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                try {
                    String string = File.separator;
                    File file = new File(System.getProperty("gnu.classpath.home.url") + string + "accessibility.properties");
                    InputStream inputStream = new FileInputStream(file);
                    Properties properties = new Properties();
                    properties.load(inputStream);
                    ((InputStream)inputStream).close();
                    String string2 = Toolkit.getProperty("AWT.DnD.flavorMapFileURL", null);
                    if (string2 != null) {
                        URL uRL = new URL(string2);
                        inputStream = uRL.openStream();
                        properties.load(inputStream);
                    }
                    SystemFlavorMap.this.setupMapping(properties);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return null;
            }
        });
    }

    void setupMapping(Properties properties) {
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            try {
                List<String> list2;
                String string = (String)enumeration.nextElement();
                String string2 = properties.getProperty(string);
                MimeType mimeType = new MimeType(string2);
                DataFlavor dataFlavor = new DataFlavor(string2);
                List<DataFlavor> list3 = this.nativeToFlavorMap.get(string);
                if (list3 == null) {
                    list3 = new ArrayList<DataFlavor>();
                    this.nativeToFlavorMap.put(string, list3);
                }
                if ((list2 = this.flavorToNativeMap.get(dataFlavor)) == null) {
                    list2 = new ArrayList<String>();
                    this.flavorToNativeMap.put(dataFlavor, list2);
                }
                list3.add(dataFlavor);
                list2.add(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (MimeTypeParseException mimeTypeParseException) {}
        }
    }

    @Override
    public Map<DataFlavor, String> getNativesForFlavors(DataFlavor[] dataFlavorArray) {
        return new HashMap<DataFlavor, String>();
    }

    @Override
    public Map<String, DataFlavor> getFlavorsForNatives(String[] stringArray) {
        return new HashMap<String, DataFlavor>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FlavorMap getDefaultFlavorMap() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        Map map = systemFlavorMaps;
        synchronized (map) {
            FlavorMap flavorMap = (FlavorMap)systemFlavorMaps.get(classLoader);
            if (flavorMap == null) {
                flavorMap = new SystemFlavorMap();
                systemFlavorMaps.put(classLoader, flavorMap);
            }
            return flavorMap;
        }
    }

    public static String encodeJavaMIMEType(String string) {
        if (string != null) {
            return GNU_JAVA_MIME_PREFIX + string;
        }
        return null;
    }

    public static String encodeDataFlavor(DataFlavor dataFlavor) {
        if (dataFlavor != null) {
            return SystemFlavorMap.encodeJavaMIMEType(dataFlavor.getMimeType());
        }
        return null;
    }

    public static boolean isJavaMIMEType(String string) {
        return string != null && string.startsWith(GNU_JAVA_MIME_PREFIX);
    }

    public static String decodeJavaMIMEType(String string) {
        if (SystemFlavorMap.isJavaMIMEType(string)) {
            return string.substring(GNU_JAVA_MIME_PREFIX.length());
        }
        return null;
    }

    public static DataFlavor decodeDataFlavor(String string) throws ClassNotFoundException {
        String string2 = SystemFlavorMap.decodeJavaMIMEType(string);
        if (string2 != null) {
            return new DataFlavor(string2);
        }
        return null;
    }

    @Override
    public List<DataFlavor> getFlavorsForNative(String string) {
        ArrayList<DataFlavor> arrayList = new ArrayList<DataFlavor>();
        if (string == null) {
            Collection<List<DataFlavor>> collection = this.nativeToFlavorMap.values();
            for (List<DataFlavor> list2 : collection) {
                for (DataFlavor dataFlavor : list2) {
                    if (arrayList.contains(dataFlavor)) continue;
                    arrayList.add(dataFlavor);
                }
            }
        } else {
            List<DataFlavor> list3 = this.nativeToFlavorMap.get(string);
            if (list3 != null) {
                arrayList.addAll(list3);
            }
        }
        return arrayList;
    }

    @Override
    public List<String> getNativesForFlavor(DataFlavor dataFlavor) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (dataFlavor == null) {
            Collection<List<String>> collection = this.flavorToNativeMap.values();
            for (List<String> list2 : collection) {
                for (String string : list2) {
                    if (arrayList.contains(string)) continue;
                    arrayList.add(string);
                }
            }
        } else {
            List<String> list3 = this.flavorToNativeMap.get(dataFlavor);
            if (list3 != null) {
                arrayList.addAll(list3);
            }
        }
        return arrayList;
    }

    public synchronized void addFlavorForUnencodedNative(String string, DataFlavor dataFlavor) {
        if (string == null || dataFlavor == null) {
            throw new NullPointerException();
        }
        List<DataFlavor> list2 = this.nativeToFlavorMap.get(string);
        if (list2 == null) {
            list2 = new ArrayList<DataFlavor>();
            this.nativeToFlavorMap.put(string, list2);
        } else if (!list2.contains(dataFlavor)) {
            list2.add(dataFlavor);
        }
    }

    public synchronized void addUnencodedNativeForFlavor(DataFlavor dataFlavor, String string) {
        if (string == null || dataFlavor == null) {
            throw new NullPointerException();
        }
        List<String> list2 = this.flavorToNativeMap.get(dataFlavor);
        if (list2 == null) {
            list2 = new ArrayList<String>();
            this.flavorToNativeMap.put(dataFlavor, list2);
        } else if (!list2.contains(string)) {
            list2.add(string);
        }
    }

    public synchronized void setNativesForFlavor(DataFlavor dataFlavor, String[] stringArray) {
        if (stringArray == null || dataFlavor == null) {
            throw new NullPointerException();
        }
        this.flavorToNativeMap.remove(dataFlavor);
        for (int i = 0; i < stringArray.length; ++i) {
            this.addUnencodedNativeForFlavor(dataFlavor, stringArray[i]);
        }
    }

    public synchronized void setFlavorsForNative(String string, DataFlavor[] dataFlavorArray) {
        if (string == null || dataFlavorArray == null) {
            throw new NullPointerException();
        }
        this.nativeToFlavorMap.remove(string);
        for (int i = 0; i < dataFlavorArray.length; ++i) {
            this.addFlavorForUnencodedNative(string, dataFlavorArray[i]);
        }
    }
}

