/*
 * Decompiled with CFR 0.152.
 */
package java.awt.datatransfer;

import gnu.java.lang.CPStringBuilder;
import java.awt.datatransfer.MimeTypeParseException;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.StringTokenizer;

class MimeType
implements Externalizable {
    private String primaryType;
    private String subType;
    private HashMap parameters = new HashMap();

    public MimeType() {
    }

    MimeType(String string) throws MimeTypeParseException {
        this();
        this.parse(string);
    }

    void addParameter(String string, String string2) {
        this.parameters.put(string, string2);
    }

    void removeParameter(String string) {
        this.parameters.remove(string);
    }

    String getParameter(String string) {
        return (String)this.parameters.get(string);
    }

    String getPrimaryType() {
        return this.primaryType;
    }

    String getSubType() {
        return this.subType;
    }

    String getBaseType() {
        return this.primaryType + '/' + this.subType;
    }

    boolean matches(MimeType mimeType) {
        boolean bl = false;
        if (mimeType != null) {
            bl = this.primaryType.equals(mimeType.primaryType) && (this.subType.equals("*") || mimeType.subType.equals("*") || this.subType.equals(mimeType.subType));
        }
        return bl;
    }

    public void readExternal(ObjectInput objectInput) throws ClassNotFoundException, IOException {
        String string = objectInput.readUTF();
        this.parameters.clear();
        try {
            this.parse(string);
        }
        catch (MimeTypeParseException mimeTypeParseException) {
            IOException iOException = new IOException();
            iOException.initCause(mimeTypeParseException);
            throw iOException;
        }
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeUTF(this.toString());
    }

    public String toString() {
        CPStringBuilder cPStringBuilder = new CPStringBuilder();
        cPStringBuilder.append(this.primaryType);
        cPStringBuilder.append('/');
        cPStringBuilder.append(this.subType);
        if (this.parameters.size() > 0) {
            Set set = this.parameters.entrySet();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                cPStringBuilder.append("; ");
                Map.Entry entry = iterator.next();
                cPStringBuilder.append(entry.getKey());
                cPStringBuilder.append('=');
                cPStringBuilder.append(entry.getValue());
            }
        }
        return cPStringBuilder.toString();
    }

    private void parse(String string) throws MimeTypeParseException {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        try {
            this.primaryType = stringTokenizer.nextToken("/");
            this.subType = stringTokenizer.nextToken("/;");
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new MimeTypeParseException("Expected / separator");
        }
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken(";");
            int n = string2.indexOf(61);
            if (n == -1) {
                throw new MimeTypeParseException("Expected = as parameter separator");
            }
            String string3 = string2.substring(0, n).trim();
            String string4 = string2.substring(n + 1).trim();
            this.parameters.put(string3, string4);
        }
    }
}

