/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.AWTException;
import java.awt.AWTPermission;
import java.awt.BorderLayout;
import java.awt.BufferCapabilities;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.FocusTraversalPolicy;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.ImageCapabilities;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.awt.event.WindowListener;
import java.awt.event.WindowStateListener;
import java.awt.image.BufferStrategy;
import java.awt.peer.WindowPeer;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.EventListener;
import java.util.Iterator;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Window
extends Container
implements Accessible {
    private static final long serialVersionUID = 4497834738069338734L;
    private String warningString = null;
    private int windowSerializedDataVersion = 0;
    private int state = 0;
    private boolean focusableWindowState = true;
    private boolean alwaysOnTop = false;
    private transient Vector ownedWindows = new Vector();
    private transient WindowListener windowListener;
    private transient WindowFocusListener windowFocusListener;
    private transient WindowStateListener windowStateListener;
    private transient boolean shown;
    transient Component windowFocusOwner;
    private static transient long next_window_number;

    Window() {
        this.visible = false;
        this.focusCycleRoot = true;
        this.setLayout(new BorderLayout());
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        this.graphicsConfig = graphicsEnvironment.getDefaultScreenDevice().getDefaultConfiguration();
    }

    Window(GraphicsConfiguration graphicsConfiguration) {
        this();
        this.graphicsConfig = graphicsConfiguration;
    }

    public Window(Frame frame) {
        this(frame, frame.getGraphicsConfiguration());
    }

    public Window(Window window) {
        this(window, window.getGraphicsConfiguration());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Window(Window window, GraphicsConfiguration graphicsConfiguration) {
        this();
        Object object = this.getTreeLock();
        synchronized (object) {
            if (window == null) {
                throw new IllegalArgumentException("owner must not be null");
            }
            this.parent = window;
            window.ownedWindows.add(new WeakReference<Window>(this));
        }
        object = System.getSecurityManager();
        if (object != null && !((SecurityManager)object).checkTopLevelWindow(this)) {
            this.warningString = System.getProperty("awt.appletWarning");
        }
        if (graphicsConfiguration != null && graphicsConfiguration.getDevice().getType() != 0) {
            throw new IllegalArgumentException("gc must be from a screen device");
        }
        this.graphicsConfig = graphicsConfiguration == null ? GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration() : graphicsConfiguration;
    }

    @Override
    public void addNotify() {
        if (this.peer == null) {
            this.peer = this.getToolkit().createWindow(this);
        }
        super.addNotify();
    }

    public void pack() {
        if (this.parent != null && !this.parent.isDisplayable()) {
            this.parent.addNotify();
        }
        if (this.peer == null) {
            this.addNotify();
        }
        this.setSize(this.getPreferredSize());
        this.validate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public void show() {
        Object object = this.getTreeLock();
        synchronized (object) {
            Object object2;
            Object object3;
            if (this.peer == null) {
                this.addNotify();
            }
            this.validate();
            if (this.visible) {
                this.toFront();
            } else {
                super.show();
                object3 = this.ownedWindows.iterator();
                while (object3.hasNext()) {
                    object2 = (Window)((Reference)object3.next()).get();
                    if (object2 != null) {
                        if (!((Component)object2).isVisible()) continue;
                        ((Component)object2).getPeer().setVisible(true);
                        continue;
                    }
                    object3.remove();
                }
            }
            object3 = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            ((KeyboardFocusManager)object3).setGlobalFocusedWindow(this);
            if (!this.shown) {
                object2 = this.getFocusTraversalPolicy();
                Component component = null;
                if (object2 != null) {
                    component = ((FocusTraversalPolicy)object2).getInitialComponent(this);
                }
                if (component != null) {
                    component.requestFocusInWindow();
                }
                if (this.windowListener != null || (this.eventMask & 0x40L) != 0L) {
                    WindowEvent windowEvent = new WindowEvent(this, 200);
                    Toolkit toolkit = Toolkit.getDefaultToolkit();
                    toolkit.getSystemEventQueue().postEvent(windowEvent);
                }
                this.shown = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public void hide() {
        Object object = this.getTreeLock();
        synchronized (object) {
            Iterator iterator = this.ownedWindows.iterator();
            while (iterator.hasNext()) {
                Window window = (Window)((Reference)iterator.next()).get();
                if (window != null) {
                    if (!window.isVisible() || window.getPeer() == null) continue;
                    window.getPeer().setVisible(false);
                    continue;
                }
                iterator.remove();
            }
        }
        super.hide();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        this.hide();
        Object object = this.getTreeLock();
        synchronized (object) {
            Iterator iterator = this.ownedWindows.iterator();
            while (iterator.hasNext()) {
                Window window = (Window)((Reference)iterator.next()).get();
                if (window != null) {
                    window.dispose();
                    continue;
                }
                iterator.remove();
            }
            for (int i = 0; i < this.ncomponents; ++i) {
                this.component[i].removeNotify();
            }
            this.removeNotify();
            if (this.windowListener != null || (this.eventMask & 0x40L) != 0L) {
                WindowEvent windowEvent = new WindowEvent(this, 202);
                Toolkit toolkit = Toolkit.getDefaultToolkit();
                toolkit.getSystemEventQueue().postEvent(windowEvent);
            }
        }
    }

    public void toBack() {
        if (this.peer != null) {
            if (this.alwaysOnTop) {
                this.setAlwaysOnTop(false);
            }
            ((WindowPeer)this.peer).toBack();
        }
    }

    public void toFront() {
        if (this.peer != null) {
            ((WindowPeer)this.peer).toFront();
        }
    }

    @Override
    public Toolkit getToolkit() {
        return Toolkit.getDefaultToolkit();
    }

    public final String getWarningString() {
        return this.warningString;
    }

    @Override
    public Locale getLocale() {
        return this.locale == null ? Locale.getDefault() : this.locale;
    }

    @Override
    public void setCursor(Cursor cursor) {
        super.setCursor(cursor);
    }

    public Window getOwner() {
        return (Window)this.parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Window[] getOwnedWindows() {
        Window[] windowArray;
        Object object = this.getTreeLock();
        synchronized (object) {
            Window[] windowArray2 = new Window[this.ownedWindows.size()];
            Iterator iterator = this.ownedWindows.iterator();
            int n = 0;
            while (iterator.hasNext()) {
                Window window = (Window)((Reference)iterator.next()).get();
                if (window != null) {
                    windowArray2[n++] = window;
                    continue;
                }
                iterator.remove();
            }
            if (n != windowArray2.length) {
                windowArray = new Window[n];
                System.arraycopy(windowArray2, 0, windowArray, 0, n);
            } else {
                windowArray = windowArray2;
            }
        }
        return windowArray;
    }

    public synchronized void addWindowListener(WindowListener windowListener) {
        if (windowListener != null) {
            this.newEventsOnly = true;
            this.windowListener = AWTEventMulticaster.add(this.windowListener, windowListener);
        }
    }

    public synchronized void removeWindowListener(WindowListener windowListener) {
        this.windowListener = AWTEventMulticaster.remove(this.windowListener, windowListener);
    }

    public synchronized WindowListener[] getWindowListeners() {
        return (WindowListener[])AWTEventMulticaster.getListeners((EventListener)this.windowListener, WindowListener.class);
    }

    public synchronized WindowFocusListener[] getWindowFocusListeners() {
        return (WindowFocusListener[])AWTEventMulticaster.getListeners((EventListener)this.windowFocusListener, WindowFocusListener.class);
    }

    public synchronized WindowStateListener[] getWindowStateListeners() {
        return (WindowStateListener[])AWTEventMulticaster.getListeners((EventListener)this.windowStateListener, WindowStateListener.class);
    }

    public void addWindowFocusListener(WindowFocusListener windowFocusListener) {
        if (windowFocusListener != null) {
            this.newEventsOnly = true;
            this.windowFocusListener = AWTEventMulticaster.add(this.windowFocusListener, windowFocusListener);
        }
    }

    public void addWindowStateListener(WindowStateListener windowStateListener) {
        if (windowStateListener != null) {
            this.newEventsOnly = true;
            this.windowStateListener = AWTEventMulticaster.add(this.windowStateListener, windowStateListener);
        }
    }

    public void removeWindowFocusListener(WindowFocusListener windowFocusListener) {
        this.windowFocusListener = AWTEventMulticaster.remove(this.windowFocusListener, windowFocusListener);
    }

    public void removeWindowStateListener(WindowStateListener windowStateListener) {
        this.windowStateListener = AWTEventMulticaster.remove(this.windowStateListener, windowStateListener);
    }

    @Override
    public <T extends EventListener> T[] getListeners(Class<T> clazz) {
        if (clazz == WindowListener.class) {
            return this.getWindowListeners();
        }
        return super.getListeners(clazz);
    }

    @Override
    void dispatchEventImpl(AWTEvent aWTEvent) {
        if (aWTEvent.getID() == 101) {
            this.invalidate();
            this.validate();
        }
        super.dispatchEventImpl(aWTEvent);
    }

    @Override
    protected void processEvent(AWTEvent aWTEvent) {
        if (aWTEvent instanceof WindowEvent) {
            WindowEvent windowEvent = (WindowEvent)aWTEvent;
            switch (aWTEvent.getID()) {
                case 200: 
                case 201: 
                case 202: 
                case 203: 
                case 204: 
                case 205: 
                case 206: {
                    this.processWindowEvent(windowEvent);
                    break;
                }
                case 207: 
                case 208: {
                    this.processWindowFocusEvent(windowEvent);
                    break;
                }
                case 209: {
                    this.processWindowStateEvent(windowEvent);
                }
            }
        } else {
            super.processEvent(aWTEvent);
        }
    }

    protected void processWindowEvent(WindowEvent windowEvent) {
        if (this.windowListener != null) {
            switch (windowEvent.getID()) {
                case 205: {
                    this.windowListener.windowActivated(windowEvent);
                    break;
                }
                case 202: {
                    this.windowListener.windowClosed(windowEvent);
                    break;
                }
                case 201: {
                    this.windowListener.windowClosing(windowEvent);
                    break;
                }
                case 206: {
                    this.windowListener.windowDeactivated(windowEvent);
                    break;
                }
                case 204: {
                    this.windowListener.windowDeiconified(windowEvent);
                    break;
                }
                case 203: {
                    this.windowListener.windowIconified(windowEvent);
                    break;
                }
                case 200: {
                    this.windowListener.windowOpened(windowEvent);
                }
            }
        }
    }

    public boolean isActive() {
        KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        return keyboardFocusManager.getActiveWindow() == this;
    }

    public boolean isFocused() {
        KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        return keyboardFocusManager.getFocusedWindow() == this;
    }

    public Component getFocusOwner() {
        KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        Window window = keyboardFocusManager.getActiveWindow();
        if (window == this) {
            return keyboardFocusManager.getFocusOwner();
        }
        return null;
    }

    public Component getMostRecentFocusOwner() {
        return this.windowFocusOwner;
    }

    void setFocusOwner(Component component) {
        this.windowFocusOwner = component;
    }

    @Override
    public boolean postEvent(Event event) {
        return this.handleEvent(event);
    }

    @Override
    public boolean isShowing() {
        return this.isVisible();
    }

    public void setLocationRelativeTo(Component component) {
        int n = 0;
        int n2 = 0;
        if (component == null || !component.isShowing()) {
            GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
            Point point = graphicsEnvironment.getCenterPoint();
            n = point.x - this.width / 2;
            n2 = point.y - this.height / 2;
        } else {
            int n3 = component.getWidth();
            int n4 = component.getHeight();
            Dimension dimension = this.getToolkit().getScreenSize();
            n = component.getLocationOnScreen().x;
            n2 = component.getLocationOnScreen().y;
            if (n2 + n4 > dimension.height) {
                n = dimension.width / 2 - n <= 0 ? (n - this.width >= 0 ? (n -= this.width) : 0) : (n + n3 + this.width <= dimension.width ? (n += n3) : dimension.width - this.width);
                n2 = dimension.height - this.height;
            } else if (n3 > this.width || n4 > this.height) {
                n = n + this.width > dimension.width ? dimension.width - this.width : (n < 0 ? 0 : (n += (n3 - this.width) / 2));
                n2 += (n4 - this.height) / 2;
            } else {
                n = n + this.width > dimension.width ? dimension.width - this.width : (n < 0 || n - (this.width - n3) / 2 < 0 ? 0 : (n -= (this.width - n3) / 2));
                n2 = n2 - (this.height - n4) / 2 > 0 ? (n2 -= (this.height - n4) / 2) : 0;
            }
        }
        this.setLocation(n, n2);
    }

    public void createBufferStrategy(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("Window.createBufferStrategy: number of buffers is less than one");
        }
        if (!this.isDisplayable()) {
            throw new IllegalStateException("Window.createBufferStrategy: window is not displayable");
        }
        BufferStrategy bufferStrategy = null;
        try {
            bufferStrategy = new WindowFlipBufferStrategy(n);
        }
        catch (AWTException aWTException) {
            // empty catch block
        }
        if (bufferStrategy == null) {
            bufferStrategy = new WindowBltBufferStrategy(n, true);
        }
        this.bufferStrategy = bufferStrategy;
    }

    public void createBufferStrategy(int n, BufferCapabilities bufferCapabilities) throws AWTException {
        if (n < 1) {
            throw new IllegalArgumentException("Window.createBufferStrategy: number of buffers is less than one");
        }
        if (bufferCapabilities == null) {
            throw new IllegalArgumentException("Window.createBufferStrategy: capabilities object is null");
        }
        this.bufferStrategy = bufferCapabilities.isPageFlipping() ? new WindowFlipBufferStrategy(n) : new WindowBltBufferStrategy(n, true);
    }

    public BufferStrategy getBufferStrategy() {
        return this.bufferStrategy;
    }

    public void applyResourceBundle(ResourceBundle resourceBundle) {
        this.applyComponentOrientation(ComponentOrientation.getOrientation(resourceBundle));
    }

    public void applyResourceBundle(String string) {
        ResourceBundle resourceBundle = ResourceBundle.getBundle(string, Locale.getDefault(), ClassLoader.getSystemClassLoader());
        if (resourceBundle != null) {
            this.applyResourceBundle(resourceBundle);
        }
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleAWTWindow();
        }
        return this.accessibleContext;
    }

    @Override
    public GraphicsConfiguration getGraphicsConfiguration() {
        GraphicsConfiguration graphicsConfiguration = this.graphicsConfig;
        if (graphicsConfiguration == null) {
            this.graphicsConfig = graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        }
        return graphicsConfiguration;
    }

    protected void processWindowFocusEvent(WindowEvent windowEvent) {
        if (this.windowFocusListener != null) {
            switch (windowEvent.getID()) {
                case 207: {
                    this.windowFocusListener.windowGainedFocus(windowEvent);
                    break;
                }
                case 208: {
                    this.windowFocusListener.windowLostFocus(windowEvent);
                    break;
                }
            }
        }
    }

    protected void processWindowStateEvent(WindowEvent windowEvent) {
        if (this.windowStateListener != null && windowEvent.getID() == 209) {
            this.windowStateListener.windowStateChanged(windowEvent);
        }
    }

    public final boolean isFocusableWindow() {
        if (!this.getFocusableWindowState()) {
            return false;
        }
        return this instanceof Dialog || this instanceof Frame;
    }

    public boolean getFocusableWindowState() {
        return this.focusableWindowState;
    }

    public void setFocusableWindowState(boolean bl) {
        this.focusableWindowState = bl;
    }

    @Override
    public final boolean isFocusCycleRoot() {
        return true;
    }

    @Override
    public final void setFocusCycleRoot(boolean bl) {
    }

    @Override
    public final Container getFocusCycleRootAncestor() {
        return null;
    }

    public final boolean isAlwaysOnTop() {
        return this.alwaysOnTop;
    }

    public final void setAlwaysOnTop(boolean bl) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new AWTPermission("setWindowAlwaysOnTop"));
        }
        if (this.alwaysOnTop == bl) {
            return;
        }
        if (bl) {
            this.toFront();
        }
        this.firePropertyChange("alwaysOnTop", this.alwaysOnTop, bl);
        this.alwaysOnTop = bl;
        if (this.peer != null) {
            ((WindowPeer)this.peer).updateAlwaysOnTop();
        } else {
            System.out.println("Null peer?!");
        }
    }

    @Override
    String generateName() {
        return "win" + Window.getUniqueLong();
    }

    @Override
    boolean eventTypeEnabled(int n) {
        boolean bl = false;
        switch (n) {
            case 200: 
            case 201: 
            case 202: 
            case 203: 
            case 204: 
            case 205: 
            case 206: {
                bl = (this.eventMask & 0x40L) != 0L || this.windowListener != null;
                break;
            }
            case 207: 
            case 208: {
                bl = (this.eventMask & 0x80000L) != 0L || this.windowFocusListener != null;
                break;
            }
            case 209: {
                bl = (this.eventMask & 0x40000L) != 0L || this.windowStateListener != null;
                break;
            }
            default: {
                bl = super.eventTypeEnabled(n);
            }
        }
        return bl;
    }

    private static synchronized long getUniqueLong() {
        return next_window_number++;
    }

    private class WindowFlipBufferStrategy
    extends Component.FlipBufferStrategy {
        WindowFlipBufferStrategy(int n) throws AWTException {
            super(n, new BufferCapabilities(new ImageCapabilities(true), new ImageCapabilities(true), BufferCapabilities.FlipContents.COPIED));
        }
    }

    private class WindowBltBufferStrategy
    extends Component.BltBufferStrategy {
        WindowBltBufferStrategy(int n, boolean bl) {
            super(n, new BufferCapabilities(new ImageCapabilities(bl), new ImageCapabilities(bl), BufferCapabilities.FlipContents.COPIED));
        }
    }

    protected class AccessibleAWTWindow
    extends Container.AccessibleAWTContainer {
        private static final long serialVersionUID = 4215068635060671780L;

        protected AccessibleAWTWindow() {
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.WINDOW;
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet accessibleStateSet = super.getAccessibleStateSet();
            if (Window.this.isActive()) {
                accessibleStateSet.add(AccessibleState.ACTIVE);
            }
            return accessibleStateSet;
        }
    }
}

