/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.TextComponent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.peer.TextFieldPeer;
import java.util.EventListener;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleStateSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextField
extends TextComponent {
    private static transient long next_textfield_number;
    private static final long serialVersionUID = -2966288784432217853L;
    private int columns;
    private char echoChar;
    private ActionListener action_listeners;

    public TextField() {
        this("", 0);
    }

    public TextField(String string) {
        this(string, string == null ? 0 : string.length());
    }

    public TextField(int n) {
        this("", n);
    }

    public TextField(String string, int n) {
        super(string);
        this.columns = n < 0 ? 0 : n;
        if (GraphicsEnvironment.isHeadless()) {
            throw new HeadlessException();
        }
    }

    public int getColumns() {
        return this.columns;
    }

    public synchronized void setColumns(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Value is less than zero: " + n);
        }
        this.columns = n;
    }

    public char getEchoChar() {
        return this.echoChar;
    }

    public void setEchoChar(char c) {
        this.setEchoCharacter(c);
    }

    public void setEchoCharacter(char c) {
        this.echoChar = c;
        TextFieldPeer textFieldPeer = (TextFieldPeer)this.getPeer();
        if (textFieldPeer != null) {
            textFieldPeer.setEchoChar(c);
        }
    }

    public boolean echoCharIsSet() {
        return this.echoChar != '\u0000';
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getMinimumSize(this.getColumns());
    }

    public Dimension getMinimumSize(int n) {
        return this.minimumSize(n);
    }

    @Override
    public Dimension minimumSize() {
        return this.minimumSize(this.getColumns());
    }

    public Dimension minimumSize(int n) {
        if (this.isMinimumSizeSet()) {
            return new Dimension(this.minSize);
        }
        TextFieldPeer textFieldPeer = (TextFieldPeer)this.getPeer();
        if (textFieldPeer == null) {
            return new Dimension(this.getWidth(), this.getHeight());
        }
        return textFieldPeer.getMinimumSize(n);
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getPreferredSize(this.getColumns());
    }

    public Dimension getPreferredSize(int n) {
        return this.preferredSize(n);
    }

    @Override
    public Dimension preferredSize() {
        return this.preferredSize(this.getColumns());
    }

    public Dimension preferredSize(int n) {
        if (this.isPreferredSizeSet()) {
            return new Dimension(this.prefSize);
        }
        TextFieldPeer textFieldPeer = (TextFieldPeer)this.getPeer();
        if (textFieldPeer == null) {
            return new Dimension(this.getWidth(), this.getHeight());
        }
        return textFieldPeer.getPreferredSize(n);
    }

    @Override
    public void addNotify() {
        if (this.getPeer() != null) {
            return;
        }
        this.setPeer(this.getToolkit().createTextField(this));
        super.addNotify();
    }

    public synchronized void addActionListener(ActionListener actionListener) {
        this.action_listeners = AWTEventMulticaster.add(this.action_listeners, actionListener);
        this.enableEvents(128L);
    }

    public synchronized void removeActionListener(ActionListener actionListener) {
        this.action_listeners = AWTEventMulticaster.remove(this.action_listeners, actionListener);
    }

    @Override
    protected void processEvent(AWTEvent aWTEvent) {
        if (aWTEvent instanceof ActionEvent) {
            this.processActionEvent((ActionEvent)aWTEvent);
        } else {
            super.processEvent(aWTEvent);
        }
    }

    protected void processActionEvent(ActionEvent actionEvent) {
        if (this.action_listeners != null) {
            this.action_listeners.actionPerformed(actionEvent);
        }
    }

    @Override
    void dispatchEventImpl(AWTEvent aWTEvent) {
        if (aWTEvent.id <= 1001 && aWTEvent.id >= 1001 && (this.action_listeners != null || (this.eventMask & 0x80L) != 0L)) {
            this.processEvent(aWTEvent);
        } else {
            super.dispatchEventImpl(aWTEvent);
        }
    }

    @Override
    protected String paramString() {
        return this.getClass().getName() + "(columns=" + this.getColumns() + ",echoChar=" + this.getEchoChar();
    }

    @Override
    public <T extends EventListener> T[] getListeners(Class<T> clazz) {
        if (clazz == ActionListener.class) {
            return AWTEventMulticaster.getListeners((EventListener)this.action_listeners, clazz);
        }
        return super.getListeners(clazz);
    }

    public ActionListener[] getActionListeners() {
        return (ActionListener[])this.getListeners(ActionListener.class);
    }

    @Override
    String generateName() {
        return "textfield" + TextField.getUniqueLong();
    }

    private static synchronized long getUniqueLong() {
        return next_textfield_number++;
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        return new AccessibleAWTTextField();
    }

    protected class AccessibleAWTTextField
    extends TextComponent.AccessibleAWTTextComponent {
        private static final long serialVersionUID = 6219164359235943158L;

        protected AccessibleAWTTextField() {
        }

        public AccessibleStateSet getAccessibleStateSet() {
            return super.getAccessibleStateSet();
        }
    }
}

