/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTError;
import java.awt.AWTEventMulticaster;
import java.awt.Adjustable;
import java.awt.ScrollPane;
import java.awt.event.AdjustmentListener;
import java.io.Serializable;
import java.util.EventListener;

public class ScrollPaneAdjustable
implements Adjustable,
Serializable {
    private static final long serialVersionUID = -3359745691033257079L;
    ScrollPane sp;
    int orientation;
    int value;
    int minimum;
    int maximum;
    int visibleAmount;
    int unitIncrement = 1;
    int blockIncrement = 1;
    AdjustmentListener adjustmentListener;
    private transient boolean valueIsAdjusting = false;

    ScrollPaneAdjustable(ScrollPane scrollPane, int n) {
        this.sp = scrollPane;
        this.orientation = n;
    }

    ScrollPaneAdjustable(ScrollPane scrollPane, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        this.sp = scrollPane;
        this.orientation = n;
        this.value = n2;
        this.minimum = n3;
        this.maximum = n4;
        this.visibleAmount = n5;
        this.unitIncrement = n6;
        this.blockIncrement = n7;
    }

    public void addAdjustmentListener(AdjustmentListener adjustmentListener) {
        if (adjustmentListener == null) {
            return;
        }
        this.adjustmentListener = AWTEventMulticaster.add(this.adjustmentListener, adjustmentListener);
    }

    public void removeAdjustmentListener(AdjustmentListener adjustmentListener) {
        if (adjustmentListener == null) {
            return;
        }
        this.adjustmentListener = AWTEventMulticaster.remove(this.adjustmentListener, adjustmentListener);
    }

    public AdjustmentListener[] getAdjustmentListeners() {
        return (AdjustmentListener[])AWTEventMulticaster.getListeners((EventListener)this.adjustmentListener, AdjustmentListener.class);
    }

    public int getBlockIncrement() {
        return this.blockIncrement;
    }

    public int getMaximum() {
        return this.maximum;
    }

    public int getMinimum() {
        return this.minimum;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public int getUnitIncrement() {
        return this.unitIncrement;
    }

    public int getValue() {
        return this.value;
    }

    public int getVisibleAmount() {
        return this.visibleAmount;
    }

    public void setBlockIncrement(int n) {
        this.blockIncrement = n;
    }

    public void setMaximum(int n) throws AWTError {
        throw new AWTError("Can be set by scrollpane only");
    }

    public void setMinimum(int n) {
        throw new AWTError("Can be set by scrollpane only");
    }

    public void setUnitIncrement(int n) {
        this.unitIncrement = n;
    }

    public void setValue(int n) {
        this.value = n;
        if (n < this.minimum) {
            this.minimum = n;
        }
        if (n > this.maximum) {
            this.maximum = n;
        }
    }

    public void setVisibleAmount(int n) {
        throw new AWTError("Can be set by scrollpane only");
    }

    public String paramString() {
        return this.paramStringHelper() + ",[" + this.getMinimum() + ".." + this.getMaximum() + "],val=" + this.getValue() + ",vis=" + this.getVisibleAmount() + ",unit=" + this.getUnitIncrement() + ",block=" + this.getBlockIncrement() + ",isAdjusting=" + this.valueIsAdjusting;
    }

    private String paramStringHelper() {
        if (this.getOrientation() == 0) {
            return "horizontal";
        }
        return "vertical";
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.paramString() + "]";
    }

    public boolean getValueIsAdjusting() {
        return this.valueIsAdjusting;
    }

    public void setValueIsAdjusting(boolean bl) {
        this.valueIsAdjusting = bl;
    }
}

