/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import gnu.java.awt.ClasspathToolkit;
import java.awt.AWTException;
import java.awt.AWTPermission;
import java.awt.Color;
import java.awt.EventQueue;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.peer.RobotPeer;
import java.lang.reflect.InvocationTargetException;

public class Robot {
    private boolean waitForIdle;
    private int autoDelay;
    private RobotPeer peer;

    public Robot() throws AWTException {
        if (GraphicsEnvironment.isHeadless()) {
            throw new AWTException("Robot: headless graphics environment");
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new AWTPermission("createRobot"));
        }
        ClasspathToolkit classpathToolkit = (ClasspathToolkit)Toolkit.getDefaultToolkit();
        this.peer = classpathToolkit.createRobot(GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice());
    }

    public Robot(GraphicsDevice graphicsDevice) throws AWTException {
        if (GraphicsEnvironment.isHeadless()) {
            throw new AWTException("Robot: headless graphics environment");
        }
        if (graphicsDevice.getType() != 0) {
            throw new IllegalArgumentException("Robot: graphics device is not a screen");
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new AWTPermission("createRobot"));
        }
        ClasspathToolkit classpathToolkit = (ClasspathToolkit)Toolkit.getDefaultToolkit();
        this.peer = classpathToolkit.createRobot(graphicsDevice);
    }

    public void mouseMove(int n, int n2) {
        this.peer.mouseMove(n, n2);
        if (this.waitForIdle) {
            this.waitForIdle();
        }
        if (this.autoDelay > 0) {
            this.delay(this.autoDelay);
        }
    }

    public void mousePress(int n) {
        if ((n & 0x10) == 0 && (n & 8) == 0 && (n & 4) == 0) {
            throw new IllegalArgumentException("Robot: mousePress: invalid button mask");
        }
        this.peer.mousePress(n);
        if (this.waitForIdle) {
            this.waitForIdle();
        }
        if (this.autoDelay > 0) {
            this.delay(this.autoDelay);
        }
    }

    public void mouseRelease(int n) {
        if ((n & 0x10) == 0 && (n & 8) == 0 && (n & 4) == 0) {
            throw new IllegalArgumentException("Robot: mouseRelease: invalid button mask");
        }
        this.peer.mouseRelease(n);
        if (this.waitForIdle) {
            this.waitForIdle();
        }
        if (this.autoDelay > 0) {
            this.delay(this.autoDelay);
        }
    }

    public void mouseWheel(int n) {
        this.peer.mouseWheel(n);
        if (this.waitForIdle) {
            this.waitForIdle();
        }
        if (this.autoDelay > 0) {
            this.delay(this.autoDelay);
        }
    }

    public void keyPress(int n) {
        this.peer.keyPress(n);
        if (this.waitForIdle) {
            this.waitForIdle();
        }
        if (this.autoDelay > 0) {
            this.delay(this.autoDelay);
        }
    }

    public void keyRelease(int n) {
        this.peer.keyRelease(n);
        if (this.waitForIdle) {
            this.waitForIdle();
        }
        if (this.autoDelay > 0) {
            this.delay(this.autoDelay);
        }
    }

    public Color getPixelColor(int n, int n2) {
        return new Color(this.peer.getRGBPixel(n, n2));
    }

    public BufferedImage createScreenCapture(Rectangle rectangle) {
        if (rectangle.width <= 0) {
            throw new IllegalArgumentException("Robot: capture width is <= 0");
        }
        if (rectangle.height <= 0) {
            throw new IllegalArgumentException("Robot: capture height is <= 0");
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new AWTPermission("readDisplayPixels"));
        }
        int[] nArray = this.peer.getRGBPixels(rectangle);
        BufferedImage bufferedImage = new BufferedImage(rectangle.width, rectangle.height, 2);
        bufferedImage.setRGB(0, 0, rectangle.width, rectangle.height, nArray, 0, rectangle.width);
        return bufferedImage;
    }

    public boolean isAutoWaitForIdle() {
        return this.waitForIdle;
    }

    public void setAutoWaitForIdle(boolean bl) {
        this.waitForIdle = bl;
    }

    public int getAutoDelay() {
        return this.autoDelay;
    }

    public void setAutoDelay(int n) {
        if (n <= 0 || n >= 60000) {
            throw new IllegalArgumentException("Robot: delay length out-of-bounds");
        }
        this.autoDelay = n;
    }

    public void delay(int n) {
        if (n < 0 || n > 60000) {
            throw new IllegalArgumentException("Robot: delay length out-of-bounds");
        }
        try {
            Thread.sleep(n);
        }
        catch (InterruptedException interruptedException) {
            System.err.println("Robot: delay interrupted");
        }
    }

    public void waitForIdle() {
        if (EventQueue.isDispatchThread()) {
            throw new IllegalThreadStateException("Robot: waitForIdle called from the event dispatch thread");
        }
        try {
            EventQueue.invokeAndWait(new Runnable(){

                public void run() {
                }
            });
        }
        catch (InterruptedException interruptedException) {
            System.err.println("Robot: waitForIdle interrupted");
        }
        catch (InvocationTargetException invocationTargetException) {
            System.err.println("Robot: waitForIdle cannot invoke target");
        }
    }

    public String toString() {
        return this.getClass().getName() + "[ autoDelay = " + this.autoDelay + ", autoWaitForIdle = " + this.waitForIdle + " ]";
    }
}

