/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.MenuComponent;
import java.awt.MenuContainer;
import java.awt.MenuItem;
import java.awt.peer.MenuPeer;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;

public class Menu
extends MenuItem
implements MenuContainer,
Serializable {
    private static transient long next_menu_number;
    private static final long serialVersionUID = -8809584163345499784L;
    private Vector items = new Vector();
    private boolean tearOff;
    private boolean isHelpMenu;
    private int menuSerializedDataVersion = 1;
    static final transient String separatorLabel = "-";

    public Menu() {
    }

    public Menu(String string) {
        this(string, false);
    }

    public Menu(String string, boolean bl) {
        super(string);
        this.tearOff = bl;
        if (string.equals("Help")) {
            this.isHelpMenu = true;
        }
        if (GraphicsEnvironment.isHeadless()) {
            throw new HeadlessException();
        }
    }

    public boolean isTearOff() {
        return this.tearOff;
    }

    public int getItemCount() {
        return this.countItems();
    }

    public int countItems() {
        return this.items.size();
    }

    public MenuItem getItem(int n) {
        return (MenuItem)this.items.elementAt(n);
    }

    public MenuItem add(MenuItem menuItem) {
        MenuContainer menuContainer = menuItem.getParent();
        if (menuContainer != null) {
            menuContainer.remove(menuItem);
        }
        this.items.addElement(menuItem);
        menuItem.setParent(this);
        if (this.peer != null) {
            menuItem.addNotify();
            MenuPeer menuPeer = (MenuPeer)this.peer;
            menuPeer.addItem(menuItem);
        }
        return menuItem;
    }

    public void add(String string) {
        this.add(new MenuItem(string));
    }

    public void insert(MenuItem menuItem, int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Index is less than zero");
        }
        int n2 = this.getItemCount();
        if (n >= n2) {
            this.add(menuItem);
        } else {
            int n3;
            MenuContainer menuContainer = menuItem.getParent();
            if (menuContainer != null) {
                menuContainer.remove(menuItem);
            }
            this.items.insertElementAt(menuItem, n);
            menuItem.setParent(this);
            MenuPeer menuPeer = (MenuPeer)this.getPeer();
            if (menuPeer == null) {
                return;
            }
            for (n3 = n2 - 1; n3 >= n; --n3) {
                menuPeer.delItem(n3);
            }
            menuItem.addNotify();
            menuPeer.addItem(menuItem);
            for (n3 = n + 1; n3 <= n2; ++n3) {
                menuPeer.addItem((MenuItem)this.items.elementAt(n3));
            }
        }
    }

    public void insert(String string, int n) {
        this.insert(new MenuItem(string), n);
    }

    public void addSeparator() {
        this.add(new MenuItem(separatorLabel));
    }

    public void insertSeparator(int n) {
        this.insert(new MenuItem(separatorLabel), n);
    }

    public synchronized void remove(int n) {
        MenuItem menuItem = (MenuItem)this.items.remove(n);
        MenuPeer menuPeer = (MenuPeer)this.getPeer();
        if (menuPeer != null) {
            menuPeer.delItem(n);
            menuItem.removeNotify();
        }
        menuItem.setParent(null);
    }

    public void remove(MenuComponent menuComponent) {
        int n = this.items.indexOf(menuComponent);
        if (n == -1) {
            return;
        }
        this.remove(n);
    }

    public synchronized void removeAll() {
        int n = this.getItemCount();
        for (int i = 0; i < n; ++i) {
            this.remove(0);
        }
    }

    public void addNotify() {
        MenuPeer menuPeer = (MenuPeer)this.getPeer();
        if (menuPeer == null) {
            menuPeer = this.getToolkit().createMenu(this);
            this.setPeer(menuPeer);
        }
        Enumeration enumeration = this.items.elements();
        while (enumeration.hasMoreElements()) {
            MenuItem menuItem = (MenuItem)enumeration.nextElement();
            menuItem.addNotify();
            menuPeer.addItem(menuItem);
        }
        super.addNotify();
    }

    public void removeNotify() {
        Enumeration enumeration = this.items.elements();
        while (enumeration.hasMoreElements()) {
            MenuItem menuItem = (MenuItem)enumeration.nextElement();
            menuItem.removeNotify();
        }
        super.removeNotify();
    }

    public String paramString() {
        return ",tearOff=" + this.tearOff + ",isHelpMenu=" + this.isHelpMenu + super.paramString();
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleAWTMenu();
        }
        return this.accessibleContext;
    }

    String generateName() {
        return "menu" + Menu.getUniqueLong();
    }

    private static synchronized long getUniqueLong() {
        return next_menu_number++;
    }

    protected class AccessibleAWTMenu
    extends MenuItem.AccessibleAWTMenuItem {
        private static final long serialVersionUID = 5228160894980069094L;

        protected AccessibleAWTMenu() {
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.MENU;
        }
    }
}

