/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.peer.LabelPeer;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;

public class Label
extends Component
implements Accessible {
    public static final int LEFT = 0;
    public static final int CENTER = 1;
    public static final int RIGHT = 2;
    private static final long serialVersionUID = 3094126758329070636L;
    private int alignment;
    private String text;
    private static transient long nextLabelNumber;

    public Label() {
        this("", 0);
    }

    public Label(String string) {
        this(string, 0);
    }

    public Label(String string, int n) {
        this.setAlignment(n);
        this.setText(string);
        if (GraphicsEnvironment.isHeadless()) {
            throw new HeadlessException();
        }
    }

    public int getAlignment() {
        return this.alignment;
    }

    public synchronized void setAlignment(int n) {
        if (n != 1 && n != 0 && n != 2) {
            throw new IllegalArgumentException("invalid alignment: " + n);
        }
        this.alignment = n;
        if (this.peer != null) {
            LabelPeer labelPeer = (LabelPeer)this.peer;
            labelPeer.setAlignment(n);
        }
    }

    public String getText() {
        return this.text;
    }

    public synchronized void setText(String string) {
        if (this.text == null && string != null || this.text != null && !this.text.equals(string)) {
            this.text = string;
            if (this.peer != null) {
                LabelPeer labelPeer = (LabelPeer)this.peer;
                labelPeer.setText(string);
            }
            this.invalidate();
        }
    }

    public void addNotify() {
        if (this.peer == null) {
            this.peer = this.getToolkit().createLabel(this);
        }
        super.addNotify();
    }

    protected String paramString() {
        return "text=" + this.getText() + ",alignment=" + this.getAlignment() + "," + super.paramString();
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleAWTLabel();
        }
        return this.accessibleContext;
    }

    String generateName() {
        return "label" + Label.getUniqueLong();
    }

    private static synchronized long getUniqueLong() {
        return nextLabelNumber++;
    }

    protected class AccessibleAWTLabel
    extends Component.AccessibleAWTComponent {
        private static final long serialVersionUID = -3568967560160480438L;

        public String getAccessibleName() {
            return Label.this.getText();
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.LABEL;
        }
    }
}

