/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Cursor;
import java.awt.GraphicsConfiguration;
import java.awt.IllegalComponentStateException;
import java.awt.Image;
import java.awt.MenuBar;
import java.awt.MenuComponent;
import java.awt.MenuContainer;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.peer.FramePeer;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Vector;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;

public class Frame
extends Window
implements MenuContainer {
    public static final int DEFAULT_CURSOR = 0;
    public static final int CROSSHAIR_CURSOR = 1;
    public static final int TEXT_CURSOR = 2;
    public static final int WAIT_CURSOR = 3;
    public static final int SW_RESIZE_CURSOR = 4;
    public static final int SE_RESIZE_CURSOR = 5;
    public static final int NW_RESIZE_CURSOR = 6;
    public static final int NE_RESIZE_CURSOR = 7;
    public static final int N_RESIZE_CURSOR = 8;
    public static final int S_RESIZE_CURSOR = 9;
    public static final int E_RESIZE_CURSOR = 11;
    public static final int W_RESIZE_CURSOR = 10;
    public static final int HAND_CURSOR = 12;
    public static final int MOVE_CURSOR = 13;
    public static final int ICONIFIED = 1;
    public static final int MAXIMIZED_BOTH = 6;
    public static final int MAXIMIZED_HORIZ = 2;
    public static final int MAXIMIZED_VERT = 4;
    public static final int NORMAL = 0;
    private static final long serialVersionUID = 2673458971256075116L;
    private int frameSerializedDataVersion;
    private Image icon;
    private boolean mbManagement;
    private MenuBar menuBar;
    Vector ownedWindows = new Vector();
    private boolean resizable = true;
    int state;
    private String title = "";
    private Rectangle maximizedBounds;
    private boolean undecorated = false;
    private static transient long next_frame_number;
    private static ArrayList<WeakReference<Frame>> weakFrames;
    private static ReferenceQueue weakFramesQueue;

    public Frame() {
        this("");
        Frame.noteFrame(this);
    }

    public Frame(String string) {
        this.title = string;
        this.visible = false;
        Frame.noteFrame(this);
    }

    public Frame(GraphicsConfiguration graphicsConfiguration) {
        super(graphicsConfiguration);
        this.visible = false;
        Frame.noteFrame(this);
    }

    public Frame(String string, GraphicsConfiguration graphicsConfiguration) {
        super(graphicsConfiguration);
        this.setTitle(string);
        this.visible = false;
        Frame.noteFrame(this);
    }

    public String getTitle() {
        return this.title;
    }

    public synchronized void setTitle(String string) {
        this.title = string;
        if (this.peer != null) {
            ((FramePeer)this.peer).setTitle(string);
        }
    }

    public Image getIconImage() {
        return this.icon;
    }

    public synchronized void setIconImage(Image image) {
        this.icon = image;
        if (this.peer != null) {
            ((FramePeer)this.peer).setIconImage(image);
        }
    }

    public MenuBar getMenuBar() {
        return this.menuBar;
    }

    public synchronized void setMenuBar(MenuBar menuBar) {
        if (this.menuBar != null) {
            this.remove(this.menuBar);
        }
        this.menuBar = menuBar;
        if (menuBar != null) {
            MenuContainer menuContainer = menuBar.getParent();
            if (menuContainer != null) {
                menuContainer.remove(menuBar);
            }
            menuBar.setParent(this);
            FramePeer framePeer = (FramePeer)this.peer;
            if (framePeer != null) {
                if (menuBar != null) {
                    menuBar.addNotify();
                }
                if (this.valid) {
                    this.invalidate();
                }
                framePeer.setMenuBar(menuBar);
            }
        }
    }

    public boolean isResizable() {
        return this.resizable;
    }

    public synchronized void setResizable(boolean bl) {
        this.resizable = bl;
        if (this.peer != null) {
            ((FramePeer)this.peer).setResizable(bl);
        }
    }

    public int getCursorType() {
        return this.getCursor().getType();
    }

    public void setCursor(int n) {
        this.setCursor(new Cursor(n));
    }

    public void remove(MenuComponent menuComponent) {
        if (menuComponent == this.menuBar) {
            if (this.menuBar != null) {
                if (this.peer != null) {
                    ((FramePeer)this.peer).setMenuBar(null);
                    this.menuBar.removeNotify();
                }
                this.menuBar.setParent(null);
            }
            this.menuBar = null;
        } else {
            super.remove(menuComponent);
        }
    }

    public void addNotify() {
        if (this.menuBar != null) {
            this.menuBar.addNotify();
        }
        if (this.peer == null) {
            this.peer = this.getToolkit().createFrame(this);
        }
        super.addNotify();
    }

    public void removeNotify() {
        if (this.menuBar != null) {
            this.menuBar.removeNotify();
        }
        super.removeNotify();
    }

    protected String paramString() {
        String string = this.getTitle();
        String string2 = "";
        if (this.isResizable()) {
            string2 = ",resizable";
        }
        String string3 = "";
        switch (this.getState()) {
            case 0: {
                string3 = ",normal";
                break;
            }
            case 1: {
                string3 = ",iconified";
                break;
            }
            case 6: {
                string3 = ",maximized-both";
                break;
            }
            case 2: {
                string3 = ",maximized-horiz";
                break;
            }
            case 4: {
                string3 = ",maximized-vert";
            }
        }
        return super.paramString() + ",title=" + string + string2 + string3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void noteFrame(Frame frame) {
        ArrayList<WeakReference<Frame>> arrayList = weakFrames;
        synchronized (arrayList) {
            Reference reference = weakFramesQueue.poll();
            while (reference != null) {
                weakFrames.remove(reference);
                reference = weakFramesQueue.poll();
            }
            weakFrames.add(new WeakReference<Frame>(frame));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean hasDisplayableFrames() {
        ArrayList<WeakReference<Frame>> arrayList = weakFrames;
        synchronized (arrayList) {
            for (WeakReference weakReference : weakFrames) {
                Frame frame = (Frame)weakReference.get();
                if (frame == null || !frame.isDisplayable()) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Frame[] getFrames() {
        ArrayList<WeakReference<Frame>> arrayList = weakFrames;
        synchronized (arrayList) {
            ArrayList<Frame> arrayList2 = new ArrayList<Frame>();
            for (WeakReference weakReference : weakFrames) {
                Frame frame = (Frame)weakReference.get();
                if (frame == null) continue;
                arrayList2.add(frame);
            }
            Frame[] frameArray = new Frame[arrayList2.size()];
            frameArray = arrayList2.toArray(frameArray);
            return frameArray;
        }
    }

    public void setState(int n) {
        int n2 = this.getExtendedState();
        if (n == 0 && (n2 & 1) != 0) {
            this.setExtendedState(n2 | 1);
        }
        if (n == 1 && (n2 & 0xFFFFFFFE) == 0) {
            this.setExtendedState(n2 & 0xFFFFFFFE);
        }
    }

    public int getState() {
        return (this.getExtendedState() & 1) != 0 ? 1 : 0;
    }

    public void setExtendedState(int n) {
        if (this.getToolkit().isFrameStateSupported(n)) {
            this.state = n;
            FramePeer framePeer = (FramePeer)this.peer;
            if (framePeer != null) {
                framePeer.setState(n);
            }
        }
    }

    public int getExtendedState() {
        FramePeer framePeer = (FramePeer)this.peer;
        if (framePeer != null) {
            this.state = framePeer.getState();
        }
        return this.state;
    }

    public void setMaximizedBounds(Rectangle rectangle) {
        this.maximizedBounds = rectangle;
    }

    public Rectangle getMaximizedBounds() {
        return this.maximizedBounds;
    }

    public boolean isUndecorated() {
        return this.undecorated;
    }

    public void setUndecorated(boolean bl) {
        if (this.isDisplayable()) {
            throw new IllegalComponentStateException();
        }
        this.undecorated = bl;
    }

    String generateName() {
        return "frame" + Frame.getUniqueLong();
    }

    private static synchronized long getUniqueLong() {
        return next_frame_number++;
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleAWTFrame();
        }
        return this.accessibleContext;
    }

    static {
        weakFrames = new ArrayList();
        weakFramesQueue = new ReferenceQueue();
    }

    protected class AccessibleAWTFrame
    extends Window.AccessibleAWTWindow {
        private static final long serialVersionUID = -6172960752956030250L;

        protected AccessibleAWTFrame() {
            super(Frame.this);
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.FRAME;
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet accessibleStateSet = super.getAccessibleStateSet();
            if (Frame.this.isResizable()) {
                accessibleStateSet.add(AccessibleState.RESIZABLE);
            }
            if ((Frame.this.state & 1) != 0) {
                accessibleStateSet.add(AccessibleState.ICONIFIED);
            }
            return accessibleStateSet;
        }
    }
}

