/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import gnu.java.awt.ClasspathToolkit;
import gnu.java.awt.peer.ClasspathFontPeer;
import java.awt.FontFormatException;
import java.awt.Toolkit;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.LineMetrics;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.peer.FontPeer;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.text.AttributedCharacterIterator;
import java.text.CharacterIterator;
import java.text.StringCharacterIterator;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Font
implements Serializable {
    public static final int PLAIN = 0;
    public static final int BOLD = 1;
    public static final int ITALIC = 2;
    public static final int ROMAN_BASELINE = 0;
    public static final int CENTER_BASELINE = 1;
    public static final int HANGING_BASELINE = 2;
    public static final int TRUETYPE_FONT = 0;
    public static final int TYPE1_FONT = 1;
    public static final int LAYOUT_LEFT_TO_RIGHT = 0;
    public static final int LAYOUT_RIGHT_TO_LEFT = 1;
    public static final int LAYOUT_NO_START_CONTEXT = 2;
    public static final int LAYOUT_NO_LIMIT_CONTEXT = 4;
    public static final String DIALOG = "Dialog";
    public static final String DIALOG_INPUT = "DialogInput";
    public static final String MONOSPACED = "Monospaced";
    public static final String SANS_SERIF = "SansSerif";
    public static final String SERIF = "Serif";
    protected String name;
    protected int size;
    protected float pointSize;
    protected int style;
    private static final long serialVersionUID = -4206021311591459213L;
    private transient ClasspathFontPeer peer;
    private transient int hashCode;

    public static Font decode(String string) {
        Object object;
        if (string == null) {
            string = "Dialog-PLAIN-12";
        }
        Object object2 = null;
        int n = 0;
        int n2 = 12;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "- ");
        while (stringTokenizer.hasMoreTokens()) {
            object = stringTokenizer.nextToken();
            if (object2 == null) {
                object2 = object;
                continue;
            }
            if (((String)object).toUpperCase().equals("BOLD")) {
                n = 1;
                continue;
            }
            if (((String)object).toUpperCase().equals("ITALIC")) {
                n = 2;
                continue;
            }
            if (((String)object).toUpperCase().equals("BOLDITALIC")) {
                n = 3;
                continue;
            }
            int n3 = 0;
            try {
                n3 = Integer.parseInt((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (n3 == 0) continue;
            n2 = n3;
        }
        object = new HashMap();
        ClasspathFontPeer.copyStyleToAttrs(n, (Map)object);
        ClasspathFontPeer.copySizeToAttrs(n2, (Map)object);
        return Font.getFontFromToolkit((String)object2, (Map)object);
    }

    static ClasspathToolkit tk() {
        return (ClasspathToolkit)Toolkit.getDefaultToolkit();
    }

    static Font getFontFromToolkit(String string, Map map) {
        return Font.tk().getFont(string, map);
    }

    static ClasspathFontPeer getPeerFromToolkit(String string, Map map) {
        return Font.tk().getClasspathFontPeer(string, map);
    }

    public static Font getFont(String string, Font font) {
        String string2 = System.getProperty(string);
        if (string2 != null) {
            return Font.decode(string2);
        }
        return font;
    }

    public static Font getFont(String string) {
        return Font.getFont(string, null);
    }

    protected Font(Font font) {
        this(font.getName(), font.getAttributes());
    }

    public Font(String string, int n, int n2) {
        HashMap hashMap = new HashMap();
        ClasspathFontPeer.copyStyleToAttrs(n, hashMap);
        ClasspathFontPeer.copySizeToAttrs(n2, hashMap);
        this.peer = Font.getPeerFromToolkit(string, hashMap);
        this.size = n2;
        this.pointSize = n2;
        this.name = string != null ? string : this.peer.getName(this);
    }

    public Font(Map<? extends AttributedCharacterIterator.Attribute, ?> map) {
        this(null, map);
    }

    Font(String string, Map hashMap) {
        if (hashMap == null) {
            hashMap = new HashMap();
        }
        this.peer = Font.getPeerFromToolkit(string, hashMap);
        this.size = (int)this.peer.getSize(this);
        this.pointSize = this.peer.getSize(this);
        this.name = string != null ? string : this.peer.getName(this);
    }

    public String getName() {
        return this.peer.getName(this);
    }

    public int getSize() {
        return this.size;
    }

    public float getSize2D() {
        return this.pointSize;
    }

    public boolean isPlain() {
        return this.peer.isPlain(this);
    }

    public boolean isBold() {
        return this.peer.isBold(this);
    }

    public boolean isItalic() {
        return this.peer.isItalic(this);
    }

    public String getFamily() {
        return this.peer.getFamily(this);
    }

    public int getStyle() {
        return this.peer.getStyle(this);
    }

    public boolean canDisplay(char c) {
        return this.canDisplay((int)c);
    }

    public boolean canDisplay(int n) {
        return this.peer.canDisplay(this, n);
    }

    public int canDisplayUpTo(String string) {
        return this.peer.canDisplayUpTo(this, new StringCharacterIterator(string), 0, string.length() - 1);
    }

    public int canDisplayUpTo(char[] cArray, int n, int n2) {
        return this.peer.canDisplayUpTo(this, new StringCharacterIterator(new String(cArray)), n, n2);
    }

    public int canDisplayUpTo(CharacterIterator characterIterator, int n, int n2) {
        return this.peer.canDisplayUpTo(this, characterIterator, n, n2);
    }

    public static Font createFont(int n, InputStream inputStream) throws FontFormatException, IOException {
        return Font.tk().createFont(n, inputStream);
    }

    public static Font createFont(int n, File file) throws FontFormatException, IOException {
        if (file == null) {
            throw new NullPointerException("Null file argument");
        }
        return Font.tk().createFont(n, new FileInputStream(file));
    }

    public GlyphVector createGlyphVector(FontRenderContext fontRenderContext, String string) {
        return this.peer.createGlyphVector(this, fontRenderContext, new StringCharacterIterator(string));
    }

    public GlyphVector createGlyphVector(FontRenderContext fontRenderContext, CharacterIterator characterIterator) {
        return this.peer.createGlyphVector(this, fontRenderContext, characterIterator);
    }

    public GlyphVector createGlyphVector(FontRenderContext fontRenderContext, char[] cArray) {
        return this.peer.createGlyphVector(this, fontRenderContext, new StringCharacterIterator(new String(cArray)));
    }

    public GlyphVector createGlyphVector(FontRenderContext fontRenderContext, int[] nArray) {
        return this.peer.createGlyphVector(this, fontRenderContext, nArray);
    }

    public Font deriveFont(int n, float f) {
        return this.peer.deriveFont(this, n, f);
    }

    public Font deriveFont(float f) {
        return this.peer.deriveFont(this, f);
    }

    public Font deriveFont(int n) {
        return this.peer.deriveFont(this, n);
    }

    public Font deriveFont(int n, AffineTransform affineTransform) {
        if (affineTransform == null) {
            throw new IllegalArgumentException("Affine transformation is null");
        }
        return this.peer.deriveFont(this, n, affineTransform);
    }

    public Font deriveFont(AffineTransform affineTransform) {
        if (affineTransform == null) {
            throw new IllegalArgumentException("Affine transformation is null");
        }
        return this.peer.deriveFont(this, affineTransform);
    }

    public Font deriveFont(Map<? extends AttributedCharacterIterator.Attribute, ?> map) {
        return this.peer.deriveFont(this, map);
    }

    public Map<TextAttribute, ?> getAttributes() {
        return this.peer.getAttributes(this);
    }

    public AttributedCharacterIterator.Attribute[] getAvailableAttributes() {
        return this.peer.getAvailableAttributes(this);
    }

    public byte getBaselineFor(char c) {
        return this.peer.getBaselineFor(this, c);
    }

    public String getFamily(Locale locale) {
        return this.peer.getFamily(this, locale);
    }

    public static Font getFont(Map<? extends AttributedCharacterIterator.Attribute, ?> map) {
        return Font.getFontFromToolkit(null, map);
    }

    public String getFontName() {
        return this.peer.getFontName(this);
    }

    public String getFontName(Locale locale) {
        return this.peer.getFontName(this, locale);
    }

    public float getItalicAngle() {
        return this.peer.getItalicAngle(this);
    }

    public LineMetrics getLineMetrics(String string, int n, int n2, FontRenderContext fontRenderContext) {
        return this.peer.getLineMetrics(this, new StringCharacterIterator(string), n, n2, fontRenderContext);
    }

    public LineMetrics getLineMetrics(char[] cArray, int n, int n2, FontRenderContext fontRenderContext) {
        return this.peer.getLineMetrics(this, new StringCharacterIterator(new String(cArray)), n, n2, fontRenderContext);
    }

    public LineMetrics getLineMetrics(CharacterIterator characterIterator, int n, int n2, FontRenderContext fontRenderContext) {
        return this.peer.getLineMetrics(this, characterIterator, n, n2, fontRenderContext);
    }

    public Rectangle2D getMaxCharBounds(FontRenderContext fontRenderContext) {
        return this.peer.getMaxCharBounds(this, fontRenderContext);
    }

    public int getMissingGlyphCode() {
        return this.peer.getMissingGlyphCode(this);
    }

    public int getNumGlyphs() {
        return this.peer.getNumGlyphs(this);
    }

    public String getPSName() {
        return this.peer.getPostScriptName(this);
    }

    public Rectangle2D getStringBounds(String string, FontRenderContext fontRenderContext) {
        char[] cArray = string.toCharArray();
        return this.getStringBounds(cArray, 0, cArray.length, fontRenderContext);
    }

    public Rectangle2D getStringBounds(String string, int n, int n2, FontRenderContext fontRenderContext) {
        String string2 = string.substring(n, n2);
        return this.getStringBounds(string2, fontRenderContext);
    }

    public Rectangle2D getStringBounds(CharacterIterator characterIterator, int n, int n2, FontRenderContext fontRenderContext) {
        int n3 = characterIterator.getBeginIndex();
        int n4 = characterIterator.getEndIndex();
        char[] cArray = new char[n2 - n3];
        characterIterator.setIndex(n3);
        for (int i = 0; i < cArray.length; ++i) {
            cArray[i] = characterIterator.current();
            characterIterator.next();
        }
        return this.getStringBounds(cArray, 0, cArray.length, fontRenderContext);
    }

    public Rectangle2D getStringBounds(char[] cArray, int n, int n2, FontRenderContext fontRenderContext) {
        String string = new String(cArray, n, n2 - n);
        TextLayout textLayout = new TextLayout(string, this, fontRenderContext);
        return new Rectangle2D.Float(0.0f, -textLayout.getAscent(), textLayout.getAdvance(), textLayout.getDescent() + textLayout.getLeading());
    }

    public AffineTransform getTransform() {
        return this.peer.getTransform(this);
    }

    public boolean hasUniformLineMetrics() {
        return this.peer.hasUniformLineMetrics(this);
    }

    public boolean isTransformed() {
        return this.peer.isTransformed(this);
    }

    public GlyphVector layoutGlyphVector(FontRenderContext fontRenderContext, char[] cArray, int n, int n2, int n3) {
        return this.peer.layoutGlyphVector(this, fontRenderContext, cArray, n, n2, n3);
    }

    public FontPeer getPeer() {
        return this.peer;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = this.getName().hashCode() ^ this.getTransform().hashCode() ^ this.getSize() ^ this.getStyle();
            if (this.hashCode == 0) {
                this.hashCode = -1;
            }
        }
        return this.hashCode;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof Font)) {
            return false;
        }
        Font font = (Font)object;
        return font.getName().equals(this.getName()) && font.getFamily().equals(this.getFamily()) && font.getFontName().equals(this.getFontName()) && font.getTransform().equals(this.getTransform()) && font.getSize() == this.getSize() && font.getStyle() == this.getStyle();
    }

    public String toString() {
        String string = "";
        switch (this.getStyle()) {
            case 0: {
                string = "plain";
                break;
            }
            case 1: {
                string = "bold";
                break;
            }
            case 2: {
                string = "italic";
                break;
            }
            default: {
                string = "unknown";
            }
        }
        return this.getClass().getName() + "[family=" + this.getFamily() + ",name=" + this.getFontName() + ",style=" + string + ",size=" + this.getSize() + "]";
    }

    public LineMetrics getLineMetrics(String string, FontRenderContext fontRenderContext) {
        return this.getLineMetrics(string, 0, string.length() - 1, fontRenderContext);
    }

    public boolean hasLayoutAttributes() {
        return false;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        HashMap hashMap = new HashMap();
        ClasspathFontPeer.copyStyleToAttrs(this.style, hashMap);
        ClasspathFontPeer.copySizeToAttrs(this.size, hashMap);
        this.peer = Font.getPeerFromToolkit(this.name, hashMap);
    }
}

