/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.awt.Window;
import java.io.Serializable;

public class ContainerOrderFocusTraversalPolicy
extends FocusTraversalPolicy
implements Serializable {
    static final long serialVersionUID = 486933713763926351L;
    private boolean implicitDownCycleTraversal = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Component getComponentAfter(Container container, Component component) {
        Container container2;
        if (container == null) {
            throw new IllegalArgumentException("focus cycle root is null");
        }
        if (component == null) {
            throw new IllegalArgumentException("current component is null");
        }
        if (!container.isFocusCycleRoot()) {
            throw new IllegalArgumentException("root is not a focus cycle root");
        }
        Container container3 = container2 = component.getFocusCycleRootAncestor();
        while (container2 != container) {
            container2 = component.getFocusCycleRootAncestor();
            if (container2 == container3) {
                if (container2 == null) {
                    container2 = container;
                } else {
                    if (container2 == container) break;
                    throw new IllegalArgumentException("the given container is not a focus cycle root of the current component");
                }
            }
            container3 = container2;
        }
        if (container == component) {
            container = component.getFocusCycleRootAncestor();
        }
        if (component instanceof Window) {
            return this.getFirstComponent((Container)component);
        }
        Container container4 = component.getParent();
        Object object = container4.getTreeLock();
        synchronized (object) {
            int n;
            Component[] componentArray = container4.getComponents();
            int n2 = 0;
            int n3 = container4.getComponentCount();
            for (n = 0; n < n3; ++n) {
                if (!componentArray[n].equals(component)) continue;
                n2 = n;
            }
            n = n2 + 1;
            int n4 = n3 - 1;
            Component component2 = this.getNextAvailableComponent(componentArray, n, n4);
            if (component2 != null) {
                return component2;
            }
            n = 0;
            n4 = n2;
            component2 = this.getNextAvailableComponent(componentArray, n, n4);
            if (component2 != null) {
                return component2;
            }
            Component component3 = this.getComponentAfter(container, container4);
            return component3;
        }
    }

    private Component getNextAvailableComponent(Component[] componentArray, int n, int n2) {
        while (n <= n2) {
            Component component;
            Component component2 = componentArray[n];
            if (component2.visible && component2.isDisplayable() && component2.enabled && component2.focusable) {
                return component2;
            }
            if (component2 instanceof Container && (component = this.getFirstComponent((Container)component2)) != null && this.implicitDownCycleTraversal && component.visible && component.isDisplayable() && component.enabled && component.focusable) {
                return component;
            }
            ++n;
        }
        return null;
    }

    Component getPrevAvailableComponent(Component[] componentArray, int n, int n2) {
        while (n >= n2) {
            Component component;
            Component component2 = componentArray[n];
            if (component2.visible && component2.isDisplayable() && component2.enabled && component2.focusable) {
                return component2;
            }
            if (component2 instanceof Container && (component = this.getLastComponent((Container)component2)) != null && component.visible && component.isDisplayable() && component.enabled && component.focusable) {
                return component;
            }
            --n;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Component getComponentBefore(Container container, Component component) {
        Container container2;
        if (container == null) {
            throw new IllegalArgumentException("focus cycle root is null");
        }
        if (component == null) {
            throw new IllegalArgumentException("current component is null");
        }
        if (!container.isFocusCycleRoot()) {
            throw new IllegalArgumentException("root is not a focus cycle root");
        }
        Container container3 = container2 = component.getFocusCycleRootAncestor();
        while (container2 != container) {
            container2 = component.getFocusCycleRootAncestor();
            if (container2 == container3) {
                if (container2 == null) {
                    container2 = container;
                } else {
                    if (container2 == container) break;
                    throw new IllegalArgumentException("the given container is not a focus cycle root of the current component");
                }
            }
            container3 = container2;
        }
        if (container == component) {
            container = component.getFocusCycleRootAncestor();
        }
        if (component instanceof Window) {
            return this.getLastComponent((Container)component);
        }
        Container container4 = component.getParent();
        Object object = container4.getTreeLock();
        synchronized (object) {
            int n;
            Component[] componentArray = container4.getComponents();
            int n2 = 0;
            int n3 = container4.getComponentCount();
            for (n = 0; n < n3; ++n) {
                if (componentArray[n] != component) continue;
                n2 = n;
            }
            n = n2 - 1;
            int n4 = 0;
            Component component2 = this.getPrevAvailableComponent(componentArray, n, n4);
            if (component2 != null) {
                return component2;
            }
            n = n3 - 1;
            n4 = n2;
            component2 = this.getPrevAvailableComponent(componentArray, n, n4);
            if (component2 != null) {
                return component2;
            }
            Component component3 = this.getComponentBefore(container, container4);
            return component3;
        }
    }

    public Component getFirstComponent(Container container) {
        if (container == null) {
            throw new IllegalArgumentException();
        }
        if (!container.isVisible() || !container.isDisplayable()) {
            return null;
        }
        if (this.accept(container)) {
            return container;
        }
        int n = container.getComponentCount();
        for (int i = 0; i < n; ++i) {
            Component component = container.getComponent(i);
            if (component instanceof Container && !((Container)component).isFocusCycleRoot()) {
                Component component2 = null;
                Container container2 = (Container)component;
                if (container2.isFocusTraversalPolicyProvider()) {
                    FocusTraversalPolicy focusTraversalPolicy = container2.getFocusTraversalPolicy();
                    component2 = focusTraversalPolicy.getFirstComponent(container2);
                } else {
                    component2 = this.getFirstComponent(container2);
                }
                if (component2 == null) continue;
                return component2;
            }
            if (!this.accept(component)) continue;
            return component;
        }
        return null;
    }

    public Component getLastComponent(Container container) {
        if (container == null) {
            throw new IllegalArgumentException();
        }
        if (!container.isVisible() || !container.isDisplayable()) {
            return null;
        }
        if (container.visible && container.isDisplayable() && container.enabled && container.focusable) {
            return container;
        }
        Component[] componentArray = container.getComponents();
        for (int i = componentArray.length - 1; i >= 0; --i) {
            Component component;
            Component component2 = componentArray[i];
            if (component2.visible && component2.isDisplayable() && component2.enabled && component2.focusable) {
                return component2;
            }
            if (!(component2 instanceof Container) || (component = this.getLastComponent((Container)component2)) == null || !component.visible || !component.isDisplayable() || !component.enabled || !component.focusable) continue;
            return component;
        }
        return null;
    }

    public Component getDefaultComponent(Container container) {
        return this.getFirstComponent(container);
    }

    public void setImplicitDownCycleTraversal(boolean bl) {
        this.implicitDownCycleTraversal = bl;
    }

    public boolean getImplicitDownCycleTraversal() {
        return this.implicitDownCycleTraversal;
    }

    protected boolean accept(Component component) {
        return component.visible && component.isDisplayable() && component.enabled && component.focusable;
    }
}

