/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import gnu.java.lang.CPStringBuilder;
import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.AWTKeyStroke;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.FocusTraversalPolicy;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.LayoutManager2;
import java.awt.LightweightDispatcher;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.peer.ComponentPeer;
import java.awt.peer.ContainerPeer;
import java.awt.peer.LightweightPeer;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.accessibility.Accessible;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Container
extends Component {
    private static final long serialVersionUID = 4613797578919906343L;
    int ncomponents;
    Component[] component;
    LayoutManager layoutMgr;
    boolean focusCycleRoot;
    private boolean focusTraversalPolicyProvider;
    int containerSerializedDataVersion;
    transient ContainerListener containerListener;
    private FocusTraversalPolicy focusTraversalPolicy;
    transient Set[] focusTraversalKeys;

    public int getComponentCount() {
        return this.countComponents();
    }

    public int countComponents() {
        return this.ncomponents;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Component getComponent(int n) {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (n < 0 || n >= this.ncomponents) {
                throw new ArrayIndexOutOfBoundsException("no such component");
            }
            return this.component[n];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Component[] getComponents() {
        Object object = this.getTreeLock();
        synchronized (object) {
            Component[] componentArray = new Component[this.ncomponents];
            if (this.ncomponents > 0) {
                System.arraycopy(this.component, 0, componentArray, 0, this.ncomponents);
            }
            return componentArray;
        }
    }

    public Insets getInsets() {
        return this.insets();
    }

    public Insets insets() {
        Insets insets = this.peer == null || this.peer instanceof LightweightPeer ? new Insets(0, 0, 0, 0) : ((ContainerPeer)this.peer).getInsets();
        return insets;
    }

    public Component add(Component component) {
        this.addImpl(component, null, -1);
        return component;
    }

    public Component add(String string, Component component) {
        this.addImpl(component, string, -1);
        return component;
    }

    public Component add(Component component, int n) {
        this.addImpl(component, null, n);
        return component;
    }

    public void add(Component component, Object object) {
        this.addImpl(component, object, -1);
    }

    public void add(Component component, Object object, int n) {
        this.addImpl(component, object, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addImpl(Component component, Object object, int n) {
        Object object2 = this.getTreeLock();
        synchronized (object2) {
            Object object3;
            int n2;
            int n3;
            if (n > this.ncomponents || n < 0 && n != -1 || component instanceof Window || component instanceof Container && ((Container)component).isAncestorOf(this)) {
                throw new IllegalArgumentException();
            }
            if (component.parent != null) {
                component.parent.remove(component);
            }
            if (this.component == null) {
                this.component = new Component[4];
            }
            if (this.ncomponents >= this.component.length) {
                n3 = this.component.length * 2;
                Component[] componentArray = new Component[n3];
                System.arraycopy(this.component, 0, componentArray, 0, this.ncomponents);
                this.component = componentArray;
            }
            if (n == -1) {
                this.component[this.ncomponents++] = component;
            } else {
                System.arraycopy(this.component, n, this.component, n + 1, this.ncomponents - n);
                this.component[n] = component;
                ++this.ncomponents;
            }
            component.parent = this;
            n3 = component.numHierarchyListeners;
            if (n3 > 0) {
                this.updateHierarchyListenerCount(32768L, n3);
            }
            if ((n2 = component.numHierarchyBoundsListeners) > 0) {
                this.updateHierarchyListenerCount(65536L, n3);
            }
            if (this.valid) {
                this.invalidate();
            }
            if (this.peer != null) {
                component.addNotify();
            }
            if (this.layoutMgr != null) {
                if (this.layoutMgr instanceof LayoutManager2) {
                    object3 = (LayoutManager2)this.layoutMgr;
                    object3.addLayoutComponent(component, object);
                } else if (object instanceof String) {
                    this.layoutMgr.addLayoutComponent((String)object, component);
                } else {
                    this.layoutMgr.addLayoutComponent("", component);
                }
            }
            if (this.containerListener != null || (this.eventMask & 2L) != 0L) {
                object3 = new ContainerEvent(this, 300, component);
                this.dispatchEvent((AWTEvent)object3);
            }
            component.fireHierarchyEvent(1400, component, this, 1L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(int n) {
        Object object = this.getTreeLock();
        synchronized (object) {
            int n2;
            int n3;
            if (n < 0 || n >= this.ncomponents) {
                throw new ArrayIndexOutOfBoundsException();
            }
            Component component = this.component[n];
            if (this.peer != null) {
                component.removeNotify();
            }
            if (this.layoutMgr != null) {
                this.layoutMgr.removeLayoutComponent(component);
            }
            if ((n3 = component.numHierarchyListeners) > 0) {
                this.updateHierarchyListenerCount(32768L, -n3);
            }
            if ((n2 = component.numHierarchyBoundsListeners) > 0) {
                this.updateHierarchyListenerCount(65536L, -n3);
            }
            component.parent = null;
            System.arraycopy(this.component, n + 1, this.component, n, this.ncomponents - n - 1);
            this.component[--this.ncomponents] = null;
            if (this.valid) {
                this.invalidate();
            }
            if (this.containerListener != null || (this.eventMask & 2L) != 0L) {
                ContainerEvent containerEvent = new ContainerEvent(this, 301, component);
                this.dispatchEvent(containerEvent);
            }
            component.fireHierarchyEvent(1400, component, this, 1L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Component component) {
        Object object = this.getTreeLock();
        synchronized (object) {
            for (int i = 0; i < this.ncomponents; ++i) {
                if (this.component[i] != component) continue;
                this.remove(i);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll() {
        Object object = this.getTreeLock();
        synchronized (object) {
            while (this.ncomponents > 0) {
                int n;
                int n2;
                --this.ncomponents;
                Component component = this.component[this.ncomponents];
                this.component[this.ncomponents] = null;
                if (this.peer != null) {
                    component.removeNotify();
                }
                if (this.layoutMgr != null) {
                    this.layoutMgr.removeLayoutComponent(component);
                }
                component.parent = null;
                if (this.containerListener != null || (this.eventMask & 2L) != 0L) {
                    ContainerEvent containerEvent = new ContainerEvent(this, 301, component);
                    this.dispatchEvent(containerEvent);
                }
                if ((n2 = component.numHierarchyListeners) > 0) {
                    this.updateHierarchyListenerCount(32768L, -n2);
                }
                if ((n = component.numHierarchyBoundsListeners) > 0) {
                    this.updateHierarchyListenerCount(65536L, -n2);
                }
                this.fireHierarchyEvent(1400, component, this, 1L);
            }
            if (this.valid) {
                this.invalidate();
            }
        }
    }

    public LayoutManager getLayout() {
        return this.layoutMgr;
    }

    public void setLayout(LayoutManager layoutManager) {
        this.layoutMgr = layoutManager;
        if (this.valid) {
            this.invalidate();
        }
    }

    @Override
    public void doLayout() {
        this.layout();
    }

    @Override
    public void layout() {
        if (this.layoutMgr != null) {
            this.layoutMgr.layoutContainer(this);
        }
    }

    @Override
    public void invalidate() {
        super.invalidate();
        if (this.layoutMgr != null && this.layoutMgr instanceof LayoutManager2) {
            LayoutManager2 layoutManager2 = (LayoutManager2)this.layoutMgr;
            layoutManager2.invalidateLayout(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void validate() {
        ComponentPeer componentPeer = this.peer;
        if (!this.valid && componentPeer != null) {
            ContainerPeer containerPeer = null;
            if (componentPeer instanceof ContainerPeer) {
                containerPeer = (ContainerPeer)this.peer;
            }
            Object object = this.getTreeLock();
            synchronized (object) {
                if (containerPeer != null) {
                    containerPeer.beginValidate();
                }
                this.validateTree();
                this.valid = true;
                if (containerPeer != null) {
                    containerPeer.endValidate();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void invalidateTree() {
        Object object = this.getTreeLock();
        synchronized (object) {
            for (int i = 0; i < this.ncomponents; ++i) {
                Component component = this.component[i];
                if (component instanceof Container) {
                    ((Container)component).invalidateTree();
                    continue;
                }
                if (!component.valid) continue;
                component.invalidate();
            }
            if (this.valid) {
                this.invalidate();
            }
        }
    }

    protected void validateTree() {
        if (!this.valid) {
            ContainerPeer containerPeer = null;
            if (this.peer instanceof ContainerPeer) {
                containerPeer = (ContainerPeer)this.peer;
                containerPeer.beginLayout();
            }
            this.doLayout();
            for (int i = 0; i < this.ncomponents; ++i) {
                Component component = this.component[i];
                if (component instanceof Container && !(component instanceof Window) && !component.valid) {
                    ((Container)component).validateTree();
                    continue;
                }
                component.validate();
            }
            if (containerPeer != null) {
                containerPeer = (ContainerPeer)this.peer;
                containerPeer.endLayout();
            }
        }
        this.valid = true;
    }

    @Override
    public void setFont(Font font) {
        Font font2 = this.getFont();
        super.setFont(font);
        Font font3 = this.getFont();
        if (!(font3 == font2 || font2 != null && font2.equals(font3))) {
            this.invalidateTree();
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return this.preferredSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension preferredSize() {
        Dimension dimension = this.prefSize;
        if (dimension == null || !this.prefSizeSet && !this.valid) {
            Object object = this.getTreeLock();
            synchronized (object) {
                LayoutManager layoutManager = this.layoutMgr;
                this.prefSize = layoutManager != null ? layoutManager.preferredLayoutSize(this) : super.preferredSizeImpl();
                dimension = this.prefSize;
            }
        }
        if (dimension != null) {
            return new Dimension(dimension);
        }
        return dimension;
    }

    @Override
    public Dimension getMinimumSize() {
        return this.minimumSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension minimumSize() {
        Dimension dimension = this.minSize;
        if (dimension == null || !this.minSizeSet && !this.valid) {
            Object object = this.getTreeLock();
            synchronized (object) {
                LayoutManager layoutManager = this.layoutMgr;
                this.minSize = layoutManager != null ? layoutManager.minimumLayoutSize(this) : super.minimumSizeImpl();
                dimension = this.minSize;
            }
        }
        if (dimension != null) {
            return new Dimension(dimension);
        }
        return dimension;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension getMaximumSize() {
        Dimension dimension = this.maxSize;
        if (dimension == null || !this.maxSizeSet && !this.valid) {
            Object object = this.getTreeLock();
            synchronized (object) {
                LayoutManager layoutManager = this.layoutMgr;
                this.maxSize = layoutManager instanceof LayoutManager2 ? ((LayoutManager2)layoutManager).maximumLayoutSize(this) : super.maximumSizeImpl();
                dimension = this.maxSize;
            }
        }
        if (dimension != null) {
            return new Dimension(dimension);
        }
        return dimension;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public float getAlignmentX() {
        LayoutManager layoutManager = this.getLayout();
        float f = 0.0f;
        if (layoutManager != null && layoutManager instanceof LayoutManager2) {
            Object object = this.getTreeLock();
            synchronized (object) {
                LayoutManager2 layoutManager2 = (LayoutManager2)layoutManager;
                f = layoutManager2.getLayoutAlignmentX(this);
            }
        } else {
            f = super.getAlignmentX();
        }
        return f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public float getAlignmentY() {
        LayoutManager layoutManager = this.getLayout();
        float f = 0.0f;
        if (layoutManager != null && layoutManager instanceof LayoutManager2) {
            Object object = this.getTreeLock();
            synchronized (object) {
                LayoutManager2 layoutManager2 = (LayoutManager2)layoutManager;
                f = layoutManager2.getLayoutAlignmentY(this);
            }
        } else {
            f = super.getAlignmentY();
        }
        return f;
    }

    @Override
    public void paint(Graphics graphics) {
        if (this.isShowing()) {
            this.visitChildren(graphics, GfxPaintVisitor.INSTANCE, true);
        }
    }

    @Override
    public void update(Graphics graphics) {
        if (this.isShowing()) {
            ComponentPeer componentPeer = this.peer;
            if (!(componentPeer instanceof LightweightPeer)) {
                graphics.clearRect(0, 0, this.getWidth(), this.getHeight());
            }
            this.paint(graphics);
        }
    }

    @Override
    public void print(Graphics graphics) {
        super.print(graphics);
        this.visitChildren(graphics, GfxPrintVisitor.INSTANCE, true);
    }

    public void paintComponents(Graphics graphics) {
        if (this.isShowing()) {
            this.visitChildren(graphics, GfxPaintAllVisitor.INSTANCE, false);
        }
    }

    public void printComponents(Graphics graphics) {
        super.paint(graphics);
        this.visitChildren(graphics, GfxPrintAllVisitor.INSTANCE, true);
    }

    public synchronized void addContainerListener(ContainerListener containerListener) {
        if (containerListener != null) {
            this.containerListener = AWTEventMulticaster.add(this.containerListener, containerListener);
            this.newEventsOnly = true;
        }
    }

    public synchronized void removeContainerListener(ContainerListener containerListener) {
        this.containerListener = AWTEventMulticaster.remove(this.containerListener, containerListener);
    }

    public synchronized ContainerListener[] getContainerListeners() {
        return (ContainerListener[])AWTEventMulticaster.getListeners((EventListener)this.containerListener, ContainerListener.class);
    }

    @Override
    public <T extends EventListener> T[] getListeners(Class<T> clazz) {
        if (clazz == ContainerListener.class) {
            return this.getContainerListeners();
        }
        return super.getListeners(clazz);
    }

    @Override
    protected void processEvent(AWTEvent aWTEvent) {
        if (aWTEvent instanceof ContainerEvent) {
            this.processContainerEvent((ContainerEvent)aWTEvent);
        } else {
            super.processEvent(aWTEvent);
        }
    }

    protected void processContainerEvent(ContainerEvent containerEvent) {
        if (this.containerListener == null) {
            return;
        }
        switch (containerEvent.id) {
            case 300: {
                this.containerListener.componentAdded(containerEvent);
                break;
            }
            case 301: {
                this.containerListener.componentRemoved(containerEvent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deliverEvent(Event event) {
        if (!this.handleEvent(event)) {
            Object object = this.getTreeLock();
            synchronized (object) {
                Container container = this.getParent();
                if (container != null) {
                    ((Component)container).deliverEvent(event);
                }
            }
        }
    }

    @Override
    public Component getComponentAt(int n, int n2) {
        return this.locate(n, n2);
    }

    public Point getMousePosition(boolean bl) throws HeadlessException {
        return super.getMousePositionHelper(bl);
    }

    @Override
    boolean mouseOverComponent(Component component, boolean bl) {
        if (bl) {
            return this.isAncestorOf(component);
        }
        return component == this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Component locate(int n, int n2) {
        Object object = this.getTreeLock();
        synchronized (object) {
            int n3;
            int n4;
            Component component;
            int n5;
            if (!this.contains(n, n2)) {
                return null;
            }
            for (n5 = 0; n5 < this.ncomponents; ++n5) {
                component = this.component[n5];
                n4 = n - component.x;
                n3 = n2 - component.y;
                if (!component.contains(n4, n3) || component.isLightweight()) continue;
                return component;
            }
            for (n5 = 0; n5 < this.ncomponents; ++n5) {
                component = this.component[n5];
                n4 = n - component.x;
                n3 = n2 - component.y;
                if (!component.contains(n4, n3) || !component.isLightweight()) continue;
                return component;
            }
            return this;
        }
    }

    @Override
    public Component getComponentAt(Point point) {
        return this.getComponentAt(point.x, point.y);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Component findComponentAt(int n, int n2) {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (!this.contains(n, n2)) {
                return null;
            }
            for (int i = 0; i < this.ncomponents; ++i) {
                if (!this.component[i].isVisible()) continue;
                int n3 = n - this.component[i].x;
                int n4 = n2 - this.component[i].y;
                if (this.component[i] instanceof Container) {
                    Container container = (Container)this.component[i];
                    Component component = container.findComponentAt(n3, n4);
                    if (component == null) continue;
                    return component;
                }
                if (!this.component[i].contains(n3, n4)) continue;
                return this.component[i];
            }
            return this;
        }
    }

    public Component findComponentAt(Point point) {
        return this.findComponentAt(point.x, point.y);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addNotify() {
        Object object = this.getTreeLock();
        synchronized (object) {
            super.addNotify();
            this.addNotifyContainerChildren();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeNotify() {
        Object object = this.getTreeLock();
        synchronized (object) {
            int n = this.ncomponents;
            Component[] componentArray = this.component;
            for (int i = n - 1; i >= 0; --i) {
                Component component = componentArray[i];
                if (component == null) continue;
                component.removeNotify();
            }
            super.removeNotify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAncestorOf(Component component) {
        Object object = this.getTreeLock();
        synchronized (object) {
            do {
                if (component != null) continue;
                return false;
            } while ((component = component.getParent()) != this);
            return true;
        }
    }

    @Override
    protected String paramString() {
        if (this.layoutMgr == null) {
            return super.paramString();
        }
        CPStringBuilder cPStringBuilder = new CPStringBuilder();
        cPStringBuilder.append(super.paramString());
        cPStringBuilder.append(",layout=");
        cPStringBuilder.append(this.layoutMgr.getClass().getName());
        return cPStringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void list(PrintStream printStream, int n) {
        Object object = this.getTreeLock();
        synchronized (object) {
            super.list(printStream, n);
            for (int i = 0; i < this.ncomponents; ++i) {
                this.component[i].list(printStream, n + 2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void list(PrintWriter printWriter, int n) {
        Object object = this.getTreeLock();
        synchronized (object) {
            super.list(printWriter, n);
            for (int i = 0; i < this.ncomponents; ++i) {
                this.component[i].list(printWriter, n + 2);
            }
        }
    }

    @Override
    public void setFocusTraversalKeys(int n, Set<? extends AWTKeyStroke> set) {
        String string;
        Set<AWTKeyStroke> set2;
        Set<AWTKeyStroke> set3;
        Object object;
        if (n != 0 && n != 1 && n != 2 && n != 3) {
            throw new IllegalArgumentException();
        }
        if (set == null) {
            for (object = this.getParent(); object != null; object = ((Component)object).getParent()) {
                if (!((Container)object).areFocusTraversalKeysSet(n)) continue;
                set = ((Container)object).getFocusTraversalKeys(n);
                break;
            }
            if (set == null) {
                set = KeyboardFocusManager.getCurrentKeyboardFocusManager().getDefaultFocusTraversalKeys(n);
            }
        }
        switch (n) {
            case 0: {
                object = this.getFocusTraversalKeys(1);
                set3 = this.getFocusTraversalKeys(2);
                set2 = this.getFocusTraversalKeys(3);
                string = "forwardFocusTraversalKeys";
                break;
            }
            case 1: {
                object = this.getFocusTraversalKeys(0);
                set3 = this.getFocusTraversalKeys(2);
                set2 = this.getFocusTraversalKeys(3);
                string = "backwardFocusTraversalKeys";
                break;
            }
            case 2: {
                object = this.getFocusTraversalKeys(0);
                set3 = this.getFocusTraversalKeys(1);
                set2 = this.getFocusTraversalKeys(3);
                string = "upCycleFocusTraversalKeys";
                break;
            }
            case 3: {
                object = this.getFocusTraversalKeys(0);
                set3 = this.getFocusTraversalKeys(1);
                set2 = this.getFocusTraversalKeys(2);
                string = "downCycleFocusTraversalKeys";
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        int n2 = set.size();
        Iterator<? extends AWTKeyStroke> iterator = set.iterator();
        while (--n2 >= 0) {
            AWTKeyStroke aWTKeyStroke = iterator.next();
            if (aWTKeyStroke instanceof AWTKeyStroke && !object.contains(aWTKeyStroke) && !set3.contains(aWTKeyStroke) && !set2.contains(aWTKeyStroke) && aWTKeyStroke.keyCode != 0) continue;
            throw new IllegalArgumentException();
        }
        if (this.focusTraversalKeys == null) {
            this.focusTraversalKeys = new Set[4];
        }
        set = Collections.unmodifiableSet(new HashSet<AWTKeyStroke>(set));
        this.firePropertyChange(string, this.focusTraversalKeys[n], set);
        this.focusTraversalKeys[n] = set;
    }

    @Override
    public Set<AWTKeyStroke> getFocusTraversalKeys(int n) {
        if (n != 0 && n != 1 && n != 2 && n != 3) {
            throw new IllegalArgumentException();
        }
        Set<AWTKeyStroke> set = null;
        if (this.focusTraversalKeys != null) {
            set = this.focusTraversalKeys[n];
        }
        if (set == null && this.parent != null) {
            set = this.parent.getFocusTraversalKeys(n);
        }
        return set == null ? KeyboardFocusManager.getCurrentKeyboardFocusManager().getDefaultFocusTraversalKeys(n) : set;
    }

    @Override
    public boolean areFocusTraversalKeysSet(int n) {
        if (n != 0 && n != 1 && n != 2 && n != 3) {
            throw new IllegalArgumentException();
        }
        return this.focusTraversalKeys != null && this.focusTraversalKeys[n] != null;
    }

    @Override
    public boolean isFocusCycleRoot(Container container) {
        if (this == container && this.isFocusCycleRoot()) {
            return true;
        }
        Container container2 = this.getFocusCycleRootAncestor();
        return container == container2;
    }

    public void setFocusTraversalPolicy(FocusTraversalPolicy focusTraversalPolicy) {
        this.focusTraversalPolicy = focusTraversalPolicy;
    }

    public FocusTraversalPolicy getFocusTraversalPolicy() {
        if (!this.isFocusCycleRoot()) {
            return null;
        }
        if (this.focusTraversalPolicy == null) {
            Container container = this.getFocusCycleRootAncestor();
            if (container != this && container != null) {
                return container.getFocusTraversalPolicy();
            }
            KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            return keyboardFocusManager.getDefaultFocusTraversalPolicy();
        }
        return this.focusTraversalPolicy;
    }

    public boolean isFocusTraversalPolicySet() {
        return this.focusTraversalPolicy == null;
    }

    public void setFocusCycleRoot(boolean bl) {
        this.focusCycleRoot = bl;
    }

    public final boolean isFocusTraversalPolicyProvider() {
        return this.focusTraversalPolicyProvider;
    }

    public final void setFocusTraversalPolicyProvider(boolean bl) {
        this.focusTraversalPolicyProvider = bl;
    }

    public boolean isFocusCycleRoot() {
        return this.focusCycleRoot;
    }

    public void transferFocusDownCycle() {
        if (this.isFocusCycleRoot()) {
            KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            keyboardFocusManager.setGlobalCurrentFocusCycleRoot(this);
            FocusTraversalPolicy focusTraversalPolicy = this.getFocusTraversalPolicy();
            Component component = focusTraversalPolicy.getDefaultComponent(this);
            if (component != null) {
                component.requestFocus();
            }
        }
    }

    @Override
    public void applyComponentOrientation(ComponentOrientation componentOrientation) {
        if (componentOrientation == null) {
            throw new NullPointerException();
        }
        this.setComponentOrientation(componentOrientation);
        for (int i = 0; i < this.ncomponents; ++i) {
            if (this.component[i] instanceof Container) {
                ((Container)this.component[i]).applyComponentOrientation(componentOrientation);
                continue;
            }
            this.component[i].setComponentOrientation(componentOrientation);
        }
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        super.addPropertyChangeListener(propertyChangeListener);
    }

    @Override
    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        super.addPropertyChangeListener(string, propertyChangeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setComponentZOrder(Component component, int n) {
        if (component == null) {
            throw new NullPointerException("comp must not be null");
        }
        if (component instanceof Container && ((Container)component).isAncestorOf(this)) {
            throw new IllegalArgumentException("comp must not be an ancestor of this");
        }
        if (component instanceof Window) {
            throw new IllegalArgumentException("comp must not be a Window");
        }
        if (component == this) {
            throw new IllegalArgumentException("cannot add component to itself");
        }
        Object object = this.getTreeLock();
        synchronized (object) {
            if (component.getParent() != this) {
                throw new AssertionError((Object)"Reparenting is not implemented yet");
            }
            int n2 = this.getComponentZOrder(component);
            if (n2 < n) {
                System.arraycopy(this.component, n2 + 1, this.component, n2, n - n2);
            } else {
                System.arraycopy(this.component, n, this.component, n + 1, n2 - n);
            }
            this.component[n] = component;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getComponentZOrder(Component component) {
        Object object = this.getTreeLock();
        synchronized (object) {
            int n = -1;
            if (this.component != null) {
                for (int i = 0; i < this.ncomponents; ++i) {
                    if (this.component[i] != component) continue;
                    n = i;
                    break;
                }
            }
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void visitChildren(Graphics graphics, GfxVisitor gfxVisitor, boolean bl) {
        Object object = this.getTreeLock();
        synchronized (object) {
            for (int i = this.ncomponents - 1; i >= 0; --i) {
                boolean bl2;
                Component component = this.component[i];
                boolean bl3 = bl2 = component.isVisible() && (component.isLightweight() || !bl);
                if (!bl2) continue;
                this.visitChild(graphics, gfxVisitor, component);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void visitChild(Graphics graphics, GfxVisitor gfxVisitor, Component component) {
        Rectangle rectangle = component.getBounds();
        if (!graphics.hitClip(rectangle.x, rectangle.y, rectangle.width, rectangle.height)) {
            return;
        }
        Graphics graphics2 = graphics.create(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        try {
            graphics2.setFont(component.getFont());
            gfxVisitor.visit(component, graphics2);
            Object var7_6 = null;
            graphics2.dispose();
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            graphics2.dispose();
            throw throwable;
        }
    }

    @Override
    void dispatchEventImpl(AWTEvent aWTEvent) {
        LightweightDispatcher lightweightDispatcher = LightweightDispatcher.getInstance();
        if (!this.isLightweight() && lightweightDispatcher.dispatchEvent(aWTEvent)) {
            aWTEvent.consume();
            ComponentPeer componentPeer = this.peer;
            if (componentPeer != null) {
                componentPeer.handleEvent(aWTEvent);
            }
        } else {
            super.dispatchEventImpl(aWTEvent);
        }
    }

    void dispatchNoLightweight(AWTEvent aWTEvent) {
        super.dispatchEventImpl(aWTEvent);
    }

    @Override
    boolean eventTypeEnabled(int n) {
        if (n <= 301 && n >= 300) {
            return this.containerListener != null || (this.eventMask & 2L) != 0L;
        }
        return super.eventTypeEnabled(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    Component findNextFocusComponent(Component component) {
        Object object = this.getTreeLock();
        synchronized (object) {
            int n;
            int n2;
            if (component != null) {
                for (n2 = 0; n2 < this.ncomponents && this.component[n2] != component; ++n2) {
                }
                n = n2;
                if (n == 0) {
                    n = this.ncomponents;
                }
                ++n2;
            } else {
                n2 = 0;
                n = this.ncomponents;
            }
            for (int i = n2; i != n; ++i) {
                if (i >= this.ncomponents) {
                    if (this.parent != null) {
                        return this.parent.findNextFocusComponent(this);
                    }
                    i -= this.ncomponents;
                }
                if (this.component[i] instanceof Container) {
                    Component component2 = this.component[i];
                    if ((component2 = component2.findNextFocusComponent(null)) == null) continue;
                    return component2;
                }
                if (!this.component[i].isFocusTraversable()) continue;
                return this.component[i];
            }
            return null;
        }
    }

    @Override
    void fireHierarchyEvent(int n, Component component, Container container, long l) {
        if (n == 1400 && this.numHierarchyListeners > 0 || (n == 1401 || n == 1402) && this.numHierarchyBoundsListeners > 0) {
            for (int i = 0; i < this.ncomponents; ++i) {
                this.component[i].fireHierarchyEvent(n, component, container, l);
            }
            super.fireHierarchyEvent(n, component, container, l);
        }
    }

    void updateHierarchyListenerCount(long l, int n) {
        if (l == 65536L) {
            this.numHierarchyBoundsListeners += n;
        } else if (l == 32768L) {
            this.numHierarchyListeners += n;
        } else assert (false) : "Should not reach here";
        if (this.parent != null) {
            this.parent.updateHierarchyListenerCount(l, n);
        }
    }

    @Override
    void notifyReshape(boolean bl, boolean bl2) {
        super.notifyReshape(bl, bl2);
        if (this.ncomponents > 0) {
            Component component;
            int n;
            if (bl) {
                for (n = 0; n < this.getComponentCount(); ++n) {
                    component = this.getComponent(n);
                    component.fireHierarchyEvent(1402, this, this.parent, 0L);
                }
            }
            if (bl2) {
                for (n = 0; n < this.getComponentCount(); ++n) {
                    component = this.getComponent(n);
                    component.fireHierarchyEvent(1401, this, this.parent, 0L);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addNotifyContainerChildren() {
        Object object = this.getTreeLock();
        synchronized (object) {
            int n = this.ncomponents;
            while (--n >= 0) {
                this.component[n].addNotify();
            }
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        String string = (String)objectInputStream.readObject();
        while (string != null) {
            Object object = objectInputStream.readObject();
            if ("containerL".equals(string)) {
                this.addContainerListener((ContainerListener)object);
            } else if ("focusTraversalPolicy".equals(string)) {
                this.setFocusTraversalPolicy((FocusTraversalPolicy)object);
            }
            string = (String)objectInputStream.readObject();
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        AWTEventMulticaster.save(objectOutputStream, "containerL", this.containerListener);
        if (this.focusTraversalPolicy instanceof Serializable) {
            objectOutputStream.writeObject(this.focusTraversalPolicy);
        } else {
            objectOutputStream.writeObject(null);
        }
    }

    protected class AccessibleAWTContainer
    extends Component.AccessibleAWTComponent {
        private static final long serialVersionUID = 5081320404842566097L;
        protected ContainerListener accessibleContainerHandler = new AccessibleContainerHandler();

        protected AccessibleAWTContainer() {
            Container.this.addContainerListener(this.accessibleContainerHandler);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getAccessibleChildrenCount() {
            Object object = Container.this.getTreeLock();
            synchronized (object) {
                int n;
                int n2 = 0;
                int n3 = n = Container.this.component == null ? 0 : Container.this.component.length;
                while (--n >= 0) {
                    if (!(Container.this.component[n] instanceof Accessible)) continue;
                    ++n2;
                }
                return n2;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Accessible getAccessibleChild(int n) {
            Object object = Container.this.getTreeLock();
            synchronized (object) {
                if (Container.this.component == null) {
                    return null;
                }
                int n2 = -1;
                while (n >= 0 && ++n2 < Container.this.component.length) {
                    if (!(Container.this.component[n2] instanceof Accessible)) continue;
                    --n;
                }
                if (n < 0) {
                    return (Accessible)((Object)Container.this.component[n2]);
                }
                return null;
            }
        }

        public Accessible getAccessibleAt(Point point) {
            Component component = Container.this.getComponentAt(point.x, point.y);
            return component != Container.this && component instanceof Accessible ? (Accessible)((Object)component) : null;
        }

        protected class AccessibleContainerHandler
        implements ContainerListener {
            protected AccessibleContainerHandler() {
            }

            public void componentAdded(ContainerEvent containerEvent) {
                AccessibleAWTContainer.this.firePropertyChange("AccessibleChild", null, containerEvent.getChild());
            }

            public void componentRemoved(ContainerEvent containerEvent) {
                AccessibleAWTContainer.this.firePropertyChange("AccessibleChild", containerEvent.getChild(), null);
            }
        }
    }

    static class GfxPrintAllVisitor
    extends GfxVisitor {
        public static final GfxVisitor INSTANCE = new GfxPrintAllVisitor();

        GfxPrintAllVisitor() {
        }

        public void visit(Component component, Graphics graphics) {
            component.printAll(graphics);
        }
    }

    static class GfxPaintAllVisitor
    extends GfxVisitor {
        public static final GfxVisitor INSTANCE = new GfxPaintAllVisitor();

        GfxPaintAllVisitor() {
        }

        public void visit(Component component, Graphics graphics) {
            component.paintAll(graphics);
        }
    }

    static class GfxPrintVisitor
    extends GfxVisitor {
        public static final GfxVisitor INSTANCE = new GfxPrintVisitor();

        GfxPrintVisitor() {
        }

        public void visit(Component component, Graphics graphics) {
            component.print(graphics);
        }
    }

    static class GfxPaintVisitor
    extends GfxVisitor {
        public static final GfxVisitor INSTANCE = new GfxPaintVisitor();

        GfxPaintVisitor() {
        }

        public void visit(Component component, Graphics graphics) {
            component.paint(graphics);
        }
    }

    static abstract class GfxVisitor {
        GfxVisitor() {
        }

        public abstract void visit(Component var1, Graphics var2);
    }
}

