/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTException;
import java.awt.BufferCapabilities;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.ImageCapabilities;
import java.awt.image.BufferStrategy;
import java.io.Serializable;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;

public class Canvas
extends Component
implements Serializable,
Accessible {
    private static final long serialVersionUID = -2284879212465893870L;
    private static transient long next_canvas_number;
    transient BufferStrategy bufferStrategy;

    public Canvas() {
    }

    public Canvas(GraphicsConfiguration graphicsConfiguration) {
        this.graphicsConfig = graphicsConfiguration;
    }

    public void addNotify() {
        if (this.peer == null) {
            this.peer = this.getToolkit().createCanvas(this);
        }
        super.addNotify();
    }

    public void paint(Graphics graphics) {
        graphics.setColor(this.getBackground());
        Dimension dimension = this.getSize();
        graphics.fillRect(0, 0, dimension.width, dimension.height);
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleAWTCanvas();
        }
        return this.accessibleContext;
    }

    public void createBufferStrategy(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("Canvas.createBufferStrategy: number of buffers is less than one");
        }
        if (!this.isDisplayable()) {
            throw new IllegalStateException("Canvas.createBufferStrategy: canvas is not displayable");
        }
        BufferStrategy bufferStrategy = null;
        try {
            bufferStrategy = new CanvasFlipBufferStrategy(n);
        }
        catch (AWTException aWTException) {
            // empty catch block
        }
        if (bufferStrategy == null) {
            bufferStrategy = new CanvasBltBufferStrategy(n, true);
        }
        this.bufferStrategy = bufferStrategy;
    }

    public void createBufferStrategy(int n, BufferCapabilities bufferCapabilities) throws AWTException {
        if (n < 1) {
            throw new IllegalArgumentException("Canvas.createBufferStrategy: number of buffers is less than one");
        }
        if (bufferCapabilities == null) {
            throw new IllegalArgumentException("Canvas.createBufferStrategy: capabilities object is null");
        }
        this.bufferStrategy = bufferCapabilities.isPageFlipping() ? new CanvasFlipBufferStrategy(n) : new CanvasBltBufferStrategy(n, true);
    }

    public BufferStrategy getBufferStrategy() {
        return this.bufferStrategy;
    }

    public void update(Graphics graphics) {
        Dimension dimension = this.getSize();
        graphics.clearRect(0, 0, dimension.width, dimension.height);
        this.paint(graphics);
    }

    String generateName() {
        return "canvas" + Canvas.getUniqueLong();
    }

    private static synchronized long getUniqueLong() {
        return next_canvas_number++;
    }

    private class CanvasFlipBufferStrategy
    extends Component.FlipBufferStrategy {
        CanvasFlipBufferStrategy(int n) throws AWTException {
            super(n, new BufferCapabilities(new ImageCapabilities(true), new ImageCapabilities(true), BufferCapabilities.FlipContents.COPIED));
        }
    }

    private class CanvasBltBufferStrategy
    extends Component.BltBufferStrategy {
        CanvasBltBufferStrategy(int n, boolean bl) {
            super(n, new BufferCapabilities(new ImageCapabilities(bl), new ImageCapabilities(bl), BufferCapabilities.FlipContents.COPIED));
        }
    }

    protected class AccessibleAWTCanvas
    extends Component.AccessibleAWTComponent {
        private static final long serialVersionUID = -6325592262103146699L;

        protected AccessibleAWTCanvas() {
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.CANVAS;
        }
    }
}

