/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.xpath;

import gnu.java.lang.CPStringBuilder;
import gnu.xml.xpath.Expr;
import gnu.xml.xpath.Path;
import gnu.xml.xpath.Pattern;
import gnu.xml.xpath.Root;
import gnu.xml.xpath.Selector;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import javax.xml.namespace.QName;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Steps
extends Path {
    final LinkedList<Expr> path;

    public Steps() {
        this(new LinkedList<Expr>());
    }

    Steps(LinkedList<Expr> linkedList) {
        this.path = linkedList;
    }

    @Override
    public boolean matches(Node node2) {
        return this.matches(node2, this.path.size() - 1);
    }

    boolean matches(Node node2, int n) {
        Pattern pattern2 = (Pattern)this.path.get(n);
        if (!pattern2.matches(node2)) {
            return false;
        }
        if (n > 0) {
            Pattern pattern3 = (Pattern)this.path.get(n - 1);
            for (Node node3 : this.possibleContexts(pattern2, node2)) {
                if (!pattern3.matches(node3) || !this.matches(node3, n - 1)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    Collection<Node> possibleContexts(Pattern pattern2, Node node2) {
        if (pattern2 instanceof Selector) {
            Selector selector = (Selector)pattern2;
            LinkedHashSet<Node> linkedHashSet = new LinkedHashSet<Node>();
            switch (selector.axis) {
                case 9: {
                    selector.addChildNodes(node2, linkedHashSet, false);
                    break;
                }
                case 0: {
                    selector.addChildNodes(node2, linkedHashSet, true);
                    break;
                }
                case 1: {
                    linkedHashSet.add(node2);
                    selector.addChildNodes(node2, linkedHashSet, true);
                    break;
                }
                case 3: {
                    selector.addParentNode(node2, linkedHashSet, false);
                    break;
                }
                case 4: {
                    selector.addParentNode(node2, linkedHashSet, true);
                    break;
                }
                case 5: {
                    linkedHashSet.add(node2);
                    selector.addParentNode(node2, linkedHashSet, true);
                    break;
                }
                case 11: {
                    selector.addFollowingNodes(node2, linkedHashSet, false);
                    break;
                }
                case 7: {
                    selector.addPrecedingNodes(node2, linkedHashSet, false);
                    break;
                }
                case 10: {
                    selector.addFollowingNodes(node2, linkedHashSet, true);
                    break;
                }
                case 6: {
                    selector.addPrecedingNodes(node2, linkedHashSet, true);
                    break;
                }
                case 2: 
                case 8: {
                    if (node2.getNodeType() != 2) break;
                    linkedHashSet.add(((Attr)node2).getOwnerElement());
                    break;
                }
                case 12: {
                    linkedHashSet.add(node2);
                }
            }
            return linkedHashSet;
        }
        return Collections.emptySet();
    }

    @Override
    public Object evaluate(Node node2, int n, int n2) {
        Iterator iterator = this.path.iterator();
        Expr expr = (Expr)iterator.next();
        Collection<Node> collection = expr.evaluate(node2, n, n2);
        while (collection instanceof Collection && iterator.hasNext()) {
            Path path = (Path)iterator.next();
            Collection collection2 = collection;
            collection = path.evaluate(node2, collection2);
        }
        return collection;
    }

    @Override
    Collection<Node> evaluate(Node node2, Collection<Node> collection) {
        Object object;
        Iterator iterator = this.path.iterator();
        Expr expr = (Expr)iterator.next();
        if (expr instanceof Path) {
            collection = ((Path)expr).evaluate(node2, collection);
        } else {
            object = new LinkedHashSet();
            int n = 1;
            int n2 = collection.size();
            for (Node node3 : collection) {
                Object object2 = expr.evaluate(node3, n++, n2);
                if (!(object2 instanceof Collection)) continue;
                Collection collection2 = (Collection)object2;
                object.addAll(collection2);
            }
            collection = object;
        }
        while (iterator.hasNext()) {
            object = (Path)iterator.next();
            collection = ((Path)object).evaluate(node2, collection);
        }
        return collection;
    }

    @Override
    public Expr clone(Object object) {
        int n = this.path.size();
        LinkedList<Expr> linkedList = new LinkedList<Expr>();
        for (int i = 0; i < n; ++i) {
            linkedList.add(this.path.get(i).clone(object));
        }
        return new Steps(linkedList);
    }

    @Override
    public boolean references(QName qName) {
        Iterator iterator = this.path.iterator();
        while (iterator.hasNext()) {
            if (!((Expr)iterator.next()).references(qName)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        CPStringBuilder cPStringBuilder = new CPStringBuilder();
        Iterator iterator = this.path.iterator();
        Expr expr = (Expr)iterator.next();
        if (!(expr instanceof Root)) {
            cPStringBuilder.append(expr);
        }
        while (iterator.hasNext()) {
            expr = (Expr)iterator.next();
            cPStringBuilder.append('/');
            cPStringBuilder.append(expr);
        }
        return cPStringBuilder.toString();
    }
}

