/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.xpath;

import gnu.java.lang.CPStringBuilder;
import gnu.xml.xpath.Expr;
import gnu.xml.xpath.Function;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPathFunction;
import javax.xml.xpath.XPathFunctionException;
import javax.xml.xpath.XPathFunctionResolver;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FunctionCall
extends Expr {
    final XPathFunctionResolver resolver;
    final String name;
    final List<Expr> args;

    public FunctionCall(XPathFunctionResolver xPathFunctionResolver, String string) {
        this(xPathFunctionResolver, string, null);
    }

    public FunctionCall(XPathFunctionResolver xPathFunctionResolver, String string, List<Expr> list2) {
        this.resolver = xPathFunctionResolver;
        this.name = string;
        this.args = list2 == null ? Collections.emptyList() : list2;
    }

    @Override
    public Object evaluate(Node node2, int n, int n2) {
        int n3;
        QName qName;
        XPathFunction xPathFunction;
        if (this.resolver != null && (xPathFunction = this.resolver.resolveFunction(qName = QName.valueOf(this.name), n3 = this.args.size())) != null) {
            if (xPathFunction instanceof Expr) {
                if (xPathFunction instanceof Function) {
                    ((Function)((Object)xPathFunction)).setArguments(this.args);
                }
                return ((Expr)((Object)xPathFunction)).evaluate(node2, n, n2);
            }
            ArrayList<Object> arrayList = new ArrayList<Object>(n3);
            for (int i = 0; i < n3; ++i) {
                Expr expr = this.args.get(i);
                arrayList.add(expr.evaluate(node2, n, n2));
            }
            try {
                return xPathFunction.evaluate(arrayList);
            }
            catch (XPathFunctionException xPathFunctionException) {
                xPathFunctionException.printStackTrace(System.err);
                throw new RuntimeException(xPathFunctionException.getMessage(), xPathFunctionException);
            }
        }
        throw new IllegalArgumentException("Invalid function call: " + this.toString());
    }

    @Override
    public Expr clone(Object object) {
        int n = this.args.size();
        ArrayList<Expr> arrayList = new ArrayList<Expr>(n);
        for (int i = 0; i < n; ++i) {
            arrayList.add(this.args.get(i).clone(object));
        }
        XPathFunctionResolver xPathFunctionResolver = this.resolver;
        if (object instanceof XPathFunctionResolver) {
            xPathFunctionResolver = (XPathFunctionResolver)object;
        }
        return new FunctionCall(xPathFunctionResolver, this.name, arrayList);
    }

    @Override
    public boolean references(QName qName) {
        Iterator<Expr> iterator = this.args.iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().references(qName)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        CPStringBuilder cPStringBuilder = new CPStringBuilder();
        cPStringBuilder.append(this.name);
        cPStringBuilder.append('(');
        int n = this.args.size();
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                cPStringBuilder.append(',');
            }
            cPStringBuilder.append(this.args.get(i));
        }
        cPStringBuilder.append(')');
        return cPStringBuilder.toString();
    }
}

