/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.xpath;

import gnu.xml.xpath.Expr;
import java.util.Collection;
import javax.xml.namespace.QName;
import org.w3c.dom.Node;

final class EqualityExpr
extends Expr {
    final Expr lhs;
    final Expr rhs;
    final boolean invert;

    EqualityExpr(Expr expr, Expr expr2, boolean bl) {
        this.lhs = expr;
        this.rhs = expr2;
        this.invert = bl;
    }

    public Object evaluate(Node node2, int n, int n2) {
        boolean bl = this.evaluateImpl(node2, n, n2);
        if (this.invert) {
            return bl ? Boolean.FALSE : Boolean.TRUE;
        }
        return bl ? Boolean.TRUE : Boolean.FALSE;
    }

    private boolean evaluateImpl(Node node2, int n, int n2) {
        Object object = this.lhs.evaluate(node2, n, n2);
        Object object2 = this.rhs.evaluate(node2, n, n2);
        boolean bl = object instanceof Collection;
        boolean bl2 = object2 instanceof Collection;
        if (bl && bl2) {
            Collection collection = (Collection)object;
            Collection collection2 = (Collection)object2;
            if (collection.isEmpty()) {
                return false;
            }
            boolean bl3 = true;
            for (Node node3 : collection) {
                for (Node node4 : collection2) {
                    if (node3 == node4 || node3.equals(node4)) {
                        if (this.invert) continue;
                        return true;
                    }
                    if (EqualityExpr.stringValue(node3).equals(EqualityExpr.stringValue(node4))) {
                        if (this.invert) continue;
                        return true;
                    }
                    bl3 = false;
                }
            }
            return bl3;
        }
        boolean bl4 = object instanceof Double;
        boolean bl5 = object2 instanceof Double;
        if (bl && bl5 || bl2 && bl4) {
            Collection collection = bl ? (Collection)object : (Collection)object2;
            double d = bl4 ? ((Double)object).doubleValue() : ((Double)object2).doubleValue();
            boolean bl6 = true;
            for (Node node5 : collection) {
                double d2 = EqualityExpr._number(node2, EqualityExpr.stringValue(node5));
                if (d2 == d) {
                    if (this.invert) continue;
                    return true;
                }
                bl6 = false;
            }
            return this.invert ? bl6 : false;
        }
        boolean bl7 = object instanceof String;
        boolean bl8 = object2 instanceof String;
        if (bl && bl8 || bl2 && bl7) {
            Collection collection = bl ? (Collection)object : (Collection)object2;
            String string = bl7 ? (String)object : (String)object2;
            boolean bl9 = true;
            for (Node node6 : collection) {
                if (EqualityExpr.stringValue(node6).equals(string)) {
                    if (this.invert) continue;
                    return true;
                }
                bl9 = false;
            }
            return this.invert ? bl9 : false;
        }
        boolean bl10 = object instanceof Boolean;
        boolean bl11 = object2 instanceof Boolean;
        if (bl && bl11 || bl2 && bl10) {
            Collection collection = bl ? (Collection)object : (Collection)object2;
            boolean bl12 = bl10 ? ((Boolean)object).booleanValue() : ((Boolean)object2).booleanValue();
            return EqualityExpr._boolean(node2, collection) == bl12;
        }
        if (bl10 || bl11) {
            boolean bl13 = bl10 ? (Boolean)object : EqualityExpr._boolean(node2, object);
            boolean bl14 = bl11 ? (Boolean)object2 : EqualityExpr._boolean(node2, object2);
            return bl13 == bl14;
        }
        if (bl4 || bl5) {
            double d = bl4 ? (Double)object : EqualityExpr._number(node2, object);
            double d3 = bl5 ? (Double)object2 : EqualityExpr._number(node2, object2);
            return d == d3;
        }
        String string = bl7 ? (String)object : EqualityExpr._string(node2, object);
        String string2 = bl8 ? (String)object2 : EqualityExpr._string(node2, object2);
        return string.equals(string2);
    }

    public Expr clone(Object object) {
        return new EqualityExpr(this.lhs.clone(object), this.rhs.clone(object), this.invert);
    }

    public boolean references(QName qName) {
        return this.lhs.references(qName) || this.rhs.references(qName);
    }

    public String toString() {
        if (this.invert) {
            return this.lhs + " != " + this.rhs;
        }
        return this.lhs + " = " + this.rhs;
    }
}

