/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.xpath;

import gnu.java.lang.CPStringBuilder;
import gnu.xml.xpath.Expr;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ConcatFunction
extends Expr {
    final List<Expr> args;

    ConcatFunction(List<Expr> list2) {
        this.args = list2;
    }

    @Override
    public Object evaluate(Node node2, int n, int n2) {
        CPStringBuilder cPStringBuilder = new CPStringBuilder();
        for (Expr expr : this.args) {
            Object object = expr.evaluate(node2, n, n2);
            cPStringBuilder.append(ConcatFunction._string(node2, object));
        }
        return cPStringBuilder.toString();
    }

    @Override
    public Expr clone(Object object) {
        int n = this.args.size();
        ArrayList<Expr> arrayList = new ArrayList<Expr>(n);
        for (int i = 0; i < n; ++i) {
            arrayList.add(this.args.get(i).clone(object));
        }
        return new ConcatFunction(arrayList);
    }

    @Override
    public boolean references(QName qName) {
        Iterator<Expr> iterator = this.args.iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().references(qName)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        CPStringBuilder cPStringBuilder = new CPStringBuilder("concat(");
        int n = this.args.size();
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                cPStringBuilder.append(',');
            }
            cPStringBuilder.append(this.args.get(i));
        }
        cPStringBuilder.append(')');
        return cPStringBuilder.toString();
    }
}

