/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.validation.xmlschema;

import gnu.xml.validation.datatype.Annotation;
import gnu.xml.validation.datatype.SimpleType;
import gnu.xml.validation.datatype.Type;
import gnu.xml.validation.xmlschema.AnyAttribute;
import gnu.xml.validation.xmlschema.AttributeDeclaration;
import gnu.xml.validation.xmlschema.AttributeUse;
import gnu.xml.validation.xmlschema.ComplexType;
import gnu.xml.validation.xmlschema.ElementDeclaration;
import gnu.xml.validation.xmlschema.Particle;
import gnu.xml.validation.xmlschema.XMLSchema;
import java.util.LinkedHashSet;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import org.relaxng.datatype.DatatypeException;
import org.relaxng.datatype.DatatypeLibrary;
import org.relaxng.datatype.helpers.DatatypeLibraryLoader;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

class XMLSchemaBuilder {
    XMLSchema schema;
    final DatatypeLibrary typeLibrary = new DatatypeLibraryLoader().createDatatypeLibrary("http://www.w3.org/2001/XMLSchema");

    XMLSchemaBuilder() {
    }

    void parseSchema(Node node2) throws DatatypeException {
        String string = node2.getNamespaceURI();
        String string2 = node2.getLocalName();
        if ("http://www.w3.org/2001/XMLSchema".equals(string) && node2.getNodeType() == 1 && "schema".equals(string2)) {
            NamedNodeMap namedNodeMap = node2.getAttributes();
            String string3 = XMLSchemaBuilder.getAttribute(namedNodeMap, "targetNamespace");
            String string4 = XMLSchemaBuilder.getAttribute(namedNodeMap, "version");
            String string5 = XMLSchemaBuilder.getAttribute(namedNodeMap, "finalDefault");
            int n = this.parseFullDerivationSet(string5);
            String string6 = XMLSchemaBuilder.getAttribute(namedNodeMap, "blockDefault");
            int n2 = this.parseBlockSet(string6);
            String string7 = XMLSchemaBuilder.getAttribute(namedNodeMap, "attributeFormDefault");
            boolean bl = "qualified".equals(string7);
            String string8 = XMLSchemaBuilder.getAttribute(namedNodeMap, "elementFormDefault");
            boolean bl2 = "qualified".equals(string8);
            this.schema = new XMLSchema(string3, string4, n, n2, bl, bl2);
            for (Node node3 = node2.getFirstChild(); node3 != null; node3 = node3.getNextSibling()) {
                this.parseTopLevelElement(node3);
            }
            return;
        }
    }

    void parseTopLevelElement(Node node2) throws DatatypeException {
        String string = node2.getNamespaceURI();
        String string2 = node2.getLocalName();
        if ("http://www.w3.org/2001/XMLSchema".equals(string) && node2.getNodeType() == 1) {
            if ("element".equals(string2)) {
                ElementDeclaration elementDeclaration = (ElementDeclaration)this.parseElement(node2, null);
                this.schema.elementDeclarations.put(elementDeclaration.name, elementDeclaration);
            } else if ("attribute".equals(string2)) {
                AttributeDeclaration attributeDeclaration = (AttributeDeclaration)this.parseAttribute(node2, true);
                this.schema.attributeDeclarations.put(attributeDeclaration.name, attributeDeclaration);
            } else if ("type".equals(string2) || "group".equals(string2) || "attributeGroup".equals(string2) || "notation".equals(string2) || "identityConstraint".equals(string2)) {
                // empty if block
            }
        }
    }

    Object parseAttribute(Node node2, boolean bl) throws DatatypeException {
        Object object;
        NamedNodeMap namedNodeMap = node2.getAttributes();
        String string = XMLSchemaBuilder.getAttribute(namedNodeMap, "default");
        String string2 = XMLSchemaBuilder.getAttribute(namedNodeMap, "fixed");
        int n = 0;
        String string3 = null;
        if (string != null) {
            n = 1;
            string3 = string;
        } else if (string2 != null) {
            n = 2;
            string3 = string2;
        }
        String string4 = XMLSchemaBuilder.getAttribute(namedNodeMap, "name");
        String string5 = XMLSchemaBuilder.getAttribute(namedNodeMap, "targetNamespace");
        String string6 = XMLSchemaBuilder.getAttribute(namedNodeMap, "ref");
        String string7 = XMLSchemaBuilder.getAttribute(namedNodeMap, "use");
        String string8 = XMLSchemaBuilder.getAttribute(namedNodeMap, "type");
        SimpleType simpleType = string8 == null ? null : this.parseSimpleType(XMLSchemaBuilder.asQName(string8, node2));
        Annotation annotation = null;
        for (Node node3 = node2.getFirstChild(); node3 != null; node3 = node3.getNextSibling()) {
            object = node3.getNamespaceURI();
            String string9 = node3.getLocalName();
            if (!"http://www.w3.org/2001/XMLSchema".equals(object) || node3.getNodeType() != 1) continue;
            if ("annotation".equals(string9)) {
                annotation = this.parseAnnotation(node3);
                continue;
            }
            if (!"simpleType".equals(string9)) continue;
            simpleType = this.parseSimpleType(node3);
        }
        if (bl) {
            return new AttributeDeclaration(bl, n, string3, new QName(string5, string4), simpleType, annotation);
        }
        boolean bl2 = "required".equals(string7);
        object = string6 == null ? new AttributeDeclaration(bl, 0, null, new QName(string5, string4), simpleType, annotation) : null;
        return new AttributeUse(bl2, n, string3, (AttributeDeclaration)object);
    }

    int parseFullDerivationSet(String string) {
        int n = 0;
        if ("#all".equals(string)) {
            n = 15;
        } else {
            StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                if ("extension".equals(string2)) {
                    n |= 1;
                    continue;
                }
                if ("restriction".equals(string2)) {
                    n |= 2;
                    continue;
                }
                if ("list".equals(string2)) {
                    n |= 4;
                    continue;
                }
                if (!"union".equals(string2)) continue;
                n |= 8;
            }
        }
        return n;
    }

    int parseSimpleTypeDerivationSet(String string) {
        int n = 0;
        if ("#all".equals(string)) {
            n = 14;
        } else {
            StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                if ("list".equals(string2)) {
                    n |= 4;
                    continue;
                }
                if ("union".equals(string2)) {
                    n |= 8;
                    continue;
                }
                if (!"restriction".equals(string2)) continue;
                n |= 2;
            }
        }
        return n;
    }

    int parseComplexTypeDerivationSet(String string) {
        int n = 0;
        if ("#all".equals(string)) {
            n = 3;
        } else {
            StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                if ("extension".equals(string2)) {
                    n |= 1;
                    continue;
                }
                if (!"restriction".equals(string2)) continue;
                n |= 2;
            }
        }
        return n;
    }

    int parseBlockSet(String string) {
        int n = 0;
        if ("#all".equals(string)) {
            n = 7;
        } else {
            StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                if ("extension".equals(string2)) {
                    n |= 1;
                    continue;
                }
                if ("restriction".equals(string2)) {
                    n |= 2;
                    continue;
                }
                if (!"substitution".equals(string2)) continue;
                n |= 4;
            }
        }
        return n;
    }

    int parseComplexTypeBlockSet(String string) {
        int n = 0;
        if ("#all".equals(string)) {
            n = 3;
        } else {
            StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                if ("extension".equals(string2)) {
                    n |= 1;
                    continue;
                }
                if (!"restriction".equals(string2)) continue;
                n |= 2;
            }
        }
        return n;
    }

    Object parseElement(Node node2, ElementDeclaration elementDeclaration) throws DatatypeException {
        Object object;
        String string;
        String string2;
        boolean bl;
        NamedNodeMap namedNodeMap = node2.getAttributes();
        Integer n = null;
        Integer n2 = null;
        Node node3 = node2.getParentNode();
        boolean bl2 = bl = !"schema".equals(node3.getLocalName());
        if (bl && (string2 = XMLSchemaBuilder.getAttribute(namedNodeMap, "ref")) != null) {
            n = this.getOccurrence(XMLSchemaBuilder.getAttribute(namedNodeMap, "minOccurs"));
            n2 = this.getOccurrence(XMLSchemaBuilder.getAttribute(namedNodeMap, "maxOccurs"));
            Object var9_9 = null;
            return new Particle(n, n2, var9_9);
        }
        string2 = XMLSchemaBuilder.getAttribute(namedNodeMap, "name");
        String string3 = XMLSchemaBuilder.getAttribute(namedNodeMap, "targetNamespace");
        String string4 = XMLSchemaBuilder.getAttribute(namedNodeMap, "type");
        SimpleType simpleType = string4 != null ? this.parseSimpleType(XMLSchemaBuilder.asQName(string4, node2)) : null;
        int n3 = elementDeclaration == null ? 0 : 1;
        String string5 = XMLSchemaBuilder.getAttribute(namedNodeMap, "default");
        String string6 = XMLSchemaBuilder.getAttribute(namedNodeMap, "fixed");
        int n4 = 0;
        String string7 = null;
        if (string5 != null) {
            n4 = 1;
            string7 = string5;
        } else if (string6 != null) {
            n4 = 2;
            string7 = string6;
        }
        String string8 = XMLSchemaBuilder.getAttribute(namedNodeMap, "substitutionGroup");
        QName qName = QName.valueOf(string8);
        String string9 = qName.getPrefix();
        if (string9 != null && !"".equals(string9)) {
            string = qName.getLocalPart();
            String string10 = node2.lookupNamespaceURI(string9);
            qName = new QName(string10, string);
        }
        int n5 = (string = XMLSchemaBuilder.getAttribute(namedNodeMap, "block")) == null ? this.schema.blockDefault : this.parseBlockSet(string);
        String string11 = XMLSchemaBuilder.getAttribute(namedNodeMap, "final");
        int n6 = string11 == null ? this.schema.finalDefault : this.parseFullDerivationSet(string11);
        boolean bl3 = "true".equals(XMLSchemaBuilder.getAttribute(namedNodeMap, "nillable"));
        boolean bl4 = "true".equals(XMLSchemaBuilder.getAttribute(namedNodeMap, "abstract"));
        if (bl) {
            n = this.getOccurrence(XMLSchemaBuilder.getAttribute(namedNodeMap, "minOccurs"));
            n2 = this.getOccurrence(XMLSchemaBuilder.getAttribute(namedNodeMap, "maxOccurs"));
            object = XMLSchemaBuilder.getAttribute(namedNodeMap, "form");
            if (object != null) {
                if ("qualified".equals(object)) {
                    string3 = this.schema.targetNamespace;
                }
            } else if (this.schema.elementFormQualified) {
                string3 = this.schema.targetNamespace;
            }
        }
        object = new ElementDeclaration(new QName(string3, string2), simpleType, n3, elementDeclaration, n4, string7, bl3, qName, n5, n6, bl4);
        for (Node node4 = node2.getFirstChild(); node4 != null; node4 = node4.getNextSibling()) {
            String string12 = node4.getNamespaceURI();
            String string13 = node4.getLocalName();
            if (!"http://www.w3.org/2001/XMLSchema".equals(string12) || node4.getNodeType() != 1) continue;
            if ("annotation".equals(string13)) {
                ((ElementDeclaration)object).annotation = this.parseAnnotation(node4);
                continue;
            }
            if ("simpleType".equals(string13) && simpleType == null) {
                ((ElementDeclaration)object).datatype = this.parseSimpleType(node4);
                continue;
            }
            if (!"complexType".equals(string13) || simpleType != null) continue;
            ((ElementDeclaration)object).datatype = this.parseComplexType(node4, (ElementDeclaration)object);
        }
        if (bl) {
            return new Particle(n, n2, object);
        }
        return object;
    }

    Integer getOccurrence(String string) {
        if (string == null) {
            return new Integer(1);
        }
        if ("unbounded".equals(string)) {
            return null;
        }
        return new Integer(string);
    }

    SimpleType parseSimpleType(QName qName) throws DatatypeException {
        SimpleType simpleType = (SimpleType)this.schema.types.get(qName);
        if (!"http://www.w3.org/2001/XMLSchema".equals(qName.getNamespaceURI())) {
            return null;
        }
        String string = qName.getLocalPart();
        return (SimpleType)this.typeLibrary.createDatatype(string);
    }

    SimpleType parseSimpleType(Node node2) throws DatatypeException {
        Object object;
        NamedNodeMap namedNodeMap = node2.getAttributes();
        String string = XMLSchemaBuilder.getAttribute(namedNodeMap, "final");
        if (string == null) {
            Node node3;
            for (node3 = node2.getParentNode(); node3 != null && !"schema".equals(node3.getLocalName()); node3 = node3.getParentNode()) {
            }
            if (node3 != null) {
                object = node3.getAttributes();
                string = XMLSchemaBuilder.getAttribute((NamedNodeMap)object, "finalDefault");
            }
        }
        int n = this.parseSimpleTypeDerivationSet(string);
        object = XMLSchemaBuilder.asQName(XMLSchemaBuilder.getAttribute(namedNodeMap, "name"), node2);
        int n2 = 0;
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        int n3 = 0;
        SimpleType simpleType = null;
        Annotation annotation = null;
        for (Node node4 = node2.getFirstChild(); node4 != null; node4 = node4.getNextSibling()) {
            String string2 = node4.getNamespaceURI();
            String string3 = node4.getLocalName();
            if (!"http://www.w3.org/2001/XMLSchema".equals(string2) || node4.getNodeType() != 1) continue;
            if ("annotation".equals(string3)) {
                annotation = this.parseAnnotation(node4);
                continue;
            }
            if ("restriction".equals(string3)) continue;
            if ("list".equals(string3)) {
                n2 = 2;
                continue;
            }
            if (!"union".equals(string3)) continue;
            n2 = 3;
        }
        return new SimpleType((QName)object, n2, linkedHashSet, n3, simpleType, annotation);
    }

    Type parseComplexType(Node node2, ElementDeclaration elementDeclaration) throws DatatypeException {
        NamedNodeMap namedNodeMap = node2.getAttributes();
        QName qName = XMLSchemaBuilder.asQName(XMLSchemaBuilder.getAttribute(namedNodeMap, "name"), node2);
        boolean bl = "true".equals(XMLSchemaBuilder.getAttribute(namedNodeMap, "abstract"));
        String string = XMLSchemaBuilder.getAttribute(namedNodeMap, "block");
        int n = string == null ? this.schema.blockDefault : this.parseComplexTypeBlockSet(string);
        String string2 = XMLSchemaBuilder.getAttribute(namedNodeMap, "final");
        int n2 = string2 == null ? this.schema.finalDefault : this.parseComplexTypeDerivationSet(string2);
        ComplexType complexType = new ComplexType(qName, bl, n, n2);
        boolean bl2 = "true".equals(XMLSchemaBuilder.getAttribute(namedNodeMap, "mixed"));
        for (Node node3 = node2.getFirstChild(); node3 != null; node3 = node3.getNextSibling()) {
            String string3 = node3.getNamespaceURI();
            String string4 = node3.getLocalName();
            if (!"http://www.w3.org/2001/XMLSchema".equals(string3) || node3.getNodeType() != 1 || !"simpleContent".equals(string4)) continue;
            this.parseSimpleContent(node3, complexType);
        }
        if (bl2) {
            complexType.contentType = 2;
        }
        return complexType;
    }

    void parseSimpleContent(Node node2, ComplexType complexType) throws DatatypeException {
        for (Node node3 = node2.getFirstChild(); node3 != null; node3 = node3.getNextSibling()) {
            String string = node3.getNamespaceURI();
            String string2 = node3.getLocalName();
            if (!"http://www.w3.org/2001/XMLSchema".equals(string) || node3.getNodeType() != 1) continue;
            if ("annotation".equals(string2)) {
                complexType.annotations.add(this.parseAnnotation(node3));
                continue;
            }
            if ("restriction".equals(string2)) {
                complexType.derivationMethod = 2;
                this.parseRestriction(node3, complexType);
                continue;
            }
            if (!"extension".equals(string2)) continue;
            complexType.derivationMethod = 1;
            this.parseExtension(node3, complexType);
        }
    }

    void parseRestriction(Node node2, ComplexType complexType) throws DatatypeException {
        NamedNodeMap namedNodeMap = node2.getAttributes();
        String string = XMLSchemaBuilder.getAttribute(namedNodeMap, "base");
        QName qName = XMLSchemaBuilder.asQName(string, node2);
        SimpleType simpleType = null;
        for (Node node3 = node2.getFirstChild(); node3 != null; node3 = node3.getNextSibling()) {
            Object object;
            String string2 = node3.getNamespaceURI();
            String string3 = node3.getLocalName();
            if (!"http://www.w3.org/2001/XMLSchema".equals(string2) || node3.getNodeType() != 1) continue;
            if ("annotation".equals(string3)) {
                complexType.annotations.add(this.parseAnnotation(node3));
                continue;
            }
            if ("simpleType".equals(string3)) {
                complexType.contentType = 1;
                simpleType = this.parseSimpleType(node3);
                continue;
            }
            if ("minExclusive".equals(string3) || "minInclusive".equals(string3) || "maxExclusive".equals(string3) || "maxInclusive".equals(string3) || "totalDigits".equals(string3) || "fractionDigits".equals(string3) || "length".equals(string3) || "minLength".equals(string3) || "maxLength".equals(string3) || "enumeration".equals(string3) || "whiteSpace".equals(string3) || "pattern".equals(string3)) continue;
            if ("attribute".equals(string3)) {
                object = (AttributeUse)this.parseAttribute(node3, false);
                this.schema.attributeDeclarations.put(((AttributeUse)object).declaration.name, ((AttributeUse)object).declaration);
                complexType.attributeUses.add(object);
                continue;
            }
            if ("attributeGroup".equals(string3)) {
                object = node3.getAttributes();
                String string4 = XMLSchemaBuilder.getAttribute((NamedNodeMap)object, "ref");
                QName qName2 = XMLSchemaBuilder.asQName(string4, node3);
                complexType.attributeUses.add(qName2);
                continue;
            }
            if (!"anyAttribute".equals(string3)) continue;
            complexType.attributeWildcard = this.parseAnyAttribute(node3);
        }
    }

    void parseExtension(Node node2, ComplexType complexType) throws DatatypeException {
        NamedNodeMap namedNodeMap = node2.getAttributes();
        String string = XMLSchemaBuilder.getAttribute(namedNodeMap, "base");
        QName qName = XMLSchemaBuilder.asQName(string, node2);
        for (Node node3 = node2.getFirstChild(); node3 != null; node3 = node3.getNextSibling()) {
            Object object;
            String string2 = node3.getNamespaceURI();
            String string3 = node3.getLocalName();
            if (!"http://www.w3.org/2001/XMLSchema".equals(string2) || node3.getNodeType() != 1) continue;
            if ("annotation".equals(string3)) {
                complexType.annotations.add(this.parseAnnotation(node3));
                continue;
            }
            if ("attribute".equals(string3)) {
                object = (AttributeUse)this.parseAttribute(node3, false);
                this.schema.attributeDeclarations.put(((AttributeUse)object).declaration.name, ((AttributeUse)object).declaration);
                complexType.attributeUses.add(object);
                continue;
            }
            if ("attributeGroup".equals(string3)) {
                object = node3.getAttributes();
                String string4 = XMLSchemaBuilder.getAttribute((NamedNodeMap)object, "ref");
                QName qName2 = XMLSchemaBuilder.asQName(string4, node3);
                complexType.attributeUses.add(qName2);
                continue;
            }
            if (!"anyAttribute".equals(string3)) continue;
            complexType.attributeWildcard = this.parseAnyAttribute(node3);
        }
    }

    AnyAttribute parseAnyAttribute(Node node2) {
        NamedNodeMap namedNodeMap = node2.getAttributes();
        String string = XMLSchemaBuilder.getAttribute(namedNodeMap, "namespace");
        String string2 = XMLSchemaBuilder.getAttribute(namedNodeMap, "processContents");
        int n = 0;
        if ("lax".equals(string2)) {
            n = 1;
        } else if ("skip".equals(string2)) {
            n = 2;
        }
        AnyAttribute anyAttribute = new AnyAttribute(string, n);
        for (Node node3 = node2.getFirstChild(); node3 != null; node3 = node3.getNextSibling()) {
            String string3 = node3.getNamespaceURI();
            String string4 = node3.getLocalName();
            if (!"http://www.w3.org/2001/XMLSchema".equals(string3) || node3.getNodeType() != 1 || !"annotation".equals(string4)) continue;
            anyAttribute.annotation = this.parseAnnotation(node3);
        }
        return anyAttribute;
    }

    Annotation parseAnnotation(Node node2) {
        return null;
    }

    private static String getAttribute(NamedNodeMap namedNodeMap, String string) {
        Node node2 = namedNodeMap.getNamedItem(string);
        return node2 == null ? null : node2.getNodeValue();
    }

    private static QName asQName(String string, Node node2) {
        QName qName = QName.valueOf(string);
        String string2 = qName.getPrefix();
        if (string2 != null && string2.length() > 0) {
            String string3 = node2.lookupNamespaceURI(string2);
            qName = new QName(string3, qName.getLocalPart());
        }
        return qName;
    }
}

