/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.validation.relaxng;

import gnu.xml.stream.XMLParser;
import gnu.xml.validation.relaxng.AnyNameNameClass;
import gnu.xml.validation.relaxng.AttributePattern;
import gnu.xml.validation.relaxng.ChoiceNameClass;
import gnu.xml.validation.relaxng.ChoicePattern;
import gnu.xml.validation.relaxng.DataPattern;
import gnu.xml.validation.relaxng.Define;
import gnu.xml.validation.relaxng.ElementPattern;
import gnu.xml.validation.relaxng.EmptyPattern;
import gnu.xml.validation.relaxng.Grammar;
import gnu.xml.validation.relaxng.GrammarException;
import gnu.xml.validation.relaxng.GroupPattern;
import gnu.xml.validation.relaxng.InterleavePattern;
import gnu.xml.validation.relaxng.ListPattern;
import gnu.xml.validation.relaxng.NSNameNameClass;
import gnu.xml.validation.relaxng.NameClass;
import gnu.xml.validation.relaxng.NameNameClass;
import gnu.xml.validation.relaxng.NotAllowedPattern;
import gnu.xml.validation.relaxng.OneOrMorePattern;
import gnu.xml.validation.relaxng.Param;
import gnu.xml.validation.relaxng.Pattern;
import gnu.xml.validation.relaxng.RefPattern;
import gnu.xml.validation.relaxng.TextPattern;
import gnu.xml.validation.relaxng.ValuePattern;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.relaxng.datatype.DatatypeException;
import org.relaxng.datatype.DatatypeLibrary;
import org.relaxng.datatype.helpers.DatatypeLibraryLoader;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

class FullSyntaxBuilder {
    static final Map VOCABULARY = new HashMap();
    static final Set STRIPPED_ATTRIBUTES = new HashSet();
    static final Set PATTERN_ELEMENTS = new HashSet();
    private Set urls;
    private int refCount;
    private Map datatypeLibraries;

    FullSyntaxBuilder() {
    }

    synchronized Grammar parse(Document document) throws IOException {
        Node node2;
        Node node3;
        Object object;
        Object object2;
        Object object3;
        this.urls = new HashSet();
        this.refCount = 1;
        document.normalizeDocument();
        this.transform(document);
        Element element = document.getDocumentElement();
        Element element2 = document.createElementNS("http://relaxng.org/ns/structure/1.0", "grammar");
        Element element3 = document.createElementNS("http://relaxng.org/ns/structure/1.0", "start");
        document.removeChild(element);
        document.appendChild(element2);
        element2.appendChild(element3);
        element3.appendChild(element);
        this.transformGrammar(element2, element);
        Object object4 = FullSyntaxBuilder.getNextSiblingElement(element3);
        while (object4 != null) {
            object3 = FullSyntaxBuilder.getNextSiblingElement((Node)object4);
            object2 = object4.getAttribute("new-name");
            if (object2 != null) {
                object4.setAttribute("name", (String)object2);
                object4.removeAttribute("new-name");
            } else {
                element2.removeChild((Node)object4);
            }
            object4 = object3;
        }
        object3 = new HashSet();
        object2 = new HashSet();
        this.getDefines((Set)object3, element2, element2, false);
        this.getDefines((Set)object2, element2, element3, true);
        object3.removeAll((Collection<?>)object2);
        Object object5 = object3.iterator();
        while (object5.hasNext()) {
            object = (Element)object5.next();
            node3 = object.getParentNode();
            node3.removeChild((Node)object);
        }
        object5 = new HashSet();
        this.getElements((Set)object5, element2, element2);
        object = object5.iterator();
        while (object.hasNext()) {
            node3 = (Element)object.next();
            node2 = node3.getParentNode();
            if (object2.contains(node2)) continue;
            object4 = document.createElementNS("http://relaxng.org/ns/structure/1.0", "define");
            Element element4 = document.createElementNS("http://relaxng.org/ns/structure/1.0", "ref");
            String string = this.createRefName();
            object4.setAttribute("name", string);
            element4.setAttribute("name", string);
            node2.insertBefore(element4, node3);
            object4.appendChild(node3);
            element2.appendChild((Node)object4);
            object2.add(object4);
        }
        object = object2.iterator();
        while (object.hasNext()) {
            node3 = (Element)object.next();
            node2 = FullSyntaxBuilder.getFirstChildElement(node3);
            if (node2 == null || !"element".equals(node2.getLocalName())) continue;
            object.remove();
        }
        this.expandRefs((Set)object2, element2);
        object = object2.iterator();
        while (object.hasNext()) {
            node3 = (Element)object.next();
            node2 = node3.getParentNode();
            node2.removeChild(node3);
        }
        this.transform2(element);
        object = this.parseGrammar(element2);
        this.datatypeLibraries = null;
        return object;
    }

    private void getDefines(Set set, Element element, Element element2, boolean bl) {
        Object object;
        String string = element2.getLocalName();
        if ("define".equals(string)) {
            set.add(element2);
        } else if ("ref".equals(string) && bl) {
            object = element2.getAttribute("name");
            Element element3 = FullSyntaxBuilder.getFirstChildElement(element);
            element3 = FullSyntaxBuilder.getNextSiblingElement(element3);
            while (element3 != null) {
                String string2 = element3.getAttribute("name");
                if (((String)object).equals(string2)) {
                    this.getDefines(set, element, element2, bl);
                    break;
                }
                element3 = FullSyntaxBuilder.getNextSiblingElement(element3);
            }
        }
        object = FullSyntaxBuilder.getFirstChildElement(element2);
        while (object != null) {
            this.getDefines(set, element, (Element)object, bl);
            object = FullSyntaxBuilder.getNextSiblingElement((Node)object);
        }
    }

    private void getElements(Set set, Element element, Element element2) {
        String string = element2.getLocalName();
        if ("element".equals(string)) {
            set.add(element2);
        }
        Element element3 = FullSyntaxBuilder.getFirstChildElement(element2);
        while (element3 != null) {
            this.getElements(set, element, element3);
            element3 = FullSyntaxBuilder.getNextSiblingElement(element3);
        }
    }

    private void expandRefs(Set set, Element element) throws GrammarException {
        Object object;
        String string = element.getLocalName();
        if ("ref".equals(string)) {
            object = element.getAttribute("name");
            for (Element element2 : set) {
                String string2 = element2.getAttribute("name");
                if (!((String)object).equals(string2)) continue;
                Element element3 = FullSyntaxBuilder.getFirstChildElement(element2);
                this.forbidRefs(element3, (String)object);
                Element element4 = (Element)element3.cloneNode(true);
                Node node2 = element.getParentNode();
                node2.insertBefore(element4, element);
                node2.removeChild(element);
                element = element4;
                break;
            }
        }
        object = FullSyntaxBuilder.getFirstChildElement(element);
        while (object != null) {
            this.expandRefs(set, (Element)object);
            object = FullSyntaxBuilder.getNextSiblingElement((Node)object);
        }
    }

    private void forbidRefs(Element element, String string) throws GrammarException {
        Object object;
        String string2 = element.getLocalName();
        if ("ref".equals(string2) && string.equals(object = element.getAttribute("name"))) {
            throw new GrammarException("cannot expand ref with name '" + string + "' due to circularity");
        }
        object = FullSyntaxBuilder.getFirstChildElement(element);
        while (object != null) {
            this.forbidRefs((Element)object, string);
            object = FullSyntaxBuilder.getNextSiblingElement((Node)object);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void transform(Node var1_1) throws IOException {
        var2_2 = var1_1.getParentNode();
        switch (var1_1.getNodeType()) {
            case 1: {
                var3_3 = var1_1.getNamespaceURI();
                var4_4 = var1_1.getLocalName();
                if (!"http://relaxng.org/ns/structure/1.0".equals(var3_3) || !FullSyntaxBuilder.VOCABULARY.containsKey(var4_4)) {
                    var2_2.removeChild((Node)var1_1);
                    break;
                }
                var5_5 = (Set)FullSyntaxBuilder.VOCABULARY.get(var4_4);
                var6_6 = var1_1.getAttributes();
                var7_7 = var6_6.getLength();
                for (var8_8 = var7_7 - 1; var8_8 >= 0; --var8_8) {
                    var9_21 = var6_6.item(var8_8);
                    var10_22 = var9_21.getNamespaceURI();
                    var11_23 = var9_21.getLocalName();
                    if ("http://www.w3.org/2000/xmlns/".equals(var10_22)) continue;
                    if (!"http://relaxng.org/ns/structure/1.0".equals(var10_22) && var10_22 != null || !var5_5.contains(var11_23)) {
                        var6_6.removeNamedItemNS((String)var10_22, (String)var11_23);
                        continue;
                    }
                    if (FullSyntaxBuilder.STRIPPED_ATTRIBUTES.contains(var11_23)) {
                        var9_21.setNodeValue(var9_21.getNodeValue().trim());
                        continue;
                    }
                    if ("datatypeLibrary".equals(var11_23)) {
                        var12_25 = var9_21.getNodeValue();
                        var9_21.setNodeValue(FullSyntaxBuilder.escapeURL((String)var12_25));
                        continue;
                    }
                    if (!"href".equals(var11_23)) continue;
                    var12_25 = var9_21.getNodeValue();
                    var12_25 = XMLParser.absolutize(var1_1.getBaseURI(), FullSyntaxBuilder.escapeURL((String)var12_25));
                    var9_21.setNodeValue((String)var12_25);
                }
                if (!"data".equals(var4_4) && !"value".equals(var4_4)) ** GOTO lbl48
                var8_9 = (Element)var1_1;
                var9_21 = var8_9.getAttribute("datatypeLibrary");
                if (var9_21 == null) {
                    for (var10_22 = var2_2; var9_21 == null && var10_22 != null && var10_22.getNodeType() == 1; var10_22 = var10_22.getParentNode()) {
                        var9_21 = ((Element)var10_22).getAttribute("datatypeLibrary");
                    }
                    if (var9_21 == null) {
                        var9_21 = "";
                    }
                    var8_9.setAttribute("datatypeLibrary", (String)var9_21);
                }
                if ("value".equals(var4_4) && (var10_22 = var8_9.getAttribute("type")) == null) {
                    var8_9.setAttribute("type", "token");
                    var8_9.setAttribute("datatypeLibrary", "");
                }
                ** GOTO lbl335
lbl48:
                // 1 sources

                if ("externalRef".equals(var4_4)) {
                    var8_10 = (Element)var1_1;
                    var9_21 = var8_10.getAttribute("href");
                    if (this.urls.contains(var9_21)) {
                        throw new GrammarException("recursive href");
                    }
                    this.urls.add(var9_21);
                    var10_22 = FullSyntaxBuilder.resolve((String)var9_21);
                    var11_23 = var10_22.getNamespaceURI();
                    var12_25 = var10_22.getLocalName();
                    if (!"http://relaxng.org/ns/structure/1.0".equals(var11_23) && var11_23 != null || !FullSyntaxBuilder.PATTERN_ELEMENTS.contains(var12_25)) {
                        throw new GrammarException("externally referenced element is not a pattern");
                    }
                    this.transform((Node)var10_22);
                    this.urls.remove(var9_21);
                    var13_26 = var10_22.getAttribute("ns");
                    if (var13_26 != null) {
                        var10_22.setAttribute("ns", var8_10.getAttribute("ns"));
                    }
                    var10_22 = (Element)var8_10.getOwnerDocument().importNode((Node)var10_22, true);
                    var2_2.replaceChild((Node)var10_22, var8_10);
                    return;
                }
                if ("include".equals(var4_4)) {
                    var8_11 = (Element)var1_1;
                    var9_21 = var8_11.getAttribute("href");
                    if (this.urls.contains(var9_21)) {
                        throw new GrammarException("recursive href");
                    }
                    this.urls.add(var9_21);
                    var10_22 = FullSyntaxBuilder.resolve((String)var9_21);
                    var11_23 = var10_22.getNamespaceURI();
                    var12_25 = var10_22.getLocalName();
                    if (!"http://relaxng.org/ns/structure/1.0".equals(var11_23) && var11_23 != null || !"grammar".equals(var12_25)) {
                        throw new GrammarException("included element is not a grammar");
                    }
                    this.transform((Node)var10_22);
                    this.urls.remove(var9_21);
                    var13_27 = this.getComponents(var8_11);
                    var14_29 = this.getComponents((Node)var10_22);
                    for (Element var16_33 : var13_27) {
                        var17_34 = var16_33.getLocalName();
                        if ("start".equals(var17_34)) {
                            var18_35 = false;
                            for (Object var20_40 : var14_29) {
                                if (!"start".equals(var20_40.getLocalName())) continue;
                                var20_40.getParentNode().removeChild((Node)var20_40);
                                var18_35 = true;
                            }
                            if (var18_35) continue;
                            throw new GrammarException("no start component in included grammar");
                        }
                        if (!"define".equals(var17_34)) continue;
                        var18_36 = var16_33.getAttribute("name");
                        var19_39 = false;
                        var20_40 = var14_29.iterator();
                        while (var20_40.hasNext()) {
                            var21_41 = (Element)var20_40.next();
                            if (!"define".equals(var21_41.getLocalName()) || !var18_36.equals(var21_41.getAttribute("name"))) continue;
                            var21_41.getParentNode().removeChild(var21_41);
                            var19_39 = true;
                        }
                        if (var19_39) continue;
                        throw new GrammarException("no define component with name '" + var18_36 + "' in included grammar");
                    }
                    var15_31 = var8_11.getOwnerDocument();
                    var16_33 = var15_31.createElementNS("http://relaxng.org/ns/structure/1.0", "div");
                    var17_34 = var15_31.createElementNS("http://relaxng.org/ns/structure/1.0", "div");
                    var10_22 = (Element)var15_31.importNode((Node)var10_22, true);
                    var18_37 = var10_22.getFirstChild();
                    while (var18_37 != null) {
                        var19_38 = var18_37.getNextSibling();
                        var17_34.appendChild((Node)var18_37);
                        var18_37 = var19_38;
                    }
                    var16_33.appendChild((Node)var17_34);
                    var18_37 = var8_11.getFirstChild();
                    while (var18_37 != null) {
                        var19_38 = var18_37.getNextSibling();
                        var16_33.appendChild((Node)var18_37);
                        var18_37 = var19_38;
                    }
                    var2_2.replaceChild(var16_33, var8_11);
                    this.transform(var16_33);
                    return;
                }
                if (!"attribute".equals(var4_4) && !"element".equals(var4_4)) ** GOTO lbl176
                var8_12 = (Element)var1_1;
                var9_21 = var8_12.getAttribute("name");
                if (var9_21 != null) {
                    var10_22 = var8_12.getOwnerDocument();
                    var11_23 = var10_22.createElementNS("http://relaxng.org/ns/structure/1.0", "name");
                    var11_23.appendChild(var10_22.createTextNode((String)var9_21));
                    var12_25 = var8_12.getFirstChild();
                    if (var12_25 != null) {
                        var8_12.insertBefore((Node)var11_23, (Node)var12_25);
                    } else {
                        var8_12.appendChild((Node)var11_23);
                    }
                    if ("attribute".equals(var4_4) && (var13_28 = var8_12.getAttribute("ns")) != null) {
                        var11_23.setAttribute("ns", (String)var13_28);
                        var8_12.removeAttribute("ns");
                    }
                    var8_12.removeAttribute("name");
                }
                if (!"attribute".equals(var4_4)) ** GOTO lbl162
                if (this.getComponents((Node)var1_1).size() == 1) {
                    var10_22 = var1_1.getOwnerDocument();
                    var11_23 = var10_22.createElementNS("http://relaxng.org/ns/structure/1.0", "text");
                    var1_1.appendChild((Node)var11_23);
                }
                ** GOTO lbl335
lbl162:
                // 1 sources

                if (var1_1.getChildNodes().getLength() <= 2) ** GOTO lbl335
                var10_22 = var1_1.getOwnerDocument();
                var11_23 = var10_22.createElementNS("http://relaxng.org/ns/structure/1.0", "group");
                var12_25 = FullSyntaxBuilder.getFirstChildElement((Node)var1_1);
                var12_25 = FullSyntaxBuilder.getNextSiblingElement((Node)var12_25);
                while (var12_25 != null) {
                    var13_28 = FullSyntaxBuilder.getNextSiblingElement((Node)var12_25);
                    var11_23.appendChild((Node)var12_25);
                    var12_25 = var13_28;
                }
                var1_1.appendChild((Node)var11_23);
                ** GOTO lbl335
lbl176:
                // 1 sources

                if ("div".equals(var4_4)) {
                    var8_13 = var1_1.getFirstChild();
                    while (var8_13 != null) {
                        var9_21 = var8_13.getNextSibling();
                        var2_2.insertBefore((Node)var8_13, (Node)var1_1);
                        this.transform((Node)var8_13);
                        var8_13 = var9_21;
                    }
                    var2_2.removeChild((Node)var1_1);
                    return;
                }
                if (!"mixed".equals(var4_4)) ** GOTO lbl208
                FullSyntaxBuilder.transformToOneChildElement((Node)var1_1, "group");
                var8_14 = var1_1.getOwnerDocument();
                var9_21 = var8_14.createElementNS("http://relaxng.org/ns/structure/1.0", "interleave");
                var10_22 = var1_1.getFirstChild();
                while (var10_22 != null) {
                    var11_23 = var10_22.getNextSibling();
                    var9_21.appendChild((Node)var10_22);
                    var10_22 = var11_23;
                }
                var11_23 = var8_14.createElementNS("http://relaxng.org/ns/structure/1.0", "text");
                var9_21.appendChild((Node)var11_23);
                var2_2.insertBefore((Node)var9_21, (Node)var1_1);
                var2_2.removeChild((Node)var1_1);
                var1_1 = var9_21;
                ** GOTO lbl335
lbl208:
                // 1 sources

                if (!"optional".equals(var4_4)) ** GOTO lbl228
                FullSyntaxBuilder.transformToOneChildElement((Node)var1_1, "group");
                var8_15 = var1_1.getOwnerDocument();
                var9_21 = var8_15.createElementNS("http://relaxng.org/ns/structure/1.0", "choice");
                var10_22 = var1_1.getFirstChild();
                while (var10_22 != null) {
                    var11_23 = var10_22.getNextSibling();
                    var9_21.appendChild((Node)var10_22);
                    var10_22 = var11_23;
                }
                var11_23 = var8_15.createElementNS("http://relaxng.org/ns/structure/1.0", "empty");
                var9_21.appendChild((Node)var11_23);
                var2_2.insertBefore((Node)var9_21, (Node)var1_1);
                var2_2.removeChild((Node)var1_1);
                var1_1 = var9_21;
                ** GOTO lbl335
lbl228:
                // 1 sources

                if (!"zeroOrMore".equals(var4_4)) ** GOTO lbl251
                FullSyntaxBuilder.transformToOneChildElement((Node)var1_1, "group");
                var8_16 = var1_1.getOwnerDocument();
                var9_21 = var8_16.createElementNS("http://relaxng.org/ns/structure/1.0", "choice");
                var10_22 = var8_16.createElementNS("http://relaxng.org/ns/structure/1.0", "oneOrMore");
                var11_23 = var1_1.getFirstChild();
                while (var11_23 != null) {
                    var12_25 = var11_23.getNextSibling();
                    var10_22.appendChild((Node)var11_23);
                    var11_23 = var12_25;
                }
                var12_25 = var8_16.createElementNS("http://relaxng.org/ns/structure/1.0", "empty");
                var9_21.appendChild((Node)var10_22);
                var9_21.appendChild((Node)var12_25);
                var2_2.insertBefore((Node)var9_21, (Node)var1_1);
                var2_2.removeChild((Node)var1_1);
                var1_1 = var9_21;
                ** GOTO lbl335
lbl251:
                // 1 sources

                if (!"list".equals(var4_4) && !"oneOrMore".equals(var4_4) && !"define".equals(var4_4)) ** GOTO lbl254
                FullSyntaxBuilder.transformToOneChildElement((Node)var1_1, "group");
                ** GOTO lbl335
lbl254:
                // 1 sources

                if (!"except".equals(var4_4)) ** GOTO lbl268
                FullSyntaxBuilder.transformToOneChildElement((Node)var1_1, "choice");
                var8_17 = var2_2.getLocalName();
                if (!"anyName".equals(var8_17)) ** GOTO lbl260
                FullSyntaxBuilder.forbidDescendants((Node)var1_1, Collections.singleton("anyName"));
                ** GOTO lbl335
lbl260:
                // 1 sources

                if (!"nsName".equals(var8_17)) ** GOTO lbl335
                var9_21 = new HashSet<T>();
                var9_21.add("nsName");
                var9_21.add("anyName");
                FullSyntaxBuilder.forbidDescendants((Node)var1_1, (Set)var9_21);
                ** GOTO lbl335
lbl268:
                // 1 sources

                if ("choice".equals(var4_4) || "group".equals(var4_4) || "interleave".equals(var4_4)) {
                    var8_18 = FullSyntaxBuilder.getFirstChildElement((Node)var1_1);
                    var9_21 = FullSyntaxBuilder.getNextSiblingElement(var8_18);
                    if (var9_21 == null) {
                        var2_2.insertBefore(var8_18, (Node)var1_1);
                        var2_2.removeChild((Node)var1_1);
                        this.transform(var8_18);
                        return;
                    }
                    var10_22 = FullSyntaxBuilder.getNextSiblingElement((Node)var9_21);
                    if (var10_22 != null) {
                        var11_23 = var1_1.getOwnerDocument();
                        var12_25 = var11_23.createElementNS("http://relaxng.org/ns/structure/1.0", (String)var4_4);
                        var12_25.appendChild(var8_18);
                        var12_25.appendChild((Node)var9_21);
                        var1_1.insertBefore((Node)var10_22, (Node)var12_25);
                        this.transform((Node)var1_1);
                    }
                } else if ("grammar".equals(var4_4)) {
                    var8_19 = null;
                    var9_21 = new LinkedList<T>();
                    var10_22 = var1_1.getFirstChild();
                    while (var10_22 != null) {
                        var11_23 = var10_22.getNextSibling();
                        if ("start".equals(var10_22.getLocalName())) {
                            var12_25 = ((Element)var10_22).getAttribute("combine");
                            if (var8_19 != null && !var8_19.equals(var12_25)) {
                                throw new GrammarException("multiple start elements but no combine attribute");
                            }
                            var8_19 = var12_25;
                            var9_21.add(var10_22);
                        }
                        var10_22 = var11_23;
                    }
                    if (!var9_21.isEmpty()) {
                        FullSyntaxBuilder.combineNodes((Node)var1_1, var8_19, "start", (List)var9_21);
                    }
                    var11_23 = new HashMap<String, Collection<T>>();
                    var12_25 = new HashMap<K, V>();
                    var10_22 = var1_1.getFirstChild();
                    while (var10_22 != null) {
                        var13_28 = var10_22.getNextSibling();
                        if ("define".equals(var10_22.getLocalName())) {
                            var14_30 = ((Element)var10_22).getAttribute("name");
                            var8_19 = (String)var12_25.get(var14_30);
                            var15_32 = ((Element)var10_22).getAttribute("combine");
                            if (var8_19 != null && !var8_19.equals(var15_32)) {
                                throw new GrammarException("multiple define elements with name '" + var14_30 + "' but no combine attribute");
                            }
                            var12_25.put(var14_30, var15_32);
                            var9_21 = (List)var11_23.get(var14_30);
                            if (var9_21 == null) {
                                var9_21 = new LinkedList<T>();
                                var11_23.put(var14_30, var9_21);
                            }
                            var9_21.add(var10_22);
                        }
                        var10_22 = var13_28;
                    }
                    for (String var14_30 : var11_23.keySet()) {
                        var8_19 = (String)var12_25.get(var14_30);
                        var9_21 = (List)var11_23.get(var14_30);
                        if (var9_21.isEmpty()) continue;
                        FullSyntaxBuilder.combineNodes((Node)var1_1, (String)var8_19, "define", var9_21);
                    }
                }
lbl335:
                // 15 sources

                if (!"name".equals(var4_4) && !"nsName".equals(var4_4) && !"value".equals(var4_4)) break;
                var8_20 = (Element)var1_1;
                var9_21 = var8_20.getAttribute("ns");
                if (var9_21 == null) {
                    for (var10_22 = var2_2; var9_21 == null && var10_22 != null && var10_22.getNodeType() == 1; var10_22 = var10_22.getParentNode()) {
                        var9_21 = ((Element)var10_22).getAttribute("ns");
                    }
                    var8_20.setAttribute("ns", (String)(var9_21 == null ? "" : var9_21));
                }
                if ("name".equals(var4_4)) {
                    var10_22 = var8_20.getTextContent();
                    var11_24 = var10_22.indexOf(58);
                    if (var11_24 != -1) {
                        var12_25 = var10_22.substring(0, var11_24);
                        var8_20.setTextContent(var10_22.substring(var11_24 + 1));
                        var9_21 = var8_20.lookupNamespaceURI((String)var12_25);
                        var8_20.setAttribute("ns", (String)(var9_21 == null ? "" : var9_21));
                    }
                    if (!FullSyntaxBuilder.isDescendantOfFirstChildOfAttribute(var8_20) || !"".equals(var8_20.getAttribute("ns")) || !"xmlns".equals(var8_20.getTextContent())) break;
                    throw new GrammarException("name cannot be xmlns");
                }
                if (!"nsName".equals(var4_4) || !FullSyntaxBuilder.isDescendantOfFirstChildOfAttribute(var8_20) || !"http://www.w3.org/2000/xmlns".equals(var8_20.getAttribute("ns"))) break;
                throw new GrammarException("nsName cannot be XMLNS URI");
            }
            case 3: 
            case 4: {
                var5_5 = var2_2.getLocalName();
                if ("name".equals(var5_5)) {
                    var1_1.setNodeValue(var1_1.getNodeValue().trim());
                }
                if ("param".equals(var5_5) || "value".equals(var5_5) || !FullSyntaxBuilder.isWhitespace(var1_1.getNodeValue())) break;
                var2_2.removeChild((Node)var1_1);
                break;
            }
            case 9: {
                break;
            }
            default: {
                var2_2.removeChild((Node)var1_1);
            }
        }
        var3_3 = var1_1.getFirstChild();
        while (var3_3 != null) {
            var4_4 = var3_3.getNextSibling();
            this.transform((Node)var3_3);
            var3_3 = var4_4;
        }
    }

    private void transformGrammar(Node node2, Node node3) throws GrammarException {
        if (node3.getNodeType() == 1) {
            Node node4;
            Node node5;
            String string = node3.getLocalName();
            if ("grammar".equals(string)) {
                Object object;
                Node node6;
                this.handleRefs(node2, node3, node3);
                node5 = null;
                node4 = node3.getFirstChild();
                while (node4 != null) {
                    node6 = node4.getNextSibling();
                    object = node4.getLocalName();
                    if ("define".equals(object)) {
                        node2.appendChild(node4);
                    } else if ("start".equals(object)) {
                        node5 = node4;
                    }
                    node4 = node6;
                }
                if (node5 == null) {
                    throw new GrammarException("no start element for grammar");
                }
                node6 = FullSyntaxBuilder.getFirstChildElement(node5);
                object = node3.getParentNode();
                object.insertBefore(node6, node3);
                object.removeChild(node3);
                node3 = node6;
            }
            node5 = node3.getFirstChild();
            while (node5 != null) {
                node4 = node5.getNextSibling();
                this.transformGrammar(node2, node5);
                node5 = node4;
            }
        }
    }

    private void handleRefs(Node node2, Node node3, Node object) throws GrammarException {
        if (object.getNodeType() == 1) {
            Object object2;
            Object object3;
            String string = object.getLocalName();
            if ("ref".equals(string) || "parentRef".equals(string)) {
                Object object4;
                Node node4;
                object3 = node3;
                if ("parentRef".equals(string)) {
                    object3 = node2;
                }
                if ((object2 = ((Element)object).getAttribute("name")) != null) {
                    throw new GrammarException("no name attribute on " + string);
                }
                Node node5 = null;
                for (node4 = object3.getFirstChild(); node5 == null && node4 != null; node4 = node4.getNextSibling()) {
                    if (!"define".equals(node4.getLocalName()) || !((String)object2).equals(object4 = ((Element)node4).getAttribute("name"))) continue;
                    node5 = node4;
                }
                if (node5 == null) {
                    throw new GrammarException("no define for '" + (String)object2 + "'");
                }
                object2 = ((Element)node5).getAttribute("new-name");
                if (object2 == null) {
                    object2 = this.createRefName();
                    ((Element)node5).setAttribute("new-name", (String)object2);
                }
                if ("parentRef".equals(string)) {
                    Node node6;
                    node4 = object.getOwnerDocument();
                    object4 = node4.createElementNS("http://relaxng.org/ns/structure/1.0", "ref");
                    Node node7 = object.getFirstChild();
                    while (node7 != null) {
                        node6 = node7.getNextSibling();
                        object4.appendChild(node7);
                        node7 = node6;
                    }
                    node6 = object.getParentNode();
                    node6.insertBefore((Node)object4, (Node)object);
                    node6.removeChild((Node)object);
                    object = object4;
                }
                ((Element)object).setAttribute("name", (String)object2);
            } else if ("grammar".equals(string)) {
                node2 = node3;
                node3 = object;
            }
            object3 = object.getFirstChild();
            while (object3 != null) {
                object2 = object3.getNextSibling();
                this.handleRefs(node2, node3, (Node)object3);
                object3 = object2;
            }
        }
    }

    private String createRefName() {
        return "ref" + Integer.toString(this.refCount++);
    }

    private void transform2(Node node2) throws GrammarException {
        Node node3 = node2.getParentNode();
        if (node2.getNodeType() == 1) {
            Node node4;
            Object object;
            String string = node2.getLocalName();
            if ("notAllowed".equals(string)) {
                object = node3.getLocalName();
                if ("attribute".equals(object) || "list".equals(object) || "group".equals(object) || "interleave".equals(object) || "oneOrMore".equals(object)) {
                    Node node5 = node3.getParentNode();
                    node5.insertBefore(node2, node3);
                    node5.removeChild(node3);
                    this.transform2(node2);
                    return;
                }
                if ("choice".equals(object)) {
                    Element element = FullSyntaxBuilder.getFirstChildElement(node3);
                    Element element2 = FullSyntaxBuilder.getNextSiblingElement(element);
                    if (element == null || element2 == null) {
                        throw new GrammarException("choice does not have two children");
                    }
                    String string2 = element.getLocalName();
                    String string3 = element2.getLocalName();
                    Node node6 = node3.getParentNode();
                    if ("notAllowed".equals(string2) && "notAllowed".equals(string3)) {
                        node6.insertBefore(element, node3);
                        node6.removeChild(node3);
                        this.transform2(element);
                        return;
                    }
                    if ("notAllowed".equals(string2)) {
                        node6.insertBefore(element2, node3);
                        node6.removeChild(node3);
                        this.transform2(element2);
                        return;
                    }
                    node6.insertBefore(element, node3);
                    node6.removeChild(node3);
                    this.transform2(element);
                    return;
                }
                if ("except".equals(object)) {
                    Node node7 = node3.getParentNode();
                    node7.removeChild(node3);
                    return;
                }
            } else if ("empty".equals(string)) {
                object = node3.getLocalName();
                if ("group".equals(object) || "interleave".equals(object)) {
                    Element element = FullSyntaxBuilder.getFirstChildElement(node3);
                    Element element3 = FullSyntaxBuilder.getNextSiblingElement(element);
                    if (element == null || element3 == null) {
                        throw new GrammarException((String)object + " does not have two children");
                    }
                    String string4 = element.getLocalName();
                    String string5 = element3.getLocalName();
                    Node node8 = node3.getParentNode();
                    if ("empty".equals(string4) && "empty".equals(string5)) {
                        node8.insertBefore(element, node3);
                        node8.removeChild(node3);
                        this.transform2(element);
                        return;
                    }
                    if ("empty".equals(string4)) {
                        node8.insertBefore(element3, node3);
                        node8.removeChild(node3);
                        this.transform2(element3);
                        return;
                    }
                    node8.insertBefore(element, node3);
                    node8.removeChild(node3);
                    this.transform2(element);
                    return;
                }
                if ("choice".equals(object)) {
                    node4 = FullSyntaxBuilder.getFirstChildElement(node3);
                    Element element = FullSyntaxBuilder.getNextSiblingElement(node4);
                    if (node4 == null || element == null) {
                        throw new GrammarException((String)object + " does not have two children");
                    }
                    String string6 = node4.getLocalName();
                    String string7 = element.getLocalName();
                    Node node9 = node3.getParentNode();
                    if ("empty".equals(string6) && "empty".equals(string7)) {
                        node9.insertBefore(node4, node3);
                        node9.removeChild(node3);
                        this.transform2(node4);
                        return;
                    }
                } else if ("oneOrMore".equals(object)) {
                    Node node10 = node3.getParentNode();
                    node10.insertBefore(node2, node3);
                    node10.removeChild(node3);
                    this.transform2(node2);
                    return;
                }
            }
            object = node2.getFirstChild();
            while (object != null) {
                node4 = object.getNextSibling();
                this.transform2((Node)object);
                object = node4;
            }
        }
    }

    private static boolean isWhitespace(String string) {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == ' ' || c == '\t' || c == '\n' || c == '\r') continue;
            return false;
        }
        return true;
    }

    private static String escapeURL(String string) {
        try {
            return URLEncoder.encode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            RuntimeException runtimeException = new RuntimeException("UTF-8 is unsupported");
            runtimeException.initCause(unsupportedEncodingException);
            throw runtimeException;
        }
    }

    private static Element resolve(String string) throws IOException {
        try {
            URL uRL = new URL(string);
            InputStream inputStream = uRL.openStream();
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            documentBuilderFactory.setCoalescing(true);
            documentBuilderFactory.setExpandEntityReferences(true);
            documentBuilderFactory.setIgnoringComments(true);
            documentBuilderFactory.setIgnoringElementContentWhitespace(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(inputStream, string);
            inputStream.close();
            String string2 = uRL.getRef();
            if (string2 != null) {
                return document.getElementById(string2);
            }
            return document.getDocumentElement();
        }
        catch (SAXException sAXException) {
            IOException iOException = new IOException("error parsing included element");
            iOException.initCause(sAXException);
            throw iOException;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            IOException iOException = new IOException("error parsing included element");
            iOException.initCause(parserConfigurationException);
            throw iOException;
        }
    }

    private List getComponents(Node node2) {
        LinkedList linkedList = new LinkedList();
        for (Node node3 = node2.getFirstChild(); node3 != null; node3 = node3.getNextSibling()) {
            String string;
            if (node3.getNodeType() != 1 || (string = node3.getNamespaceURI()) != null && !string.equals("http://relaxng.org/ns/structure/1.0")) continue;
            String string2 = node3.getLocalName();
            if ("div".equals(string2)) {
                linkedList.addAll(this.getComponents(node3));
                continue;
            }
            if (!VOCABULARY.containsKey(string2)) continue;
            linkedList.add(node3);
        }
        return linkedList;
    }

    private static void transformToOneChildElement(Node node2, String string) {
        if (node2.getChildNodes().getLength() < 2) {
            return;
        }
        Document document = node2.getOwnerDocument();
        Element element = document.createElementNS("http://relaxng.org/ns/structure/1.0", string);
        Element element2 = FullSyntaxBuilder.getFirstChildElement(node2);
        while (element2 != null) {
            Element element3 = FullSyntaxBuilder.getNextSiblingElement(element2);
            element.appendChild(element2);
            element2 = element3;
        }
        node2.appendChild(element);
    }

    private static Element getFirstChildElement(Node node2) {
        Node node3;
        for (node3 = node2.getFirstChild(); node3 != null && node3.getNodeType() != 1; node3 = node3.getNextSibling()) {
        }
        return (Element)node3;
    }

    private static Element getNextSiblingElement(Node node2) {
        Node node3;
        for (node3 = node2.getNextSibling(); node3 != null && node3.getNodeType() != 1; node3 = node3.getNextSibling()) {
        }
        return (Element)node3;
    }

    private static void forbidDescendants(Node node2, Set set) throws GrammarException {
        for (Node node3 = node2.getFirstChild(); node3 != null; node3 = node3.getNextSibling()) {
            String string = node3.getNamespaceURI();
            if (!"http://relaxng.org/ns/structure/1.0".equals(string)) continue;
            String string2 = node3.getLocalName();
            if (set.contains(string2)) {
                throw new GrammarException("name not allowed: " + string2);
            }
            FullSyntaxBuilder.forbidDescendants(node3, set);
        }
    }

    private static boolean isDescendantOfFirstChildOfAttribute(Node node2) {
        Node node3 = node2;
        Node node4 = node2.getParentNode();
        while (node4 != null && !"attribute".equals(node4.getLocalName())) {
            node3 = node4;
            node4 = node3.getParentNode();
        }
        if (node4 == null) {
            return false;
        }
        Element element = FullSyntaxBuilder.getFirstChildElement(node4);
        return element == node3;
    }

    private static void combineNodes(Node node2, String string, String string2, List list2) {
        Document document = node2.getOwnerDocument();
        Element element = document.createElementNS("http://relaxng.org/ns/structure/1.0", string2);
        Element element2 = document.createElementNS("http://relaxng.org/ns/structure/1.0", string);
        element.appendChild(element2);
        boolean bl = false;
        for (Node node3 : list2) {
            if (!bl) {
                node2.insertBefore(element, node3);
                bl = true;
            }
            Node node4 = node3.getFirstChild();
            while (node4 != null) {
                Node node5 = node4.getNextSibling();
                element2.appendChild(node4);
                node4 = node5;
            }
            node2.removeChild(node3);
        }
    }

    Grammar parseGrammar(Element element) throws GrammarException {
        this.checkName(element, "grammar");
        Grammar grammar = new Grammar();
        Element element2 = FullSyntaxBuilder.getFirstChildElement(element);
        grammar.start = this.parsePattern(FullSyntaxBuilder.getFirstChildElement(element2));
        Element element3 = FullSyntaxBuilder.getNextSiblingElement(element2);
        while (element3 != null) {
            grammar.defines.add(this.parseDefine(element3));
            element3 = FullSyntaxBuilder.getNextSiblingElement(element3);
        }
        return grammar;
    }

    Define parseDefine(Element element) throws GrammarException {
        this.checkName(element, "define");
        Define define = new Define();
        define.name = element.getAttribute("name");
        define.element = this.parseElement(FullSyntaxBuilder.getFirstChildElement(element));
        return define;
    }

    Pattern parseTop(Element element) throws GrammarException {
        String string = element.getLocalName();
        if ("notAllowed".equals(string)) {
            return this.parseNotAllowed(element);
        }
        return this.parsePattern(element);
    }

    Pattern parsePattern(Element element) throws GrammarException {
        String string = element.getLocalName();
        if ("empty".equals(string)) {
            return this.parseEmpty(element);
        }
        return this.parseNonEmptyPattern(element);
    }

    Pattern parseNonEmptyPattern(Element element) throws GrammarException {
        String string = element.getLocalName();
        if ("text".equals(string)) {
            return this.parseText(element);
        }
        if ("data".equals(string)) {
            return this.parseData(element);
        }
        if ("value".equals(string)) {
            return this.parseValue(element);
        }
        if ("list".equals(string)) {
            return this.parseList(element);
        }
        if ("attribute".equals(string)) {
            return this.parseAttribute(element);
        }
        if ("ref".equals(string)) {
            return this.parseRef(element);
        }
        if ("oneOrMore".equals(string)) {
            return this.parseOneOrMore(element);
        }
        if ("choice".equals(string)) {
            return this.parseChoice(element);
        }
        if ("group".equals(string)) {
            return this.parseGroup(element);
        }
        if ("interleave".equals(string)) {
            return this.parseInterleave(element);
        }
        throw new GrammarException("invalid pattern: " + string);
    }

    ElementPattern parseElement(Element element) throws GrammarException {
        this.checkName(element, "element");
        ElementPattern elementPattern = new ElementPattern();
        Element element2 = FullSyntaxBuilder.getFirstChildElement(element);
        elementPattern.nameClass = this.parseNameClass(element2);
        elementPattern.pattern = this.parseTop(FullSyntaxBuilder.getNextSiblingElement(element2));
        return elementPattern;
    }

    NotAllowedPattern parseNotAllowed(Element element) throws GrammarException {
        this.checkName(element, "notAllowed");
        return NotAllowedPattern.INSTANCE;
    }

    EmptyPattern parseEmpty(Element element) throws GrammarException {
        this.checkName(element, "empty");
        return EmptyPattern.INSTANCE;
    }

    TextPattern parseText(Element element) throws GrammarException {
        this.checkName(element, "text");
        return TextPattern.INSTANCE;
    }

    DataPattern parseData(Element element) throws GrammarException {
        this.checkName(element, "data");
        DataPattern dataPattern = new DataPattern();
        DatatypeLibrary datatypeLibrary = this.getDatatypeLibrary(element.getAttribute("datatypeLibrary"));
        String string = element.getAttribute("type");
        try {
            dataPattern.type = datatypeLibrary.createDatatype(string);
            dataPattern.datatypeLibrary = datatypeLibrary;
        }
        catch (DatatypeException datatypeException) {
            GrammarException grammarException = new GrammarException(string);
            grammarException.initCause(datatypeException);
            throw grammarException;
        }
        Element element2 = FullSyntaxBuilder.getFirstChildElement(element);
        while (element2 != null) {
            Element element3 = FullSyntaxBuilder.getNextSiblingElement(element2);
            String string2 = element2.getLocalName();
            if ("param".equals(string2)) {
                dataPattern.params.add(this.parseParam(element2));
            } else if ("except".equals(string2) && element3 == null) {
                dataPattern.exceptPattern = this.parsePattern(FullSyntaxBuilder.getFirstChildElement(element2));
            } else {
                throw new GrammarException("invalid element: " + string2);
            }
            element2 = element3;
        }
        return dataPattern;
    }

    Param parseParam(Element element) throws GrammarException {
        this.checkName(element, "param");
        Param param = new Param();
        param.name = element.getAttribute("name");
        param.value = element.getTextContent();
        return param;
    }

    ValuePattern parseValue(Element element) throws GrammarException {
        this.checkName(element, "value");
        ValuePattern valuePattern = new ValuePattern();
        DatatypeLibrary datatypeLibrary = this.getDatatypeLibrary(element.getAttribute("datatypeLibrary"));
        String string = element.getAttribute("type");
        try {
            valuePattern.type = datatypeLibrary.createDatatype(string);
            valuePattern.datatypeLibrary = datatypeLibrary;
        }
        catch (DatatypeException datatypeException) {
            GrammarException grammarException = new GrammarException(string);
            grammarException.initCause(datatypeException);
            throw grammarException;
        }
        valuePattern.ns = element.getAttribute("ns");
        valuePattern.value = element.getTextContent();
        return valuePattern;
    }

    ListPattern parseList(Element element) throws GrammarException {
        this.checkName(element, "list");
        ListPattern listPattern = new ListPattern();
        listPattern.pattern = this.parsePattern(FullSyntaxBuilder.getFirstChildElement(element));
        return listPattern;
    }

    AttributePattern parseAttribute(Element element) throws GrammarException {
        this.checkName(element, "attribute");
        AttributePattern attributePattern = new AttributePattern();
        Element element2 = FullSyntaxBuilder.getFirstChildElement(element);
        attributePattern.nameClass = this.parseNameClass(element2);
        attributePattern.pattern = this.parsePattern(FullSyntaxBuilder.getNextSiblingElement(element2));
        return attributePattern;
    }

    RefPattern parseRef(Element element) throws GrammarException {
        this.checkName(element, "ref");
        RefPattern refPattern = new RefPattern();
        refPattern.name = element.getAttribute("name");
        return refPattern;
    }

    OneOrMorePattern parseOneOrMore(Element element) throws GrammarException {
        this.checkName(element, "oneOrMore");
        OneOrMorePattern oneOrMorePattern = new OneOrMorePattern();
        oneOrMorePattern.pattern = this.parseNonEmptyPattern(FullSyntaxBuilder.getFirstChildElement(element));
        return oneOrMorePattern;
    }

    ChoicePattern parseChoice(Element element) throws GrammarException {
        this.checkName(element, "choice");
        ChoicePattern choicePattern = new ChoicePattern();
        Element element2 = FullSyntaxBuilder.getFirstChildElement(element);
        Element element3 = FullSyntaxBuilder.getNextSiblingElement(element2);
        choicePattern.pattern1 = this.parsePattern(element2);
        choicePattern.pattern2 = this.parseNonEmptyPattern(element3);
        return choicePattern;
    }

    GroupPattern parseGroup(Element element) throws GrammarException {
        this.checkName(element, "group");
        GroupPattern groupPattern = new GroupPattern();
        Element element2 = FullSyntaxBuilder.getFirstChildElement(element);
        Element element3 = FullSyntaxBuilder.getNextSiblingElement(element2);
        groupPattern.pattern1 = this.parseNonEmptyPattern(element2);
        groupPattern.pattern2 = this.parseNonEmptyPattern(element3);
        return groupPattern;
    }

    InterleavePattern parseInterleave(Element element) throws GrammarException {
        this.checkName(element, "interleave");
        InterleavePattern interleavePattern = new InterleavePattern();
        Element element2 = FullSyntaxBuilder.getFirstChildElement(element);
        Element element3 = FullSyntaxBuilder.getNextSiblingElement(element2);
        interleavePattern.pattern1 = this.parseNonEmptyPattern(element2);
        interleavePattern.pattern2 = this.parseNonEmptyPattern(element3);
        return interleavePattern;
    }

    NameClass parseNameClass(Element element) throws GrammarException {
        String string = element.getLocalName();
        if ("anyName".equals(string)) {
            return this.parseAnyName(element);
        }
        if ("name".equals(string)) {
            return this.parseName(element);
        }
        if ("nsName".equals(string)) {
            return this.parseNsName(element);
        }
        if ("choice".equals(string)) {
            return this.parseChoiceNameClass(element);
        }
        throw new GrammarException("invalid name class: " + string);
    }

    AnyNameNameClass parseAnyName(Element element) throws GrammarException {
        this.checkName(element, "anyName");
        AnyNameNameClass anyNameNameClass = new AnyNameNameClass();
        Element element2 = FullSyntaxBuilder.getFirstChildElement(element);
        if (element2 != null) {
            this.checkName(element2, "except");
            anyNameNameClass.exceptNameClass = this.parseNameClass(FullSyntaxBuilder.getFirstChildElement(element2));
        }
        return anyNameNameClass;
    }

    NameNameClass parseName(Element element) throws GrammarException {
        this.checkName(element, "name");
        NameNameClass nameNameClass = new NameNameClass();
        nameNameClass.ns = element.getAttribute("ns");
        nameNameClass.name = element.getTextContent();
        return nameNameClass;
    }

    NSNameNameClass parseNsName(Element element) throws GrammarException {
        this.checkName(element, "nsName");
        NSNameNameClass nSNameNameClass = new NSNameNameClass();
        nSNameNameClass.ns = element.getAttribute("ns");
        Element element2 = FullSyntaxBuilder.getFirstChildElement(element);
        if (element2 != null) {
            this.checkName(element2, "except");
            nSNameNameClass.exceptNameClass = this.parseNameClass(FullSyntaxBuilder.getFirstChildElement(element2));
        }
        return nSNameNameClass;
    }

    ChoiceNameClass parseChoiceNameClass(Element element) throws GrammarException {
        this.checkName(element, "choice");
        ChoiceNameClass choiceNameClass = new ChoiceNameClass();
        Element element2 = FullSyntaxBuilder.getFirstChildElement(element);
        Element element3 = FullSyntaxBuilder.getNextSiblingElement(element2);
        choiceNameClass.name1 = this.parseNameClass(element2);
        choiceNameClass.name2 = this.parseNameClass(element3);
        return choiceNameClass;
    }

    void checkName(Element element, String string) throws GrammarException {
        if (!string.equals(element.getLocalName())) {
            throw new GrammarException("expecting " + string);
        }
    }

    DatatypeLibrary getDatatypeLibrary(String string) throws GrammarException {
        DatatypeLibrary datatypeLibrary;
        if (this.datatypeLibraries == null) {
            this.datatypeLibraries = new HashMap();
        }
        if ((datatypeLibrary = (DatatypeLibrary)this.datatypeLibraries.get(string)) == null) {
            datatypeLibrary = new DatatypeLibraryLoader().createDatatypeLibrary(string);
            if (datatypeLibrary == null) {
                throw new GrammarException("Datatype library not supported: " + string);
            }
            this.datatypeLibraries.put(string, datatypeLibrary);
        }
        return datatypeLibrary;
    }

    static {
        Set<String> set = Collections.singleton("name");
        HashSet hashSet = new HashSet();
        hashSet.add("type");
        hashSet.add("datatypeLibrary");
        HashSet hashSet2 = new HashSet();
        hashSet2.add("type");
        hashSet2.add("datatypeLibrary");
        hashSet2.add("ns");
        Set<String> set2 = Collections.singleton("href");
        Set<String> set3 = Collections.singleton("combine");
        HashSet hashSet3 = new HashSet();
        hashSet3.add("name");
        hashSet3.add("combine");
        Set<String> set4 = Collections.singleton("ns");
        VOCABULARY.put("element", set);
        VOCABULARY.put("attribute", set);
        VOCABULARY.put("group", Collections.EMPTY_SET);
        VOCABULARY.put("interleave", Collections.EMPTY_SET);
        VOCABULARY.put("choice", Collections.EMPTY_SET);
        VOCABULARY.put("optional", Collections.EMPTY_SET);
        VOCABULARY.put("zeroOrMore", Collections.EMPTY_SET);
        VOCABULARY.put("oneOrMore", Collections.EMPTY_SET);
        VOCABULARY.put("list", Collections.EMPTY_SET);
        VOCABULARY.put("mixed", Collections.EMPTY_SET);
        VOCABULARY.put("ref", set);
        VOCABULARY.put("parentRef", set);
        VOCABULARY.put("empty", Collections.EMPTY_SET);
        VOCABULARY.put("text", Collections.EMPTY_SET);
        VOCABULARY.put("value", hashSet2);
        VOCABULARY.put("data", hashSet);
        VOCABULARY.put("notAllowed", Collections.EMPTY_SET);
        VOCABULARY.put("externalRef", set2);
        VOCABULARY.put("grammar", Collections.EMPTY_SET);
        VOCABULARY.put("param", set);
        VOCABULARY.put("except", Collections.EMPTY_SET);
        VOCABULARY.put("div", Collections.EMPTY_SET);
        VOCABULARY.put("include", set2);
        VOCABULARY.put("start", set3);
        VOCABULARY.put("define", hashSet3);
        VOCABULARY.put("name", set4);
        VOCABULARY.put("anyName", Collections.EMPTY_SET);
        VOCABULARY.put("nsName", set4);
        STRIPPED_ATTRIBUTES.add("name");
        STRIPPED_ATTRIBUTES.add("type");
        STRIPPED_ATTRIBUTES.add("combine");
        PATTERN_ELEMENTS.add("element");
        PATTERN_ELEMENTS.add("attribute");
        PATTERN_ELEMENTS.add("group");
        PATTERN_ELEMENTS.add("interleave");
        PATTERN_ELEMENTS.add("choice");
        PATTERN_ELEMENTS.add("optional");
        PATTERN_ELEMENTS.add("zeroOrMore");
        PATTERN_ELEMENTS.add("oneOrMore");
        PATTERN_ELEMENTS.add("list");
        PATTERN_ELEMENTS.add("mixed");
        PATTERN_ELEMENTS.add("ref");
        PATTERN_ELEMENTS.add("parentRef");
        PATTERN_ELEMENTS.add("empty");
        PATTERN_ELEMENTS.add("text");
        PATTERN_ELEMENTS.add("value");
        PATTERN_ELEMENTS.add("data");
        PATTERN_ELEMENTS.add("notAllowed");
        PATTERN_ELEMENTS.add("externalRef");
        PATTERN_ELEMENTS.add("grammar");
    }
}

