/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.validation.datatype;

import gnu.xml.validation.datatype.AtomicSimpleType;
import gnu.xml.validation.datatype.TypeLibrary;
import javax.xml.namespace.QName;
import org.relaxng.datatype.DatatypeException;
import org.relaxng.datatype.ValidationContext;

final class UnsignedLongType
extends AtomicSimpleType {
    static final int[] CONSTRAINING_FACETS = new int[]{11, 12, 4, 6, 5, 7, 8, 10, 9};
    static final String MAX_VALUE = "18446744073709551615";
    static final int LENGTH = "18446744073709551615".length();

    UnsignedLongType() {
        super(new QName("http://www.w3.org/2001/XMLSchema", "unsignedLong"), TypeLibrary.NON_NEGATIVE_INTEGER);
    }

    public int[] getConstrainingFacets() {
        return CONSTRAINING_FACETS;
    }

    public void checkValid(String string, ValidationContext validationContext) throws DatatypeException {
        super.checkValid(string, validationContext);
        int n = string.length();
        if (n == 0) {
            throw new DatatypeException(0, "invalid unsigned long value");
        }
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            char c;
            if (n - i > LENGTH) {
                throw new DatatypeException(i, "invalid unsigned long value");
            }
            if (n - i == LENGTH) {
                bl = true;
            }
            if ((c = string.charAt(i)) >= '0' && c <= '9') {
                if (!bl) continue;
                char c2 = MAX_VALUE.charAt(i);
                if (Character.digit(c, 10) <= Character.digit(c2, 10)) continue;
                throw new DatatypeException(i, "invalid unsigned long value");
            }
            throw new DatatypeException(i, "invalid unsigned long value");
        }
    }

    public Object createValue(String string, ValidationContext validationContext) {
        try {
            return new Long(string);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }
}

