/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.validation.datatype;

import gnu.xml.validation.datatype.AtomicSimpleType;
import gnu.xml.validation.datatype.TypeLibrary;
import javax.xml.namespace.QName;
import org.relaxng.datatype.DatatypeException;
import org.relaxng.datatype.ValidationContext;

final class GYearType
extends AtomicSimpleType {
    static final int[] CONSTRAINING_FACETS = new int[]{4, 5, 6, 7, 8, 10, 9};

    GYearType() {
        super(new QName("http://www.w3.org/2001/XMLSchema", "gYear"), TypeLibrary.ANY_SIMPLE_TYPE);
    }

    public int[] getConstrainingFacets() {
        return CONSTRAINING_FACETS;
    }

    public void checkValid(String string, ValidationContext validationContext) throws DatatypeException {
        super.checkValid(string, validationContext);
        int n = string.length();
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '-' && i == 0) {
                ++n3;
                continue;
            }
            if (c >= '0' && c <= '9') continue;
            throw new DatatypeException(i, "invalid GYear value");
        }
        switch (n2) {
            case 0: {
                String string2 = string.substring(n3, n);
                if (string2.length() >= 4 && Integer.parseInt(string2) != 0) break;
                throw new DatatypeException("invalid GYear value");
            }
            default: {
                throw new DatatypeException("invalid GYear value");
            }
        }
    }

    public Object createValue(String string, ValidationContext validationContext) {
        try {
            GYear gYear = new GYear();
            gYear.year = Integer.parseInt(string);
            return gYear;
        }
        catch (Exception exception) {
            return null;
        }
    }

    static class GYear
    implements Comparable {
        int year;

        GYear() {
        }

        public int hashCode() {
            return this.year;
        }

        public boolean equals(Object object) {
            if (object instanceof GYear) {
                return ((GYear)object).year == this.year;
            }
            return false;
        }

        public int compareTo(Object object) {
            if (object instanceof GYear) {
                GYear gYear = (GYear)object;
                if (gYear.year == this.year) {
                    return 0;
                }
                return this.year < gYear.year ? -1 : 1;
            }
            return 0;
        }
    }
}

