/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.validation.datatype;

import gnu.xml.validation.datatype.AtomicSimpleType;
import gnu.xml.validation.datatype.TypeLibrary;
import javax.xml.namespace.QName;
import org.relaxng.datatype.DatatypeException;
import org.relaxng.datatype.ValidationContext;

final class GDayType
extends AtomicSimpleType {
    static final int[] CONSTRAINING_FACETS = new int[]{4, 5, 6, 7, 8, 10, 9};

    GDayType() {
        super(new QName("http://www.w3.org/2001/XMLSchema", "gDay"), TypeLibrary.ANY_SIMPLE_TYPE);
    }

    public int[] getConstrainingFacets() {
        return CONSTRAINING_FACETS;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void checkValid(String string, ValidationContext validationContext) throws DatatypeException {
        super.checkValid(string, validationContext);
        int n = string.length();
        int n2 = 0;
        int n3 = 0;
        block11: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c >= '0' && c <= '9') continue;
            switch (n2) {
                case 0: {
                    if (c != '-') break;
                    switch (i) {
                        case 0: {
                            continue block11;
                        }
                        case 1: {
                            n2 = 1;
                            n3 = i + 1;
                            continue block11;
                        }
                        default: {
                            throw new DatatypeException(i, "invalid GDay value");
                        }
                    }
                }
                case 1: {
                    if (c != '-') break;
                    if (i - n3 != 0) {
                        throw new DatatypeException(i, "invalid GDay value");
                    }
                    n2 = 2;
                    n3 = i + 1;
                    continue block11;
                }
            }
            throw new DatatypeException(i, "invalid GDay value");
        }
        switch (n2) {
            case 2: {
                if (n - n3 == 2) break;
                throw new DatatypeException("invalid GDay value");
            }
            default: {
                throw new DatatypeException("invalid GDay value");
            }
        }
    }

    public Object createValue(String string, ValidationContext validationContext) {
        try {
            GDay gDay = new GDay();
            gDay.day = Integer.parseInt(string.substring(3));
            return gDay;
        }
        catch (Exception exception) {
            return null;
        }
    }

    static class GDay
    implements Comparable {
        int day;

        GDay() {
        }

        public int hashCode() {
            return this.day;
        }

        public boolean equals(Object object) {
            if (object instanceof GDay) {
                return ((GDay)object).day == this.day;
            }
            return false;
        }

        public int compareTo(Object object) {
            if (object instanceof GDay) {
                GDay gDay = (GDay)object;
                if (gDay.day == this.day) {
                    return 0;
                }
                return this.day < gDay.day ? -1 : 1;
            }
            return 0;
        }
    }
}

