/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.util;

import java.util.Enumeration;
import java.util.Locale;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Entity;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.Notation;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.DefaultHandler2;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.NamespaceSupport;

public final class DomParser
implements XMLReader {
    private DefaultHandler2 defaultHandler = new DefaultHandler2();
    private ContentHandler contentHandler = this.defaultHandler;
    private DTDHandler dtdHandler = this.defaultHandler;
    private DeclHandler declHandler = this.defaultHandler;
    private LexicalHandler lexicalHandler = this.defaultHandler;
    private ErrorHandler errHandler = this.defaultHandler;
    private EntityResolver resolver = this.defaultHandler;
    private Locale locale = Locale.getDefault();
    private Node start;
    private Node current;
    private boolean isL2;
    private boolean showNamespaces = true;
    private boolean showXML1_0 = false;
    private NamespaceSupport prefixStack = new NamespaceSupport();
    private boolean isDocument;
    private static final String FEATURES = "http://xml.org/sax/features/";
    private static final String HANDLERS = "http://xml.org/sax/properties/";

    public DomParser() {
    }

    public DomParser(Node node2) {
        this.setStart(node2);
    }

    public EntityResolver getEntityResolver() {
        return this.resolver;
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        if (entityResolver == null) {
            entityResolver = this.defaultHandler;
        }
        this.resolver = entityResolver;
    }

    public void setLocale(Locale locale) throws SAXException {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        this.locale = locale;
    }

    public ErrorHandler getErrorHandler() {
        return this.errHandler;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        if (errorHandler == null) {
            errorHandler = this.defaultHandler;
        }
        this.errHandler = errorHandler;
    }

    public ContentHandler getContentHandler() {
        return this.contentHandler;
    }

    public void setContentHandler(ContentHandler contentHandler) {
        if (contentHandler == null) {
            contentHandler = this.defaultHandler;
        }
        this.contentHandler = contentHandler;
    }

    public DTDHandler getDTDHandler() {
        return this.dtdHandler;
    }

    public void setDTDHandler(DTDHandler dTDHandler) {
        if (dTDHandler == null) {
            dTDHandler = this.defaultHandler;
        }
        this.dtdHandler = dTDHandler;
    }

    public void parse(String string) throws SAXException {
        this.parse();
    }

    public void parse(InputSource inputSource) throws SAXException {
        this.parse();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void parse() throws SAXException {
        block3: {
            try {
                this.walk();
                Object var2_1 = null;
                if (!this.isDocument) break block3;
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                if (this.isDocument) {
                    this.contentHandler.endDocument();
                }
                this.current = null;
                this.prefixStack.reset();
                throw throwable;
            }
            this.contentHandler.endDocument();
        }
        this.current = null;
        this.prefixStack.reset();
    }

    private boolean getIsL2(Node node2) {
        Document document = node2 instanceof Document ? (Document)node2 : node2.getOwnerDocument();
        if (document == null) {
            throw new RuntimeException("? unowned node - L2 DTD ?");
        }
        DOMImplementation dOMImplementation = document.getImplementation();
        return dOMImplementation.hasFeature("XML", "2.0");
    }

    public boolean getFeature(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        if ("http://xml.org/sax/features/validation".equals(string) || "http://xml.org/sax/features/external-general-entities".equals(string) || "http://xml.org/sax/features/external-parameter-entities".equals(string) || "http://xml.org/sax/features/string-interning".equals(string)) {
            return false;
        }
        if ("http://xml.org/sax/features/namespaces".equals(string)) {
            return this.showNamespaces;
        }
        if ("http://xml.org/sax/features/namespace-prefixes".equals(string)) {
            return this.showXML1_0;
        }
        throw new SAXNotRecognizedException(string);
    }

    public Object getProperty(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        if ("http://xml.org/sax/properties/declaration-handler".equals(string)) {
            return this.declHandler == this.defaultHandler ? null : this.declHandler;
        }
        if ("http://xml.org/sax/properties/lexical-handler".equals(string)) {
            return this.lexicalHandler == this.defaultHandler ? null : this.lexicalHandler;
        }
        if ("http://xml.org/sax/properties/dom-node".equals(string)) {
            return this.current;
        }
        throw new SAXNotRecognizedException(string);
    }

    public void setFeature(String string, boolean bl) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (this.current != null) {
            throw new IllegalStateException("feature change midparse");
        }
        boolean bl2 = this.getFeature(string);
        if (bl2 == bl) {
            return;
        }
        if ("http://xml.org/sax/features/namespaces".equals(string)) {
            if (!this.showXML1_0 && !bl) {
                throw new SAXNotSupportedException("Illegal namespace processing configuration");
            }
            this.showNamespaces = bl;
            return;
        }
        if ("http://xml.org/sax/features/namespace-prefixes".equals(string)) {
            if (!this.showNamespaces && !bl) {
                throw new SAXNotSupportedException("Illegal namespace processing configuration");
            }
            this.showXML1_0 = bl;
            return;
        }
        throw new SAXNotSupportedException(string);
    }

    public void setProperty(String string, Object object) throws SAXNotRecognizedException, SAXNotSupportedException {
        if ("http://xml.org/sax/properties/declaration-handler".equals(string)) {
            if (!(object instanceof DeclHandler) && object != null) {
                throw new SAXNotSupportedException(string);
            }
            this.declHandler = (DeclHandler)object;
            return;
        }
        if ("http://xml.org/sax/properties/lexical-handler".equals(string)) {
            if (!(object instanceof LexicalHandler) && object != null) {
                throw new SAXNotSupportedException(string);
            }
            this.lexicalHandler = (LexicalHandler)object;
            return;
        }
        if ("http://xml.org/sax/properties/dom-node".equals(string)) {
            if (object == null || object instanceof Node) {
                if (this.current != null) {
                    throw new SAXNotSupportedException("property is readonly during parse:  " + string);
                }
                this.setStart((Node)object);
                return;
            }
            throw new SAXNotSupportedException("not a DOM Node");
        }
        throw new SAXNotRecognizedException(string);
    }

    private void setStart(Node node2) {
        this.start = node2;
        if (this.start != null) {
            this.isL2 = this.getIsL2(this.start);
            this.isDocument = this.start instanceof Document;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void walk() throws SAXException {
        AttributesImpl attributesImpl = new AttributesImpl();
        Object object = this;
        synchronized (object) {
            if (this.current != null) {
                throw new IllegalStateException("already walking tree");
            }
            this.current = this.start;
        }
        block17: while (true) {
            short s = this.current.getNodeType();
            switch (s) {
                case 9: {
                    this.contentHandler.startDocument();
                    break;
                }
                case 1: {
                    Object object2;
                    String string;
                    String string2;
                    Object object3;
                    NamedNodeMap namedNodeMap = this.current.getAttributes();
                    int n2 = namedNodeMap.getLength();
                    this.prefixStack.pushContext();
                    for (int i = 0; i < n2; ++i) {
                        Attr attr = (Attr)namedNodeMap.item(i);
                        object3 = attr.getNodeName();
                        if (this.showNamespaces && ((String)object3).startsWith("xmlns")) {
                            string2 = "xmlns".equals(object3) ? "" : ((String)object3).substring(6);
                            String string3 = attr.getNodeValue();
                            this.prefixStack.declarePrefix(string2, string3);
                            this.contentHandler.startPrefixMapping(string2, string3);
                            if (!this.showXML1_0) continue;
                        }
                        if (this.showNamespaces) {
                            if (!this.isL2) throw new RuntimeException("NYI, ns lookup when parsing L1 DOM");
                            string = attr.getNamespaceURI();
                            if (string == null) {
                                string = "";
                            }
                            if ((object2 = attr.getLocalName()) == null) {
                                object2 = object3;
                            }
                        } else {
                            object2 = "";
                            string = "";
                        }
                        attributesImpl.addAttribute(string, (String)object2, (String)object3, "CDATA", attr.getNodeValue());
                    }
                    if (this.showNamespaces) {
                        if (!this.isL2) throw new RuntimeException("NYI, ns lookup when parsing L1 DOM");
                        string = this.current.getNamespaceURI();
                        if (string == null) {
                            string = "";
                        }
                        if ((object2 = this.current.getLocalName()) == null) {
                            object2 = this.current.getNodeName();
                        }
                    } else {
                        object2 = "";
                        string = "";
                    }
                    this.contentHandler.startElement(string, (String)object2, this.current.getNodeName(), attributesImpl);
                    if (n2 == 0) break;
                    attributesImpl.clear();
                    break;
                }
                case 4: {
                    this.lexicalHandler.startCDATA();
                    char[] cArray = this.current.getNodeValue().toCharArray();
                    this.contentHandler.characters(cArray, 0, cArray.length);
                    this.lexicalHandler.endCDATA();
                    break;
                }
                case 8: {
                    char[] cArray = this.current.getNodeValue().toCharArray();
                    this.lexicalHandler.comment(cArray, 0, cArray.length);
                    break;
                }
                case 10: {
                    int n;
                    String string2;
                    object = (DocumentType)this.current;
                    if (this.isL2) {
                        this.lexicalHandler.startDTD(object.getName(), object.getPublicId(), object.getSystemId());
                    } else {
                        this.lexicalHandler.startDTD(object.getName(), null, null);
                    }
                    String string = this.isL2 && object.getInternalSubset() != null ? " Full DTD known; can't be shown using SAX2. " : " This DTD was was recreated using incomplete DOM L2 records. ";
                    Object object3 = string.toCharArray();
                    this.lexicalHandler.comment((char[])object3, 0, ((char[])object3).length);
                    NamedNodeMap namedNodeMap = object.getNotations();
                    int n2 = namedNodeMap.getLength();
                    for (n = 0; n < n2; ++n) {
                        object3 = (Notation)namedNodeMap.item(n);
                        this.dtdHandler.notationDecl(object3.getNodeName(), object3.getPublicId(), object3.getSystemId());
                    }
                    namedNodeMap = object.getEntities();
                    n2 = namedNodeMap.getLength();
                    for (n = 0; n < n2; ++n) {
                        object3 = (Entity)namedNodeMap.item(n);
                        string2 = object3.getNotationName();
                        if (string2 != null) {
                            this.dtdHandler.unparsedEntityDecl(object3.getNodeName(), object3.getPublicId(), object3.getSystemId(), string2);
                            continue;
                        }
                        if (object3.getSystemId() == null) continue;
                        this.declHandler.externalEntityDecl(object3.getNodeName(), object3.getPublicId(), object3.getSystemId());
                    }
                    this.lexicalHandler.endDTD();
                    break;
                }
                case 5: {
                    this.lexicalHandler.startEntity(this.current.getNodeName());
                    break;
                }
                case 7: {
                    this.contentHandler.processingInstruction(this.current.getNodeName(), this.current.getNodeValue());
                    break;
                }
                case 3: {
                    char[] cArray = this.current.getNodeValue().toCharArray();
                    this.contentHandler.characters(cArray, 0, cArray.length);
                    break;
                }
                default: {
                    throw new SAXException("Illegal DOM Node type in Document:  " + this.current.getNodeType());
                }
            }
            switch (s) {
                case 1: 
                case 5: 
                case 9: {
                    object = this.current.getFirstChild();
                    if (object != null) {
                        this.current = object;
                        continue block17;
                    }
                    this.callEnd(this.current);
                }
                case 3: 
                case 4: 
                case 6: 
                case 7: 
                case 8: 
                case 10: {
                    while ((object = this.current.getNextSibling()) == null) {
                        this.current = this.current.getParentNode();
                        if (this.current == null || this.current == this.start) {
                            return;
                        }
                        this.callEnd(this.current);
                    }
                    this.current = object;
                    continue block17;
                }
            }
            break;
        }
        throw new SAXException("Illegal DOM Node type found:  " + this.current.getNodeType());
    }

    private void callEnd(Node node2) throws SAXException {
        switch (node2.getNodeType()) {
            case 9: {
                return;
            }
            case 1: {
                if (this.showNamespaces) {
                    if (!this.isL2) {
                        throw new RuntimeException("NYI, ns lookup when parsing L1 DOM");
                    }
                    this.contentHandler.endElement(node2.getNamespaceURI(), node2.getLocalName(), node2.getNodeName());
                    Enumeration enumeration = this.prefixStack.getDeclaredPrefixes();
                    while (enumeration.hasMoreElements()) {
                        this.contentHandler.endPrefixMapping((String)enumeration.nextElement());
                    }
                } else {
                    this.contentHandler.endElement("", "", node2.getNodeName());
                }
                this.prefixStack.popContext();
                return;
            }
            case 5: {
                this.lexicalHandler.endEntity(node2.getNodeName());
                return;
            }
            case 2: 
            case 11: {
                return;
            }
        }
        throw new SAXException("Illegal DOM container type found:  " + this.current.getNodeType());
    }
}

