/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.transform;

import gnu.java.lang.CPStringBuilder;
import gnu.xml.transform.Stylesheet;
import gnu.xml.transform.TemplateNode;
import gnu.xml.xpath.Expr;
import java.util.Collection;
import javax.xml.namespace.QName;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

final class ValueOfNode
extends TemplateNode {
    final Expr select;
    final boolean disableOutputEscaping;

    ValueOfNode(Expr expr, boolean bl) {
        this.select = expr;
        this.disableOutputEscaping = bl;
    }

    TemplateNode clone(Stylesheet stylesheet) {
        ValueOfNode valueOfNode = new ValueOfNode(this.select.clone(stylesheet), this.disableOutputEscaping);
        if (this.children != null) {
            valueOfNode.children = this.children.clone(stylesheet);
        }
        if (this.next != null) {
            valueOfNode.next = this.next.clone(stylesheet);
        }
        return valueOfNode;
    }

    void doApply(Stylesheet stylesheet, QName qName, Node node2, int n, int n2, Node node3, Node node4) throws TransformerException {
        String string;
        Object object;
        Object object2 = this.select.evaluate(node2, n, n2);
        if (object2 instanceof Collection) {
            object = new CPStringBuilder();
            for (Node node5 : (Collection)object2) {
                ((CPStringBuilder)object).append(Expr.stringValue(node5));
            }
            string = ((CPStringBuilder)object).toString();
        } else {
            string = object2 == null ? "" : Expr._string(node2, object2);
        }
        if (stylesheet.debug) {
            System.err.println("value-of: " + node2 + " " + this.select + " -> " + string);
        }
        if (string != null && string.length() > 0) {
            object = node3 instanceof Document ? (Document)node3 : node3.getOwnerDocument();
            Text text = object.createTextNode(string);
            if (this.disableOutputEscaping) {
                text.setUserData("disable-output-escaping", "yes", stylesheet);
            }
            if (node4 != null) {
                node3.insertBefore(text, node4);
            } else {
                node3.appendChild(text);
            }
        }
        if (this.next != null) {
            this.next.apply(stylesheet, qName, node2, n, n2, node3, node4);
        }
    }

    public boolean references(QName qName) {
        if (this.select != null && this.select.references(qName)) {
            return true;
        }
        return super.references(qName);
    }

    public String toString() {
        CPStringBuilder cPStringBuilder = new CPStringBuilder("value-of");
        cPStringBuilder.append('[');
        cPStringBuilder.append("select=");
        cPStringBuilder.append(this.select);
        if (this.disableOutputEscaping) {
            cPStringBuilder.append(",disableOutputEscaping");
        }
        cPStringBuilder.append(']');
        return cPStringBuilder.toString();
    }
}

