/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.transform;

import gnu.java.lang.CPStringBuilder;
import gnu.xml.dom.DomDoctype;
import gnu.xml.dom.DomDocument;
import gnu.xml.dom.ls.WriterOutputStream;
import gnu.xml.transform.SAXSerializer;
import gnu.xml.transform.StreamSerializer;
import gnu.xml.transform.Stylesheet;
import gnu.xml.transform.TransformerFactoryImpl;
import gnu.xml.transform.TransformerOutputProperties;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownServiceException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

class TransformerImpl
extends Transformer {
    final TransformerFactoryImpl factory;
    final Stylesheet stylesheet;
    URIResolver uriResolver;
    ErrorListener errorListener;
    Properties outputProperties;
    static final String INDENT_WHITESPACE = "  ";

    TransformerImpl(TransformerFactoryImpl transformerFactoryImpl, Stylesheet stylesheet, Properties properties) throws TransformerConfigurationException {
        this.factory = transformerFactoryImpl;
        this.uriResolver = transformerFactoryImpl.userResolver;
        this.errorListener = transformerFactoryImpl.userListener;
        this.stylesheet = stylesheet;
        this.outputProperties = properties;
        if (stylesheet != null) {
            stylesheet.bindings.push(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void transform(Source var1_1, Result var2_2) throws TransformerException {
        var4_3 = this.factory.resolver;
        synchronized (var4_3) {
            this.factory.resolver.setUserResolver(this.uriResolver);
            this.factory.resolver.setUserListener(this.errorListener);
            var3_4 = this.factory.resolver.resolveDOM(var1_1, null, null);
        }
        var4_3 = var3_4.getNode();
        v0 = var5_6 = var4_3 instanceof Document != false ? (Document)var4_3 : var4_3.getOwnerDocument();
        if (var5_6 instanceof DomDocument) {
            ((DomDocument)var5_6).setBuilding(true);
        }
        var6_7 = null;
        var7_8 = null;
        if (var2_2 instanceof DOMResult) {
            var8_9 = (DOMResult)var2_2;
            var6_7 = var8_9.getNode();
            var7_8 = var8_9.getNextSibling();
            v1 = var9_11 = var6_7 instanceof Document != false ? (Document)var6_7 : var6_7.getOwnerDocument();
            if (var9_11 instanceof DomDocument) {
                var10_13 = (DomDocument)var9_11;
                var10_13.setBuilding(true);
                var10_13.setCheckWellformedness(false);
            }
        }
        var8_10 = false;
        if (this.stylesheet != null) {
            if (var6_7 == null) {
                var9_11 = new DomDocument();
                var9_11.setBuilding(true);
                var9_11.setCheckWellformedness(false);
                var6_7 = var9_11;
                var8_10 = true;
            }
            var4_3 = var4_3.cloneNode(true);
            TransformerImpl.strip(this.stylesheet, (Node)var4_3);
            try {
                ((TransformerOutputProperties)this.outputProperties).apply();
                this.stylesheet.initTopLevelVariables((Node)var4_3);
                var9_11 = this.stylesheet.getTemplate(null, (Node)var4_3, false);
                if (var9_11 == null) ** GOTO lbl71
                this.stylesheet.current = var4_3;
                var9_11.apply(this.stylesheet, null, (Node)var4_3, 1, 1, var6_7, var7_8);
            }
            catch (TransformerException var9_12) {
                if (var5_6 instanceof DomDocument) {
                    ((DomDocument)var5_6).setBuilding(false);
                }
                throw var9_12;
            }
        } else {
            var9_11 = var4_3.cloneNode(true);
            if (var4_3.getNodeType() != 9) {
                if (var6_7 == null) {
                    var11_15 = new DomDocument();
                    var11_15.setBuilding(true);
                    var11_15.setCheckWellformedness(false);
                    var10_13 = var11_15;
                    var6_7 = var10_13;
                    var8_10 = true;
                } else {
                    var10_13 = var6_7 instanceof Document != false ? (Document)var6_7 : var6_7.getOwnerDocument();
                }
                var11_15 = var4_3.getOwnerDocument();
                if (var11_15 != var10_13) {
                    var9_11 = var10_13.adoptNode((Node)var9_11);
                }
                if (var7_8 != null) {
                    var6_7.insertBefore((Node)var9_11, var7_8);
                } else {
                    var6_7.appendChild((Node)var9_11);
                }
            } else {
                var6_7 = var9_11;
                var8_10 = true;
            }
        }
lbl71:
        // 5 sources

        var9_11 = this.outputProperties.getProperty("method");
        var10_14 = "html".equals(var9_11) != false ? 1 : ("text".equals(var9_11) != false ? 2 : 0);
        var11_15 = this.outputProperties.getProperty("encoding");
        var12_16 = this.outputProperties.getProperty("doctype-public");
        var13_17 = this.outputProperties.getProperty("doctype-system");
        var14_18 = this.outputProperties.getProperty("version");
        var15_19 = "yes".equals(this.outputProperties.getProperty("omit-xml-declaration"));
        var16_20 = "yes".equals(this.outputProperties.getProperty("standalone"));
        var17_21 = this.outputProperties.getProperty("media-type");
        var18_22 = this.outputProperties.getProperty("cdata-section-elements");
        var19_23 = "yes".equals(this.outputProperties.getProperty("indent"));
        if (var8_10 && var6_7 instanceof DomDocument) {
            var20_24 = (DomDocument)var6_7;
            var21_25 = var20_24.getDocumentElement();
            if ((var12_16 != null || var13_17 != null) && var21_25 != null) {
                var22_27 = new DomDoctype((DomDocument)var20_24, var21_25.getNodeName(), var12_16, var13_17);
                var20_24.insertBefore((Node)var22_27, (Node)var21_25);
            }
            var20_24.setBuilding(false);
            var20_24.setCheckWellformedness(true);
        } else if (var12_16 != null || var13_17 != null) {
            switch (var6_7.getNodeType()) {
                case 9: 
                case 11: {
                    var20_24 = var6_7 instanceof Document != false ? (Document)var6_7 : var6_7.getOwnerDocument();
                    var21_25 = var20_24.getImplementation();
                    var22_27 = var20_24.getDocumentElement();
                    if (var22_27 == null) break;
                    var23_30 = var21_25.createDocumentType(var22_27.getNodeName(), var12_16, var13_17);
                    var20_24.insertBefore((Node)var23_30, (Node)var22_27);
                }
            }
        }
        if (var14_18 != null) {
            var6_7.setUserData("version", var14_18, this.stylesheet);
        }
        if (var15_19) {
            var6_7.setUserData("omit-xml-declaration", "yes", this.stylesheet);
        }
        if (var16_20) {
            var6_7.setUserData("standalone", "yes", this.stylesheet);
        }
        if (var17_21 != null) {
            var6_7.setUserData("media-type", var17_21, this.stylesheet);
        }
        if (var18_22 != null) {
            var20_24 = new LinkedList<T>();
            var21_25 = new StringTokenizer(var18_22);
            while (var21_25.hasMoreTokens()) {
                var23_30 = var22_27 = var21_25.nextToken();
                var24_32 = null;
                var25_33 = null;
                var26_34 = var22_27.indexOf(58);
                if (var26_34 != -1) {
                    var25_33 = var22_27.substring(0, var26_34);
                    var23_30 = var22_27.substring(var26_34 + 1);
                    var24_32 = this.stylesheet.output.lookupNamespaceURI(var25_33);
                }
                var20_24.add(new QName(var24_32, (String)var23_30, var25_33));
            }
            if (!var20_24.isEmpty()) {
                var22_27 = var6_7 instanceof Document != false ? (Document)var6_7 : var6_7.getOwnerDocument();
                this.convertCdataSectionElements((Document)var22_27, var6_7, (List)var20_24);
            }
        }
        if (var19_23) {
            if (var8_10 && var6_7 instanceof DomDocument) {
                var20_24 = (DomDocument)var6_7;
                var20_24.setBuilding(true);
                var20_24.setCheckWellformedness(false);
            }
            var6_7.normalize();
            if (this.stylesheet != null) {
                TransformerImpl.strip(this.stylesheet, var6_7);
            }
            var20_24 = var6_7 instanceof Document != false ? (Document)var6_7 : var6_7.getOwnerDocument();
            this.reindent((Document)var20_24, var6_7, 0);
            if (var8_10 && var6_7 instanceof DomDocument) {
                var21_25 = (DomDocument)var6_7;
                var21_25.setBuilding(false);
                var21_25.setCheckWellformedness(true);
            }
        }
        if (var2_2 instanceof DOMResult) {
            if (var8_10) {
                var20_24 = (DOMResult)var2_2;
                var20_24.setNode(var6_7);
                var20_24.setNextSibling(null);
            }
        } else if (var2_2 instanceof StreamResult) {
            var20_24 = (StreamResult)var2_2;
            var21_25 = null;
            try {
                this.writeStreamResult(var6_7, (StreamResult)var20_24, var10_14, (String)var11_15);
            }
            catch (UnsupportedEncodingException var22_28) {
                try {
                    this.writeStreamResult(var6_7, (StreamResult)var20_24, var10_14, "UTF-8");
                }
                catch (IOException var23_31) {
                    var21_25 = var23_31;
                }
            }
            catch (IOException var22_29) {
                var21_25 = var22_29;
            }
            if (var21_25 != null) {
                if (this.errorListener != null) {
                    this.errorListener.error(new TransformerException((Throwable)var21_25));
                } else {
                    var21_25.printStackTrace(System.err);
                }
            }
        } else if (var2_2 instanceof SAXResult) {
            var20_24 = (SAXResult)var2_2;
            try {
                var21_25 = var20_24.getHandler();
                var22_27 = var20_24.getLexicalHandler();
                if (var22_27 == null && var21_25 instanceof LexicalHandler) {
                    var22_27 = (LexicalHandler)var21_25;
                }
                var23_30 = new SAXSerializer();
                var23_30.serialize(var6_7, (ContentHandler)var21_25, (LexicalHandler)var22_27);
            }
            catch (SAXException var21_26) {
                if (this.errorListener != null) {
                    this.errorListener.error(new TransformerException(var21_26));
                }
                var21_26.printStackTrace(System.err);
            }
        }
    }

    static boolean strip(Stylesheet stylesheet, Node node2) throws TransformerConfigurationException {
        short s = node2.getNodeType();
        if (s == 5) {
            Node node3 = node2.getParentNode();
            Node node4 = node2.getNextSibling();
            Node node5 = node2.getFirstChild();
            while (node5 != null) {
                Node node6 = node5.getNextSibling();
                node2.removeChild(node5);
                if (node4 != null) {
                    node3.insertBefore(node5, node4);
                } else {
                    node3.appendChild(node5);
                }
                node5 = node6;
            }
            return true;
        }
        if (s == 3 || s == 4) {
            String string = node2.getNodeValue();
            String[] stringArray = TransformerImpl.tokenizeWhitespace(string);
            if (stringArray.length > 1) {
                node2.setNodeValue(stringArray[0]);
                Node node7 = node2.getParentNode();
                Node node8 = node2.getNextSibling();
                Document document = node2.getOwnerDocument();
                for (int i = 1; i < stringArray.length; ++i) {
                    Text text;
                    Text text2 = text = s == 4 ? document.createCDATASection(stringArray[i]) : document.createTextNode(stringArray[i]);
                    if (node8 != null) {
                        node7.insertBefore(text, node8);
                        continue;
                    }
                    node7.appendChild(text);
                }
            }
            return !stylesheet.isPreserved((Text)node2, true);
        }
        Node node9 = node2.getFirstChild();
        while (node9 != null) {
            boolean bl = TransformerImpl.strip(stylesheet, node9);
            Node node10 = node9.getNextSibling();
            if (bl) {
                node2.removeChild(node9);
            }
            node9 = node10;
        }
        return false;
    }

    private static String[] tokenizeWhitespace(String string) {
        boolean bl;
        int n;
        int n2;
        int n3 = string.length();
        int n4 = 0;
        int n5 = n3 - 1;
        for (n2 = 0; n2 < n3; ++n2) {
            n = string.charAt(n2);
            boolean bl2 = bl = n == 32 || n == 10 || n == 9 || n == 13;
            if (!bl) break;
            ++n4;
        }
        if (n4 == n5) {
            return new String[]{string};
        }
        for (n2 = n5; n2 > n4; --n2) {
            n = string.charAt(n2);
            boolean bl3 = bl = n == 32 || n == 10 || n == 9 || n == 13;
            if (!bl) break;
            --n5;
        }
        if (n4 == 0 && n5 == n3 - 1) {
            return new String[]{string};
        }
        String[] stringArray = n4 > 0 && n5 < n3 - 1 ? new String[3] : new String[2];
        n = 0;
        if (n4 > 0) {
            stringArray[n++] = string.substring(0, n4);
        }
        stringArray[n++] = string.substring(n4, n5 + 1);
        if (n5 < n3 - 1) {
            stringArray[n++] = string.substring(n5 + 1);
        }
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeStreamResult(Node node2, StreamResult streamResult, int n, String string) throws IOException {
        block18: {
            OutputStream outputStream = null;
            boolean bl = false;
            try {
                Object object;
                Object object2;
                outputStream = streamResult.getOutputStream();
                if (outputStream == null && (object2 = streamResult.getWriter()) != null) {
                    outputStream = new WriterOutputStream((Writer)object2);
                }
                if (outputStream == null) {
                    object2 = streamResult.getSystemId();
                    try {
                        object = new URL((String)object2);
                        URLConnection uRLConnection = ((URL)object).openConnection();
                        uRLConnection.setDoInput(false);
                        uRLConnection.setDoOutput(true);
                        outputStream = uRLConnection.getOutputStream();
                    }
                    catch (MalformedURLException malformedURLException) {
                        outputStream = new FileOutputStream((String)object2);
                    }
                    catch (UnknownServiceException unknownServiceException) {
                        URL uRL = new URL((String)object2);
                        outputStream = new FileOutputStream(uRL.getPath());
                    }
                    bl = true;
                }
                outputStream = new BufferedOutputStream(outputStream);
                object2 = new StreamSerializer(n, string, null);
                if (this.stylesheet != null) {
                    object = this.stylesheet.outputCdataSectionElements;
                    ((StreamSerializer)object2).setCdataSectionElements((Collection)object);
                }
                ((StreamSerializer)object2).serialize(node2, outputStream);
                outputStream.flush();
                Object var11_13 = null;
            }
            catch (Throwable throwable) {
                block19: {
                    Object var11_14 = null;
                    try {
                        if (outputStream != null && bl) {
                            outputStream.close();
                        }
                    }
                    catch (IOException iOException) {
                        if (this.errorListener != null) {
                            try {
                                this.errorListener.error(new TransformerException(iOException));
                            }
                            catch (TransformerException transformerException) {
                                transformerException.printStackTrace(System.err);
                            }
                            break block19;
                        }
                        iOException.printStackTrace(System.err);
                    }
                }
                throw throwable;
            }
            try {
                if (outputStream != null && bl) {
                    outputStream.close();
                }
            }
            catch (IOException iOException) {
                if (this.errorListener != null) {
                    try {
                        this.errorListener.error(new TransformerException(iOException));
                    }
                    catch (TransformerException transformerException) {
                        transformerException.printStackTrace(System.err);
                    }
                    break block18;
                }
                iOException.printStackTrace(System.err);
            }
        }
    }

    void copyChildren(Document document, Node node2, Node node3) {
        for (Node node4 = node2.getFirstChild(); node4 != null; node4 = node4.getNextSibling()) {
            Node node5 = document.adoptNode(node4);
            node3.appendChild(node5);
        }
    }

    public void setParameter(String string, Object object) {
        if (this.stylesheet != null) {
            this.stylesheet.bindings.set(new QName(null, string), object, 1);
        }
    }

    public Object getParameter(String string) {
        if (this.stylesheet != null) {
            return this.stylesheet.bindings.get(new QName(null, string), null, 1, 1);
        }
        return null;
    }

    public void clearParameters() {
        if (this.stylesheet != null) {
            this.stylesheet.bindings.pop(1);
            this.stylesheet.bindings.push(1);
        }
    }

    public void setURIResolver(URIResolver uRIResolver) {
        this.uriResolver = uRIResolver;
    }

    public URIResolver getURIResolver() {
        return this.uriResolver;
    }

    public void setOutputProperties(Properties properties) throws IllegalArgumentException {
        if (properties == null) {
            this.outputProperties.clear();
        } else {
            this.outputProperties.putAll(properties);
        }
    }

    public Properties getOutputProperties() {
        return (Properties)this.outputProperties.clone();
    }

    public void setOutputProperty(String string, String string2) throws IllegalArgumentException {
        this.outputProperties.put(string, string2);
    }

    public String getOutputProperty(String string) throws IllegalArgumentException {
        return this.outputProperties.getProperty(string);
    }

    public void setErrorListener(ErrorListener errorListener) {
        this.errorListener = errorListener;
    }

    public ErrorListener getErrorListener() {
        return this.errorListener;
    }

    void reindent(Document document, Node node2, int n) {
        if (node2.hasChildNodes()) {
            boolean bl = false;
            boolean bl2 = false;
            LinkedList linkedList = new LinkedList();
            for (Node node3 = node2.getFirstChild(); node3 != null; node3 = node3.getNextSibling()) {
                switch (node3.getNodeType()) {
                    case 1: 
                    case 7: 
                    case 10: {
                        bl = true;
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: 
                    case 8: {
                        bl2 = true;
                    }
                }
                linkedList.add(node3);
            }
            if (bl) {
                short s;
                if (bl2) {
                    // empty if block
                }
                if ((s = node2.getNodeType()) == 9) {
                    for (Node node3 : linkedList) {
                        this.reindent(document, node3, n);
                    }
                } else {
                    CPStringBuilder cPStringBuilder = new CPStringBuilder();
                    cPStringBuilder.append('\n');
                    for (int i = 0; i < n + 1; ++i) {
                        cPStringBuilder.append(INDENT_WHITESPACE);
                    }
                    String string = cPStringBuilder.toString();
                    for (Node node3 : linkedList) {
                        node2.insertBefore(document.createTextNode(string), node3);
                        this.reindent(document, node3, n + 1);
                    }
                    cPStringBuilder = new CPStringBuilder();
                    cPStringBuilder.append('\n');
                    for (int i = 0; i < n; ++i) {
                        cPStringBuilder.append(INDENT_WHITESPACE);
                    }
                    string = cPStringBuilder.toString();
                    node2.appendChild(document.createTextNode(string));
                }
            }
        }
    }

    void convertCdataSectionElements(Document document, Node node2, List list2) {
        if (node2.getNodeType() == 1) {
            Object object;
            boolean bl = false;
            Object object2 = list2.iterator();
            while (object2.hasNext()) {
                object = (QName)object2.next();
                if (!this.match((QName)object, node2)) continue;
                bl = true;
                break;
            }
            if (bl) {
                for (object2 = node2.getFirstChild(); object2 != null; object2 = object2.getNextSibling()) {
                    if (object2.getNodeType() != 3) continue;
                    object = document.createCDATASection(object2.getNodeValue());
                    node2.replaceChild((Node)object, (Node)object2);
                    object2 = object;
                }
            }
        }
        for (Node node3 = node2.getFirstChild(); node3 != null; node3 = node3.getNextSibling()) {
            if (!node3.hasChildNodes()) continue;
            this.convertCdataSectionElements(document, node3, list2);
        }
    }

    boolean match(QName qName, Node node2) {
        String string;
        String string2 = qName.getLocalPart();
        String string3 = node2.getLocalName();
        if (string3 == null) {
            return string2.equals(node2.getNodeName());
        }
        String string4 = qName.getNamespaceURI();
        return string4.equals(string = node2.getNamespaceURI()) && string2.equals(string3);
    }
}

