/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.transform;

import gnu.xml.dom.DomDocument;
import gnu.xml.transform.SAXTemplatesHandler;
import gnu.xml.transform.SAXTransformerHandler;
import gnu.xml.transform.Stylesheet;
import gnu.xml.transform.TemplatesImpl;
import gnu.xml.transform.TransformerImpl;
import gnu.xml.transform.TransformerOutputProperties;
import gnu.xml.transform.XSLURIResolver;
import gnu.xml.xpath.XPathFactoryImpl;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TemplatesHandler;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.XMLFilter;

public class TransformerFactoryImpl
extends SAXTransformerFactory {
    final XPathFactory xpathFactory = new XPathFactoryImpl();
    final XSLURIResolver resolver = new XSLURIResolver();
    ErrorListener userListener;
    URIResolver userResolver;

    public Transformer newTransformer(Source source) throws TransformerConfigurationException {
        TransformerImpl transformerImpl;
        Stylesheet stylesheet = this.newStylesheet(source, 0, null);
        TransformerOutputProperties transformerOutputProperties = new TransformerOutputProperties(stylesheet);
        stylesheet.transformer = transformerImpl = new TransformerImpl(this, stylesheet, transformerOutputProperties);
        return transformerImpl;
    }

    public Transformer newTransformer() throws TransformerConfigurationException {
        return new TransformerImpl(this, null, new Properties());
    }

    public Templates newTemplates(Source source) throws TransformerConfigurationException {
        Stylesheet stylesheet = this.newStylesheet(source, 0, null);
        return new TemplatesImpl(this, stylesheet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Stylesheet newStylesheet(Source source, int n, Stylesheet stylesheet) throws TransformerConfigurationException {
        Document document = null;
        String string = null;
        if (source != null) {
            try {
                DOMSource dOMSource;
                Object object = this.resolver;
                synchronized (object) {
                    this.resolver.setUserResolver(this.userResolver);
                    this.resolver.setUserListener(this.userListener);
                    dOMSource = this.resolver.resolveDOM(source, null, null);
                }
                object = dOMSource.getNode();
                if (object == null) {
                    throw new TransformerConfigurationException("no source document");
                }
                document = object instanceof Document ? (Document)object : object.getOwnerDocument();
                string = dOMSource.getSystemId();
            }
            catch (TransformerException transformerException) {
                throw new TransformerConfigurationException(transformerException);
            }
        }
        return new Stylesheet(this, stylesheet, document, string, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Source getAssociatedStylesheet(Source source, String string, String string2, String string3) throws TransformerConfigurationException {
        try {
            Object object;
            Object object2;
            Object object3;
            DOMSource dOMSource;
            Object object4 = this.resolver;
            synchronized (object4) {
                this.resolver.setUserResolver(this.userResolver);
                this.resolver.setUserListener(this.userListener);
                dOMSource = this.resolver.resolveDOM(source, null, null);
            }
            object4 = dOMSource.getNode();
            if (object4 == null) {
                throw new TransformerConfigurationException("no source document");
            }
            Document document = object4 instanceof Document ? (Document)object4 : object4.getOwnerDocument();
            LinkedList<Object> linkedList = new LinkedList<Object>();
            for (object4 = document.getFirstChild(); object4 != null; object4 = object4.getNextSibling()) {
                if (object4.getNodeType() != 7 || !"xml-stylesheet".equals(object4.getNodeName())) continue;
                object3 = this.parseParameters(object4.getNodeValue());
                if (string != null && !string.equals(object3.get("media")) || string2 != null && !string2.equals(object3.get("title")) || string3 != null && !string3.equals(object3.get("charset"))) continue;
                object2 = (String)object3.get("href");
                object = this.resolver.resolveURL(null, object4.getBaseURI(), (String)object2);
                linkedList.add(object);
            }
            switch (linkedList.size()) {
                case 0: {
                    return null;
                }
                case 1: {
                    return new StreamSource(((URL)linkedList.getFirst()).toString());
                }
            }
            object3 = new DomDocument();
            ((DomDocument)object3).setBuilding(true);
            object2 = ((DomDocument)object3).createElementNS("http://www.w3.org/1999/XSL/Transform", "stylesheet");
            object = ((DomDocument)object3).createAttributeNS(null, "version");
            object.setNodeValue("1.0");
            object2.getAttributes().setNamedItemNS((Node)object);
            ((DomDocument)object3).appendChild((Node)object2);
            for (URL uRL : linkedList) {
                Element element = ((DomDocument)object3).createElementNS("http://www.w3.org/1999/XSL/Transform", "import");
                Attr attr = ((DomDocument)object3).createAttributeNS(null, "href");
                attr.setNodeValue(uRL.toString());
                element.getAttributes().setNamedItemNS(attr);
                object2.appendChild(element);
            }
            ((DomDocument)object3).setBuilding(false);
            return new DOMSource((Node)object3);
        }
        catch (IOException iOException) {
            throw new TransformerConfigurationException(iOException);
        }
        catch (TransformerException transformerException) {
            throw new TransformerConfigurationException(transformerException);
        }
    }

    Map parseParameters(String string) {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        int n = string.length();
        String string2 = null;
        int n2 = 0;
        char c = '\u0000';
        for (int i = 0; i < n; ++i) {
            char c2 = string.charAt(i);
            if (c == '\u0000' && c2 == ' ') {
                if (string2 == null && n2 < i) {
                    string2 = string.substring(n2, i);
                } else {
                    String string3 = this.unquote(string.substring(n2, i).trim());
                    linkedHashMap.put(string2, string3);
                    string2 = null;
                }
                n2 = i + 1;
                continue;
            }
            if (c2 == '\"') {
                c = c == c2 ? (char)'\u0000' : c2;
                continue;
            }
            if (c2 != '\'') continue;
            c = c == c2 ? (char)'\u0000' : c2;
        }
        if (n2 < n && string2 != null) {
            String string4 = this.unquote(string.substring(n2, n).trim());
            linkedHashMap.put(string2, string4);
        }
        return linkedHashMap;
    }

    String unquote(String string) {
        int n = string.length() - 1;
        if (string.charAt(0) == '\'' && string.charAt(n) == '\'') {
            return string.substring(1, n);
        }
        if (string.charAt(0) == '\"' && string.charAt(n) == '\"') {
            return string.substring(1, n);
        }
        return string;
    }

    public void setURIResolver(URIResolver uRIResolver) {
        this.userResolver = uRIResolver;
    }

    public URIResolver getURIResolver() {
        return this.userResolver;
    }

    public void setFeature(String string, boolean bl) throws TransformerConfigurationException {
        throw new TransformerConfigurationException("not supported");
    }

    public boolean getFeature(String string) {
        return "http://javax.xml.transform.sax.SAXSource/feature".equals(string) || "http://javax.xml.transform.sax.SAXResult/feature".equals(string) || "http://javax.xml.transform.stream.StreamSource/feature".equals(string) || "http://javax.xml.transform.stream.StreamResult/feature".equals(string) || "http://javax.xml.transform.dom.DOMSource/feature".equals(string) || "http://javax.xml.transform.dom.DOMResult/feature".equals(string) || "http://javax.xml.transform.sax.SAXTransformerFactory/feature".equals(string);
    }

    public void setAttribute(String string, Object object) throws IllegalArgumentException {
        throw new IllegalArgumentException("not supported");
    }

    public Object getAttribute(String string) throws IllegalArgumentException {
        throw new IllegalArgumentException("not supported");
    }

    public void setErrorListener(ErrorListener errorListener) throws IllegalArgumentException {
        this.userListener = errorListener;
    }

    public ErrorListener getErrorListener() {
        return this.userListener;
    }

    public TemplatesHandler newTemplatesHandler() throws TransformerConfigurationException {
        return new SAXTemplatesHandler(this);
    }

    public TransformerHandler newTransformerHandler() throws TransformerConfigurationException {
        Transformer transformer2 = this.newTransformer();
        return new SAXTransformerHandler(this, transformer2);
    }

    public TransformerHandler newTransformerHandler(Source source) throws TransformerConfigurationException {
        Transformer transformer2 = this.newTransformer(source);
        return new SAXTransformerHandler(this, transformer2);
    }

    public TransformerHandler newTransformerHandler(Templates templates) throws TransformerConfigurationException {
        Transformer transformer2 = templates.newTransformer();
        return new SAXTransformerHandler(this, transformer2);
    }

    public XMLFilter newXMLFilter(Source source) throws TransformerConfigurationException {
        throw new UnsupportedOperationException();
    }

    public XMLFilter newXMLFilter(Templates templates) throws TransformerConfigurationException {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) throws Exception {
        OutputStream outputStream;
        InputStream inputStream;
        block12: {
            InputStream inputStream2 = null;
            inputStream = null;
            outputStream = null;
            try {
                if (stringArray.length > 0) {
                    inputStream2 = new FileInputStream(stringArray[0]);
                    if (stringArray.length > 1) {
                        inputStream = new FileInputStream(stringArray[1]);
                        if (stringArray.length > 2) {
                            outputStream = new FileOutputStream(stringArray[2]);
                        }
                    }
                }
                if (inputStream == null) {
                    inputStream = System.in;
                }
                if (outputStream == null) {
                    outputStream = System.out;
                }
                TransformerFactoryImpl transformerFactoryImpl = new TransformerFactoryImpl();
                Transformer transformer2 = inputStream2 != null ? ((TransformerFactory)transformerFactoryImpl).newTransformer(new StreamSource(inputStream2)) : ((TransformerFactory)transformerFactoryImpl).newTransformer();
                transformer2.transform(new StreamSource(inputStream), new StreamResult(outputStream));
                Object var7_6 = null;
                if (inputStream2 == null) break block12;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                if (inputStream2 != null) {
                    inputStream2.close();
                }
                if (inputStream != null && inputStream instanceof FileInputStream) {
                    inputStream.close();
                }
                if (outputStream != null && outputStream instanceof FileOutputStream) {
                    outputStream.close();
                }
                throw throwable;
            }
            inputStream2.close();
        }
        if (inputStream != null && inputStream instanceof FileInputStream) {
            inputStream.close();
        }
        if (outputStream != null && outputStream instanceof FileOutputStream) {
            outputStream.close();
        }
    }
}

