/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.transform;

import gnu.java.lang.CPStringBuilder;
import gnu.xml.transform.Stylesheet;
import gnu.xml.transform.TemplateNode;
import gnu.xml.xpath.Expr;
import java.util.Collections;
import javax.xml.namespace.QName;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ParameterNode
extends TemplateNode
implements Comparable<ParameterNode> {
    final QName name;
    final Expr select;
    final int type;

    ParameterNode(QName qName, Expr expr, int n) {
        this.name = qName;
        this.select = expr;
        this.type = n;
    }

    @Override
    ParameterNode clone(Stylesheet stylesheet) {
        ParameterNode parameterNode = new ParameterNode(this.name, this.select == null ? null : this.select.clone(stylesheet), this.type);
        if (this.children != null) {
            parameterNode.children = this.children.clone(stylesheet);
        }
        if (this.next != null) {
            parameterNode.next = this.next.clone(stylesheet);
        }
        return parameterNode;
    }

    @Override
    void doApply(Stylesheet stylesheet, QName qName, Node node2, int n, int n2, Node node3, Node node4) throws TransformerException {
        stylesheet.bindings.push(this.type);
        Object object = this.getValue(stylesheet, qName, node2, n, n2);
        if (object != null) {
            stylesheet.bindings.set(this.name, object, this.type);
            if (stylesheet.debug) {
                System.err.println(this + ": set to " + object);
            }
        }
        if (this.next != null) {
            this.next.apply(stylesheet, qName, node2, n, n2, node3, node4);
        }
        stylesheet.bindings.pop(this.type);
    }

    Object getValue(Stylesheet stylesheet, QName qName, Node node2, int n, int n2) throws TransformerException {
        if (this.select != null) {
            return this.select.evaluate(node2, n, n2);
        }
        if (this.children != null) {
            Document document = node2 instanceof Document ? (Document)node2 : node2.getOwnerDocument();
            DocumentFragment documentFragment = document.createDocumentFragment();
            this.children.apply(stylesheet, qName, node2, n, n2, documentFragment, null);
            return Collections.singleton(documentFragment);
        }
        return null;
    }

    @Override
    public boolean references(QName qName) {
        if (this.select != null && this.select.references(qName)) {
            return true;
        }
        return super.references(qName);
    }

    @Override
    public int compareTo(ParameterNode parameterNode) {
        boolean bl = this.references(parameterNode.name);
        boolean bl2 = parameterNode.references(this.name);
        if (bl && bl2) {
            throw new IllegalArgumentException("circular definitions");
        }
        if (bl) {
            return 1;
        }
        if (bl2) {
            return -1;
        }
        return 0;
    }

    public String toString() {
        CPStringBuilder cPStringBuilder = new CPStringBuilder();
        switch (this.type) {
            case 0: {
                cPStringBuilder.append("variable");
                break;
            }
            case 1: {
                cPStringBuilder.append("param");
                break;
            }
            case 2: {
                cPStringBuilder.append("with-param");
            }
        }
        cPStringBuilder.append('[');
        cPStringBuilder.append("name=");
        cPStringBuilder.append(this.name);
        cPStringBuilder.append(",select=");
        cPStringBuilder.append(this.select);
        cPStringBuilder.append(']');
        return cPStringBuilder.toString();
    }
}

