/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.transform;

import gnu.xml.transform.AbstractNumberNode;
import gnu.xml.transform.Stylesheet;
import gnu.xml.transform.TemplateNode;
import gnu.xml.xpath.Expr;
import gnu.xml.xpath.Pattern;
import gnu.xml.xpath.Selector;
import gnu.xml.xpath.UnionExpr;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Node;

final class NodeNumberNode
extends AbstractNumberNode {
    static final int SINGLE = 0;
    static final int MULTIPLE = 1;
    static final int ANY = 2;
    final int level;
    final Pattern count;
    final Pattern from;

    NodeNumberNode(int n, Pattern pattern2, Pattern pattern3, TemplateNode templateNode, String string, int n2, String string2, int n3) {
        super(templateNode, string, n2, string2, n3);
        this.level = n;
        this.count = pattern2;
        this.from = pattern3;
    }

    TemplateNode clone(Stylesheet stylesheet) {
        NodeNumberNode nodeNumberNode = new NodeNumberNode(this.level, this.count == null ? null : (Pattern)this.count.clone(stylesheet), this.from == null ? this.from : (Pattern)this.from.clone(stylesheet), this.format, this.lang, this.letterValue, this.groupingSeparator, this.groupingSize);
        if (this.children != null) {
            nodeNumberNode.children = this.children.clone(stylesheet);
        }
        if (this.next != null) {
            nodeNumberNode.next = this.next.clone(stylesheet);
        }
        return nodeNumberNode;
    }

    int[] compute(Stylesheet stylesheet, Node node2, int n, int n2) throws TransformerException {
        Node node3 = node2;
        switch (this.level) {
            case 0: {
                int[] nArray;
                if (this.from == null) {
                    while (node2 != null && !this.countMatches(node3, node2)) {
                        node2 = node2.getParentNode();
                    }
                } else {
                    while (node2 != null && !this.countMatches(node3, node2) && !this.fromMatches(node2)) {
                        node2 = node2.getParentNode();
                    }
                }
                if (node2 == null) {
                    nArray = new int[]{};
                } else {
                    int[] nArray2 = new int[1];
                    nArray = nArray2;
                    nArray2[0] = node2 == node3 ? n : this.getIndex(node3, node2);
                }
                return nArray;
            }
            case 1: {
                ArrayList<Node> arrayList = new ArrayList<Node>();
                while (node2 != null) {
                    if (this.countMatches(node3, node2) && (this.from == null || this.fromMatches(node2))) {
                        arrayList.add(node2);
                    }
                    node2 = node2.getParentNode();
                }
                Collections.sort(arrayList, documentOrderComparator);
                int[] nArray = new int[arrayList.size()];
                for (int i = 0; i < nArray.length; ++i) {
                    nArray[i] = this.getIndex(node3, (Node)arrayList.get(i));
                }
                return nArray;
            }
            case 2: {
                Selector selector = new Selector(10, Collections.EMPTY_LIST);
                Selector selector2 = new Selector(1, Collections.EMPTY_LIST);
                UnionExpr unionExpr = new UnionExpr(selector, selector2);
                Object object = ((Expr)unionExpr).evaluate(node2, n, n2);
                if (object instanceof Collection) {
                    Collection collection = (Collection)object;
                    ArrayList<Node> arrayList = new ArrayList<Node>();
                    for (Node node4 : collection) {
                        if (!this.countMatches(node3, node4)) continue;
                        arrayList.add(node4);
                        if (this.from == null || !this.from.matches(node4)) continue;
                        break;
                    }
                    return new int[]{arrayList.size()};
                }
                return new int[0];
            }
        }
        throw new TransformerException("invalid level");
    }

    boolean countMatches(Node node2, Node node3) {
        if (this.count == null) {
            short s;
            short s2 = node2.getNodeType();
            if (s2 != (s = node3.getNodeType())) {
                return false;
            }
            if (s == 1 || s == 2) {
                String string;
                String string2 = node2.getNamespaceURI();
                String string3 = node3.getNamespaceURI();
                if (string2 == null && string3 != null || string2 != null && !string2.equals(string3)) {
                    return false;
                }
                String string4 = node2.getLocalName();
                if (string4 == null) {
                    string4 = node2.getNodeName();
                }
                if ((string = node3.getLocalName()) == null) {
                    string = node3.getNodeName();
                }
                if (!string4.equals(string)) {
                    return false;
                }
            }
            return true;
        }
        return this.count.matches(node3);
    }

    boolean fromMatches(Node node2) {
        for (Node node3 = node2.getParentNode(); node3 != null; node3 = node3.getParentNode()) {
            if (!this.from.matches(node3)) continue;
            return true;
        }
        return false;
    }

    int getIndex(Node node2, Node node3) {
        int n = 0;
        while (true) {
            if ((node3 = node3.getPreviousSibling()) != null && !this.countMatches(node2, node3)) {
                continue;
            }
            ++n;
            if (node3 == null) break;
        }
        return n;
    }
}

