/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.stream;

import gnu.java.lang.CPStringBuilder;
import java.io.Writer;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public abstract class XMLEventImpl
implements XMLEvent {
    protected final Location location;

    protected XMLEventImpl(Location location) {
        this.location = location;
    }

    public abstract int getEventType();

    public Location getLocation() {
        return this.location;
    }

    public boolean isStartElement() {
        return this.getEventType() == 1;
    }

    public boolean isAttribute() {
        return this.getEventType() == 10;
    }

    public boolean isNamespace() {
        return this.getEventType() == 13;
    }

    public boolean isEndElement() {
        return this.getEventType() == 2;
    }

    public boolean isEntityReference() {
        return this.getEventType() == 9;
    }

    public boolean isProcessingInstruction() {
        return this.getEventType() == 3;
    }

    public boolean isCharacters() {
        int n = this.getEventType();
        return n == 4 || n == 12;
    }

    public boolean isStartDocument() {
        return this.getEventType() == 7;
    }

    public boolean isEndDocument() {
        return this.getEventType() == 8;
    }

    public StartElement asStartElement() {
        return (StartElement)((Object)this);
    }

    public EndElement asEndElement() {
        return (EndElement)((Object)this);
    }

    public Characters asCharacters() {
        return (Characters)((Object)this);
    }

    public QName getSchemaType() {
        return null;
    }

    public abstract void writeAsEncodedUnicode(Writer var1) throws XMLStreamException;

    protected String encode(String string, boolean bl) {
        int n = string.length();
        CPStringBuilder cPStringBuilder = null;
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '<') {
                if (cPStringBuilder == null) {
                    cPStringBuilder = new CPStringBuilder(string.substring(0, i));
                }
                cPStringBuilder.append("&lt;");
                continue;
            }
            if (c == '>') {
                if (cPStringBuilder == null) {
                    cPStringBuilder = new CPStringBuilder(string.substring(0, i));
                }
                cPStringBuilder.append("&gt;");
                continue;
            }
            if (c == '&') {
                if (cPStringBuilder == null) {
                    cPStringBuilder = new CPStringBuilder(string.substring(0, i));
                }
                cPStringBuilder.append("&amp;");
                continue;
            }
            if (c == '\'' && bl) {
                if (cPStringBuilder == null) {
                    cPStringBuilder = new CPStringBuilder(string.substring(0, i));
                }
                cPStringBuilder.append("&apos;");
                continue;
            }
            if (c == '\"' && bl) {
                if (cPStringBuilder == null) {
                    cPStringBuilder = new CPStringBuilder(string.substring(0, i));
                }
                cPStringBuilder.append("&quot;");
                continue;
            }
            if (cPStringBuilder == null) continue;
            cPStringBuilder.append(c);
        }
        return cPStringBuilder == null ? string : cPStringBuilder.toString();
    }
}

