/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.pipeline;

import gnu.xml.pipeline.EventConsumer;
import gnu.xml.pipeline.EventFilter;
import gnu.xml.util.Resolver;
import gnu.xml.util.XMLWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import java.net.URLConnection;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public final class CallFilter
implements EventConsumer {
    private Requestor req;
    private EventConsumer next;
    private URL target;
    private URLConnection conn;
    private ErrorHandler errHandler;

    public CallFilter(String string, EventConsumer eventConsumer) throws IOException {
        this.next = eventConsumer;
        this.req = new Requestor();
        this.setCallTarget(string);
    }

    public final void setCallTarget(String string) throws IOException {
        this.target = new URL(string);
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.req.setErrorHandler(errorHandler);
    }

    public final String getCallTarget() {
        return this.target.toString();
    }

    public final ContentHandler getContentHandler() {
        return this.req;
    }

    public final DTDHandler getDTDHandler() {
        return this.req;
    }

    public final Object getProperty(String string) throws SAXNotRecognizedException {
        if ("http://xml.org/sax/properties/declaration-handler".equals(string)) {
            return this.req;
        }
        if ("http://xml.org/sax/properties/lexical-handler".equals(string)) {
            return this.req;
        }
        throw new SAXNotRecognizedException(string);
    }

    ErrorHandler getErrorHandler() {
        return this.errHandler;
    }

    final class Requestor
    extends XMLWriter {
        Requestor() {
            super((Writer)null);
        }

        public synchronized void startDocument() throws SAXException {
            try {
                if (CallFilter.this.conn != null) {
                    throw new IllegalStateException("call is being made");
                }
                CallFilter.this.conn = CallFilter.this.target.openConnection();
                CallFilter.this.conn.setDoOutput(true);
                CallFilter.this.conn.setRequestProperty("Content-Type", "application/xml;charset=UTF-8");
                this.setWriter(new OutputStreamWriter(CallFilter.this.conn.getOutputStream(), "UTF8"), "UTF-8");
            }
            catch (IOException iOException) {
                this.fatal("can't write (POST) to URI: " + CallFilter.this.target, iOException);
            }
            super.startDocument();
        }

        public void endDocument() throws SAXException {
            super.endDocument();
            try {
                InputSource inputSource = new InputSource(CallFilter.this.conn.getInputStream());
                String string = Resolver.getEncoding(CallFilter.this.conn.getContentType());
                if (string != null) {
                    inputSource.setEncoding(string);
                }
                XMLReader xMLReader = XMLReaderFactory.createXMLReader();
                xMLReader.setErrorHandler(CallFilter.this.getErrorHandler());
                EventFilter.bind(xMLReader, CallFilter.this.next);
                xMLReader.parse(inputSource);
                CallFilter.this.conn = null;
            }
            catch (IOException iOException) {
                this.fatal("I/O Exception reading response, " + iOException.getMessage(), iOException);
            }
        }
    }
}

