/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.dom;

import gnu.xml.dom.Consumer;
import gnu.xml.dom.DomDocument;
import gnu.xml.dom.DomImpl;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public final class JAXPFactory
extends DocumentBuilderFactory {
    private static final String PROPERTY = "http://xml.org/sax/properties/";
    private static final String FEATURE = "http://xml.org/sax/features/";
    private SAXParserFactory pf;
    private boolean secureProcessing;

    public DocumentBuilder newDocumentBuilder() throws ParserConfigurationException {
        if (this.pf == null) {
            this.pf = new gnu.xml.aelfred2.JAXPFactory();
        }
        this.pf.setValidating(this.isValidating());
        this.pf.setNamespaceAware(this.isNamespaceAware());
        try {
            this.pf.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
            return new JAXPBuilder(this.pf.newSAXParser().getXMLReader(), this);
        }
        catch (SAXException sAXException) {
            String string = "can't create JAXP DocumentBuilder: " + sAXException.getMessage();
            throw new ParserConfigurationException(string);
        }
    }

    public void setAttribute(String string, Object object) throws IllegalArgumentException {
        if (!"http://java.sun.com/xml/jaxp/properties/schemaLanguage".equals(string)) {
            throw new IllegalArgumentException(string);
        }
    }

    public Object getAttribute(String string) throws IllegalArgumentException {
        throw new IllegalArgumentException(string);
    }

    public void setFeature(String string, boolean bl) throws ParserConfigurationException {
        if (string == null) {
            throw new NullPointerException();
        }
        if ("http://javax.xml.XMLConstants/feature/secure-processing".equals(string)) {
            this.secureProcessing = true;
            return;
        }
        throw new ParserConfigurationException(string);
    }

    public boolean getFeature(String string) throws ParserConfigurationException {
        if ("http://javax.xml.XMLConstants/feature/secure-processing".equals(string)) {
            return this.secureProcessing;
        }
        throw new ParserConfigurationException(string);
    }

    static final class JAXPBuilder
    extends DocumentBuilder
    implements ErrorHandler {
        private Consumer consumer;
        private XMLReader producer;
        private DomImpl impl = new DomImpl();

        JAXPBuilder(XMLReader xMLReader, JAXPFactory jAXPFactory) throws ParserConfigurationException {
            try {
                this.consumer = new Consumer();
            }
            catch (SAXException sAXException) {
                throw new ParserConfigurationException(sAXException.getMessage());
            }
            this.consumer.setHidingReferences(jAXPFactory.isExpandEntityReferences());
            this.consumer.setHidingComments(jAXPFactory.isIgnoringComments());
            this.consumer.setHidingWhitespace(jAXPFactory.isIgnoringElementContentWhitespace());
            this.consumer.setHidingCDATA(jAXPFactory.isCoalescing());
            this.producer = xMLReader;
            this.producer.setContentHandler(this.consumer.getContentHandler());
            this.producer.setDTDHandler(this.consumer.getDTDHandler());
            try {
                if (jAXPFactory.isValidating()) {
                    this.producer.setFeature("http://xml.org/sax/features/validation", true);
                    this.producer.setErrorHandler(this);
                }
                this.producer.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
                this.producer.setFeature("http://xml.org/sax/features/namespaces", jAXPFactory.isNamespaceAware());
                String string = "http://xml.org/sax/properties/lexical-handler";
                this.producer.setProperty(string, this.consumer.getProperty(string));
                string = "http://xml.org/sax/properties/declaration-handler";
                this.producer.setProperty(string, this.consumer.getProperty(string));
            }
            catch (SAXException sAXException) {
                throw new ParserConfigurationException(sAXException.getMessage());
            }
        }

        public Document parse(InputSource inputSource) throws SAXException, IOException {
            this.producer.parse(inputSource);
            Document document = this.consumer.getDocument();
            document.setDocumentURI(inputSource.getSystemId());
            return document;
        }

        public boolean isNamespaceAware() {
            try {
                return this.producer.getFeature("http://xml.org/sax/features/namespaces");
            }
            catch (SAXException sAXException) {
                throw new RuntimeException(sAXException.getMessage());
            }
        }

        public boolean isValidating() {
            try {
                return this.producer.getFeature("http://xml.org/sax/features/validation");
            }
            catch (SAXException sAXException) {
                throw new RuntimeException(sAXException.getMessage());
            }
        }

        public void setEntityResolver(EntityResolver entityResolver) {
            this.producer.setEntityResolver(entityResolver);
        }

        public void setErrorHandler(ErrorHandler errorHandler) {
            this.producer.setErrorHandler(errorHandler);
            this.consumer.setErrorHandler(errorHandler);
        }

        public DOMImplementation getDOMImplementation() {
            return this.impl;
        }

        public Document newDocument() {
            return new DomDocument();
        }

        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            throw sAXParseException;
        }

        public void error(SAXParseException sAXParseException) throws SAXException {
            throw sAXParseException;
        }

        public void warning(SAXParseException sAXParseException) throws SAXException {
        }
    }
}

