/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.dom;

import gnu.xml.dom.DomDOMException;
import java.util.Arrays;
import java.util.List;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.DOMErrorHandler;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMStringList;

class DomDocumentConfiguration
implements DOMConfiguration,
DOMStringList {
    private static final List SUPPORTED_PARAMETERS = Arrays.asList("cdata-sections", "comments", "element-content-whitespace", "entities", "error-handler", "namespace-declarations", "split-cdata-sections", "infoset");
    boolean cdataSections = true;
    boolean comments = true;
    boolean elementContentWhitespace = true;
    boolean entities = true;
    DOMErrorHandler errorHandler;
    boolean namespaceDeclarations = true;
    boolean splitCdataSections = true;

    DomDocumentConfiguration() {
    }

    public void setParameter(String string, Object object) throws DOMException {
        if ("cdata-sections".equals(string = string.toLowerCase())) {
            this.cdataSections = "true".equals(object.toString());
        } else if ("comments".equals(string)) {
            this.comments = "true".equals(object.toString());
        } else if ("element-content-whitespace".equals(string)) {
            this.elementContentWhitespace = "true".equals(object.toString());
        } else if ("entities".equals(string)) {
            this.entities = "true".equals(object.toString());
        } else if ("error-handler".equals(string)) {
            try {
                this.errorHandler = (DOMErrorHandler)object;
            }
            catch (ClassCastException classCastException) {
                throw new DomDOMException(17, object.getClass().getName(), null, 0);
            }
        } else if ("namespace-declarations".equals(string)) {
            this.namespaceDeclarations = "true".equals(object.toString());
        } else if ("split-cdata-sections".equals(string)) {
            this.comments = "true".equals(object.toString());
        } else if ("infoset".equals(string)) {
            if ("true".equals(object.toString())) {
                this.entities = false;
                this.cdataSections = false;
                this.namespaceDeclarations = true;
                this.elementContentWhitespace = true;
                this.comments = true;
            }
        } else if (!(("canonical-form".equals(string) || "check-character-normalization".equals(string) || "datatype-normalization".equals(string) || "normalize-characters".equals(string) || "validate".equals(string) || "validate-if-schema".equals(string)) && "false".equals(object.toString()) || ("namespaces".equals(string) || "well-formed".equals(string)) && "true".equals(object.toString()))) {
            throw new DomDOMException(9, string, null, 0);
        }
    }

    public Object getParameter(String string) throws DOMException {
        if ("cdata-sections".equals(string = string.toLowerCase())) {
            return this.cdataSections ? Boolean.TRUE : Boolean.FALSE;
        }
        if ("comments".equals(string)) {
            return this.comments ? Boolean.TRUE : Boolean.FALSE;
        }
        if ("element-content-whitespace".equals(string)) {
            return this.elementContentWhitespace ? Boolean.TRUE : Boolean.FALSE;
        }
        if ("entities".equals(string)) {
            return this.entities ? Boolean.TRUE : Boolean.FALSE;
        }
        if ("error-handler".equals(string)) {
            return this.errorHandler;
        }
        if ("namespace-declarations".equals(string)) {
            return this.namespaceDeclarations ? Boolean.TRUE : Boolean.FALSE;
        }
        if ("split-cdata-sections".equals(string)) {
            return this.comments ? Boolean.TRUE : Boolean.FALSE;
        }
        if ("canonical-form".equals(string) || "check-character-normalization".equals(string) || "datatype-normalization".equals(string) || "normalize-characters".equals(string) || "validate".equals(string) || "validate-if-schema".equals(string)) {
            return Boolean.FALSE;
        }
        if ("namespaces".equals(string) || "well-formed".equals(string)) {
            return Boolean.TRUE;
        }
        if ("infoset".equals(string)) {
            return !this.entities && !this.cdataSections && this.namespaceDeclarations && this.comments ? Boolean.TRUE : Boolean.FALSE;
        }
        throw new DomDOMException(9, string, null, 0);
    }

    public boolean canSetParameter(String string, Object object) {
        if ("error-handler".equals(string = string.toLowerCase())) {
            return object == null || object instanceof DOMErrorHandler;
        }
        if (this.contains(string)) {
            return true;
        }
        if ("canonical-form".equals(string) || "check-character-normalization".equals(string) || "datatype-normalization".equals(string) || "normalize-characters".equals(string) || "validate".equals(string) || "validate-if-schema".equals(string)) {
            return "false".equals(object.toString());
        }
        if ("namespaces".equals(string) || "well-formed".equals(string)) {
            return "true".equals(object.toString());
        }
        return false;
    }

    public DOMStringList getParameterNames() {
        return this;
    }

    public String item(int n) {
        try {
            return (String)SUPPORTED_PARAMETERS.get(n);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return null;
        }
    }

    public int getLength() {
        return SUPPORTED_PARAMETERS.size();
    }

    public boolean contains(String string) {
        string = string.toLowerCase();
        return SUPPORTED_PARAMETERS.contains(string);
    }
}

