/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.dom;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSException;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSParser;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

class DomDocumentBuilder
extends DocumentBuilder {
    final DOMImplementation impl;
    final DOMImplementationLS ls;
    final LSParser parser;

    DomDocumentBuilder(DOMImplementation dOMImplementation, DOMImplementationLS dOMImplementationLS, LSParser lSParser) {
        this.impl = dOMImplementation;
        this.ls = dOMImplementationLS;
        this.parser = lSParser;
    }

    public boolean isNamespaceAware() {
        DOMConfiguration dOMConfiguration = this.parser.getDomConfig();
        return (Boolean)dOMConfiguration.getParameter("namespaces");
    }

    public boolean isValidating() {
        DOMConfiguration dOMConfiguration = this.parser.getDomConfig();
        return (Boolean)dOMConfiguration.getParameter("validating");
    }

    public boolean isXIncludeAware() {
        DOMConfiguration dOMConfiguration = this.parser.getDomConfig();
        return (Boolean)dOMConfiguration.getParameter("xinclude-aware");
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        DOMConfiguration dOMConfiguration = this.parser.getDomConfig();
        dOMConfiguration.setParameter("entity-resolver", entityResolver);
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        DOMConfiguration dOMConfiguration = this.parser.getDomConfig();
        dOMConfiguration.setParameter("error-handler", errorHandler);
    }

    public DOMImplementation getDOMImplementation() {
        return this.impl;
    }

    public Document newDocument() {
        return this.impl.createDocument(null, null, null);
    }

    public Document parse(InputStream inputStream) throws SAXException, IOException {
        LSInput lSInput = this.ls.createLSInput();
        lSInput.setByteStream(inputStream);
        try {
            return this.parser.parse(lSInput);
        }
        catch (LSException lSException) {
            Throwable throwable = lSException.getCause();
            if (throwable instanceof IOException) {
                throw (IOException)throwable;
            }
            throw lSException;
        }
    }

    public Document parse(InputStream inputStream, String string) throws SAXException, IOException {
        LSInput lSInput = this.ls.createLSInput();
        lSInput.setByteStream(inputStream);
        lSInput.setSystemId(string);
        try {
            return this.parser.parse(lSInput);
        }
        catch (LSException lSException) {
            Throwable throwable = lSException.getCause();
            if (throwable instanceof IOException) {
                throw (IOException)throwable;
            }
            throw lSException;
        }
    }

    public Document parse(String string) throws SAXException, IOException {
        try {
            return this.parser.parseURI(string);
        }
        catch (LSException lSException) {
            Throwable throwable = lSException.getCause();
            if (throwable instanceof IOException) {
                throw (IOException)throwable;
            }
            throw lSException;
        }
    }

    public Document parse(InputSource inputSource) throws SAXException, IOException {
        Serializable serializable;
        LSInput lSInput = this.ls.createLSInput();
        String string = inputSource.getSystemId();
        InputStream inputStream = inputSource.getByteStream();
        if (inputStream != null) {
            lSInput.setByteStream(inputStream);
        } else {
            Reader reader = inputSource.getCharacterStream();
            if (reader != null) {
                lSInput.setCharacterStream(reader);
            } else {
                try {
                    serializable = new URL(string);
                    lSInput.setByteStream(serializable.openStream());
                }
                catch (MalformedURLException malformedURLException) {
                    File file = new File(System.getProperty("user.dir"));
                    URL uRL = new URL(file.toURL(), string);
                    lSInput.setByteStream(uRL.openStream());
                }
            }
        }
        lSInput.setPublicId(inputSource.getPublicId());
        lSInput.setSystemId(string);
        lSInput.setEncoding(inputSource.getEncoding());
        try {
            return this.parser.parse(lSInput);
        }
        catch (LSException lSException) {
            serializable = lSException.getCause();
            if (serializable instanceof IOException) {
                throw (IOException)serializable;
            }
            throw lSException;
        }
    }
}

