/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.dom;

import org.w3c.dom.DOMException;
import org.w3c.dom.Node;

public class DomDOMException
extends DOMException {
    private String data;
    private Node node;
    private int value;

    public DomDOMException(short s) {
        super(s, DomDOMException.diagnostic(s));
    }

    public DomDOMException(short s, String string, Node node2, int n) {
        super(s, DomDOMException.diagnostic(s));
        this.data = string;
        this.node = node2;
        this.value = n;
    }

    public final Node getNode() {
        return this.node;
    }

    public final String getData() {
        return this.data;
    }

    public final int getValue() {
        return this.value;
    }

    public String getMessage() {
        String string = super.getMessage();
        if (this.data != null) {
            string = string + "\nMore Information: " + this.data;
        }
        if (this.value != 0) {
            string = string + "\nNumber: " + this.value;
        }
        if (this.node != null) {
            string = string + "\nNode Name: " + this.node.getNodeName();
        }
        return string;
    }

    private static String diagnostic(short s) {
        switch (s) {
            case 1: {
                return "An index or size is out of range.";
            }
            case 2: {
                return "A string is too big.";
            }
            case 3: {
                return "The node doesn't belong here.";
            }
            case 4: {
                return "The node belongs in another document.";
            }
            case 5: {
                return "That character is not permitted.";
            }
            case 6: {
                return "This node does not permit data.";
            }
            case 7: {
                return "No changes are allowed.";
            }
            case 8: {
                return "The node was not found in that context.";
            }
            case 9: {
                return "That object is not supported.";
            }
            case 10: {
                return "The attribute belongs to a different element.";
            }
            case 11: {
                return "The object is not usable.";
            }
            case 12: {
                return "An illegal string was provided.";
            }
            case 13: {
                return "An object's type may not be changed.";
            }
            case 14: {
                return "The operation violates XML Namespaces.";
            }
            case 15: {
                return "Parameter or operation isn't supported by this node.";
            }
            case 17: {
                return "The type of the argument is incompatible with the expected type.";
            }
        }
        return "Reserved exception number: " + s;
    }
}

