/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.swing.text.html.parser.support;

import gnu.java.lang.CPStringBuilder;
import gnu.javax.swing.text.html.parser.HTML_401F;
import gnu.javax.swing.text.html.parser.htmlAttributeSet;
import gnu.javax.swing.text.html.parser.htmlValidator;
import gnu.javax.swing.text.html.parser.support.low.ParseException;
import gnu.javax.swing.text.html.parser.support.low.ReaderTokenizer;
import gnu.javax.swing.text.html.parser.support.low.Token;
import gnu.javax.swing.text.html.parser.support.low.node;
import gnu.javax.swing.text.html.parser.support.low.pattern;
import gnu.javax.swing.text.html.parser.support.parameterDefaulter;
import gnu.javax.swing.text.html.parser.support.textPreProcessor;
import java.io.IOException;
import java.io.Reader;
import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.text.ChangedCharSetException;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.html.HTML;
import javax.swing.text.html.parser.AttributeList;
import javax.swing.text.html.parser.DTD;
import javax.swing.text.html.parser.DTDConstants;
import javax.swing.text.html.parser.Element;
import javax.swing.text.html.parser.Entity;
import javax.swing.text.html.parser.TagElement;

public class Parser
extends ReaderTokenizer
implements DTDConstants {
    public Token hTag = new Token();
    protected DTD dtd;
    protected boolean strict;
    protected int preformatted = 0;
    private Set documentTags = new TreeSet(new Comparator(){

        public int compare(Object object, Object object2) {
            return ((String)object).compareToIgnoreCase((String)object2);
        }
    });
    private final StringBuffer buffer = new StringBuffer();
    private final StringBuffer title = new StringBuffer();
    private Token t;
    private boolean titleHandled;
    private boolean titleOpen;
    htmlAttributeSet attributes = htmlAttributeSet.EMPTY_HTML_ATTRIBUTE_SET;
    private htmlValidator validator;
    private parameterDefaulter defaulter;
    private textPreProcessor textProcessor = new textPreProcessor();

    public Parser(DTD dTD) {
        this.dtd = dTD == null ? HTML_401F.getInstance() : dTD;
        this.defaulter = new parameterDefaulter(this.dtd);
        this.validator = new htmlValidator(this.dtd){

            protected void s_error(String string) {
                Parser.this.error(string);
            }

            protected void handleSupposedEndTag(Element element) {
                TagElement tagElement = Parser.this.makeTag(element, true);
                Parser.this._handleEndTag_remaining(tagElement);
            }

            protected void handleSupposedStartTag(Element element) {
                TagElement tagElement = Parser.this.makeTag(element, true);
                htmlAttributeSet htmlAttributeSet2 = Parser.this.attributes;
                Parser.this.attributes = htmlAttributeSet.EMPTY_HTML_ATTRIBUTE_SET;
                Parser.this._handleStartTag(tagElement);
                Parser.this.attributes = htmlAttributeSet2;
            }
        };
    }

    public SimpleAttributeSet getAttributes() {
        return new SimpleAttributeSet(this.attributes);
    }

    public void error(String string) {
        this.error(string, this.getTokenAhead());
    }

    public void error(String string, Token token) {
        if (token != null) {
            this.handleError(token.where.beginLine, string + ": line " + token.where.beginLine + ", absolute pos " + token.where.startPosition);
        } else {
            this.handleError(0, string);
        }
    }

    public void error(String string, String string2) {
        this.error(string + ": '" + string2 + "'");
    }

    public void error(String string, String string2, String string3) {
        this.error(string + " " + string2 + " " + string3);
    }

    public void error(String string, String string2, String string3, String string4) {
        this.error(string + " " + string2 + " " + string3 + " " + string4);
    }

    public void flushAttributes() {
    }

    public synchronized void parse(Reader reader) throws IOException {
        block2: {
            this.reset(reader);
            this.restart();
            try {
                this.parseDocument();
                this.validator.closeAll();
            }
            catch (ParseException parseException) {
                if (parseException == null) break block2;
                this.error("Unable to continue parsing the document", parseException.getMessage());
                Throwable throwable = parseException.getCause();
                if (!(throwable instanceof IOException)) break block2;
                throw (IOException)throwable;
            }
        }
    }

    public String parseDTDMarkup() throws IOException {
        return null;
    }

    public boolean parseMarkupDeclarations(StringBuffer stringBuffer) throws IOException {
        return false;
    }

    protected int getCurrentLine() {
        return this.hTag.where.beginLine;
    }

    protected void CDATA(boolean bl) throws ParseException {
        Token token = this.hTag = this.getTokenAhead();
        if (bl) {
            this.buffer.setLength(0);
        }
        if (token.kind == 3) {
            return;
        }
        while (true) {
            this.t = this.getTokenAhead();
            if (this.t.kind == 3) {
                this.error("unexpected eof", this.t);
                break;
            }
            if (this.t.kind == 60) break;
            if (this.t.kind == 1004) {
                this.resolveAndAppendEntity(this.t);
                this.getNextToken();
                continue;
            }
            this.append(this.t);
            this.getNextToken();
        }
        this.hTag = new Token(token, this.getTokenAhead(0));
        if (this.buffer.length() != 0) {
            this._handleText();
        }
    }

    protected void Comment() throws ParseException {
        Token token;
        this.buffer.setLength(0);
        Token token2 = this.hTag = this.mustBe(60);
        this.optional(1003);
        this.mustBe(33);
        this.optional(1003);
        this.mustBe(1000);
        while (true) {
            Token token3 = this.getTokenAhead();
            if (token3.kind == 3) {
                this.handleEOFInComment();
                token = token3;
                break;
            }
            if (COMMENT_END.matches(this)) {
                this.mustBe(1000);
                this.optional(1003);
                token = this.mustBe(62);
                break;
            }
            if (COMMENT_TRIPLEDASH_END.matches(this)) {
                this.mustBe(1000);
                token3 = this.mustBe(1005);
                if (token3.getImage().equals("-")) {
                    this.append(token3);
                    token = this.mustBe(62);
                    break;
                }
                this.buffer.append("--");
                this.append(token3);
                token3 = this.getTokenAhead();
            } else {
                if (token3.getImage().endsWith("--") && (this.getTokenAhead((int)1).kind == 62 || this.getTokenAhead((int)1).kind == 1003 && this.getTokenAhead((int)2).kind == 62)) {
                    this.buffer.append(token3.getImage().substring(0, token3.getImage().length() - 2));
                    token = this.mustBe(token3.kind);
                    break;
                }
                this.append(token3);
            }
            this.mustBe(token3.kind);
        }
        this.hTag = new Token(token2, token);
        this.optional(1003);
        this.handleComment();
    }

    protected void Script() throws ParseException {
        Token token = this.hTag = this.mustBe(60);
        this.optional(1003);
        Token token2 = this.mustBe(1002);
        this.optional(1003);
        this.restOfTag(false, token2, token);
        this.buffer.setLength(0);
        while (!SCRIPT_CLOSE.matches(this)) {
            this.append(this.getNextToken());
        }
        this.consume(SCRIPT_CLOSE);
        this._handleText();
        this.endTag(false);
        this._handleEndTag(this.makeTagElement(token2.getImage(), false));
    }

    protected void Sgml() throws ParseException {
        if (COMMENT_OPEN.matches(this)) {
            this.Comment();
        } else {
            Token token = this.hTag = this.mustBe(60);
            this.optional(1003);
            this.mustBe(33);
            this.buffer.setLength(0);
            while (true) {
                this.t = this.getNextToken();
                if (this.t.kind == 1004) {
                    this.resolveAndAppendEntity(this.t);
                    continue;
                }
                if (this.t.kind == 3) {
                    this.error("unexpected eof", this.t);
                    break;
                }
                if (this.t.kind == 62) break;
                this.append(this.t);
            }
            try {
                this.parseMarkupDeclarations(this.buffer);
            }
            catch (IOException iOException) {
                this.error("Unable to parse SGML insertion: '" + this.buffer + "'", new Token(token, this.t));
            }
        }
        this.optional(1003);
    }

    protected void Style() throws ParseException {
        Token token = this.hTag = this.mustBe(60);
        this.optional(1003);
        Token token2 = this.mustBe(1001);
        this.optional(1003);
        this.restOfTag(false, token2, token);
        this.buffer.setLength(0);
        while (!STYLE_CLOSE.matches(this)) {
            this.append(this.getNextToken());
        }
        this.consume(STYLE_CLOSE);
        this._handleText();
        this.endTag(false);
        this._handleEndTag(this.makeTagElement(token2.getImage(), false));
    }

    protected void Tag() throws ParseException {
        this.mark(true);
        boolean bl = false;
        Token token = this.hTag = this.mustBe(60);
        this.optional(1003);
        Token token2 = this.getNextToken();
        this.optional(1003);
        if (token2.kind == 47) {
            bl = true;
            token2 = this.getNextToken();
        }
        this.restOfTag(bl, token2, token);
    }

    protected void _handleText() {
        char[] cArray = this.preformatted > 0 ? this.textProcessor.preprocessPreformatted(this.buffer) : this.textProcessor.preprocess(this.buffer);
        if (!(cArray == null || cArray.length <= 0 || cArray.length <= 1 && cArray[0] == ' ' && TAG_CLOSE.matches(this))) {
            TagElement tagElement = new TagElement(this.dtd.getElement("#pcdata"));
            this.attributes = htmlAttributeSet.EMPTY_HTML_ATTRIBUTE_SET;
            this._handleEmptyTag(tagElement);
            this.handleText(cArray);
            if (this.titleOpen) {
                this.title.append(cArray);
            }
        }
    }

    protected final void append(Token token) {
        if (token.kind != 3) {
            token.appendTo(this.buffer);
        }
    }

    protected final void consume(pattern pattern2) {
        for (int i = 0; i < pattern2.nodes.length; ++i) {
            node node2 = pattern2.nodes[i];
            if (node2.optional) {
                this.optional(node2.kind);
                continue;
            }
            this.mustBe(node2.kind);
        }
    }

    protected void endTag(boolean bl) {
    }

    protected void handleComment(char[] cArray) {
    }

    protected void handleEOFInComment() {
        this.error("Unclosed comment");
    }

    protected void handleEmptyTag(TagElement tagElement) throws ChangedCharSetException {
    }

    protected void handleEndTag(TagElement tagElement) {
    }

    protected void handleError(int n, String string) {
    }

    protected void handleStartTag(TagElement tagElement) {
    }

    protected void handleText(char[] cArray) {
    }

    protected void handleTitle(char[] cArray) {
    }

    protected TagElement makeTag(Element element) {
        return this.makeTag(element, false);
    }

    protected TagElement makeTag(Element element, boolean bl) {
        return new TagElement(element, bl);
    }

    protected void markFirstTime(Element element) {
    }

    protected Token mustBe(int n) {
        if (this.getTokenAhead().kind == n) {
            return this.getNextToken();
        }
        String string = "";
        if (n < 1000) {
            string = " ('" + (char)n + "') ";
        }
        throw new AssertionError((Object)("The token of kind " + n + string + " MUST be here,"));
    }

    protected void noValueAttribute(String string, String string2) {
        Vector<?> vector;
        AttributeList attributeList;
        String string3 = "#DEFAULT";
        Element element = this.dtd.elementHash.get(string.toLowerCase());
        if (element != null && (attributeList = element.getAttribute(string2)) != null && (vector = attributeList.values) != null && vector.size() == 1) {
            string3 = vector.get(0);
        }
        this.attributes.addAttribute(string2, string3);
    }

    protected Token optional(int n) {
        if (this.getTokenAhead().kind == n) {
            return this.getNextToken();
        }
        return null;
    }

    protected void parseDocument() throws ParseException {
        this.optional(1003);
        while (this.getTokenAhead().kind != 3) {
            this.advanced = false;
            if (TAG.matches(this)) {
                this.Tag();
            } else if (COMMENT_OPEN.matches(this)) {
                this.Comment();
            } else if (STYLE_OPEN.matches(this)) {
                this.Style();
            } else if (SCRIPT_OPEN.matches(this)) {
                this.Script();
            } else if (SGML.matches(this)) {
                this.Sgml();
            } else {
                this.CDATA(true);
            }
            if (this.advanced) continue;
            Token token = this.getNextToken();
            this.error("unexpected '" + token.getImage() + "'", token);
            this.buffer.setLength(0);
            this.buffer.append(token.getImage());
            this._handleText();
        }
    }

    protected void readAttributes(String string) {
        this.attributes = new htmlAttributeSet();
        this.optional(1003);
        block6: while (this.getTokenAhead().kind == 1005) {
            Token token = this.getNextToken();
            this.optional(1003);
            Token token2 = this.getTokenAhead();
            if (token2.kind == 61) {
                String string2;
                this.mustBe(61);
                this.optional(1003);
                token2 = this.getNextToken();
                switch (token2.kind) {
                    case 34: {
                        this.buffer.setLength(0);
                        this.readTillTokenE(34);
                        string2 = this.buffer.toString();
                        break;
                    }
                    case 39: {
                        this.buffer.setLength(0);
                        this.readTillTokenE(39);
                        string2 = this.buffer.toString();
                        break;
                    }
                    case 1005: {
                        CPStringBuilder cPStringBuilder;
                        Token token3 = token2;
                        this.optional(1003);
                        token2 = this.getTokenAhead();
                        if (bQUOTING.get(token2.kind)) {
                            this.hTag = token2;
                            this.error("The value without opening quote is closed with '" + token2.getImage() + "'");
                            string2 = token3.getImage();
                            break;
                        }
                        if (token2.kind == 47 || token2.kind == 1999) {
                            cPStringBuilder = new CPStringBuilder(token3.getImage());
                            while (token2.kind == 1005 || token2.kind == 47 || token2.kind == 1999) {
                                cPStringBuilder.append(this.getNextToken().getImage());
                                token2 = this.getTokenAhead();
                            }
                            string2 = cPStringBuilder.toString();
                            break;
                        }
                        string2 = token3.getImage();
                        break;
                    }
                    case 47: {
                        CPStringBuilder cPStringBuilder;
                        Token token3 = token2;
                        this.optional(1003);
                        token2 = this.getTokenAhead();
                        if (bQUOTING.get(token2.kind)) {
                            this.hTag = token2;
                            this.error("The value without opening quote is closed with '" + token2.getImage() + "'");
                            string2 = token3.getImage();
                            break;
                        }
                        if (token2.kind == 1005 || token2.kind == 47) {
                            cPStringBuilder = new CPStringBuilder(token3.getImage());
                            while (token2.kind == 1005 || token2.kind == 47) {
                                cPStringBuilder.append(this.getNextToken().getImage());
                                token2 = this.getTokenAhead();
                            }
                            string2 = cPStringBuilder.toString();
                            break;
                        }
                        string2 = token3.getImage();
                        break;
                    }
                    default: {
                        break block6;
                    }
                }
                this.attributes.addAttribute(token.getImage(), string2);
                this.optional(1003);
                continue;
            }
            this.noValueAttribute(string, token.getImage());
        }
    }

    protected String resolveNamedEntity(String string) {
        if (!string.startsWith("&")) {
            throw new AssertionError((Object)("Named entity " + string + " must start witn '&'."));
        }
        String string2 = string.substring(1);
        try {
            Entity entity = this.dtd.getEntity(string2);
            if (entity != null) {
                return entity.getString();
            }
            entity = this.dtd.getEntity(string2.toLowerCase());
            if (entity != null) {
                this.error("The name of this entity should be in lowercase", string);
                return entity.getString();
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        this.error("Unknown named entity", string);
        return string;
    }

    protected char resolveNumericEntity(String string) {
        if (!string.startsWith("&#")) {
            throw new AssertionError((Object)("Numeric entity " + string + " must start witn '&#'."));
        }
        String string2 = string.substring(2);
        try {
            char c = string2.charAt(0);
            if (c == 'x' || c == 'X') {
                return (char)Integer.parseInt(string2.substring(1), 16);
            }
            return (char)Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        this.error("Invalid numeric entity", string);
        return '?';
    }

    protected void restart() {
        this.documentTags.clear();
        this.titleHandled = false;
        this.titleOpen = false;
        this.buffer.setLength(0);
        this.title.setLength(0);
        this.validator.restart();
    }

    protected void startTag(TagElement tagElement) throws ChangedCharSetException {
    }

    private void _handleCompleteElement(TagElement tagElement) {
        this._handleStartTag(tagElement);
        HTML.Tag tag = tagElement.getHTMLTag();
        if (tag == HTML.Tag.SCRIPT || tag == HTML.Tag.STYLE) {
            boolean bl = this.titleOpen;
            this.titleOpen = false;
            this._handleText();
            this.titleOpen = bl;
        } else {
            this._handleText();
        }
        this._handleEndTag(tagElement);
    }

    private void _handleEmptyTag(TagElement tagElement) {
        try {
            this.validator.validateTag(tagElement, this.attributes);
            this.handleEmptyTag(tagElement);
            HTML.Tag tag = tagElement.getHTMLTag();
            if (this.isBlock(tag)) {
                this.optional(1003);
            }
        }
        catch (ChangedCharSetException changedCharSetException) {
            this.error("Changed charset exception:", changedCharSetException.getMessage());
        }
    }

    private void _handleEndTag(TagElement tagElement) {
        if (this.validator.closeTag(tagElement)) {
            this._handleEndTag_remaining(tagElement);
        }
    }

    void _handleEndTag_remaining(TagElement tagElement) {
        HTML.Tag tag = tagElement.getHTMLTag();
        this.handleEndTag(tagElement);
        this.endTag(tagElement.fictional());
        if (tag.isPreformatted()) {
            --this.preformatted;
        }
        if (this.preformatted < 0) {
            this.preformatted = 0;
        }
        if (this.isBlock(tag)) {
            this.optional(1003);
        }
        if (tag == HTML.Tag.TITLE) {
            this.titleOpen = false;
            this.titleHandled = true;
            char[] cArray = new char[this.title.length()];
            this.title.getChars(0, cArray.length, cArray, 0);
            this.handleTitle(cArray);
        }
    }

    void _handleStartTag(TagElement tagElement) {
        this.validator.openTag(tagElement, this.attributes);
        this.startingTag(tagElement);
        this.handleStartTag(tagElement);
        HTML.Tag tag = tagElement.getHTMLTag();
        if (this.isBlock(tag)) {
            this.optional(1003);
        }
        if (tag.isPreformatted()) {
            ++this.preformatted;
        }
        if (tag == HTML.Tag.TITLE) {
            if (this.titleHandled) {
                this.error("Repetetive <TITLE> tag");
            }
            this.titleOpen = true;
            this.titleHandled = false;
        }
    }

    private void forciblyCloseTheTag() throws ParseException {
        int n;
        int n2 = 0;
        this.buffer.setLength(0);
        for (n = 1; n < 100; ++n) {
            this.t = this.getTokenAhead(n - 1);
            if (this.t.kind == 3 || this.t.kind == 60) break;
            if (this.t.kind != 62) continue;
            n2 = n;
            break;
        }
        if (n2 > 0) {
            this.buffer.append("Ignoring '");
            for (n = 1; n <= n2; ++n) {
                this.t = this.getNextToken();
                this.append(this.t);
            }
            this.buffer.append('\'');
            this.error(this.buffer.toString());
        }
    }

    private void handleComment() {
        char[] cArray = new char[this.buffer.length()];
        this.buffer.getChars(0, cArray.length, cArray, 0);
        this.handleComment(cArray);
    }

    private TagElement makeTagElement(String string, boolean bl) {
        Element element = this.dtd.elementHash.get(string.toLowerCase());
        if (element == null) {
            this.error("Unknown tag <" + string + ">");
            element = this.dtd.getElement(string);
            element.name = string.toUpperCase();
            element.index = -1;
        }
        if (!this.documentTags.contains(element.name)) {
            this.markFirstTime(element);
            this.documentTags.add(element.name);
        }
        return this.makeTag(element, bl);
    }

    private void readTillTokenE(int n) throws ParseException {
        this.buffer.setLength(0);
        block0: while (true) {
            this.t = this.getNextToken();
            if (this.t.kind == 1004) {
                this.resolveAndAppendEntity(this.t);
                continue;
            }
            if (this.t.kind == 3) {
                this.error("unexpected eof", this.t);
                break;
            }
            if (this.t.kind == n) break;
            if (this.t.kind == 1003) {
                String string = this.t.getImage();
                int n2 = 0;
                while (true) {
                    if (n2 >= string.length()) continue block0;
                    char c = string.charAt(n2);
                    if (c == '\r') {
                        this.buffer.append(' ');
                    } else if (c != '\n') {
                        if (c == '\t') {
                            this.buffer.append(' ');
                        } else {
                            this.buffer.append(c);
                        }
                    }
                    ++n2;
                }
            }
            this.append(this.t);
        }
    }

    private void resolveAndAppendEntity(Token token) {
        switch (token.category) {
            case 1: {
                this.buffer.append(this.resolveNamedEntity(token.getImage()));
                break;
            }
            case 2: {
                this.buffer.append(this.resolveNumericEntity(token.getImage()));
                break;
            }
            default: {
                throw new AssertionError((Object)("Invalid entity category " + token.category));
            }
        }
    }

    private void restOfTag(boolean bl, Token token, Token token2) throws ParseException {
        boolean bl2 = false;
        this.optional(1003);
        this.readAttributes(token.getImage());
        this.optional(1003);
        Token token3 = this.getTokenAhead();
        if (token3.kind == 62) {
            this.mustBe(62);
            bl2 = true;
        }
        this.hTag = new Token(token2, token3);
        if (!bl2) {
            if (this.dtd.elementHash.get(token.getImage().toLowerCase()) == null && this.backupMode) {
                this.error("Errors in tag body and unknown tag name. Treating the tag as a text.");
                this.reset();
                this.hTag = this.mustBe(60);
                this.buffer.setLength(0);
                this.buffer.append(this.hTag.getImage());
                this.CDATA(false);
                return;
            }
            this.error("Forcibly closing invalid parameter list");
            this.forciblyCloseTheTag();
        }
        if (bl) {
            this.endTag(false);
            this._handleEndTag(this.makeTagElement(token.getImage(), false));
        } else {
            TagElement tagElement = this.makeTagElement(token.getImage(), false);
            if (tagElement.getElement().type == 17) {
                this._handleEmptyTag(tagElement);
            } else {
                this.optional(1003);
                this._handleStartTag(tagElement);
            }
        }
    }

    private void startingTag(TagElement tagElement) {
        try {
            this.startTag(tagElement);
        }
        catch (ChangedCharSetException changedCharSetException) {
            this.error("Invalid change of charset");
        }
    }

    private void ws_error() {
        this.error("Whitespace here is not permitted");
    }

    private boolean isBlock(HTML.Tag tag) {
        return tag.isBlock() || tag == HTML.Tag.STYLE || tag == HTML.Tag.FRAME;
    }
}

